/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tea\u0001B\u0013'\u0001MB\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!AA\u000b\u0001B\u0001B\u0003%Q\u000b\u0003\u0005a\u0001\t\u0005\t\u0015!\u0003b\u0011!Y\u0007A!A!\u0002\u0013a\u0007\u0002C8\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0011Q\u0004!Q1A\u0005BUD\u0001B\u001f\u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\u0006w\u0002!\t\u0001 \u0005\n\u0003\u0017\u0001!\u0019!C!\u0003\u001bA\u0001\"!\u0007\u0001A\u0003%\u0011q\u0002\u0005\f\u00037\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0002C\u0006\u00022\u0001\u0001\r\u00111A\u0005\n\u0005M\u0002bCA \u0001\u0001\u0007\t\u0011)Q\u0005\u0003?A1\"!\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002L!Y\u0011Q\u000b\u0001A\u0002\u0003\u0007I\u0011BA,\u0011-\tY\u0006\u0001a\u0001\u0002\u0003\u0006K!!\u0014\t\u0017\u0005}\u0003\u00011AA\u0002\u0013%\u0011\u0011\r\u0005\f\u0003G\u0002\u0001\u0019!a\u0001\n\u0013\t)\u0007\u0003\u0006\u0002j\u0001\u0001\r\u0011!Q!\nEDq!!\u001c\u0001\t\u0003\ny\u0007C\u0004\u0002r\u0001!\t&!\b\t\u000f\u0005M\u0004\u0001\"\u0015\u0002L!9\u0011Q\u000f\u0001\u0005B\u0005]\u0004bBA=\u0001\u0011%\u0011q\u000f\u0005\b\u0003w\u0002A\u0011IA?\u0011\u001d\ty\t\u0001C!\u0003#Cq!!'\u0001\t\u0003\tYjB\u0004\u0002(\u001aB\t!!+\u0007\r\u00152\u0003\u0012AAV\u0011\u0019Yh\u0004\"\u0001\u0002@\"A\u0011\u0011\u0019\u0010\u0005\u0002)\n\u0019\r\u0003\u0006\u0002pz\t\n\u0011\"\u0001+\u0003cD\u0011Ba\u0002\u001f#\u0003%\tA!\u0003\t\u0013\t5a$%A\u0005\u0002\t=\u0001\"\u0003B\n=E\u0005I\u0011\u0001B\u000b\u0005EIe.T3n_JLh)\u001b7f\u0013:$W\r\u001f\u0006\u0003O!\n1\u0002Z1uCN|WO]2fg*\u0011\u0011FK\u0001\nKb,7-\u001e;j_:T!a\u000b\u0017\u0002\u0007M\fHN\u0003\u0002.]\u0005)1\u000f]1sW*\u0011q\u0006M\u0001\u0007CB\f7\r[3\u000b\u0003E\n1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u001b\u0011\u0005U2T\"\u0001\u0014\n\u0005]2#A\u0007)beRLG/[8oS:<\u0017i^1sK\u001aKG.Z%oI\u0016D\u0018\u0001D:qCJ\\7+Z:tS>t\u0007C\u0001\u001e<\u001b\u0005Q\u0013B\u0001\u001f+\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003I\u0011xn\u001c;QCRD7o\u00159fG&4\u0017.\u001a3\u0011\u0007}JEJ\u0004\u0002A\r:\u0011\u0011\tR\u0007\u0002\u0005*\u00111IM\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015\u000bQa]2bY\u0006L!a\u0012%\u0002\u000fA\f7m[1hK*\tQ)\u0003\u0002K\u0017\n\u00191+Z9\u000b\u0005\u001dC\u0005CA'S\u001b\u0005q%BA(Q\u0003\t17O\u0003\u0002R]\u00051\u0001.\u00193p_BL!a\u0015(\u0003\tA\u000bG\u000f[\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\u0003\u0002,[;vs!a\u0016-\u0011\u0005\u0005C\u0015BA-I\u0003\u0019\u0001&/\u001a3fM&\u00111\f\u0018\u0002\u0004\u001b\u0006\u0004(BA-I!\t1f,\u0003\u0002`9\n11\u000b\u001e:j]\u001e\f1#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006\u00042AY2f\u001b\u0005A\u0015B\u00013I\u0005\u0019y\u0005\u000f^5p]B\u0011a-[\u0007\u0002O*\u0011\u0001NK\u0001\u0006if\u0004Xm]\u0005\u0003U\u001e\u0014!b\u0015;sk\u000e$H+\u001f9f\u0003=1\u0017\u000e\\3Ti\u0006$Xo]\"bG\",\u0007CA\u001bn\u0013\tqgEA\bGS2,7\u000b^1ukN\u001c\u0015m\u00195f\u0003i)8/\u001a:Ta\u0016\u001c\u0017NZ5fIB\u000b'\u000f^5uS>t7\u000b]3d!\r\u00117-\u001d\t\u0003kIL!a\u001d\u0014\u0003\u001bA\u000b'\u000f^5uS>t7\u000b]3d\u0003EiW\r^1eCR\fw\n]:US6,gj]\u000b\u0002mB\u0019!mY<\u0011\u0005\tD\u0018BA=I\u0005\u0011auN\\4\u0002%5,G/\u00193bi\u0006|\u0005o\u001d+j[\u0016t5\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001butx0!\u0001\u0002\u0004\u0005\u0015\u0011qAA\u0005!\t)\u0004\u0001C\u00039\u0013\u0001\u0007\u0011\bC\u0003>\u0013\u0001\u0007a\bC\u0003U\u0013\u0001\u0007Q\u000bC\u0003a\u0013\u0001\u0007\u0011\rC\u0004l\u0013A\u0005\t\u0019\u00017\t\u000f=L\u0001\u0013!a\u0001a\"9A/\u0003I\u0001\u0002\u00041\u0018!\u0003:p_R\u0004\u0016\r\u001e5t+\t\ty\u0001E\u0003\u0002\u0012\u0005]A*\u0004\u0002\u0002\u0014)\u0019\u0011Q\u0003%\u0002\u0015\r|G\u000e\\3di&|g.C\u0002K\u0003'\t!B]8piB\u000bG\u000f[:!\u0003=\u0019\u0017m\u00195fI2+\u0017M\u001a$jY\u0016\u001cXCAA\u0010!\u001d\t\t#a\nM\u0003Wi!!a\t\u000b\t\u0005\u0015\u00121C\u0001\b[V$\u0018M\u00197f\u0013\u0011\tI#a\t\u0003\u001b1Kgn[3e\u0011\u0006\u001c\b.T1q!\ri\u0015QF\u0005\u0004\u0003_q%A\u0003$jY\u0016\u001cF/\u0019;vg\u0006\u00192-Y2iK\u0012dU-\u00194GS2,7o\u0018\u0013fcR!\u0011QGA\u001e!\r\u0011\u0017qG\u0005\u0004\u0003sA%\u0001B+oSRD\u0011\"!\u0010\u000e\u0003\u0003\u0005\r!a\b\u0002\u0007a$\u0013'\u0001\tdC\u000eDW\r\u001a'fC\u001a4\u0015\u000e\\3tA!\u001aa\"a\u0011\u0011\u0007\t\f)%C\u0002\u0002H!\u0013\u0001B^8mCRLG.Z\u0001\u001dG\u0006\u001c\u0007.\u001a3MK\u00064G)\u001b:U_\u000eC\u0017\u000e\u001c3sK:4\u0015\u000e\\3t+\t\ti\u0005E\u0003W52\u000by\u0005E\u0003c\u0003#\nY#C\u0002\u0002T!\u0013Q!\u0011:sCf\f\u0001eY1dQ\u0016$G*Z1g\t&\u0014Hk\\\"iS2$'/\u001a8GS2,7o\u0018\u0013fcR!\u0011QGA-\u0011%\ti\u0004EA\u0001\u0002\u0004\ti%A\u000fdC\u000eDW\r\u001a'fC\u001a$\u0015N\u001d+p\u0007\"LG\u000e\u001a:f]\u001aKG.Z:!Q\r\t\u00121I\u0001\u0014G\u0006\u001c\u0007.\u001a3QCJ$\u0018\u000e^5p]N\u0003XmY\u000b\u0002c\u000692-Y2iK\u0012\u0004\u0016M\u001d;ji&|gn\u00159fG~#S-\u001d\u000b\u0005\u0003k\t9\u0007\u0003\u0005\u0002>M\t\t\u00111\u0001r\u0003Q\u0019\u0017m\u00195fIB\u000b'\u000f^5uS>t7\u000b]3dA!\u001aA#a\u0011\u0002\u001bA\f'\u000f^5uS>t7\u000b]3d)\u0005\t\u0018!\u00037fC\u001a4\u0015\u000e\\3t\u0003YaW-\u00194ESJ$vn\u00115jY\u0012\u0014XM\u001c$jY\u0016\u001c\u0018a\u0002:fMJ,7\u000f\u001b\u000b\u0003\u0003k\t\u0001B]3ge\u0016\u001c\b\u000eM\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005}\u0014Q\u0011\t\u0004E\u0006\u0005\u0015bAAB\u0011\n9!i\\8mK\u0006t\u0007bBAD5\u0001\u0007\u0011\u0011R\u0001\u0006_RDWM\u001d\t\u0004E\u0006-\u0015bAAG\u0011\n\u0019\u0011I\\=\u0002\u0011!\f7\u000f[\"pI\u0016$\"!a%\u0011\u0007\t\f)*C\u0002\u0002\u0018\"\u00131!\u00138u\u00035a\u0017n\u001d;MK\u00064g)\u001b7fgR!\u0011QTAR!\u0019\t\t#a(\u0002,%!\u0011\u0011UA\u0012\u00055a\u0015N\\6fI\"\u000b7\u000f[*fi\"1\u0011Q\u0015\u000fA\u0002y\nQ\u0001]1uQN\f\u0011#\u00138NK6|'/\u001f$jY\u0016Le\u000eZ3y!\t)ddE\u0003\u001f\u0003[\u000b\u0019\fE\u0002c\u0003_K1!!-I\u0005\u0019\te.\u001f*fMB!\u0011QWA^\u001b\t\t9LC\u0002\u0002:2\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0003{\u000b9LA\u0004M_\u001e<\u0017N\\4\u0015\u0005\u0005%\u0016!\u00052vY.d\u0015n\u001d;MK\u00064g)\u001b7fgRa\u0011QYAh\u0003#\f\t/a;\u0002nB!q(SAd!\u0019\u0011\u0017\u0011\u001a'\u0002N&\u0019\u00111\u001a%\u0003\rQ+\b\u000f\\33!\u0011y\u0014*a\u000b\t\r\u0005\u0015\u0006\u00051\u0001?\u0011\u001d\t\u0019\u000e\ta\u0001\u0003+\f!\u0002[1e_>\u00048i\u001c8g!\u0011\t9.!8\u000e\u0005\u0005e'bAAn!\u0006!1m\u001c8g\u0013\u0011\ty.!7\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\t\u0019\u000f\ta\u0001\u0003K\faAZ5mi\u0016\u0014\bcA'\u0002h&\u0019\u0011\u0011\u001e(\u0003\u0015A\u000bG\u000f\u001b$jYR,'\u000fC\u00039A\u0001\u0007\u0011\bC\u0004UAA\u0005\t\u0019A+\u00027\t,Hn\u001b'jgRdU-\u00194GS2,7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\t\u0019PK\u0002V\u0003k\\#!a>\u0011\t\u0005e(1A\u0007\u0003\u0003wTA!!@\u0002\u0000\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0003A\u0015AC1o]>$\u0018\r^5p]&!!QAA~\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t-!f\u00017\u0002v\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIY*\"A!\u0005+\u0007A\f)0A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeN\u000b\u0003\u0005/Q3A^A{\u0001")
public class InMemoryFileIndex
extends PartitioningAwareFileIndex {
    private final SparkSession sparkSession;
    private final Map<String, String> parameters;
    private final FileStatusCache fileStatusCache;
    private final Option<PartitionSpec> userSpecifiedPartitionSpec;
    private final Option<Object> metadataOpsTimeNs;
    private final Seq<Path> rootPaths;
    private volatile LinkedHashMap<Path, FileStatus> cachedLeafFiles;
    private volatile Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles;
    private volatile PartitionSpec cachedPartitionSpec;

    public static Option<Object> $lessinit$greater$default$7() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<PartitionSpec> $lessinit$greater$default$6() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$6();
    }

    public static FileStatusCache $lessinit$greater$default$5() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public Option<Object> metadataOpsTimeNs() {
        return this.metadataOpsTimeNs;
    }

    @Override
    public Seq<Path> rootPaths() {
        return this.rootPaths;
    }

    private LinkedHashMap<Path, FileStatus> cachedLeafFiles() {
        return this.cachedLeafFiles;
    }

    private void cachedLeafFiles_$eq(LinkedHashMap<Path, FileStatus> x$1) {
        this.cachedLeafFiles = x$1;
    }

    private Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles;
    }

    private void cachedLeafDirToChildrenFiles_$eq(Map<Path, FileStatus[]> x$1) {
        this.cachedLeafDirToChildrenFiles = x$1;
    }

    private PartitionSpec cachedPartitionSpec() {
        return this.cachedPartitionSpec;
    }

    private void cachedPartitionSpec_$eq(PartitionSpec x$1) {
        this.cachedPartitionSpec = x$1;
    }

    @Override
    public PartitionSpec partitionSpec() {
        if (this.cachedPartitionSpec() == null) {
            if (this.userSpecifiedPartitionSpec.isDefined()) {
                this.cachedPartitionSpec_$eq((PartitionSpec)this.userSpecifiedPartitionSpec.get());
            } else {
                this.cachedPartitionSpec_$eq(this.inferPartitioning());
            }
        }
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Partition spec: ").append(this.cachedPartitionSpec()).toString());
        return this.cachedPartitionSpec();
    }

    @Override
    public LinkedHashMap<Path, FileStatus> leafFiles() {
        return this.cachedLeafFiles();
    }

    @Override
    public Map<Path, FileStatus[]> leafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles();
    }

    @Override
    public void refresh() {
        this.fileStatusCache.invalidateAll();
        this.refresh0();
    }

    private void refresh0() {
        LinkedHashSet<FileStatus> files = this.listLeafFiles(this.rootPaths());
        this.cachedLeafFiles_$eq((LinkedHashMap<Path, FileStatus>)((LinkedHashMap)new LinkedHashMap().$plus$plus$eq((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getPath()), f), LinkedHashSet$.MODULE$.canBuildFrom()))));
        this.cachedLeafDirToChildrenFiles_$eq((Map<Path, FileStatus[]>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files.toArray(ClassTag$.MODULE$.apply(FileStatus.class)))).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().getParent()));
        this.cachedPartitionSpec_$eq(null);
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof InMemoryFileIndex) {
            InMemoryFileIndex inMemoryFileIndex = (InMemoryFileIndex)object;
            Set set = this.rootPaths().toSet();
            Set set2 = inMemoryFileIndex.rootPaths().toSet();
            return !(set != null ? !set.equals(set2) : set2 != null);
        }
        return false;
    }

    public int hashCode() {
        return this.rootPaths().toSet().hashCode();
    }

    public LinkedHashSet<FileStatus> listLeafFiles(Seq<Path> paths) {
        long startTime = System.nanoTime();
        LinkedHashSet output = (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer pathsToFetch = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        paths.foreach((Function1 & Serializable & scala.Serializable)path -> {
            InMemoryFileIndex.$anonfun$listLeafFiles$1(this, output, pathsToFetch, path);
            return BoxedUnit.UNIT;
        });
        PathFilter filter = FileInputFormat.getInputPathFilter((JobConf)new JobConf(this.hadoopConf(), this.getClass()));
        Seq<Tuple2<Path, Seq<FileStatus>>> discovered = InMemoryFileIndex$.MODULE$.bulkListLeafFiles((Seq<Path>)pathsToFetch.toSeq(), this.hadoopConf(), filter, this.sparkSession, this.parameters);
        discovered.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Path path = (Path)tuple2._1();
                Seq leafFiles = (Seq)tuple2._2();
                HiveCatalogMetrics$.MODULE$.incrementFilesDiscovered(leafFiles.size());
                $this.fileStatusCache.putLeafFiles(path, (FileStatus[])leafFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)));
                return (LinkedHashSet)output.$plus$plus$eq((TraversableOnce)leafFiles);
            }
            throw new MatchError((Object)tuple2);
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("It took ").append((System.nanoTime() - startTime) / 1000000L).append(" ms to list leaf files").append(" for ").append(paths.length()).append(" paths.").toString());
        return output;
    }

    public static final /* synthetic */ void $anonfun$listLeafFiles$1(InMemoryFileIndex $this, LinkedHashSet output$1, ArrayBuffer pathsToFetch$1, Path path) {
        Option<FileStatus[]> option = $this.fileStatusCache.getLeafFiles(path);
        if (option instanceof Some) {
            Some some = (Some)option;
            FileStatus[] files = (FileStatus[])some.value();
            HiveCatalogMetrics$.MODULE$.incrementFileCacheHits(files.length);
            AbstractIterable cfr_ignored_0 = (AbstractIterable)output$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)));
        } else if (None$.MODULE$.equals(option)) {
            pathsToFetch$1.$plus$eq((Object)path);
        } else {
            throw new MatchError(option);
        }
    }

    public InMemoryFileIndex(SparkSession sparkSession, Seq<Path> rootPathsSpecified, Map<String, String> parameters, Option<StructType> userSpecifiedSchema, FileStatusCache fileStatusCache, Option<PartitionSpec> userSpecifiedPartitionSpec, Option<Object> metadataOpsTimeNs) {
        this.sparkSession = sparkSession;
        this.parameters = parameters;
        this.fileStatusCache = fileStatusCache;
        this.userSpecifiedPartitionSpec = userSpecifiedPartitionSpec;
        this.metadataOpsTimeNs = metadataOpsTimeNs;
        super(sparkSession, parameters, userSpecifiedSchema, fileStatusCache);
        this.rootPaths = (Seq)rootPathsSpecified.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSink$.MODULE$.ancestorIsMetadataDirectory(x$1, this.hadoopConf())));
        this.refresh0();
    }
}

