/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.QueryContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.util.DateFormatter$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.functions.UnboundFunction;
import org.apache.spark.sql.connector.catalog.index.TableIndex;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Literal;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.util.V2ExpressionSQLBuilder;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.jdbc.DriverRegistry$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcOptionsInWrite;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcUtils$;
import org.apache.spark.sql.execution.datasources.jdbc.connection.ConnectionProvider$;
import org.apache.spark.sql.execution.datasources.v2.TableSampleInfo;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcSQLQueryBuilder;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0011ef!B A\u0003\u0003Y\u0005\"B.\u0001\t\u0003a\u0006\"B0\u0001\r\u0003\u0001\u0007\"B9\u0001\t\u0003\u0011\bbBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fBq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002l\u0001!\t!!\u001c\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u001a\"9\u0011q\u0014\u0001\u0005\u0002\u0005\u0005\u0006bBAb\u0001\u0011\u0005\u0011Q\u0019\u0005\b\u0003\u0017\u0004A\u0011AAg\u0011\u001d\t9\u000e\u0001C\u0001\u00033Dq!a6\u0001\t\u0003\t\u0019\u000fC\u0005\u0002t\u0002\t\n\u0011\"\u0001\u0002v\"9!\u0011\u0002\u0001\u0005\u0002\t-\u0001\u0002\u0003B\u000e\u0001\u0011E\u0001I!\b\t\u000f\t\u0015\u0002\u0001\"\u0001\u0003(\u00199!1\u0007\u0001\u0001\u0001\nU\u0002BB.\u0014\t\u0003\u00119\u0005C\u0004\u0003NM!\tEa\u0014\t\u000f\tM4\u0003\"\u0011\u0003v!9!\u0011Q\n\u0005B\t\r\u0005b\u0002BG'\u0011\u0005#q\u0012\u0005\b\u0005?\u001bB\u0011\tBQ\u0011\u001d\u0011Yk\u0005C\t\u0005[CqA!-\u0014\t\u0003\u0012\u0019\fC\u0004\u00038N!\tE!/\t\u001d\t\u00057\u0003%A\u0002\u0002\u0003%IAa1\u0003^\"9!q\u001c\u0001\u0005\u0002\t\u0005\bb\u0002Bt\u0001\u0011\u0005!\u0011\u001e\u0005\b\u0005s\u0004A\u0011\u0001B~\u0011\u001d\u0019y\u0002\u0001C\u0001\u0007CAqa!\u0013\u0001\t\u0003\u0019Y\u0005C\u0004\u0004X\u0001!\ta!\u0017\t\u000f\r\r\u0004\u0001\"\u0001\u0004f!91Q\u000e\u0001\u0005\u0002\r=\u0004bBB9\u0001\u0011\u000511\u000f\u0005\b\u0007c\u0002A\u0011ABB\u0011\u001d\u0019\u0019\n\u0001C\u0001\u0007+Cqa!+\u0001\t\u0003\u0019Y\u000bC\u0004\u00046\u0002!\taa.\t\u000f\r\r\u0007\u0001\"\u0001\u0004F\"911\u001a\u0001\u0005\u0002\r5\u0007bBBl\u0001\u0011\u00051\u0011\u001c\u0005\b\u0007G\u0004A\u0011ABs\u0011\u001d\u0019Y\u000f\u0001C\u0001\u0007[Dqaa=\u0001\t\u0003\u0019)\u0010C\u0004\u0004z\u0002!\taa?\t\u000f\u0011\u0005\u0001\u0001\"\u0001\u0005\u0004!9A1\u0005\u0001\u0005\u0002\u0011\u0015\u0002b\u0002C\u0018\u0001\u0011\u0005A\u0011\u0007\u0005\b\to\u0001A\u0011\u0001C\u001d\u0011\u001d!y\u0005\u0001C\u0001\t#Bq\u0001\"\u001b\u0001\t\u0003!Y\u0007C\u0004\u0005x\u0001!\t\u0001\"\u001f\t\u000f\u0011}\u0004\u0001\"\u0001\u0005\u0002\"9A1\u0012\u0001\u0005\u0002\u00115\u0005b\u0002CH\u0001\u0011\u0005AQ\u0012\u0005\b\t#\u0003A\u0011\u0001CG\u0011\u001d!\u0019\n\u0001C\u0001\t+Cq\u0001b*\u0001\t\u0003!IKA\u0006KI\n\u001cG)[1mK\u000e$(BA!C\u0003\u0011QGMY2\u000b\u0005\r#\u0015aA:rY*\u0011QIR\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f\"\u000ba!\u00199bG\",'\"A%\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001a%+\u0016\t\u0003\u001bBk\u0011A\u0014\u0006\u0002\u001f\u0006)1oY1mC&\u0011\u0011K\u0014\u0002\u0007\u0003:L(+\u001a4\u0011\u00055\u001b\u0016B\u0001+O\u00051\u0019VM]5bY&T\u0018M\u00197f!\t1\u0016,D\u0001X\u0015\tAF)\u0001\u0005j]R,'O\\1m\u0013\tQvKA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005i\u0006C\u00010\u0001\u001b\u0005\u0001\u0015!C2b]\"\u000bg\u000e\u001a7f)\t\tG\r\u0005\u0002NE&\u00111M\u0014\u0002\b\u0005>|G.Z1o\u0011\u0015)'\u00011\u0001g\u0003\r)(\u000f\u001c\t\u0003O:t!\u0001\u001b7\u0011\u0005%tU\"\u00016\u000b\u0005-T\u0015A\u0002\u001fs_>$h(\u0003\u0002n\u001d\u00061\u0001K]3eK\u001aL!a\u001c9\u0003\rM#(/\u001b8h\u0015\tig*A\bhKR\u001c\u0015\r^1msN$H+\u001f9f)!\u0019H0a\u0001\u0002\b\u0005-\u0001cA'um&\u0011QO\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005]TX\"\u0001=\u000b\u0005e\u0014\u0015!\u0002;za\u0016\u001c\u0018BA>y\u0005!!\u0015\r^1UsB,\u0007\"B?\u0004\u0001\u0004q\u0018aB:rYRK\b/\u001a\t\u0003\u001b~L1!!\u0001O\u0005\rIe\u000e\u001e\u0005\u0007\u0003\u000b\u0019\u0001\u0019\u00014\u0002\u0011QL\b/\u001a(b[\u0016Da!!\u0003\u0004\u0001\u0004q\u0018\u0001B:ju\u0016Dq!!\u0004\u0004\u0001\u0004\ty!\u0001\u0002nIB\u0019q/!\u0005\n\u0007\u0005M\u0001PA\bNKR\fG-\u0019;b\u0005VLG\u000eZ3s\u0003-9W\r\u001e&E\u0005\u000e#\u0016\u0010]3\u0015\t\u0005e\u0011\u0011\u0005\t\u0005\u001bR\fY\u0002E\u0002_\u0003;I1!a\bA\u0005!QEMY2UsB,\u0007BBA\u0012\t\u0001\u0007a/\u0001\u0002ei\u0006y2m\u001c8wKJ$(*\u0019<b)&lWm\u001d;b[B$v\u000eV5nKN$\u0018-\u001c9\u0015\t\u0005%\u0012q\u0007\t\u0005\u0003W\t\u0019$\u0004\u0002\u0002.)\u00191)a\f\u000b\u0005\u0005E\u0012\u0001\u00026bm\u0006LA!!\u000e\u0002.\tIA+[7fgR\fW\u000e\u001d\u0005\b\u0003s)\u0001\u0019AA\u0015\u0003\u0005!\b&B\u0003\u0002>\u0005%\u0003\u0003BA \u0003\u000bj!!!\u0011\u000b\u0007\u0005\rC)\u0001\u0006b]:|G/\u0019;j_:LA!a\u0012\u0002B\t)1+\u001b8dK\u0006\u0012\u00111J\u0001\u0006g9*d\u0006M\u0001#G>tg/\u001a:u\u0015\u00064\u0018\rV5nKN$\u0018-\u001c9U_RKW.Z:uC6\u0004h\n\u0016.\u0015\t\u0005E\u0013Q\f\t\u0005\u0003'\nI&\u0004\u0002\u0002V)!\u0011qKA\u0018\u0003\u0011!\u0018.\\3\n\t\u0005m\u0013Q\u000b\u0002\u000e\u0019>\u001c\u0017\r\u001c#bi\u0016$\u0016.\\3\t\u000f\u0005eb\u00011\u0001\u0002*!*a!!\u0010\u0002J\u0005\u00113m\u001c8wKJ$H+[7fgR\fW\u000e\u001d(U5R{'*\u0019<b)&lWm\u001d;b[B$B!!\u000b\u0002f!9\u0011qM\u0004A\u0002\u0005E\u0013a\u00017ei\"*q!!\u0010\u0002J\u000592M]3bi\u0016\u001cuN\u001c8fGRLwN\u001c$bGR|'/\u001f\u000b\u0005\u0003_\nY\b\u0005\u0004N\u0003cr\u0018QO\u0005\u0004\u0003gr%!\u0003$v]\u000e$\u0018n\u001c82!\u0011\tY#a\u001e\n\t\u0005e\u0014Q\u0006\u0002\u000b\u0007>tg.Z2uS>t\u0007bBA?\u0011\u0001\u0007\u0011qP\u0001\b_B$\u0018n\u001c8t!\u0011\t\t)!$\u000e\u0005\u0005\r%bA!\u0002\u0006*!\u0011qQAE\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0007\u0005-%)A\u0005fq\u0016\u001cW\u000f^5p]&!\u0011qRAB\u0005-QEIQ\"PaRLwN\\:)\u000b!\ti$a%\"\u0005\u0005U\u0015!B\u001a/g9\u0002\u0014aD9v_R,\u0017\nZ3oi&4\u0017.\u001a:\u0015\u0007\u0019\fY\n\u0003\u0004\u0002\u001e&\u0001\rAZ\u0001\bG>dg*Y7f\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\u0015\u0005\r\u0016\u0011VAZ\u0003o\u000bY\fE\u0002N\u0003KK1!a*O\u0005\u0011)f.\u001b;\t\u000f\u0005-&\u00021\u0001\u0002.\u0006I1\u000f^1uK6,g\u000e\u001e\t\u0005\u0003W\ty+\u0003\u0003\u00022\u00065\"!C*uCR,W.\u001a8u\u0011\u0019\t)L\u0003a\u0001M\u0006IA/\u00192mK:\u000bW.\u001a\u0005\u0007\u0003sS\u0001\u0019\u00014\u0002\u0013M$(oU2iK6\f\u0007bBA?\u0015\u0001\u0007\u0011Q\u0018\t\u0005\u0003\u0003\u000by,\u0003\u0003\u0002B\u0006\r%A\u0005&eE\u000e|\u0005\u000f^5p]NLen\u0016:ji\u0016\f1cZ3u)\u0006\u0014G.Z#ySN$8/U;fef$2AZAd\u0011\u0019\tIm\u0003a\u0001M\u0006)A/\u00192mK\u0006qq-\u001a;TG\",W.Y)vKJLHc\u00014\u0002P\"1\u0011\u0011\u001a\u0007A\u0002\u0019DS\u0001DA\u001f\u0003'\f#!!6\u0002\u000bIr\u0013G\f\u0019\u0002!\u001d,G\u000f\u0016:v]\u000e\fG/Z)vKJLHc\u00014\u0002\\\"1\u0011\u0011Z\u0007A\u0002\u0019DS!DA\u001f\u0003?\f#!!9\u0002\u000bIr3G\f\u0019\u0015\u000b\u0019\f)/a:\t\r\u0005%g\u00021\u0001g\u0011%\tIO\u0004I\u0001\u0002\u0004\tY/A\u0004dCN\u001c\u0017\rZ3\u0011\u00075#\u0018\rK\u0003\u000f\u0003{\ty/\t\u0002\u0002r\u0006)!G\f\u001b/a\u0005Qr-\u001a;UeVt7-\u0019;f#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u001f\u0016\u0005\u0003W\fIp\u000b\u0002\u0002|B!\u0011Q B\u0003\u001b\t\tyP\u0003\u0003\u0003\u0002\t\r\u0011!C;oG\",7m[3e\u0015\r\t\u0019ET\u0005\u0005\u0005\u000f\tyPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1BY3g_J,g)\u001a;dQR1\u00111\u0015B\u0007\u0005#AqAa\u0004\u0011\u0001\u0004\t)(\u0001\u0006d_:tWm\u0019;j_:DqAa\u0005\u0011\u0001\u0004\u0011)\"\u0001\u0006qe>\u0004XM\u001d;jKN\u0004Ra\u001aB\fM\u001aL1A!\u0007q\u0005\ri\u0015\r]\u0001\nKN\u001c\u0017\r]3Tc2$2A\u001aB\u0010\u0011\u0019\u0011\t#\u0005a\u0001M\u0006)a/\u00197vK\"*\u0011#!\u0010\u0002`\u0006a1m\\7qS2,g+\u00197vKR!!\u0011\u0006B\u0018!\ri%1F\u0005\u0004\u0005[q%aA!os\"9!\u0011\u0005\nA\u0002\t%\u0002&\u0002\n\u0002>\u0005}'A\u0004&E\u0005\u000e\u001b\u0016\u000b\u0014\"vS2$WM]\n\u0004'\t]\u0002\u0003\u0002B\u001d\u0005\u0007j!Aa\u000f\u000b\t\tu\"qH\u0001\u0005kRLGNC\u0002\u0003B\t\u000b\u0011bY8o]\u0016\u001cGo\u001c:\n\t\t\u0015#1\b\u0002\u0017-J*\u0005\u0010\u001d:fgNLwN\\*R\u0019\n+\u0018\u000e\u001c3feR\u0011!\u0011\n\t\u0004\u0005\u0017\u001aR\"\u0001\u0001\u0002\u0019YL7/\u001b;MSR,'/\u00197\u0015\u0007\u0019\u0014\t\u0006C\u0004\u0003TU\u0001\rA!\u0016\u0002\u000f1LG/\u001a:bYB\"!q\u000bB4!\u0019\u0011IFa\u0018\u0003d5\u0011!1\f\u0006\u0005\u0005;\u0012y$A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002\u0002B1\u00057\u0012q\u0001T5uKJ\fG\u000e\u0005\u0003\u0003f\t\u001dD\u0002\u0001\u0003\r\u0005S\u0012\t&!A\u0001\u0002\u000b\u0005!1\u000e\u0002\u0004?\u0012\n\u0014\u0003\u0002B7\u0005S\u00012!\u0014B8\u0013\r\u0011\tH\u0014\u0002\b\u001d>$\b.\u001b8h\u0003M1\u0018n]5u\u001d\u0006lW\r\u001a*fM\u0016\u0014XM\\2f)\r1'q\u000f\u0005\b\u0005s2\u0002\u0019\u0001B>\u0003!q\u0017-\\3e%\u00164\u0007\u0003\u0002B-\u0005{JAAa \u0003\\\tqa*Y7fIJ+g-\u001a:f]\u000e,\u0017!\u0003<jg&$8)Y:u)\u00151'Q\u0011BE\u0011\u0019\u00119i\u0006a\u0001M\u0006\tA\u000e\u0003\u0004\u0003\f^\u0001\rA^\u0001\tI\u0006$\u0018\rV=qK\u0006\u0001b/[:jiN\u000bFJR;oGRLwN\u001c\u000b\u0006M\nE%Q\u0013\u0005\u0007\u0005'C\u0002\u0019\u00014\u0002\u0011\u0019,hn\u0019(b[\u0016DqAa&\u0019\u0001\u0004\u0011I*\u0001\u0004j]B,Ho\u001d\t\u0005\u001b\nme-C\u0002\u0003\u001e:\u0013Q!\u0011:sCf\faC^5tSR\fum\u001a:fO\u0006$XMR;oGRLwN\u001c\u000b\bM\n\r&Q\u0015BU\u0011\u0019\u0011\u0019*\u0007a\u0001M\"1!qU\rA\u0002\u0005\f!\"[:ESN$\u0018N\\2u\u0011\u001d\u00119*\u0007a\u0001\u00053\u000b1\u0003Z5bY\u0016\u001cGOR;oGRLwN\u001c(b[\u0016$2A\u001aBX\u0011\u0019\u0011\u0019J\u0007a\u0001M\u0006aa/[:ji>3XM\u001d7bsR\u0019aM!.\t\u000f\t]5\u00041\u0001\u0003\u001a\u0006Ia/[:jiR\u0013\u0018.\u001c\u000b\u0006M\nm&q\u0018\u0005\u0007\u0005{c\u0002\u0019\u00014\u0002\u0013\u0011L'/Z2uS>t\u0007b\u0002BL9\u0001\u0007!\u0011T\u0001\u0013gV\u0004XM\u001d\u0013wSNLG\u000fT5uKJ\fG\u000e\u0006\u0003\u0003F\n=\u0007\u0003\u0002Bd\u0005\u001bl!A!3\u000b\t\t-\u0017qF\u0001\u0005Y\u0006tw-C\u0002p\u0005\u0013D\u0011B!5\u001e\u0003\u0003\u0005\rAa5\u0002\u0007a$\u0013\u0007\r\u0003\u0003V\ne\u0007C\u0002B-\u0005?\u00129\u000e\u0005\u0003\u0003f\teG\u0001\u0004Bn\u0005\u001f\f\t\u0011!A\u0003\u0002\t-$AA 1\u0013\u0011\u0011iEa\u0011\u0002'%\u001c8+\u001e9q_J$X\r\u001a$v]\u000e$\u0018n\u001c8\u0015\u0007\u0005\u0014\u0019\u000f\u0003\u0004\u0003\u0014z\u0001\rA\u001a\u0015\u0006=\u0005u\u00121S\u0001\u0012G>l\u0007/\u001b7f\u000bb\u0004(/Z:tS>tG\u0003\u0002Bv\u0005[\u00042!\u0014;g\u0011\u001d\u0011yo\ba\u0001\u0005c\fA!\u001a=qeB!!\u0011\fBz\u0013\u0011\u0011)Pa\u0017\u0003\u0015\u0015C\bO]3tg&|g\u000eK\u0003 \u0003{\t\u0019*\u0001\td_6\u0004\u0018\u000e\\3BO\u001e\u0014XmZ1uKR!!1\u001eB\u007f\u0011\u001d\u0011y\u0010\ta\u0001\u0007\u0003\t1\"Y4h\rVt7\r^5p]B!11AB\u0005\u001b\t\u0019)A\u0003\u0003\u0004\b\tm\u0013!C1hOJ,w-\u0019;f\u0013\u0011\u0019Ya!\u0002\u0003\u001b\u0005;wM]3hCR,g)\u001e8dQ\u001d\u00013qBB\u000b\u00073\u00012!TB\t\u0013\r\u0019\u0019B\u0014\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017EAB\f\u0003\u0011+8/\u001a\u0011pe\u001et\u0013\r]1dQ\u0016t3\u000f]1sW:\u001a\u0018\u000f\u001c\u0018kI\n\u001cgF\u00133cG\u0012K\u0017\r\\3di:\u001aw.\u001c9jY\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0011j]N$X-\u00193/C\t\u0019Y\"A\u00034]Qr\u0003\u0007K\u0003!\u0003{\t\u0019*A\u0005gk:\u001cG/[8ogV\u001111\u0005\t\u0007\u0007K\u0019yc!\u000e\u000f\t\r\u001d21\u0006\b\u0004S\u000e%\u0012\"A(\n\u0007\r5b*A\u0004qC\u000e\\\u0017mZ3\n\t\rE21\u0007\u0002\u0004'\u0016\f(bAB\u0017\u001dB1Qja\u000eg\u0007wI1a!\u000fO\u0005\u0019!V\u000f\u001d7feA!1QHB#\u001b\t\u0019yD\u0003\u0003\u0004 \r\u0005#\u0002BB\"\u0005\u007f\tqaY1uC2|w-\u0003\u0003\u0004H\r}\"aD+oE>,h\u000e\u001a$v]\u000e$\u0018n\u001c8\u0002\u0019\r\u0014X-\u0019;f'\u000eDW-\\1\u0015\u0011\u0005\r6QJB(\u0007'Bq!a+#\u0001\u0004\ti\u000b\u0003\u0004\u0004R\t\u0002\rAZ\u0001\u0007g\u000eDW-\\1\t\r\rU#\u00051\u0001g\u0003\u001d\u0019w.\\7f]R\fQb]2iK6\f7/\u0012=jgR\u001cHcB1\u0004\\\r}3\u0011\r\u0005\b\u0007;\u001a\u0003\u0019AA;\u0003\u0011\u0019wN\u001c8\t\u000f\u0005u4\u00051\u0001\u0002\u0000!11\u0011K\u0012A\u0002\u0019\f1\u0002\\5tiN\u001b\u0007.Z7bgR11qMB5\u0007W\u0002R!\u0014BN\u00053Cqa!\u0018%\u0001\u0004\t)\bC\u0004\u0002~\u0011\u0002\r!a \u00021%\u001c8)Y:dC\u0012Lgn\u001a+sk:\u001c\u0017\r^3UC\ndW\r\u0006\u0002\u0002l\u0006Y!/\u001a8b[\u0016$\u0016M\u00197f)\u001517QOB=\u0011\u0019\u00199H\na\u0001M\u0006Aq\u000e\u001c3UC\ndW\r\u0003\u0004\u0004|\u0019\u0002\rAZ\u0001\t]\u0016<H+\u00192mK\":aea\u0004\u0004\u0000\u0005%\u0013EABA\u0003M\u0002F.Z1tK\u0002zg/\u001a:sS\u0012,\u0007E]3oC6,G+\u00192mK\u0002jW\r\u001e5pI\u0002:\u0018\u000e\u001e5!S\u0012,g\u000e^5gS\u0016\u00148\u000fF\u0003g\u0007\u000b\u001by\tC\u0004\u0004x\u001d\u0002\raa\"\u0011\t\r%51R\u0007\u0003\u0007\u0003JAa!$\u0004B\tQ\u0011\nZ3oi&4\u0017.\u001a:\t\u000f\rmt\u00051\u0001\u0004\b\"*q%!\u0010\u0002J\u0005Q\u0011\r\u001c;feR\u000b'\r\\3\u0015\u0011\te5qSBM\u0007KCa!!.)\u0001\u00041\u0007bBBNQ\u0001\u00071QT\u0001\bG\"\fgnZ3t!\u0019\u0019)ca\f\u0004 B!1\u0011RBQ\u0013\u0011\u0019\u0019k!\u0011\u0003\u0017Q\u000b'\r\\3DQ\u0006tw-\u001a\u0005\u0007\u0007OC\u0003\u0019\u0001@\u0002\u001d\u0011\u0014W*\u00196peZ+'o]5p]\u0006\tr-\u001a;BI\u0012\u001cu\u000e\\;n]F+XM]=\u0015\u000f\u0019\u001cika,\u00044\"1\u0011QW\u0015A\u0002\u0019Daa!-*\u0001\u00041\u0017AC2pYVlgNT1nK\"1!1R\u0015A\u0002\u0019\fAcZ3u%\u0016t\u0017-\\3D_2,XN\\)vKJLH#\u00034\u0004:\u000em6QXBa\u0011\u0019\t)L\u000ba\u0001M\"11\u0011\u0017\u0016A\u0002\u0019Daaa0+\u0001\u00041\u0017a\u00028fo:\u000bW.\u001a\u0005\u0007\u0007OS\u0003\u0019\u0001@\u0002)\u001d,G\u000fR3mKR,7i\u001c7v[:\fV/\u001a:z)\u001517qYBe\u0011\u0019\t)l\u000ba\u0001M\"11\u0011W\u0016A\u0002\u0019\f\u0001dZ3u+B$\u0017\r^3D_2,XN\u001c+za\u0016\fV/\u001a:z)\u001d17qZBi\u0007'Da!!.-\u0001\u00041\u0007BBBYY\u0001\u0007a\r\u0003\u0004\u0004V2\u0002\rAZ\u0001\f]\u0016<H)\u0019;b)f\u0004X-A\u0010hKR,\u0006\u000fZ1uK\u000e{G.^7o\u001dVdG.\u00192jY&$\u00180U;fef$rAZBn\u0007;\u001cy\u000e\u0003\u0004\u000266\u0002\rA\u001a\u0005\u0007\u0007ck\u0003\u0019\u00014\t\r\r\u0005X\u00061\u0001b\u0003)I7OT;mY\u0006\u0014G.Z\u0001\u0015O\u0016$H+\u00192mK\u000e{W.\\3oiF+XM]=\u0015\u000b\u0019\u001c9o!;\t\r\u0005%g\u00061\u0001g\u0011\u0019\u0019)F\fa\u0001M\u0006)r-\u001a;TG\",W.Y\"p[6,g\u000e^)vKJLH#\u00024\u0004p\u000eE\bBBB)_\u0001\u0007a\r\u0003\u0004\u0004V=\u0002\rAZ\u0001\u0019e\u0016lwN^3TG\",W.Y\"p[6,g\u000e^)vKJLHc\u00014\u0004x\"11\u0011\u000b\u0019A\u0002\u0019\f!\u0002\u001a:paN\u001b\u0007.Z7b)\u001517Q`B\u0000\u0011\u0019\u0019\t&\ra\u0001M\"1\u0011\u0011^\u0019A\u0002\u0005\f1b\u0019:fCR,\u0017J\u001c3fqRYa\r\"\u0002\u0005\n\u00115A1\u0003C\u0011\u0011\u0019!9A\ra\u0001M\u0006I\u0011N\u001c3fq:\u000bW.\u001a\u0005\b\t\u0017\u0011\u0004\u0019ABD\u0003)!\u0018M\u00197f\u0013\u0012,g\u000e\u001e\u0005\b\t\u001f\u0011\u0004\u0019\u0001C\t\u0003\u001d\u0019w\u000e\\;n]N\u0004R!\u0014BN\u0005wBq\u0001\"\u00063\u0001\u0004!9\"A\td_2,XN\\:Qe>\u0004XM\u001d;jKN\u0004\u0002\u0002\"\u0007\u0005\u001e\tmDqD\u0007\u0003\t7QAA!\u0010\u00020%!!\u0011\u0004C\u000e!\u0019!I\u0002\"\bgM\"9!1\u0003\u001aA\u0002\u0011}\u0011aC5oI\u0016DX\t_5tiN$\u0012\"\u0019C\u0014\tS!Y\u0003\"\f\t\u000f\ru3\u00071\u0001\u0002v!1AqA\u001aA\u0002\u0019Dq\u0001b\u00034\u0001\u0004\u00199\tC\u0004\u0002~M\u0002\r!a \u0002\u0013\u0011\u0014x\u000e]%oI\u0016DH#\u00024\u00054\u0011U\u0002B\u0002C\u0004i\u0001\u0007a\rC\u0004\u0005\fQ\u0002\raa\"\u0002\u00171L7\u000f^%oI\u0016DXm\u001d\u000b\t\tw!I\u0005b\u0013\u0005NA)QJa'\u0005>A!Aq\bC#\u001b\t!\tE\u0003\u0003\u0005D\r\u0005\u0013!B5oI\u0016D\u0018\u0002\u0002C$\t\u0003\u0012!\u0002V1cY\u0016Le\u000eZ3y\u0011\u001d\u0019i&\u000ea\u0001\u0003kBq\u0001b\u00036\u0001\u0004\u00199\tC\u0004\u0002~U\u0002\r!a \u0002#\rd\u0017m]:jMf,\u0005pY3qi&|g\u000e\u0006\u0004\u0005T\u0011mCq\f\t\u0005\t+\"9&D\u0001C\u0013\r!IF\u0011\u0002\u0012\u0003:\fG._:jg\u0016C8-\u001a9uS>t\u0007B\u0002C/m\u0001\u0007a-A\u0004nKN\u001c\u0018mZ3\t\u000f\u0011\u0005d\u00071\u0001\u0005d\u0005\tQ\r\u0005\u0003\u0004&\u0011\u0015\u0014\u0002\u0002C4\u0007g\u0011\u0011\u0002\u00165s_^\f'\r\\3\u0002\u001d\u001d,G\u000fT5nSR\u001cE.Y;tKR\u0019a\r\"\u001c\t\u000f\u0011=t\u00071\u0001\u0005r\u0005)A.[7jiB!!q\u0019C:\u0013\u0011!)H!3\u0003\u000f%sG/Z4fe\u0006yq-\u001a;PM\u001a\u001cX\r^\"mCV\u001cX\rF\u0002g\twBq\u0001\" 9\u0001\u0004!\t(\u0001\u0004pM\u001a\u001cX\r^\u0001\u0017O\u0016$(\n\u001a2d'Fc\u0015+^3ss\n+\u0018\u000e\u001c3feR!A1\u0011CE!\rqFQQ\u0005\u0004\t\u000f\u0003%a\u0005&eE\u000e\u001c\u0016\u000bT)vKJL()^5mI\u0016\u0014\bbBA?s\u0001\u0007\u0011qP\u0001\u000egV\u0004\bo\u001c:ug2KW.\u001b;\u0016\u0003\u0005\fab];qa>\u0014Ho](gMN,G/A\ntkB\u0004xN\u001d;t)\u0006\u0014G.Z*b[BdW-\u0001\bhKR$\u0016M\u00197f'\u0006l\u0007\u000f\\3\u0015\u0007\u0019$9\nC\u0004\u0005\u001av\u0002\r\u0001b'\u0002\rM\fW\u000e\u001d7f!\u0011!i\nb)\u000e\u0005\u0011}%\u0002\u0002CQ\u0003\u000b\u000b!A\u001e\u001a\n\t\u0011\u0015Fq\u0014\u0002\u0010)\u0006\u0014G.Z*b[BdW-\u00138g_\u0006\u0001s-\u001a;Gk2d\u00170U;bY&4\u0017.\u001a3Rk>$X\r\u001a+bE2,g*Y7f)\r1G1\u0016\u0005\b\t[s\u0004\u0019ABD\u0003\u0015IG-\u001a8uQ\u0015q\u0014QHA%Q\r\u0001A1\u0017\t\u0005\u0003\u007f!),\u0003\u0003\u00058\u0006\u0005#\u0001\u0004#fm\u0016dw\u000e]3s\u0003BL\u0007")
public abstract class JdbcDialect
implements scala.Serializable,
Logging {
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public abstract boolean canHandle(String var1);

    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        return None$.MODULE$;
    }

    public Option<JdbcType> getJDBCType(DataType dt) {
        return None$.MODULE$;
    }

    public Timestamp convertJavaTimestampToTimestamp(Timestamp t) {
        return t;
    }

    public LocalDateTime convertJavaTimestampToTimestampNTZ(Timestamp t) {
        return DateTimeUtils$.MODULE$.microsToLocalDateTime(DateTimeUtils$.MODULE$.fromJavaTimestampNoRebase(t));
    }

    public Timestamp convertTimestampNTZToJavaTimestamp(LocalDateTime ldt) {
        long micros = DateTimeUtils$.MODULE$.localDateTimeToMicros(ldt);
        return DateTimeUtils$.MODULE$.toJavaTimestampNoRebase(micros);
    }

    public Function1<Object, Connection> createConnectionFactory(JDBCOptions options) {
        String driverClass = options.driverClass();
        return (Function1 & Serializable & scala.Serializable)partitionId -> JdbcDialect.$anonfun$createConnectionFactory$1(driverClass, options, BoxesRunTime.unboxToInt((Object)partitionId));
    }

    public String quoteIdentifier(String colName) {
        return new StringBuilder(2).append("\"").append(colName).append("\"").toString();
    }

    public void createTable(Statement statement, String tableName, String strSchema, JdbcOptionsInWrite options) {
        String createTableOptions = options.createTableOptions();
        statement.executeUpdate(new StringBuilder(17).append("CREATE TABLE ").append(tableName).append(" (").append(strSchema).append(") ").append(createTableOptions).toString());
    }

    public String getTableExistsQuery(String table) {
        return new StringBuilder(24).append("SELECT 1 FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getSchemaQuery(String table) {
        return new StringBuilder(24).append("SELECT * FROM ").append(table).append(" WHERE 1=0").toString();
    }

    public String getTruncateQuery(String table) {
        return this.getTruncateQuery(table, this.isCascadingTruncateTable());
    }

    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(15).append("TRUNCATE TABLE ").append(table).toString();
    }

    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    public void beforeFetch(Connection connection, scala.collection.immutable.Map<String, String> properties) {
    }

    public String escapeSql(String value) {
        if (value == null) {
            return null;
        }
        return StringUtils.replace((String)value, (String)"'", (String)"''");
    }

    public Object compileValue(Object value2) {
        Object object = value2;
        if (object instanceof String) {
            String string = (String)object;
            return new StringBuilder(2).append("'").append(this.escapeSql(string)).append("'").toString();
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return new StringBuilder(2).append("'").append(timestamp).append("'").toString();
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.getFractionFormatter(DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
            return new StringBuilder(2).append("'").append(timestampFormatter.format(instant)).append("'").toString();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return new StringBuilder(2).append("'").append(date).append("'").toString();
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return new StringBuilder(2).append("'").append(DateFormatter$.MODULE$.apply().format(localDate)).append("'").toString();
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return Predef$.MODULE$.genericArrayOps(Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1 & Serializable & scala.Serializable)value -> this.compileValue(value), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()))).mkString(", ");
        }
        return value2;
    }

    public boolean isSupportedFunction(String funcName) {
        return false;
    }

    public Option<String> compileExpression(Expression expr) {
        Some some;
        JDBCSQLBuilder jdbcSQLBuilder = new JDBCSQLBuilder();
        try {
            some = new Some((Object)jdbcSQLBuilder.build(expr));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurs while compiling V2 expression", e);
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    public Option<String> compileAggregate(AggregateFunc aggFunction) {
        return this.compileExpression((Expression)aggFunction);
    }

    public Seq<Tuple2<String, UnboundFunction>> functions() {
        return Nil$.MODULE$;
    }

    public void createSchema(Statement statement, String schema, String comment) {
        String schemaCommentQuery = new StringOps(Predef$.MODULE$.augmentString(comment)).nonEmpty() ? this.getSchemaCommentQuery(schema, comment) : comment;
        statement.executeUpdate(new StringBuilder(14).append("CREATE SCHEMA ").append(this.quoteIdentifier(schema)).toString());
        if (new StringOps(Predef$.MODULE$.augmentString(comment)).nonEmpty()) {
            statement.executeUpdate(schemaCommentQuery);
            return;
        }
    }

    public boolean schemasExists(Connection conn, JDBCOptions options, String schema) {
        ResultSet rs = conn.getMetaData().getSchemas(null, schema);
        while (rs.next()) {
            String string = rs.getString(1);
            String string2 = schema;
            if (string != null ? !string.equals(string2) : string2 != null) continue;
            return true;
        }
        return false;
    }

    public String[][] listSchemas(Connection conn, JDBCOptions options) {
        ArrayBuilder schemaBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        ResultSet rs = conn.getMetaData().getSchemas();
        while (rs.next()) {
            schemaBuilder.$plus$eq((Object)new String[]{rs.getString(1)});
        }
        return (String[][])schemaBuilder.result();
    }

    public Option<Object> isCascadingTruncateTable() {
        return None$.MODULE$;
    }

    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(23).append("ALTER TABLE ").append(oldTable).append(" RENAME TO ").append(newTable).toString();
    }

    public String renameTable(Identifier oldTable, Identifier newTable) {
        return new StringBuilder(23).append("ALTER TABLE ").append(this.getFullyQualifiedQuotedTableName(oldTable)).append(" RENAME TO ").append(this.getFullyQualifiedQuotedTableName(newTable)).toString();
    }

    public String[] alterTable(String tableName, Seq<TableChange> changes, int dbMajorVersion) {
        ArrayBuilder updateClause = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(String.class));
        changes.foreach((Function1 & Serializable & scala.Serializable)change -> {
            TableChange.UpdateColumnNullability updateColumnNullability;
            TableChange.UpdateColumnType updateColumnType;
            TableChange.DeleteColumn deleteColumn;
            TableChange.RenameColumn renameColumn;
            TableChange.AddColumn addColumn;
            TableChange tableChange = change;
            if (tableChange instanceof TableChange.AddColumn && (addColumn = (TableChange.AddColumn)tableChange).fieldNames().length == 1) {
                String dataType = JdbcUtils$.MODULE$.getJdbcType(addColumn.dataType(), this).databaseTypeDefinition();
                String[] name = addColumn.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getAddColumnQuery(tableName, name[0], dataType));
            }
            if (tableChange instanceof TableChange.RenameColumn && (renameColumn = (TableChange.RenameColumn)tableChange).fieldNames().length == 1) {
                String[] name = renameColumn.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getRenameColumnQuery(tableName, name[0], renameColumn.newName(), dbMajorVersion));
            }
            if (tableChange instanceof TableChange.DeleteColumn && (deleteColumn = (TableChange.DeleteColumn)tableChange).fieldNames().length == 1) {
                String[] name = deleteColumn.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getDeleteColumnQuery(tableName, name[0]));
            }
            if (tableChange instanceof TableChange.UpdateColumnType && (updateColumnType = (TableChange.UpdateColumnType)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnType.fieldNames();
                String dataType = JdbcUtils$.MODULE$.getJdbcType(updateColumnType.newDataType(), this).databaseTypeDefinition();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnTypeQuery(tableName, name[0], dataType));
            }
            if (tableChange instanceof TableChange.UpdateColumnNullability && (updateColumnNullability = (TableChange.UpdateColumnNullability)tableChange).fieldNames().length == 1) {
                String[] name = updateColumnNullability.fieldNames();
                return (ArrayBuilder)updateClause.$plus$eq((Object)this.getUpdateColumnNullabilityQuery(tableName, name[0], updateColumnNullability.nullable()));
            }
            throw QueryCompilationErrors$.MODULE$.unsupportedTableChangeInJDBCCatalogError(change);
        });
        return (String[])updateClause.result();
    }

    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" ADD COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(dataType).toString();
    }

    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" RENAME COLUMN ").append(this.quoteIdentifier(columnName)).append(" TO").append(" ").append(this.quoteIdentifier(newName)).toString();
    }

    public String getDeleteColumnQuery(String tableName, String columnName) {
        return new StringBuilder(25).append("ALTER TABLE ").append(tableName).append(" DROP COLUMN ").append(this.quoteIdentifier(columnName)).toString();
    }

    public String getUpdateColumnTypeQuery(String tableName, String columnName, String newDataType) {
        return new StringBuilder(27).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" ").append(newDataType).toString();
    }

    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        String nullable = isNullable ? "NULL" : "NOT NULL";
        return new StringBuilder(31).append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(this.quoteIdentifier(columnName)).append(" SET ").append(nullable).toString();
    }

    public String getTableCommentQuery(String table, String comment) {
        return new StringBuilder(23).append("COMMENT ON TABLE ").append(table).append(" IS '").append(comment).append("'").toString();
    }

    public String getSchemaCommentQuery(String schema, String comment) {
        return new StringBuilder(24).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS '").append(comment).append("'").toString();
    }

    public String removeSchemaCommentQuery(String schema) {
        return new StringBuilder(26).append("COMMENT ON SCHEMA ").append(this.quoteIdentifier(schema)).append(" IS NULL").toString();
    }

    public String dropSchema(String schema, boolean cascade) {
        if (cascade) {
            return new StringBuilder(20).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).append(" CASCADE").toString();
        }
        return new StringBuilder(12).append("DROP SCHEMA ").append(this.quoteIdentifier(schema)).toString();
    }

    public String createIndex(String indexName, Identifier tableIdent, NamedReference[] columns, Map<NamedReference, Map<String, String>> columnsProperties, Map<String, String> properties) {
        throw new UnsupportedOperationException("createIndex is not supported");
    }

    public boolean indexExists(Connection conn, String indexName, Identifier tableIdent, JDBCOptions options) {
        throw new UnsupportedOperationException("indexExists is not supported");
    }

    public String dropIndex(String indexName, Identifier tableIdent) {
        throw new UnsupportedOperationException("dropIndex is not supported");
    }

    public TableIndex[] listIndexes(Connection conn, Identifier tableIdent, JDBCOptions options) {
        throw new UnsupportedOperationException("listIndexes is not supported");
    }

    public AnalysisException classifyException(String message, Throwable e) {
        String x$1 = message;
        Some x$2 = new Some((Object)e);
        Option x$3 = AnalysisException$.MODULE$.$lessinit$greater$default$2();
        Option x$4 = AnalysisException$.MODULE$.$lessinit$greater$default$3();
        Option x$5 = AnalysisException$.MODULE$.$lessinit$greater$default$5();
        scala.collection.immutable.Map x$6 = AnalysisException$.MODULE$.$lessinit$greater$default$6();
        QueryContext[] x$7 = AnalysisException$.MODULE$.$lessinit$greater$default$7();
        return new AnalysisException(x$1, x$3, x$4, (Option)x$2, x$5, x$6, x$7);
    }

    public String getLimitClause(Integer limit) {
        if (Predef$.MODULE$.Integer2int(limit) > 0) {
            return new StringBuilder(6).append("LIMIT ").append(limit).toString();
        }
        return "";
    }

    public String getOffsetClause(Integer offset) {
        if (Predef$.MODULE$.Integer2int(offset) > 0) {
            return new StringBuilder(7).append("OFFSET ").append(offset).toString();
        }
        return "";
    }

    public JdbcSQLQueryBuilder getJdbcSQLQueryBuilder(JDBCOptions options) {
        return new JdbcSQLQueryBuilder(this, options);
    }

    public boolean supportsLimit() {
        return false;
    }

    public boolean supportsOffset() {
        return false;
    }

    public boolean supportsTableSample() {
        return false;
    }

    public String getTableSample(TableSampleInfo sample) {
        throw new UnsupportedOperationException("TableSample is not supported by this data source");
    }

    public String getFullyQualifiedQuotedTableName(Identifier ident) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).$colon$plus((Object)ident.name(), ClassTag$.MODULE$.apply(String.class)))).map((Function1 & Serializable & scala.Serializable)colName -> this.quoteIdentifier((String)colName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(".");
    }

    public static final /* synthetic */ Connection $anonfun$createConnectionFactory$1(String driverClass$1, JDBCOptions options$1, int partitionId) {
        DriverRegistry$.MODULE$.register(driverClass$1);
        Driver driver = DriverRegistry$.MODULE$.get(driverClass$1);
        Connection connection = ConnectionProvider$.MODULE$.create(driver, (scala.collection.immutable.Map<String, String>)options$1.parameters(), options$1.connectionProviderName());
        Predef$.MODULE$.require(connection != null, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("The driver could not open a JDBC connection. Check the URL: ").append(options$1.url()).toString());
        return connection;
    }

    public JdbcDialect() {
        Logging.$init$((Logging)this);
    }

    public class JDBCSQLBuilder
    extends V2ExpressionSQLBuilder {
        private /* synthetic */ String super$visitLiteral(Literal x$1) {
            return super.visitLiteral(x$1);
        }

        public String visitLiteral(Literal<?> literal) {
            return (String)Option$.MODULE$.apply(literal.value()).map((Function1 & Serializable & scala.Serializable)v -> this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().compileValue(CatalystTypeConverters$.MODULE$.convertToScala(v, literal.dataType())).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.super$visitLiteral(literal));
        }

        public String visitNamedReference(NamedReference namedRef) {
            if (namedRef.fieldNames().length > 1) {
                throw QueryCompilationErrors$.MODULE$.commandNotSupportNestedColumnError("Filter push down", namedRef.toString());
            }
            return this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().quoteIdentifier((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namedRef.fieldNames())).head());
        }

        public String visitCast(String l, DataType dataType) {
            String databaseTypeDefinition = (String)this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().getJDBCType(dataType).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.databaseTypeDefinition()).getOrElse((Function0 & Serializable & scala.Serializable)() -> dataType.typeName());
            return new StringBuilder(10).append("CAST(").append(l).append(" AS ").append(databaseTypeDefinition).append(")").toString();
        }

        public String visitSQLFunction(String funcName, String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                return new StringBuilder(2).append(this.dialectFunctionName(funcName)).append("(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])inputs)).mkString(", ")).append(")").toString();
            }
            throw new UnsupportedOperationException(new StringBuilder(28).append(this.getClass().getSimpleName()).append(" does not support function: ").append(funcName).toString());
        }

        public String visitAggregateFunction(String funcName, boolean isDistinct, String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction(funcName)) {
                return super.visitAggregateFunction(this.dialectFunctionName(funcName), isDistinct, inputs);
            }
            throw new UnsupportedOperationException(new StringBuilder(38).append(this.getClass().getSimpleName()).append(" does not support aggregate function: ").append(funcName).toString());
        }

        public String dialectFunctionName(String funcName) {
            return funcName;
        }

        public String visitOverlay(String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction("OVERLAY")) {
                return super.visitOverlay(inputs);
            }
            throw new UnsupportedOperationException(new StringBuilder(35).append(this.getClass().getSimpleName()).append(" does not support function: OVERLAY").toString());
        }

        public String visitTrim(String direction, String[] inputs) {
            if (this.org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer().isSupportedFunction("TRIM")) {
                return super.visitTrim(direction, inputs);
            }
            throw new UnsupportedOperationException(new StringBuilder(32).append(this.getClass().getSimpleName()).append(" does not support function: TRIM").toString());
        }

        public /* synthetic */ JdbcDialect org$apache$spark$sql$jdbc$JdbcDialect$JDBCSQLBuilder$$$outer() {
            return JdbcDialect.this;
        }

        public JDBCSQLBuilder() {
            if (JdbcDialect.this == null) {
                throw null;
            }
        }
    }
}

