/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.connector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.connector.TestingV2Source;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.InputPartition;
import org.apache.spark.sql.connector.read.PartitionReader;
import org.apache.spark.sql.connector.read.PartitionReaderFactory;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.read.SupportsPushDownFilters;
import org.apache.spark.sql.connector.read.SupportsPushDownRequiredColumns;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import test.org.apache.spark.sql.connector.JavaRangeInputPartition;
import test.org.apache.spark.sql.connector.JavaSimpleBatchTable;

public class JavaAdvancedDataSourceV2
implements TestingV2Source {
    @Override
    public Table getTable(CaseInsensitiveStringMap options) {
        return new JavaSimpleBatchTable(){

            public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
                return new AdvancedScanBuilder();
            }
        };
    }

    static class AdvancedReaderFactory
    implements PartitionReaderFactory {
        StructType requiredSchema;

        AdvancedReaderFactory(StructType requiredSchema) {
            this.requiredSchema = requiredSchema;
        }

        public PartitionReader<InternalRow> createReader(InputPartition partition) {
            final JavaRangeInputPartition p = (JavaRangeInputPartition)partition;
            return new PartitionReader<InternalRow>(){
                private int current;
                {
                    this.current = p.start - 1;
                }

                public boolean next() throws IOException {
                    ++this.current;
                    return this.current < p.end;
                }

                public InternalRow get() {
                    Object[] values = new Object[requiredSchema.size()];
                    for (int i = 0; i < values.length; ++i) {
                        if ("i".equals(requiredSchema.apply(i).name())) {
                            values[i] = this.current;
                            continue;
                        }
                        if (!"j".equals(requiredSchema.apply(i).name())) continue;
                        values[i] = -this.current;
                    }
                    return new GenericInternalRow(values);
                }

                public void close() throws IOException {
                }
            };
        }
    }

    public static class AdvancedBatch
    implements Batch {
        public StructType requiredSchema;
        public Filter[] filters;

        AdvancedBatch(StructType requiredSchema, Filter[] filters) {
            this.requiredSchema = requiredSchema;
            this.filters = filters;
        }

        public InputPartition[] planInputPartitions() {
            ArrayList<JavaRangeInputPartition> res = new ArrayList<JavaRangeInputPartition>();
            Integer lowerBound = null;
            for (Filter filter : this.filters) {
                GreaterThan f;
                if (!(filter instanceof GreaterThan) || !"i".equals((f = (GreaterThan)filter).attribute()) || !(f.value() instanceof Integer)) continue;
                lowerBound = (Integer)f.value();
                break;
            }
            if (lowerBound == null) {
                res.add(new JavaRangeInputPartition(0, 5));
                res.add(new JavaRangeInputPartition(5, 10));
            } else if (lowerBound < 4) {
                res.add(new JavaRangeInputPartition(lowerBound + 1, 5));
                res.add(new JavaRangeInputPartition(5, 10));
            } else if (lowerBound < 9) {
                res.add(new JavaRangeInputPartition(lowerBound + 1, 10));
            }
            return (InputPartition[])res.stream().toArray(InputPartition[]::new);
        }

        public PartitionReaderFactory createReaderFactory() {
            return new AdvancedReaderFactory(this.requiredSchema);
        }
    }

    static class AdvancedScanBuilder
    implements ScanBuilder,
    Scan,
    SupportsPushDownFilters,
    SupportsPushDownRequiredColumns {
        private StructType requiredSchema = TestingV2Source.schema();
        private Filter[] filters = new Filter[0];

        AdvancedScanBuilder() {
        }

        public void pruneColumns(StructType requiredSchema) {
            this.requiredSchema = requiredSchema;
        }

        public StructType readSchema() {
            return this.requiredSchema;
        }

        public Filter[] pushFilters(Filter[] filters) {
            Filter[] supported = (Filter[])Arrays.stream(filters).filter(f -> {
                if (f instanceof GreaterThan) {
                    GreaterThan gt = (GreaterThan)f;
                    return gt.attribute().equals("i") && gt.value() instanceof Integer;
                }
                return false;
            }).toArray(Filter[]::new);
            Filter[] unsupported = (Filter[])Arrays.stream(filters).filter(f -> {
                if (f instanceof GreaterThan) {
                    GreaterThan gt = (GreaterThan)f;
                    return !gt.attribute().equals("i") || !(gt.value() instanceof Integer);
                }
                return true;
            }).toArray(Filter[]::new);
            this.filters = supported;
            return unsupported;
        }

        public Filter[] pushedFilters() {
            return this.filters;
        }

        public Scan build() {
            return this;
        }

        public Batch toBatch() {
            return new AdvancedBatch(this.requiredSchema, this.filters);
        }
    }
}

