/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.collection.JavaConverters;

public class JavaHigherOrderFunctionsSuite {
    private transient TestSparkSession spark;
    private Dataset<Row> arrDf;
    private Dataset<Row> mapDf;

    private void checkAnswer(Dataset<Row> actualDS, List<Row> expected) throws Exception {
        List actual = actualDS.collectAsList();
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Row expectedRow = expected.get(i);
            Row actualRow = (Row)actual.get(i);
            Assert.assertEquals((long)expectedRow.size(), (long)actualRow.size());
            for (int j = 0; j < expectedRow.size(); ++j) {
                Object expectedValue = expectedRow.get(j);
                Object actualValue = actualRow.get(j);
                if (expectedValue != null && expectedValue.getClass().isArray()) {
                    actualValue = actualValue.getClass().getMethod("array", new Class[0]).invoke(actualValue, new Object[0]);
                    Assert.assertArrayEquals((Object[])((Object[])expectedValue), (Object[])((Object[])actualValue));
                    continue;
                }
                Assert.assertEquals((Object)expectedValue, (Object)actualValue);
            }
        }
    }

    @SafeVarargs
    private static <T> List<Row> toRows(T ... objs) {
        return Arrays.stream(objs).map(xva$0 -> RowFactory.create((Object[])new Object[]{xva$0})).collect(Collectors.toList());
    }

    @SafeVarargs
    private static <T> T[] makeArray(T ... ts) {
        return ts;
    }

    private void setUpArrDf() {
        List<Row> data = JavaHigherOrderFunctionsSuite.toRows(JavaHigherOrderFunctionsSuite.makeArray(1, 9, 8, 7), JavaHigherOrderFunctionsSuite.makeArray(5, 8, 9, 7, 2), JavaHigherOrderFunctionsSuite.makeArray(new Integer[0]), null);
        StructType schema = new StructType().add("x", (DataType)new ArrayType(DataTypes.IntegerType, true), true);
        this.arrDf = this.spark.createDataFrame(data, schema);
    }

    private void setUpMapDf() {
        List<Row> data = JavaHigherOrderFunctionsSuite.toRows(new HashMap<Integer, Integer>(){
            {
                this.put(1, 1);
                this.put(2, 2);
            }
        }, null);
        StructType schema = new StructType().add("x", (DataType)new MapType(DataTypes.IntegerType, DataTypes.IntegerType, true));
        this.mapDf = this.spark.createDataFrame(data, schema);
    }

    @Before
    public void setUp() {
        this.spark = new TestSparkSession();
        this.setUpArrDf();
        this.setUpMapDf();
    }

    @After
    public void tearDown() {
        this.spark.stop();
        this.spark = null;
    }

    @Test
    public void testTransform() throws Exception {
        this.checkAnswer((Dataset<Row>)this.arrDf.select(new Column[]{functions.transform((Column)functions.col((String)"x"), x -> x.plus((Object)1))}), JavaHigherOrderFunctionsSuite.toRows(JavaHigherOrderFunctionsSuite.makeArray(2, 10, 9, 8), JavaHigherOrderFunctionsSuite.makeArray(6, 9, 10, 8, 3), JavaHigherOrderFunctionsSuite.makeArray(new Integer[0]), null));
        this.checkAnswer((Dataset<Row>)this.arrDf.select(new Column[]{functions.transform((Column)functions.col((String)"x"), (x, i) -> x.plus(i))}), JavaHigherOrderFunctionsSuite.toRows(JavaHigherOrderFunctionsSuite.makeArray(1, 10, 10, 10), JavaHigherOrderFunctionsSuite.makeArray(5, 9, 11, 10, 6), JavaHigherOrderFunctionsSuite.makeArray(new Integer[0]), null));
    }

    @Test
    public void testFilter() throws Exception {
        this.checkAnswer((Dataset<Row>)this.arrDf.select(new Column[]{functions.filter((Column)functions.col((String)"x"), x -> x.plus((Object)1).equalTo((Object)10))}), JavaHigherOrderFunctionsSuite.toRows(JavaHigherOrderFunctionsSuite.makeArray(9), JavaHigherOrderFunctionsSuite.makeArray(9), JavaHigherOrderFunctionsSuite.makeArray(new Integer[0]), null));
        this.checkAnswer((Dataset<Row>)this.arrDf.select(new Column[]{functions.filter((Column)functions.col((String)"x"), (x, i) -> x.plus(i).equalTo((Object)10))}), JavaHigherOrderFunctionsSuite.toRows(JavaHigherOrderFunctionsSuite.makeArray(9, 8, 7), JavaHigherOrderFunctionsSuite.makeArray(7), JavaHigherOrderFunctionsSuite.makeArray(new Integer[0]), null));
    }

    @Test
    public void testExists() throws Exception {
        this.checkAnswer((Dataset<Row>)this.arrDf.select(new Column[]{functions.exists((Column)functions.col((String)"x"), x -> x.plus((Object)1).equalTo((Object)10))}), JavaHigherOrderFunctionsSuite.toRows(true, true, false, null));
    }

    @Test
    public void testForall() throws Exception {
        this.checkAnswer((Dataset<Row>)this.arrDf.select(new Column[]{functions.forall((Column)functions.col((String)"x"), x -> x.plus((Object)1).equalTo((Object)10))}), JavaHigherOrderFunctionsSuite.toRows(false, false, true, null));
    }

    @Test
    public void testAggregate() throws Exception {
        this.checkAnswer((Dataset<Row>)this.arrDf.select(new Column[]{functions.aggregate((Column)functions.col((String)"x"), (Column)functions.lit((Object)0), (acc, x) -> acc.plus(x))}), JavaHigherOrderFunctionsSuite.toRows(25, 31, 0, null));
        this.checkAnswer((Dataset<Row>)this.arrDf.select(new Column[]{functions.aggregate((Column)functions.col((String)"x"), (Column)functions.lit((Object)0), (acc, x) -> acc.plus(x), x -> x)}), JavaHigherOrderFunctionsSuite.toRows(25, 31, 0, null));
    }

    @Test
    public void testZipWith() throws Exception {
        this.checkAnswer((Dataset<Row>)this.arrDf.select(new Column[]{functions.zip_with((Column)functions.col((String)"x"), (Column)functions.col((String)"x"), (a, b) -> functions.lit((Object)42))}), JavaHigherOrderFunctionsSuite.toRows(JavaHigherOrderFunctionsSuite.makeArray(42, 42, 42, 42), JavaHigherOrderFunctionsSuite.makeArray(42, 42, 42, 42, 42), JavaHigherOrderFunctionsSuite.makeArray(new Integer[0]), null));
    }

    @Test
    public void testTransformKeys() throws Exception {
        this.checkAnswer((Dataset<Row>)this.mapDf.select(new Column[]{functions.transform_keys((Column)functions.col((String)"x"), (k, v) -> k.plus(v))}), JavaHigherOrderFunctionsSuite.toRows(JavaConverters.mapAsScalaMap((Map)new HashMap<Integer, Integer>(){
            {
                this.put(2, 1);
                this.put(4, 2);
            }
        }), null));
    }

    @Test
    public void testTransformValues() throws Exception {
        this.checkAnswer((Dataset<Row>)this.mapDf.select(new Column[]{functions.transform_values((Column)functions.col((String)"x"), (k, v) -> k.plus(v))}), JavaHigherOrderFunctionsSuite.toRows(JavaConverters.mapAsScalaMap((Map)new HashMap<Integer, Integer>(){
            {
                this.put(1, 2);
                this.put(2, 4);
            }
        }), null));
    }

    @Test
    public void testMapFilter() throws Exception {
        this.checkAnswer((Dataset<Row>)this.mapDf.select(new Column[]{functions.map_filter((Column)functions.col((String)"x"), (k, v) -> functions.lit((Object)false))}), JavaHigherOrderFunctionsSuite.toRows(JavaConverters.mapAsScalaMap(new HashMap()), null));
    }

    @Test
    public void testMapZipWith() throws Exception {
        this.checkAnswer((Dataset<Row>)this.mapDf.select(new Column[]{functions.map_zip_with((Column)functions.col((String)"x"), (Column)functions.col((String)"x"), (k, v1, v2) -> functions.lit((Object)false))}), JavaHigherOrderFunctionsSuite.toRows(JavaConverters.mapAsScalaMap((Map)new HashMap<Integer, Boolean>(){
            {
                this.put(1, false);
                this.put(2, false);
            }
        }), null));
    }
}

