/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.sql.LocalSparkSession$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.streaming.StatefulOperatorStateInfo;
import org.apache.spark.sql.execution.streaming.state.StateStore;
import org.apache.spark.sql.execution.streaming.state.StateStore$;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreId;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.execution.streaming.state.StateStoreProviderId;
import org.apache.spark.sql.execution.streaming.state.StateStoreRDD;
import org.apache.spark.sql.execution.streaming.state.StateStoreTestsHelper$;
import org.apache.spark.sql.execution.streaming.state.UnsafeRowPair;
import org.apache.spark.sql.execution.streaming.state.package$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.CompletionIterator$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\t\u0013\u0001\u0005BQa\f\u0001\u0005\u0002ABqa\r\u0001C\u0002\u0013%A\u0007\u0003\u00049\u0001\u0001\u0006I!\u000e\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\u0019\u0005\u0001)A\u0005w!9A\t\u0001b\u0001\n\u0013)\u0005B\u0002'\u0001A\u0003%a\tC\u0004N\u0001\t\u0007I\u0011B#\t\r9\u0003\u0001\u0015!\u0003G\u0011\u0015y\u0005\u0001\"\u0011Q\u0011\u00159\u0006\u0001\"\u0003Y\u0011\u0019y\b\u0001\"\u0003\u0002\u0002!I\u00111\u0005\u0001\u0012\u0002\u0013%\u0011Q\u0005\u0005\n\u0003w\u0001\u0011\u0013!C\u0005\u0003{A\u0011\"!\u0011\u0001\u0005\u0004%I!a\u0011\t\u0011\u0005\r\u0004\u0001)A\u0005\u0003\u000b\u0012!c\u0015;bi\u0016\u001cFo\u001c:f%\u0012#5+^5uK*\u00111\u0003F\u0001\u0006gR\fG/\u001a\u0006\u0003+Y\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005]A\u0012!C3yK\u000e,H/[8o\u0015\tI\"$A\u0002tc2T!a\u0007\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005uq\u0012AB1qC\u000eDWMC\u0001 \u0003\ry'oZ\u0002\u0001'\u0011\u0001!E\n\u0017\u0011\u0005\r\"S\"\u0001\u000e\n\u0005\u0015R\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002(U5\t\u0001F\u0003\u0002*=\u0005I1oY1mCR,7\u000f^\u0005\u0003W!\u0012aBQ3g_J,\u0017I\u001c3BMR,'\u000f\u0005\u0002([%\u0011a\u0006\u000b\u0002\u0012\u0005\u00164wN]3B]\u0012\fe\r^3s\u00032d\u0017A\u0002\u001fj]&$h\bF\u00012!\t\u0011\u0004!D\u0001\u0013\u0003%\u0019\b/\u0019:l\u0007>tg-F\u00016!\t\u0019c'\u0003\u000285\tI1\u000b]1sW\u000e{gNZ\u0001\u000bgB\f'o[\"p]\u001a\u0004\u0013a\u0002;f[B$\u0015N]\u000b\u0002wA\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\u0005Y\u0006twMC\u0001A\u0003\u0011Q\u0017M^1\n\u0005\tk$AB*ue&tw-\u0001\u0005uK6\u0004H)\u001b:!\u0003%YW-_*dQ\u0016l\u0017-F\u0001G!\t9%*D\u0001I\u0015\tI\u0005$A\u0003usB,7/\u0003\u0002L\u0011\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0015-,\u0017pU2iK6\f\u0007%A\u0006wC2,XmU2iK6\f\u0017\u0001\u0004<bYV,7k\u00195f[\u0006\u0004\u0013\u0001C1gi\u0016\u0014\u0018\t\u001c7\u0015\u0003E\u0003\"AU+\u000e\u0003MS\u0011\u0001V\u0001\u0006g\u000e\fG.Y\u0005\u0003-N\u0013A!\u00168ji\u00069Q.Y6f%\u0012#EcA-piB\u0019!,X0\u000e\u0003mS!\u0001\u0018\u000e\u0002\u0007I$G-\u0003\u0002_7\n\u0019!\u000b\u0012#\u0011\tI\u0003'\r\\\u0005\u0003CN\u0013a\u0001V;qY\u0016\u0014\u0004CA2k\u001d\t!\u0007\u000e\u0005\u0002f'6\taM\u0003\u0002hA\u00051AH]8pizJ!![*\u0002\rA\u0013X\rZ3g\u0013\t\u00115N\u0003\u0002j'B\u0011!+\\\u0005\u0003]N\u00131!\u00138u\u0011\u0015\u00018\u00021\u0001r\u0003\t\u00198\r\u0005\u0002$e&\u00111O\u0007\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006k.\u0001\rA^\u0001\u0004g\u0016\f\bcA<}?:\u0011\u0001P\u001f\b\u0003KfL\u0011\u0001V\u0005\u0003wN\u000bq\u0001]1dW\u0006<W-\u0003\u0002~}\n\u00191+Z9\u000b\u0005m\u001c\u0016!E8qKJ\fGo\u001c:Ti\u0006$X-\u00138g_RA\u00111AA\u0006\u0003\u001f\ty\u0002\u0005\u0003\u0002\u0006\u0005\u001dQ\"\u0001\u000b\n\u0007\u0005%ACA\rTi\u0006$XMZ;m\u001fB,'/\u0019;peN#\u0018\r^3J]\u001a|\u0007BBA\u0007\u0019\u0001\u0007!-\u0001\u0003qCRD\u0007\"CA\t\u0019A\u0005\t\u0019AA\n\u0003)\tX/\u001a:z%Vt\u0017\n\u001a\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D \u0002\tU$\u0018\u000e\\\u0005\u0005\u0003;\t9B\u0001\u0003V+&#\u0005\u0002CA\u0011\u0019A\u0005\t\u0019\u00017\u0002\u000fY,'o]5p]\u0006Yr\u000e]3sCR|'o\u0015;bi\u0016LeNZ8%I\u00164\u0017-\u001e7uII*\"!a\n+\t\u0005M\u0011\u0011F\u0016\u0003\u0003W\u0001B!!\f\u000285\u0011\u0011q\u0006\u0006\u0005\u0003c\t\u0019$A\u0005v]\u000eDWmY6fI*\u0019\u0011QG*\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002:\u0005=\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006Yr\u000e]3sCR|'o\u0015;bi\u0016LeNZ8%I\u00164\u0017-\u001e7uIM*\"!a\u0010+\u00071\fI#A\u0005j]\u000e\u0014X-\\3oiV\u0011\u0011Q\t\t\n%\u0006\u001d\u00131JA)\u0003/J1!!\u0013T\u0005%1UO\\2uS>t'\u0007E\u00023\u0003\u001bJ1!a\u0014\u0013\u0005)\u0019F/\u0019;f'R|'/\u001a\t\u0005o\u0006Ms,C\u0002\u0002Vy\u0014\u0001\"\u0013;fe\u0006$xN\u001d\t\u0007\u00033\ny&!\u0019\u000e\u0005\u0005m#bAA/'\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u00131\f\t\u0005%\u0002|F.\u0001\u0006j]\u000e\u0014X-\\3oi\u0002\u0002")
public class StateStoreRDDSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private final SparkConf sparkConf;
    private final String tempDir;
    private final StructType keySchema;
    private final StructType valueSchema;
    private final Function2<StateStore, Iterator<Tuple2<String, Object>>, Iterator<Tuple2<Tuple2<String, Object>, Object>>> increment;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    private String tempDir() {
        return this.tempDir;
    }

    private StructType keySchema() {
        return this.keySchema;
    }

    private StructType valueSchema() {
        return this.valueSchema;
    }

    public void afterAll() {
        try {
            super.afterAll();
        }
        finally {
            Utils$.MODULE$.deleteRecursively(new File(this.tempDir()));
        }
    }

    private RDD<Tuple2<String, Object>> makeRDD(SparkContext sc, Seq<Tuple2<String, Object>> seq) {
        return sc.makeRDD(seq, 2, ClassTag$.MODULE$.apply(Tuple2.class)).groupBy((Function1 & Serializable & scala.Serializable)x -> x, ClassTag$.MODULE$.apply(Tuple2.class)).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Iterable)x$1._2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private StatefulOperatorStateInfo operatorStateInfo(String path, UUID queryRunId, int version) {
        return new StatefulOperatorStateInfo(path, queryRunId, 0L, (long)version, 5);
    }

    private UUID operatorStateInfo$default$2() {
        return UUID.randomUUID();
    }

    private int operatorStateInfo$default$3() {
        return 0;
    }

    private Function2<StateStore, Iterator<Tuple2<String, Object>>, Iterator<Tuple2<Tuple2<String, Object>, Object>>> increment() {
        return this.increment;
    }

    private final RDD makeStoreRDD$1(SparkSession spark, Seq seq, int storeVersion, String path$1) {
        SQLContext sqlContext = spark.sqlContext();
        String x$1 = path$1;
        int x$2 = storeVersion;
        UUID x$3 = this.operatorStateInfo$default$2();
        return package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$1, x$3, x$2), this.keySchema(), this.valueSchema(), 0, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static final /* synthetic */ void $anonfun$new$5(StateStoreRDDSuite $this, String path$1, SparkSession spark) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 20).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Predef$.MODULE$.require($this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.makeStoreRDD$1(spark, (Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$), i - 1, path$1).collect())).toSet()).$eq$eq$eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)i))})), Equality$.MODULE$.default())));
    }

    private static final Iterator iteratorOfPuts$1(StateStore store, Iterator iter) {
        Iterator resIterator = iter.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String s = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            UnsafeRow key = StateStoreTestsHelper$.MODULE$.dataToKeyRow(s, i);
            int oldValue = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)store.get(key)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.valueRowToData(row))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            int newValue = oldValue + 1;
            store.put(key, StateStoreTestsHelper$.MODULE$.dataToValueRow(newValue));
            Tuple2 tuple22 = new Tuple2((Object)new Tuple2((Object)s, (Object)BoxesRunTime.boxToInteger((int)i)), (Object)BoxesRunTime.boxToInteger((int)newValue));
            return tuple22;
        });
        return CompletionIterator$.MODULE$.apply(resIterator, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> store.commit());
    }

    private static final Iterator iteratorOfGets$1(StateStore store, Iterator iter) {
        return iter.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String s = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            UnsafeRow key = StateStoreTestsHelper$.MODULE$.dataToKeyRow(s, i);
            Option value = Option$.MODULE$.apply((Object)store.get(key)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.valueRowToData(row)));
            Tuple2 tuple22 = new Tuple2((Object)new Tuple2((Object)s, (Object)BoxesRunTime.boxToInteger((int)i)), (Object)value);
            return tuple22;
        });
    }

    public static final /* synthetic */ void $anonfun$increment$2(StateStore store$3, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String s = (String)tuple2._1();
        int i = tuple2._2$mcI$sp();
        UnsafeRow key = StateStoreTestsHelper$.MODULE$.dataToKeyRow(s, i);
        int oldValue = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)store$3.get(key)).map((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)StateStoreTestsHelper$.MODULE$.valueRowToData(row))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        store$3.put(key, StateStoreTestsHelper$.MODULE$.dataToValueRow(oldValue + 1));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public StateStoreRDDSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.sparkConf = new SparkConf().setMaster("local").setAppName(this.getClass().getSimpleName());
        this.tempDir = ((Object)Files.createTempDirectory("StateStoreRDDSuite", new FileAttribute[0])).toString();
        this.keySchema = StateStoreTestsHelper$.MODULE$.keySchema();
        this.valueSchema = StateStoreTestsHelper$.MODULE$.valueSchema();
        this.after((Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> StateStore$.MODULE$.stop(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
        this.test("versioning and immutability", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
            String path;
            String x$1 = path = Utils$.MODULE$.createDirectory(this.tempDir(), Float.toString(Random$.MODULE$.nextFloat())).toString();
            int x$2 = 0;
            UUID x$3 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd1 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(spark.sqlContext(), this.operatorStateInfo(x$1, x$3, x$2), this.keySchema(), this.valueSchema(), 0, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            String x$4 = path;
            int x$5 = 1;
            UUID x$6 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd2 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$)))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(spark.sqlContext(), this.operatorStateInfo(x$4, x$6, x$5), this.keySchema(), this.valueSchema(), 0, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd2.collect())).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        }), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("recovering from files", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), Float.toString(Random$.MODULE$.nextFloat())).toString();
            LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
                StateStoreRDDSuite.$anonfun$new$5(this, path, spark);
                return BoxedUnit.UNIT;
            });
            return (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.makeStoreRDD$1((SparkSession)spark, (Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$), 20, path).collect())).toSet());
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)21))}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            });
        }, new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("usage with iterators - only gets and only puts", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
            SQLContext sqlContext = spark.sqlContext();
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), Float.toString(Random$.MODULE$.nextFloat())).toString();
            boolean opId = false;
            String x$7 = path;
            int x$8 = 0;
            UUID x$9 = this.operatorStateInfo$default$2();
            StateStoreRDD rddOfGets1 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(spark.sqlContext(), this.operatorStateInfo(x$7, x$9, x$8), this.keySchema(), this.valueSchema(), 0, (Function2 & Serializable & scala.Serializable)(store, iter) -> StateStoreRDDSuite.iteratorOfGets$1(store, iter), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddOfGets1.collect())).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)None$.MODULE$)}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            String x$10 = path;
            int x$11 = 0;
            UUID x$12 = this.operatorStateInfo$default$2();
            StateStoreRDD rddOfPuts = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$10, x$12, x$11), this.keySchema(), this.valueSchema(), 0, (Function2 & Serializable & scala.Serializable)(store, iter) -> StateStoreRDDSuite.iteratorOfPuts$1(store, iter), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddOfPuts.collect())).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            String x$13 = path;
            int x$14 = 1;
            UUID x$15 = this.operatorStateInfo$default$2();
            StateStoreRDD rddOfGets2 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$13, x$15, x$14), this.keySchema(), this.valueSchema(), 0, (Function2 & Serializable & scala.Serializable)(store, iter) -> StateStoreRDDSuite.iteratorOfGets$1(store, iter), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rddOfGets2.collect())).toSet());
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)2))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)None$.MODULE$)}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        }), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("preferred locations using StateStoreCoordinator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Tuple2[])org.apache.spark.sql.catalyst.util.package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> {
            UUID queryRunId = UUID.randomUUID();
            int opId = 0;
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), Float.toString(Random$.MODULE$.nextFloat())).toString();
            return (Tuple2[])LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf()).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
                SQLContext sqlContext = spark.sqlContext();
                StateStoreCoordinatorRef coordinatorRef = sqlContext.streams().stateStoreCoordinator();
                StateStoreProviderId storeProviderId1 = new StateStoreProviderId(new StateStoreId(path, (long)opId, 0, StateStoreId$.MODULE$.apply$default$4()), queryRunId);
                StateStoreProviderId storeProviderId2 = new StateStoreProviderId(new StateStoreId(path, (long)opId, 1, StateStoreId$.MODULE$.apply$default$4()), queryRunId);
                coordinatorRef.reportActiveInstance(storeProviderId1, "host1", "exec1", (Seq)Nil$.MODULE$);
                coordinatorRef.reportActiveInstance(storeProviderId2, "host2", "exec2", (Seq)Nil$.MODULE$);
                Predef$.MODULE$.require(this.convertToEqualizer(coordinatorRef.getLocation(storeProviderId1)).$eq$eq$eq((Object)new Some((Object)new ExecutorCacheTaskLocation("host1", "exec1").toString()), Equality$.MODULE$.default()));
                StateStoreRDD rdd = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(path, queryRunId, this.operatorStateInfo$default$3()), this.keySchema(), this.valueSchema(), 0, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
                Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)rdd.partitions().length)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rdd.preferredLocations(rdd.partitions()[0]));
                Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)new ExecutorCacheTaskLocation("host1", "exec1").toString(), (List)Nil$.MODULE$);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rdd.preferredLocations(rdd.partitions()[1]));
                Seq $org_scalatest_assert_macro_right2 = (Seq)new .colon.colon((Object)new ExecutorCacheTaskLocation("host2", "exec2").toString(), (List)Nil$.MODULE$);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
                return (Tuple2[])rdd.collect();
            });
        }), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.ignore("distributed test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)org.apache.spark.sql.catalyst.util.package$.MODULE$.quietly((Function0 & Serializable & scala.Serializable)() -> (Assertion)LocalSparkSession$.MODULE$.withSparkSession(SparkSession$.MODULE$.builder().config(this.sparkConf().setMaster("local-cluster[2, 1, 1024]")).getOrCreate(), (Function1 & Serializable & scala.Serializable)spark -> {
            SQLContext sqlContext = spark.sqlContext();
            String path = Utils$.MODULE$.createDirectory(this.tempDir(), Float.toString(Random$.MODULE$.nextFloat())).toString();
            boolean opId = false;
            String x$16 = path;
            int x$17 = 0;
            UUID x$18 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd1 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$))))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$16, x$18, x$17), this.keySchema(), this.valueSchema(), 0, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            String x$19 = path;
            int x$20 = 1;
            UUID x$21 = this.operatorStateInfo$default$2();
            StateStoreRDD rdd2 = package$.MODULE$.StateStoreOps(this.makeRDD(spark.sparkContext(), (Seq<Tuple2<String, Object>>)((Seq)new .colon.colon((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0)), (List)new .colon.colon((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0)), (List)Nil$.MODULE$)))), ClassTag$.MODULE$.apply(Tuple2.class)).mapPartitionsWithStateStore(sqlContext, this.operatorStateInfo(x$19, x$21, x$20), this.keySchema(), this.valueSchema(), 0, this.increment(), ClassTag$.MODULE$.apply(Tuple2.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd2.collect())).toSet());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd1.collect())).toSet());
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)0))), (Object)BoxesRunTime.boxToInteger((int)1))}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        })), new Position("StateStoreRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        this.increment = (Function2 & Serializable & scala.Serializable)(store, iter) -> {
            iter.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                StateStoreRDDSuite.$anonfun$increment$2(store, x0$1);
                return BoxedUnit.UNIT;
            });
            store.commit();
            return store.iterator().map((Function1 & Serializable & scala.Serializable)row -> StateStoreTestsHelper$.MODULE$.rowPairToDataPair((UnsafeRowPair)row));
        };
    }
}

