/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaTest;
import org.apache.spark.sql.execution.datasources.parquet.ParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001\u0002\u0007\u000e\u0001qAQ!\t\u0001\u0005\u0002\tBq\u0001\n\u0001C\u0002\u0013%Q\u0005\u0003\u0004/\u0001\u0001\u0006IA\n\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0011\u0019Y\u0004\u0001)A\u0005c!)A\b\u0001C\u0005{!)!\n\u0001C\u0005\u0017\"91\u000eAI\u0001\n\u0013a\u0007bB<\u0001#\u0003%I\u0001\u001c\u0005\u0006q\u0002!I!\u001f\u0005\u0006}\u0002!Ia \u0002\u001a!\u0006\u0014\u0018/^3u\r&,G\u000eZ%e'\u000eDW-\\1Tk&$XM\u0003\u0002\u000f\u001f\u00059\u0001/\u0019:rk\u0016$(B\u0001\t\u0012\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005I\u0019\u0012!C3yK\u000e,H/[8o\u0015\t!R#A\u0002tc2T!AF\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005aI\u0012AB1qC\u000eDWMC\u0001\u001b\u0003\ry'oZ\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001f?5\tQ\"\u0003\u0002!\u001b\t\t\u0002+\u0019:rk\u0016$8k\u00195f[\u0006$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005\u0019\u0003C\u0001\u0010\u0001\u0003A1\u0015iS#`\u0007>cU+\u0014(`\u001d\u0006kU)F\u0001'!\t9C&D\u0001)\u0015\tI#&\u0001\u0003mC:<'\"A\u0016\u0002\t)\fg/Y\u0005\u0003[!\u0012aa\u0015;sS:<\u0017!\u0005$B\u0017\u0016{6i\u0014'V\u001b:{f*Q'FA\u0005QQ+V%E?J+u)\u0012-\u0016\u0003E\u0002\"AM\u001d\u000e\u0003MR!\u0001N\u001b\u0002\u00115\fGo\u00195j]\u001eT!AN\u001c\u0002\tU$\u0018\u000e\u001c\u0006\u0002q\u0005)1oY1mC&\u0011!h\r\u0002\u0006%\u0016<W\r_\u0001\f+VKEi\u0018*F\u000f\u0016C\u0006%\u0001\u0004xSRD\u0017\n\u001a\u000b\u0003}\u0011\u0003\"a\u0010\"\u000e\u0003\u0001S!!Q\n\u0002\u000bQL\b/Z:\n\u0005\r\u0003%\u0001C'fi\u0006$\u0017\r^1\t\u000b\u00153\u0001\u0019\u0001$\u0002\u0005%$\u0007CA$I\u001b\u00059\u0014BA%8\u0005\rIe\u000e^\u0001\u0013i\u0016\u001cHoU2iK6\f7\t\\5qa&tw\rF\u0004M\u001fnk&\rZ5\u0011\u0005\u001dk\u0015B\u0001(8\u0005\u0011)f.\u001b;\t\u000bA;\u0001\u0019A)\u0002\u0011Q,7\u000f\u001e(b[\u0016\u0004\"AU-\u000f\u0005M;\u0006C\u0001+8\u001b\u0005)&B\u0001,\u001c\u0003\u0019a$o\\8u}%\u0011\u0001lN\u0001\u0007!J,G-\u001a4\n\u00055R&B\u0001-8\u0011\u0015av\u00011\u0001R\u00035\u0001\u0018M]9vKR\u001c6\r[3nC\")al\u0002a\u0001?\u0006q1-\u0019;bYf\u001cHoU2iK6\f\u0007CA a\u0013\t\t\u0007I\u0001\u0006TiJ,8\r\u001e+za\u0016DQaY\u0004A\u0002E\u000ba\"\u001a=qK\u000e$X\rZ*dQ\u0016l\u0017\rC\u0004f\u000fA\u0005\t\u0019\u00014\u0002\u001b\r\f7/Z*f]NLG/\u001b<f!\t9u-\u0003\u0002io\t9!i\\8mK\u0006t\u0007b\u00026\b!\u0003\u0005\rAZ\u0001\u000bkN,g)[3mI&#\u0017\u0001\b;fgR\u001c6\r[3nC\u000ec\u0017\u000e\u001d9j]\u001e$C-\u001a4bk2$H%N\u000b\u0002[*\u0012aM\\\u0016\u0002_B\u0011\u0001/^\u0007\u0002c*\u0011!o]\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001^\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002wc\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00029Q,7\u000f^*dQ\u0016l\u0017m\u00117jaBLgn\u001a\u0013eK\u001a\fW\u000f\u001c;%m\u0005\u0001B/Z:u'FdGk\u001c)beF,X\r\u001e\u000b\u0005\u0019j\\X\u0010C\u0003Q\u0015\u0001\u0007\u0011\u000bC\u0003}\u0015\u0001\u0007q,A\u0005tc2\u001c6\r[3nC\")AL\u0003a\u0001#\u0006Q1\r[3dW\u0016\u000bX/\u00197\u0015\u000b1\u000b\t!a\u0005\t\u000f\u0005\r1\u00021\u0001\u0002\u0006\u00051\u0011m\u0019;vC2\u0004B!a\u0002\u0002\u00105\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0004tG\",W.\u0019\u0006\u0003\u001d]IA!!\u0005\u0002\n\tYQ*Z:tC\u001e,G+\u001f9f\u0011\u001d\t)b\u0003a\u0001\u0003\u000b\t\u0001\"\u001a=qK\u000e$X\r\u001a")
public class ParquetFieldIdSchemaSuite
extends ParquetSchemaTest {
    private final String FAKE_COLUMN_NAME;
    private final Regex UUID_REGEX = new StringOps(Predef$.MODULE$.augmentString("[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}")).r();

    private String FAKE_COLUMN_NAME() {
        return this.FAKE_COLUMN_NAME;
    }

    private Regex UUID_REGEX() {
        return this.UUID_REGEX;
    }

    private Metadata withId(int id) {
        return new MetadataBuilder().putLong(ParquetUtils$.MODULE$.FIELD_ID_METADATA_KEY(), (long)id).build();
    }

    private void testSchemaClipping(String testName, String parquetSchema, StructType catalystSchema, String expectedSchema, boolean caseSensitive, boolean useFieldId) {
        this.test(new StringBuilder(25).append("Clipping with field id - ").append(testName).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            MessageType fileSchema = MessageTypeParser.parseMessageType((String)parquetSchema);
            MessageType actual = ParquetReadSupport$.MODULE$.clipParquetSchema(fileSchema, catalystSchema, caseSensitive, useFieldId);
            Buffer fakeColumnNames = (Buffer)((TraversableLike)((GenericTraversableTemplate)JavaConverters$.MODULE$.asScalaBufferConverter(actual.getPaths()).asScala()).flatten((Function1 & Serializable & scala.Serializable)xs -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])xs)))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith(this.FAKE_COLUMN_NAME())));
            Buffer $org_scalatest_assert_macro_left = (Buffer)fakeColumnNames.distinct();
            Buffer $org_scalatest_assert_macro_right = fakeColumnNames;
            Buffer buffer = $org_scalatest_assert_macro_left;
            Buffer buffer2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(buffer != null ? !buffer.equals(buffer2) : buffer2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Should generate unique fake column names", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            Iterator ids1 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).iterator();
            MessageType actualNormalized = MessageTypeParser.parseMessageType((String)this.UUID_REGEX().replaceAllIn((CharSequence)actual.toString(), (Function1 & Serializable & scala.Serializable)x$2 -> ids1.next().toString()));
            Iterator ids2 = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 100).iterator();
            MessageType expectedNormalized = MessageTypeParser.parseMessageType((String)new StringOps(Predef$.MODULE$.augmentString(this.FAKE_COLUMN_NAME())).r().replaceAllIn((CharSequence)expectedSchema, (Function1 & Serializable & scala.Serializable)x$3 -> new StringBuilder(0).append(this.FAKE_COLUMN_NAME()).append(ids2.next()).toString()));
            try {
                expectedNormalized.checkContains((Type)actualNormalized);
                actualNormalized.checkContains((Type)expectedNormalized);
            }
            catch (Throwable cause) {
                throw this.fail(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(103).append("Expected clipped schema:\n             |").append(expectedSchema).append("\n             |Actual clipped schema:\n             |").append(actual).append("\n           ").toString())).stripMargin(), cause, new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
            }
            this.checkEqual(actualNormalized, expectedNormalized);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ParquetReadSupport$.MODULE$.containsFieldIds((Type)fileSchema), "ParquetReadSupport.containsFieldIds(fileSchema)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(ParquetUtils$.MODULE$.hasFieldIds(catalystSchema), "ParquetUtils.hasFieldIds(catalystSchema)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        }, new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
    }

    private boolean testSchemaClipping$default$5() {
        return true;
    }

    private boolean testSchemaClipping$default$6() {
        return true;
    }

    private void testSqlToParquet(String testName, StructType sqlSchema, String parquetSchema) {
        SparkToParquetSchemaConverter converter = new SparkToParquetSchemaConverter(false, SQLConf.ParquetOutputTimestampType$.MODULE$.INT96(), true);
        this.test(new StringBuilder(16).append("sql => parquet: ").append(testName).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MessageType actual = converter.convert(sqlSchema);
            MessageType expected = MessageTypeParser.parseMessageType((String)parquetSchema);
            this.checkEqual(actual, expected);
        }, new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
    }

    private void checkEqual(MessageType actual, MessageType expected) {
        actual.checkContains((Type)expected);
        expected.checkContains((Type)actual);
        String $org_scalatest_assert_macro_left = actual.toString();
        String $org_scalatest_assert_macro_right = expected.toString();
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(111).append("\n         |Schema mismatch.\n         |Expected schema:\n         |").append(expected.toString()).append("\n         |Actual schema:\n         |").append(actual.toString()).append("\n         ").toString())).stripMargin(), Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
    }

    public ParquetFieldIdSchemaSuite() {
        this.FAKE_COLUMN_NAME = "_fake_name_";
        this.test("check hasFieldIds for schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            StructType simpleSchemaMissingId = new StructType().add("f010", (DataType)DoubleType$.MODULE$, true, this.withId(7)).add("f012", (DataType)LongType$.MODULE$, true);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ParquetUtils$.MODULE$.hasFieldIds(simpleSchemaMissingId), "ParquetUtils.hasFieldIds(simpleSchemaMissingId)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            StructType f01ElementType = new StructType().add("f010", (DataType)DoubleType$.MODULE$, true, this.withId(7)).add("f012", (DataType)LongType$.MODULE$, true, this.withId(8));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ParquetUtils$.MODULE$.hasFieldIds(f01ElementType), "ParquetUtils.hasFieldIds(f01ElementType)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
            StructType f0Type = new StructType().add("f00", (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true, this.withId(2)).add("f01", (DataType)new ArrayType((DataType)f01ElementType, false), true);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(ParquetUtils$.MODULE$.hasFieldIds(f0Type), "ParquetUtils.hasFieldIds(f0Type)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(ParquetUtils$.MODULE$.hasFieldIds(new StructType().add("f0", (DataType)f0Type, false, this.withId(1))), "ParquetUtils.hasFieldIds(new org.apache.spark.sql.types.StructType().add(\"f0\", f0Type, false, ParquetFieldIdSchemaSuite.this.withId(1)))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ParquetUtils$.MODULE$.hasFieldIds(new StructType().add("f0", (DataType)IntegerType$.MODULE$, true)), "ParquetUtils.hasFieldIds(new org.apache.spark.sql.types.StructType().add(\"f0\", org.apache.spark.sql.types.IntegerType, true))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ParquetUtils$.MODULE$.hasFieldIds(new StructType()), "ParquetUtils.hasFieldIds(new org.apache.spark.sql.types.StructType())", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        }, new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
        this.test("check getFieldId for schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            StructType schema = new StructType().add("overflowId", (DataType)DoubleType$.MODULE$, true, new MetadataBuilder().putLong(ParquetUtils$.MODULE$.FIELD_ID_METADATA_KEY(), 12345678987654321L).build()).add("stringId", (DataType)StringType$.MODULE$, true, new MetadataBuilder().putString(ParquetUtils$.MODULE$.FIELD_ID_METADATA_KEY(), "lol").build()).add("negativeId", (DataType)LongType$.MODULE$, true, this.withId(-20)).add("noId", (DataType)LongType$.MODULE$, true);
            String $org_scalatest_assert_macro_left = ((Throwable)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ParquetUtils$.MODULE$.getFieldId((StructField)((Tuple2)schema.findNestedField((Seq)new .colon.colon((Object)"noId", (List)Nil$.MODULE$), schema.findNestedField$default$2(), schema.findNestedField$default$3(), schema.findNestedField$default$4()).get())._2()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152))).getMessage();
            String $org_scalatest_assert_macro_right = "doesn't exist";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            String $org_scalatest_assert_macro_left2 = ((Throwable)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ParquetUtils$.MODULE$.getFieldId((StructField)((Tuple2)schema.findNestedField((Seq)new .colon.colon((Object)"overflowId", (List)Nil$.MODULE$), schema.findNestedField$default$2(), schema.findNestedField$default$3(), schema.findNestedField$default$4()).get())._2()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156))).getMessage();
            String $org_scalatest_assert_macro_right2 = "must be a 32-bit integer";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
            String $org_scalatest_assert_macro_left3 = ((Throwable)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ParquetUtils$.MODULE$.getFieldId((StructField)((Tuple2)schema.findNestedField((Seq)new .colon.colon((Object)"stringId", (List)Nil$.MODULE$), schema.findNestedField$default$2(), schema.findNestedField$default$3(), schema.findNestedField$default$4()).get())._2()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160))).getMessage();
            String $org_scalatest_assert_macro_right3 = "must be a 32-bit integer";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            int $org_scalatest_assert_macro_left4 = ParquetUtils$.MODULE$.getFieldId((StructField)((Tuple2)schema.findNestedField((Seq)new .colon.colon((Object)"negativeId", (List)Nil$.MODULE$), schema.findNestedField$default$2(), schema.findNestedField$default$3(), schema.findNestedField$default$4()).get())._2());
            int $org_scalatest_assert_macro_right4 = -20;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        }, new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("check containsFieldIds for parquet schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ParquetReadSupport$.MODULE$.containsFieldIds((Type)MessageTypeParser.parseMessageType((String)new StringOps(Predef$.MODULE$.augmentString("message root {\n             |}\n          ")).stripMargin())), "ParquetReadSupport.containsFieldIds(org.apache.parquet.schema.MessageTypeParser.parseMessageType(scala.Predef.augmentString(\"message root {\\n             |}\\n          \").stripMargin))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ParquetReadSupport$.MODULE$.containsFieldIds((Type)MessageTypeParser.parseMessageType((String)new StringOps(Predef$.MODULE$.augmentString("message root {\n            |  required group f0 {\n            |    optional int32 f00;\n            |  }\n            |}\n          ")).stripMargin())), "ParquetReadSupport.containsFieldIds(org.apache.parquet.schema.MessageTypeParser.parseMessageType(scala.Predef.augmentString(\"message root {\\n            |  required group f0 {\\n            |    optional int32 f00;\\n            |  }\\n            |}\\n          \").stripMargin))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(ParquetReadSupport$.MODULE$.containsFieldIds((Type)MessageTypeParser.parseMessageType((String)new StringOps(Predef$.MODULE$.augmentString("message root {\n            |  required group f0 = 1 {\n            |    optional int32 f00;\n            |    optional binary f01;\n            |  }\n            |}\n          ")).stripMargin())), "ParquetReadSupport.containsFieldIds(org.apache.parquet.schema.MessageTypeParser.parseMessageType(scala.Predef.augmentString(\"message root {\\n            |  required group f0 = 1 {\\n            |    optional int32 f00;\\n            |    optional binary f01;\\n            |  }\\n            |}\\n          \").stripMargin))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(ParquetReadSupport$.MODULE$.containsFieldIds((Type)MessageTypeParser.parseMessageType((String)new StringOps(Predef$.MODULE$.augmentString("message root {\n            |  required group f0 {\n            |    optional int32 f00 = 1;\n            |    optional binary f01;\n            |  }\n            |}\n          ")).stripMargin())), "ParquetReadSupport.containsFieldIds(org.apache.parquet.schema.MessageTypeParser.parseMessageType(scala.Predef.augmentString(\"message root {\\n            |  required group f0 {\\n            |    optional int32 f00 = 1;\\n            |    optional binary f01;\\n            |  }\\n            |}\\n          \").stripMargin))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ParquetReadSupport$.MODULE$.containsFieldIds((Type)MessageTypeParser.parseMessageType((String)new StringOps(Predef$.MODULE$.augmentString("message spark_schema {\n              |  required group f0 {\n              |    optional group f00 (LIST) {\n              |      repeated group list {\n              |        required binary element (UTF8);\n              |      }\n              |    }\n              |  }\n              |}\n            ")).stripMargin())), "ParquetReadSupport.containsFieldIds(org.apache.parquet.schema.MessageTypeParser.parseMessageType(scala.Predef.augmentString(\"message spark_schema {\\n              |  required group f0 {\\n              |    optional group f00 (LIST) {\\n              |      repeated group list {\\n              |        required binary element (UTF8);\\n              |      }\\n              |    }\\n              |  }\\n              |}\\n            \").stripMargin))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(ParquetReadSupport$.MODULE$.containsFieldIds((Type)MessageTypeParser.parseMessageType((String)new StringOps(Predef$.MODULE$.augmentString("message spark_schema {\n            |  required group f0 {\n            |    optional group f00 (LIST) {\n            |      repeated group list = 1 {\n            |        required binary element (UTF8);\n            |      }\n            |    }\n            |  }\n            |}\n            ")).stripMargin())), "ParquetReadSupport.containsFieldIds(org.apache.parquet.schema.MessageTypeParser.parseMessageType(scala.Predef.augmentString(\"message spark_schema {\\n            |  required group f0 {\\n            |    optional group f00 (LIST) {\\n            |      repeated group list = 1 {\\n            |        required binary element (UTF8);\\n            |      }\\n            |    }\\n            |  }\\n            |}\\n            \").stripMargin))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        }, new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("ID in Parquet Types is read as null when not set", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String parquetSchemaString = new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 {\n        |    optional int32 f00;\n        |  }\n        |}\n      ")).stripMargin();
            MessageType parquetSchema = MessageTypeParser.parseMessageType((String)parquetSchemaString);
            Type f0 = (Type)parquetSchema.getFields().get(0);
            Type.ID $org_scalatest_assert_macro_left = f0.getId();
            Object $org_scalatest_assert_macro_right = null;
            Type.ID iD = $org_scalatest_assert_macro_left;
            Object var6_5 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", null, !(iD != null ? !iD.equals(var6_5) : var6_5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            Type.ID $org_scalatest_assert_macro_left2 = ((Type)f0.asGroupType().getFields().get(0)).getId();
            Object $org_scalatest_assert_macro_right2 = null;
            Type.ID iD2 = $org_scalatest_assert_macro_left2;
            Object var10_9 = null;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", null, !(iD2 != null ? !iD2.equals(var10_9) : var10_9 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        }, new Position("ParquetFieldIdSchemaSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        StructType f01ElementType = new StructType().add("f010", (DataType)DoubleType$.MODULE$, true, this.withId(7)).add("f012", (DataType)LongType$.MODULE$, true, this.withId(9));
        StructType f0Type = new StructType().add("f00", (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true, this.withId(2)).add("f01", (DataType)new ArrayType((DataType)f01ElementType, false), true, this.withId(5));
        this.testSqlToParquet("standard array", new StructType().add("f0", (DataType)f0Type, false, this.withId(1)), new StringOps(Predef$.MODULE$.augmentString("message spark_schema {\n        |  required group f0 = 1 {\n        |    optional group f00 (LIST) = 2 {\n        |      repeated group list {\n        |        required binary element (UTF8);\n        |      }\n        |    }\n        |\n        |    optional group f01 (LIST) = 5 {\n        |      repeated group list {\n        |        required group element {\n        |          optional double f010 = 7;\n        |          optional int64 f012 = 9;\n        |        }\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin());
        StructType f0Type2 = new StructType().add("g00", (DataType)IntegerType$.MODULE$, true, this.withId(2));
        this.testSchemaClipping("simple nested struct", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 = 1 {\n        |    optional int32 f00 = 2;\n        |    optional int32 f01 = 3;\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("g0", (DataType)f0Type2, false, this.withId(1)).add("g1", (DataType)IntegerType$.MODULE$, true, this.withId(4)), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(157).append("message spark_schema {\n        |  required group f0 = 1 {\n        |    optional int32 f00 = 2;\n        |  }\n        |  optional int32 ").append(this.FAKE_COLUMN_NAME()).append(" = 4;\n        |}\n      ").toString())).stripMargin(), this.testSchemaClipping$default$5(), this.testSchemaClipping$default$6());
        StructType f01ElementType2 = new StructType().add("g011", (DataType)DoubleType$.MODULE$, true, this.withId(8)).add("g012", (DataType)LongType$.MODULE$, true, this.withId(9));
        StructType f0Type3 = new StructType().add("g00", (DataType)new ArrayType((DataType)StringType$.MODULE$, false), true, this.withId(2)).add("g01", (DataType)new ArrayType((DataType)f01ElementType2, false), true, this.withId(5));
        this.testSchemaClipping("standard array", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 = 1 {\n        |    optional group f00 (LIST) = 2 {\n        |      repeated group list {\n        |        required binary element (UTF8);\n        |      }\n        |    }\n        |\n        |    optional group f01 (LIST) = 5 {\n        |      repeated group list {\n        |        required group element {\n        |          optional int32 f010 = 7;\n        |          optional double f011 = 8;\n        |        }\n        |      }\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("g0", (DataType)f0Type3, false, this.withId(1)), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(521).append("message spark_schema {\n        |  required group f0 = 1 {\n        |    optional group f00 (LIST) = 2 {\n        |      repeated group list {\n        |        required binary element (UTF8);\n        |      }\n        |    }\n        |\n        |    optional group f01 (LIST) = 5 {\n        |      repeated group list {\n        |        required group element {\n        |          optional double f011 = 8;\n        |          optional int64 ").append(this.FAKE_COLUMN_NAME()).append(" = 9;\n        |        }\n        |      }\n        |    }\n        |  }\n        |}\n      ").toString())).stripMargin(), this.testSchemaClipping$default$5(), this.testSchemaClipping$default$6());
        StructType keyType = new StructType().add("value_g1", (DataType)LongType$.MODULE$, false, this.withId(6)).add("value_g2", (DataType)DoubleType$.MODULE$, false, this.withId(7));
        MapType f0Type4 = new MapType((DataType)keyType, (DataType)IntegerType$.MODULE$, false);
        this.testSchemaClipping("standard map with complex key", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 (MAP) = 3 {\n        |    repeated group key_value = 1 {\n        |      required group key = 2 {\n        |        required int32 value_f0 = 4;\n        |        required int64 value_f1 = 6;\n        |      }\n        |      required int32 value = 5;\n        |    }\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("g0", (DataType)f0Type4, false, this.withId(3)), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(336).append("message spark_schema {\n        |  required group f0 (MAP) = 3 {\n        |    repeated group key_value = 1 {\n        |      required group key = 2 {\n        |        required int64 value_f1 = 6;\n        |        required double ").append(this.FAKE_COLUMN_NAME()).append(" = 7;\n        |      }\n        |      required int32 value = 5;\n        |    }\n        |  }\n        |}\n      ").toString())).stripMargin(), this.testSchemaClipping$default$5(), this.testSchemaClipping$default$6());
        StructType f0Type5 = new StructType().add("g00", (DataType)IntegerType$.MODULE$, true, this.withId(2)).add("g01", (DataType)IntegerType$.MODULE$, true, this.withId(3));
        this.testSchemaClipping("won't match field id if structure is different", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 = 1 {\n        |    optional int32 f00 = 2;\n        |  }\n        |  optional int32 f1 = 3;\n        |}\n      ")).stripMargin(), new StructType().add("g0", (DataType)f0Type5, false, this.withId(1)), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(159).append("message spark_schema {\n        |  required group f0 = 1 {\n        |    optional int32 f00 = 2;\n        |    optional int32 ").append(this.FAKE_COLUMN_NAME()).append(" = 3;\n        |  }\n        |}\n      ").toString())).stripMargin(), this.testSchemaClipping$default$5(), this.testSchemaClipping$default$6());
        StructType f0Type6 = new StructType().add("g00", (DataType)IntegerType$.MODULE$, true, this.withId(2));
        this.testSchemaClipping("Complex type with multiple mismatches should work", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 = 1 {\n        |    optional int32 f00 = 2;\n        |  }\n        |  optional int32 f1 = 3;\n        |  optional int32 f2 = 4;\n        |}\n      ")).stripMargin(), new StructType().add("g0", (DataType)f0Type6, false, this.withId(999)).add("g1", (DataType)IntegerType$.MODULE$, true, this.withId(3)).add("g2", (DataType)IntegerType$.MODULE$, true, this.withId(888)), new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(193).append("message spark_schema {\n        |  required group ").append(this.FAKE_COLUMN_NAME()).append(" = 999 {\n        |    optional int32 g00 = 2;\n        |  }\n        |  optional int32 f1 = 3;\n        |  optional int32 ").append(this.FAKE_COLUMN_NAME()).append(" = 888;\n        |}\n      ").toString())).stripMargin(), this.testSchemaClipping$default$5(), this.testSchemaClipping$default$6());
        StructType f0Type7 = new StructType().add("f00", (DataType)IntegerType$.MODULE$, true);
        StructType f4Type = new StructType().add("g40", (DataType)IntegerType$.MODULE$, true, this.withId(6));
        this.testSchemaClipping("Should allow fall-back to name matching if id not found", new StringOps(Predef$.MODULE$.augmentString("message root {\n        |  required group f0 = 1 {\n        |    optional int32 f00 = 2;\n        |  }\n        |  optional int32 f1 = 3;\n        |  optional int32 f2 = 4;\n        |  required group f4 = 5 {\n        |    optional int32 f40 = 6;\n        |  }\n        |}\n      ")).stripMargin(), new StructType().add("g0", (DataType)f0Type7, false, this.withId(1)).add("g1", (DataType)IntegerType$.MODULE$, true, this.withId(3)).add("f2", (DataType)IntegerType$.MODULE$, true).add("g2", (DataType)IntegerType$.MODULE$, true).add("f4", (DataType)f4Type, true), new StringOps(Predef$.MODULE$.augmentString("message spark_schema {\n        |  required group f0 = 1 {\n        |    optional int32 f00 = 2;\n        |  }\n        |  optional int32 f1 = 3;\n        |  optional int32 f2 = 4;\n        |  optional int32 g2;\n        |  required group f4 = 5 {\n        |    optional int32 f40 = 6;\n        |  }\n        |}\n      ")).stripMargin(), this.testSchemaClipping$default$5(), this.testSchemaClipping$default$6());
    }
}

