/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArrayUtil
implements Cloneable,
Serializable {
    public static <T> T[] removeFromArray(T[] array2, Object item) {
        if (item == null || array2 == null) {
            return array2;
        }
        int i = array2.length;
        while (i-- > 0) {
            if (!item.equals(array2[i])) continue;
            Class<?> c = array2 == null ? item.getClass() : array2.getClass().getComponentType();
            Object[] na = (Object[])Array.newInstance(c, Array.getLength(array2) - 1);
            if (i > 0) {
                System.arraycopy(array2, 0, na, 0, i);
            }
            if (i + 1 < array2.length) {
                System.arraycopy(array2, i + 1, na, i, array2.length - (i + 1));
            }
            return na;
        }
        return array2;
    }

    public static <T> T[] add(T[] array1, T[] array2) {
        if (array1 == null || array1.length == 0) {
            return array2;
        }
        if (array2 == null || array2.length == 0) {
            return array1;
        }
        T[] na = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, na, array1.length, array2.length);
        return na;
    }

    public static <T> T[] addToArray(T[] array2, T item, Class<?> type) {
        if (array2 == null) {
            if (type == null && item != null) {
                type = item.getClass();
            }
            Object[] na = (Object[])Array.newInstance(type, 1);
            na[0] = item;
            return na;
        }
        T[] na = Arrays.copyOf(array2, array2.length + 1);
        na[array2.length] = item;
        return na;
    }

    public static <T> T[] prependToArray(T item, T[] array2, Class<?> type) {
        if (array2 == null) {
            if (type == null && item != null) {
                type = item.getClass();
            }
            Object[] na = (Object[])Array.newInstance(type, 1);
            na[0] = item;
            return na;
        }
        Class<?> c = array2.getClass().getComponentType();
        Object[] na = (Object[])Array.newInstance(c, Array.getLength(array2) + 1);
        System.arraycopy(array2, 0, na, 1, array2.length);
        na[0] = item;
        return na;
    }

    public static <E> List<E> asMutableList(E[] array2) {
        if (array2 == null || array2.length == 0) {
            return new ArrayList();
        }
        return new ArrayList<E>(Arrays.asList(array2));
    }

    public static <T> T[] removeNulls(T[] array2) {
        for (T t : array2) {
            if (t != null) continue;
            ArrayList<T> list = new ArrayList<T>();
            for (T t2 : array2) {
                if (t2 == null) continue;
                list.add(t2);
            }
            return list.toArray(Arrays.copyOf(array2, list.size()));
        }
        return array2;
    }
}

