/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.plus.jndi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.spark_project.jetty.plus.jndi.NamingEntry;
import org.spark_project.jetty.util.StringUtil;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;

public class NamingEntryUtil {
    private static final Logger LOG = Log.getLogger(NamingEntryUtil.class);

    public static boolean bindToENC(Object scope, String asName, String mappedName) throws NamingException {
        NamingEntry entry2;
        if (asName == null || asName.trim().equals("")) {
            throw new NamingException("No name for NamingEntry");
        }
        if (mappedName == null || "".equals(mappedName)) {
            mappedName = asName;
        }
        if ((entry2 = NamingEntryUtil.lookupNamingEntry(scope, mappedName)) == null) {
            return false;
        }
        entry2.bindToENC(asName);
        return true;
    }

    public static NamingEntry lookupNamingEntry(Object scope, String jndiName) throws NamingException {
        NamingEntry entry2 = null;
        try {
            Name scopeName = NamingEntryUtil.getNameForScope(scope);
            InitialContext ic = new InitialContext();
            NameParser parser = ic.getNameParser("");
            Name namingEntryName = NamingEntryUtil.makeNamingEntryName(parser, jndiName);
            scopeName.addAll(namingEntryName);
            entry2 = (NamingEntry)ic.lookup(scopeName);
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return entry2;
    }

    public static Object lookup(Object scope, String jndiName) throws NamingException {
        Name scopeName = NamingEntryUtil.getNameForScope(scope);
        InitialContext ic = new InitialContext();
        NameParser parser = ic.getNameParser("");
        scopeName.addAll(parser.parse(jndiName));
        return ic.lookup(scopeName);
    }

    public static <T> List<? extends T> lookupNamingEntries(Object scope, Class<T> clazz) throws NamingException {
        try {
            Context scopeContext = NamingEntryUtil.getContextForScope(scope);
            Context namingEntriesContext = (Context)scopeContext.lookup("__");
            ArrayList<Object> list = new ArrayList<Object>();
            NamingEntryUtil.lookupNamingEntries(list, namingEntriesContext, clazz);
            return list;
        }
        catch (NameNotFoundException e) {
            return Collections.emptyList();
        }
    }

    public static Name makeNamingEntryName(NameParser parser, NamingEntry namingEntry) throws NamingException {
        return NamingEntryUtil.makeNamingEntryName(parser, namingEntry == null ? null : namingEntry.getJndiName());
    }

    public static Name makeNamingEntryName(NameParser parser, String jndiName) throws NamingException {
        if (jndiName == null) {
            return null;
        }
        if (parser == null) {
            InitialContext ic = new InitialContext();
            parser = ic.getNameParser("");
        }
        Name name2 = parser.parse("");
        name2.add("__");
        name2.addAll(parser.parse(jndiName));
        return name2;
    }

    public static Name getNameForScope(Object scope) {
        try {
            InitialContext ic = new InitialContext();
            NameParser parser = ic.getNameParser("");
            Name name2 = parser.parse("");
            if (scope != null) {
                name2.add(NamingEntryUtil.canonicalizeScope(scope));
            }
            return name2;
        }
        catch (NamingException e) {
            LOG.warn(e);
            return null;
        }
    }

    public static Context getContextForScope(Object scope) throws NamingException {
        InitialContext ic = new InitialContext();
        NameParser parser = ic.getNameParser("");
        Name name2 = parser.parse("");
        if (scope != null) {
            name2.add(NamingEntryUtil.canonicalizeScope(scope));
        }
        return (Context)ic.lookup(name2);
    }

    public static Context getContextForNamingEntries(Object scope) throws NamingException {
        Context scopeContext = NamingEntryUtil.getContextForScope(scope);
        return (Context)scopeContext.lookup("__");
    }

    private static List<Object> lookupNamingEntries(List<Object> list, Context context, Class<?> clazz) throws NamingException {
        block4: {
            try {
                NamingEnumeration<Binding> nenum = context.listBindings("");
                while (nenum.hasMoreElements()) {
                    Binding binding = nenum.next();
                    if (binding.getObject() instanceof Context) {
                        NamingEntryUtil.lookupNamingEntries(list, (Context)binding.getObject(), clazz);
                        continue;
                    }
                    if (!clazz.isInstance(binding.getObject())) continue;
                    list.add(binding.getObject());
                }
            }
            catch (NameNotFoundException e) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug("No entries of type " + clazz.getName() + " in context=" + context, new Object[0]);
            }
        }
        return list;
    }

    private static String canonicalizeScope(Object scope) {
        if (scope == null) {
            return "";
        }
        String str2 = scope.getClass().getName() + "@" + Long.toHexString(scope.hashCode());
        str2 = StringUtil.replace(str2, '/', '_');
        str2 = StringUtil.replace(str2, ' ', '_');
        return str2;
    }
}

