/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.util.UUID;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnsupportedOperationChecker$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.streaming.BaseStreamingSink;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryListenerBus;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.sources.v2.StreamWriteSupport;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.ProcessingTime;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryManager$;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Evolving
@ScalaSignature(bytes="\u0006\u0001\t-f\u0001B\u0001\u0003\u00015\u0011Qc\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u00180T1oC\u001e,'O\u0003\u0002\u0004\t\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001a-\t9Aj\\4hS:<\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005uqR\"\u0001\u0003\n\u0005}!!\u0001D*qCJ\\7+Z:tS>t\u0007BB\u0011\u0001\t\u0003!!%\u0001\u0004=S:LGO\u0010\u000b\u0003G\u0015\u0002\"\u0001\n\u0001\u000e\u0003\tAQa\u0007\u0011A\u0002qA\u0001b\n\u0001C\u0002\u0013\u0005A\u0001K\u0001\u0016gR\fG/Z*u_J,7i\\8sI&t\u0017\r^8s+\u0005I\u0003C\u0001\u00161\u001b\u0005Y#B\u0001\u0017.\u0003\u0015\u0019H/\u0019;f\u0015\t\u0019aF\u0003\u00020\t\u0005IQ\r_3dkRLwN\\\u0005\u0003c-\u0012\u0001d\u0015;bi\u0016\u001cFo\u001c:f\u0007>|'\u000fZ5oCR|'OU3g\u0011\u0019\u0019\u0004\u0001)A\u0005S\u000512\u000f^1uKN#xN]3D_>\u0014H-\u001b8bi>\u0014\b\u0005C\u00046\u0001\t\u0007I\u0011\u0002\u001c\u0002\u00171L7\u000f^3oKJ\u0014Uo]\u000b\u0002oA\u0011\u0001(O\u0007\u0002[%\u0011!(\f\u0002\u001a'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0019&\u001cH/\u001a8fe\n+8\u000f\u0003\u0004=\u0001\u0001\u0006IaN\u0001\rY&\u001cH/\u001a8fe\n+8\u000f\t\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u00035\t7\r^5wKF+XM]5fgV\t\u0001\t\u0005\u0003B\r\"\u0003V\"\u0001\"\u000b\u0005\r#\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u000bB\t!bY8mY\u0016\u001cG/[8o\u0013\t9%IA\u0004ICNDW*\u00199\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015\u0001B;uS2T\u0011!T\u0001\u0005U\u00064\u0018-\u0003\u0002P\u0015\n!Q+V%E!\t!\u0013+\u0003\u0002S\u0005\tq1\u000b\u001e:fC6LgnZ)vKJL\bB\u0002+\u0001A\u0003%\u0001)\u0001\bbGRLg/Z)vKJLWm\u001d\u0011)\tM3\u0006-\u0019\t\u0003/zk\u0011\u0001\u0017\u0006\u00033j\u000b!bY8oGV\u0014(/\u001a8u\u0015\tYF,\u0001\u0006b]:|G/\u0019;j_:T\u0011!X\u0001\u0006U\u00064\u0018\r_\u0005\u0003?b\u0013\u0011bR;be\u0012,GMQ=\u0002\u000bY\fG.^3\"\u0003\t\f\u0011#Y2uSZ,\u0017+^3sS\u0016\u001cHj\\2l\u0011\u001d\u0011\u0007A1A\u0005\n\u0011,\u0012!\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003Q2\u000bA\u0001\\1oO&\u0011!n\u001a\u0002\u0007\u001f\nTWm\u0019;\t\r1\u0004\u0001\u0015!\u0003f\u0003I\t7\r^5wKF+XM]5fg2{7m\u001b\u0011\t\u000f9\u0004!\u0019!C\u0005I\u0006!\u0012m^1jiR+'/\\5oCRLwN\u001c'pG.Da\u0001\u001d\u0001!\u0002\u0013)\u0017!F1xC&$H+\u001a:nS:\fG/[8o\u0019>\u001c7\u000e\t\u0005\be\u0002\u0001\r\u0011\"\u0003t\u0003Ma\u0017m\u001d;UKJl\u0017N\\1uK\u0012\fV/\u001a:z+\u0005\u0001\u0006bB;\u0001\u0001\u0004%IA^\u0001\u0018Y\u0006\u001cH\u000fV3s[&t\u0017\r^3e#V,'/_0%KF$\"a\u001e>\u0011\u0005=A\u0018BA=\u0011\u0005\u0011)f.\u001b;\t\u000fm$\u0018\u0011!a\u0001!\u0006\u0019\u0001\u0010J\u0019\t\ru\u0004\u0001\u0015)\u0003Q\u0003Qa\u0017m\u001d;UKJl\u0017N\\1uK\u0012\fV/\u001a:zA!\"AP\u00161\u0000C\u0005q\u0007bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u0007C\u000e$\u0018N^3\u0016\u0005\u0005\u001d\u0001\u0003B\b\u0002\nAK1!a\u0003\u0011\u0005\u0015\t%O]1z\u0011\u001d\ty\u0001\u0001C\u0001\u0003#\t1aZ3u)\r\u0001\u00161\u0003\u0005\b\u0003+\ti\u00011\u0001I\u0003\tIG\rC\u0004\u0002\u0010\u0001!\t!!\u0007\u0015\u0007A\u000bY\u0002\u0003\u0005\u0002\u0016\u0005]\u0001\u0019AA\u000f!\u0011\ty\"!\n\u000f\u0007=\t\t#C\u0002\u0002$A\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0014\u0003S\u0011aa\u0015;sS:<'bAA\u0012!!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0012aE1xC&$\u0018I\\=UKJl\u0017N\\1uS>tG#A<)\r\u0005-\u00121GA !\u0015y\u0011QGA\u001d\u0013\r\t9\u0004\u0005\u0002\u0007i\"\u0014xn^:\u0011\u0007\u0011\nY$C\u0002\u0002>\t\u0011qc\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u00180\u0012=dKB$\u0018n\u001c82\u000fy\ti\"!\u0011\u0002tEJ1%a\u0011\u0002L\u0005%\u0014QJ\u000b\u0005\u0003\u000b\n9%\u0006\u0002\u0002\u001e\u00119\u0011\u0011\n\u0007C\u0002\u0005M#!\u0001+\n\t\u00055\u0013qJ\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u0019\u000b\u0007\u0005E\u0003#\u0001\u0004uQJ|wo]\t\u0005\u0003+\nY\u0006E\u0002\u0010\u0003/J1!!\u0017\u0011\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\u0018\u0002d9\u0019q\"a\u0018\n\u0007\u0005\u0005\u0004#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0014q\r\u0002\n)\"\u0014xn^1cY\u0016T1!!\u0019\u0011c%\u0019\u00131NA7\u0003_\n\tFD\u0002\u0010\u0003[J1!!\u0015\u0011c\u0015\u0011s\u0002EA9\u0005\u0015\u00198-\u00197bc\r1\u0013\u0011\b\u0005\b\u0003[\u0001A\u0011AA<)\u0011\tI(a \u0011\u0007=\tY(C\u0002\u0002~A\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005\u0002\u0002\u0006U\u0004\u0019AAB\u0003%!\u0018.\\3pkRl5\u000fE\u0002\u0010\u0003\u000bK1!a\"\u0011\u0005\u0011auN\\4)\r\u0005U\u00141GAFc\u001dq\u0012QDAG\u0003'\u000b\u0014bIA\"\u0003\u0017\ny)!\u00142\u0013\r\nY'!\u001c\u0002\u0012\u0006E\u0013'\u0002\u0012\u0010!\u0005E\u0014g\u0001\u0014\u0002:!9\u0011q\u0013\u0001\u0005\u0002\u0005=\u0012a\u0004:fg\u0016$H+\u001a:nS:\fG/\u001a3\t\u000f\u0005m\u0005\u0001\"\u0001\u0002\u001e\u0006Y\u0011\r\u001a3MSN$XM\\3s)\r9\u0018q\u0014\u0005\t\u0003C\u000bI\n1\u0001\u0002$\u0006AA.[:uK:,'\u000fE\u0002%\u0003KK1!a*\u0003\u0005Y\u0019FO]3b[&tw-U;fefd\u0015n\u001d;f]\u0016\u0014\bbBAV\u0001\u0011\u0005\u0011QV\u0001\u000fe\u0016lwN^3MSN$XM\\3s)\r9\u0018q\u0016\u0005\t\u0003C\u000bI\u000b1\u0001\u0002$\"A\u00111\u0017\u0001\u0005\u0002\u0011\t),A\tq_N$H*[:uK:,'/\u0012<f]R$2a^A\\\u0011!\tI,!-A\u0002\u0005m\u0016!B3wK:$\b\u0003BA_\u0003\u0007t1\u0001JA`\u0013\r\t\tMA\u0001\u0017'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0019&\u001cH/\u001a8fe&!\u0011QYAd\u0005\u0015)e/\u001a8u\u0015\r\t\tM\u0001\u0005\b\u0003\u0017\u0004A\u0011BAg\u0003-\u0019'/Z1uKF+XM]=\u0015-\u0005=\u0017Q[Ap\u0003G\u0014IAa\u0005\u0003\u001e\t\u001d\"1\u0006B\u0018\u0005s\u00012\u0001OAi\u0013\r\t\u0019.\f\u0002\u0016'R\u0014X-Y7j]\u001e\fV/\u001a:z/J\f\u0007\u000f]3s\u0011!\t9.!3A\u0002\u0005e\u0017!E;tKJ\u001c\u0006/Z2jM&,GMT1nKB)q\"a7\u0002\u001e%\u0019\u0011Q\u001c\t\u0003\r=\u0003H/[8o\u0011!\t\t/!3A\u0002\u0005e\u0017aH;tKJ\u001c\u0006/Z2jM&,Gm\u00115fG.\u0004x.\u001b8u\u0019>\u001c\u0017\r^5p]\"A\u0011Q]Ae\u0001\u0004\t9/\u0001\u0002eMB!\u0011\u0011\u001eB\u0002\u001d\u0011\tYO!\u0001\u000f\t\u00055\u0018q \b\u0005\u0003_\fiP\u0004\u0003\u0002r\u0006mh\u0002BAz\u0003sl!!!>\u000b\u0007\u0005]H\"\u0001\u0004=e>|GOP\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0007\u0005\u0005D!\u0003\u0003\u0003\u0006\t\u001d!!\u0003#bi\u00064%/Y7f\u0015\r\t\t\u0007\u0002\u0005\t\u0005\u0017\tI\r1\u0001\u0003\u000e\u0005aQ\r\u001f;sC>\u0003H/[8ogBA\u0011q\u0004B\b\u0003;\ti\"\u0003\u0003\u0003\u0012\u0005%\"aA'ba\"A!QCAe\u0001\u0004\u00119\"\u0001\u0003tS:\\\u0007c\u0001\u001d\u0003\u001a%\u0019!1D\u0017\u0003#\t\u000b7/Z*ue\u0016\fW.\u001b8h'&t7\u000e\u0003\u0005\u0003 \u0005%\u0007\u0019\u0001B\u0011\u0003)yW\u000f\u001e9vi6{G-\u001a\t\u0004I\t\r\u0012b\u0001B\u0013\u0005\tQq*\u001e;qkRlu\u000eZ3\t\u0011\t%\u0012\u0011\u001aa\u0001\u0003s\n\u0011$^:f)\u0016l\u0007o\u00115fG.\u0004x.\u001b8u\u0019>\u001c\u0017\r^5p]\"A!QFAe\u0001\u0004\tI(A\u000fsK\u000e|g/\u001a:Ge>l7\t[3dWB|\u0017N\u001c;M_\u000e\fG/[8o\u0011!\u0011\t$!3A\u0002\tM\u0012a\u0002;sS\u001e<WM\u001d\t\u0004I\tU\u0012b\u0001B\u001c\u0005\t9AK]5hO\u0016\u0014\b\u0002\u0003B\u001e\u0003\u0013\u0004\rA!\u0010\u0002\u0019Q\u0014\u0018nZ4fe\u000ecwnY6\u0011\t\t}\"1I\u0007\u0003\u0005\u0003R!a\u0013\u0004\n\t\t\u0015#\u0011\t\u0002\u0006\u00072|7m\u001b\u0005\t\u0005\u0013\u0002A\u0011\u0001\u0003\u0003L\u0005Q1\u000f^1siF+XM]=\u0015+A\u0013iEa\u0014\u0003R\tM#Q\u000bB,\u00053\u0012YF!\u0018\u0003`!A\u0011q\u001bB$\u0001\u0004\tI\u000e\u0003\u0005\u0002b\n\u001d\u0003\u0019AAm\u0011!\t)Oa\u0012A\u0002\u0005\u001d\b\u0002\u0003B\u0006\u0005\u000f\u0002\rA!\u0004\t\u0011\tU!q\ta\u0001\u0005/A\u0001Ba\b\u0003H\u0001\u0007!\u0011\u0005\u0005\u000b\u0005S\u00119\u0005%AA\u0002\u0005e\u0004B\u0003B\u0017\u0005\u000f\u0002\n\u00111\u0001\u0002z!Q!\u0011\u0007B$!\u0003\u0005\rAa\r\t\u0015\tm\"q\tI\u0001\u0002\u0004\u0011i\u0004\u0003\u0005\u0003d\u0001!\t\u0001\u0002B3\u0003Yqw\u000e^5gsF+XM]=UKJl\u0017N\\1uS>tGcA<\u0003h!9!\u0011\u000eB1\u0001\u0004\u0001\u0016a\u0004;fe6Lg.\u0019;fIF+XM]=\t\u0013\t5\u0004!%A\u0005\u0002\t=\u0014\u0001F:uCJ$\u0018+^3ss\u0012\"WMZ1vYR$s'\u0006\u0002\u0003r)\"\u0011\u0011\u0010B:W\t\u0011)\b\u0005\u0003\u0003x\t}TB\u0001B=\u0015\u0011\u0011YH! \u0002\u0013Ut7\r[3dW\u0016$'BA.\u0011\u0013\u0011\u0011\tI!\u001f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0003\u0006\u0002\t\n\u0011\"\u0001\u0003p\u0005!2\u000f^1siF+XM]=%I\u00164\u0017-\u001e7uIaB\u0011B!#\u0001#\u0003%\tAa#\u0002)M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u0013:+\t\u0011iI\u000b\u0003\u00034\tM\u0004\"\u0003BI\u0001E\u0005I\u0011\u0001BJ\u0003U\u0019H/\u0019:u#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%cA*\"A!&+\t\tu\"1\u000f\u0015\u0004\u0001\te\u0005\u0003\u0002BN\u0005KsAA!(\u0003\"6\u0011!q\u0014\u0006\u00037\u001aIAAa)\u0003 \u0006\u0011\u0012J\u001c;fe\u001a\f7-Z*uC\nLG.\u001b;z\u0013\u0011\u00119K!+\u0003\u0011\u00153x\u000e\u001c<j]\u001eTAAa)\u0003 \u0002")
public class StreamingQueryManager
implements Logging {
    public final SparkSession org$apache$spark$sql$streaming$StreamingQueryManager$$sparkSession;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final StreamingQueryListenerBus listenerBus;
    @GuardedBy(value="activeQueriesLock")
    private final HashMap<UUID, StreamingQuery> org$apache$spark$sql$streaming$StreamingQueryManager$$activeQueries;
    private final Object activeQueriesLock;
    private final Object awaitTerminationLock;
    @GuardedBy(value="awaitTerminationLock")
    private StreamingQuery lastTerminatedQuery;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private StreamingQueryListenerBus listenerBus() {
        return this.listenerBus;
    }

    public HashMap<UUID, StreamingQuery> org$apache$spark$sql$streaming$StreamingQueryManager$$activeQueries() {
        return this.org$apache$spark$sql$streaming$StreamingQueryManager$$activeQueries;
    }

    private Object activeQueriesLock() {
        return this.activeQueriesLock;
    }

    private Object awaitTerminationLock() {
        return this.awaitTerminationLock;
    }

    private StreamingQuery lastTerminatedQuery() {
        return this.lastTerminatedQuery;
    }

    private void lastTerminatedQuery_$eq(StreamingQuery x$1) {
        this.lastTerminatedQuery = x$1;
    }

    public StreamingQuery[] active() {
        Object object = this.activeQueriesLock();
        synchronized (object) {
            Object object2 = this.org$apache$spark$sql$streaming$StreamingQueryManager$$activeQueries().values().toArray(ClassTag$.MODULE$.apply(StreamingQuery.class));
            return (StreamingQuery[])object2;
        }
    }

    public StreamingQuery get(UUID id) {
        Object object = this.activeQueriesLock();
        synchronized (object) {
            Object object2 = this.org$apache$spark$sql$streaming$StreamingQueryManager$$activeQueries().get((Object)id).orNull(Predef$.MODULE$.$conforms());
            return (StreamingQuery)object2;
        }
    }

    public StreamingQuery get(String id) {
        return this.get(UUID.fromString(id));
    }

    public void awaitAnyTermination() throws StreamingQueryException {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (this.lastTerminatedQuery() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQuery() != null && this.lastTerminatedQuery().exception().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQuery().exception().get();
            }
            return;
        }
    }

    public boolean awaitAnyTermination(long timeoutMs) throws StreamingQueryException {
        long startTime = System.currentTimeMillis();
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (!this.isTimedout$1(timeoutMs, startTime) && this.lastTerminatedQuery() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQuery() != null && this.lastTerminatedQuery().exception().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQuery().exception().get();
            }
            Boolean bl = BoxesRunTime.boxToBoolean((this.lastTerminatedQuery() != null ? 1 : 0) != 0);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public void resetTerminated() {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            this.lastTerminatedQuery_$eq(null);
            return;
        }
    }

    public void addListener(StreamingQueryListener listener) {
        this.listenerBus().addListener(listener);
    }

    public void removeListener(StreamingQueryListener listener) {
        this.listenerBus().removeListener(listener);
    }

    public void postListenerEvent(StreamingQueryListener.Event event) {
        this.listenerBus().post(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamingQueryWrapper createQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, BaseStreamingSink sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock) {
        Tuple2 tuple2;
        Path checkpointPath;
        FileSystem fs;
        BooleanRef deleteCheckpointOnStop = BooleanRef.create((boolean)false);
        String checkpointLocation = (String)userSpecifiedCheckpointLocation.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String userSpecified) {
                return new Path(userSpecified).toUri().toString();
            }
        }).orElse((Function0)new Serializable(this, userSpecifiedName, df){
            public static final long serialVersionUID = 0L;
            public final Option userSpecifiedName$1;
            private final Dataset df$1;

            public final Option<String> apply() {
                return this.df$1.sparkSession().sessionState().conf().checkpointLocation().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final String apply(String location) {
                        return new Path(location, (String)this.$outer.userSpecifiedName$1.getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return UUID.randomUUID().toString();
                            }
                        })).toUri().toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.userSpecifiedName$1 = userSpecifiedName$1;
                this.df$1 = df$1;
            }
        }).getOrElse((Function0)new Serializable(this, useTempCheckpointLocation, deleteCheckpointOnStop){
            public static final long serialVersionUID = 0L;
            private final boolean useTempCheckpointLocation$1;
            private final BooleanRef deleteCheckpointOnStop$1;

            public final String apply() {
                if (this.useTempCheckpointLocation$1) {
                    this.deleteCheckpointOnStop$1.elem = true;
                    String x$3 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"temporary"})).s((Seq)Nil$.MODULE$);
                    String x$4 = Utils$.MODULE$.createTempDir$default$1();
                    return Utils$.MODULE$.createTempDir(x$4, x$3).getCanonicalPath();
                }
                throw new AnalysisException(new StringBuilder().append((Object)"checkpointLocation must be specified either through option(\"checkpointLocation\", ...) or ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SparkSession.conf.set(\"", "\", ...)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SQLConf$.MODULE$.CHECKPOINT_LOCATION().key()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.useTempCheckpointLocation$1 = useTempCheckpointLocation$1;
                this.deleteCheckpointOnStop$1 = deleteCheckpointOnStop$1;
            }
        });
        if (!recoverFromCheckpointLocation && (fs = (checkpointPath = new Path(checkpointLocation, "offsets")).getFileSystem(df.sparkSession().sessionState().newHadoopConf())).exists(checkpointPath)) {
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This query does not support recovering from checkpoint location. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delete ", " to start over."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{checkpointPath}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        LogicalPlan analyzedPlan = df.queryExecution().analyzed();
        df.queryExecution().assertAnalyzed();
        if (this.org$apache$spark$sql$streaming$StreamingQueryManager$$sparkSession.sessionState().conf().isUnsupportedOperationCheckEnabled()) {
            UnsupportedOperationChecker$.MODULE$.checkForStreaming(analyzedPlan, outputMode);
        }
        if (this.org$apache$spark$sql$streaming$StreamingQueryManager$$sparkSession.sessionState().conf().adaptiveExecutionEnabled()) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key()}))).append((Object)"is not supported in streaming DataFrames/Datasets and will be disabled.").toString();
                }
            });
        }
        if ((tuple2 = new Tuple2((Object)sink, (Object)trigger)) == null) return new StreamingQueryWrapper(new MicroBatchExecution(this.org$apache$spark$sql$streaming$StreamingQueryManager$$sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        BaseStreamingSink v2Sink = (BaseStreamingSink)tuple2._1();
        Trigger trigger2 = (Trigger)tuple2._2();
        if (!(v2Sink instanceof StreamWriteSupport)) return new StreamingQueryWrapper(new MicroBatchExecution(this.org$apache$spark$sql$streaming$StreamingQueryManager$$sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        StreamWriteSupport streamWriteSupport = (StreamWriteSupport)v2Sink;
        if (!(trigger2 instanceof ContinuousTrigger)) return new StreamingQueryWrapper(new MicroBatchExecution(this.org$apache$spark$sql$streaming$StreamingQueryManager$$sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
        if (!this.org$apache$spark$sql$streaming$StreamingQueryManager$$sparkSession.sessionState().conf().isUnsupportedOperationCheckEnabled()) return new StreamingQueryWrapper(new ContinuousExecution(this.org$apache$spark$sql$streaming$StreamingQueryManager$$sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, streamWriteSupport, continuousTrigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        UnsupportedOperationChecker$.MODULE$.checkForContinuous(analyzedPlan, outputMode);
        return new StreamingQueryWrapper(new ContinuousExecution(this.org$apache$spark$sql$streaming$StreamingQueryManager$$sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, streamWriteSupport, continuousTrigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public StreamingQuery startQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, BaseStreamingSink sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock) {
        StreamingQueryWrapper query = this.createQuery(userSpecifiedName, userSpecifiedCheckpointLocation, df, extraOptions, sink, outputMode, useTempCheckpointLocation, recoverFromCheckpointLocation, trigger, triggerClock);
        Object object = this.activeQueriesLock();
        // MONITORENTER : object
        userSpecifiedName.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ StreamingQueryManager $outer;

            public final void apply(String name2) {
                if (this.$outer.org$apache$spark$sql$streaming$StreamingQueryManager$$activeQueries().values().exists((Function1)new Serializable(this, name2){
                    public static final long serialVersionUID = 0L;
                    private final String name$1;

                    public final boolean apply(StreamingQuery x$1) {
                        String string = x$1.name();
                        String string2 = this.name$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.name$1 = name$1;
                    }
                })) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot start query with name ", " as a query with that name is already active"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name2})));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        if (this.org$apache$spark$sql$streaming$StreamingQueryManager$$activeQueries().values().exists((Function1)new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final StreamingQueryWrapper query$1;

            public final boolean apply(StreamingQuery x$2) {
                UUID uUID = x$2.id();
                UUID uUID2 = this.query$1.id();
                return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
            }
            {
                this.query$1 = query$1;
            }
        })) {
            throw new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot start query with id ", " as another query with same id is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query.id()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"already active. Perhaps you are attempting to restart a query from checkpoint "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"that is already active."})).s((Seq)Nil$.MODULE$)).toString());
        }
        this.org$apache$spark$sql$streaming$StreamingQueryManager$$activeQueries().put((Object)query.id(), (Object)query);
        // MONITOREXIT : object
        try {
            query.streamingQuery().start();
            return query;
        }
        catch (Throwable throwable) {
            void var11_11;
            Object object2 = this.activeQueriesLock();
            // MONITORENTER : object2
            this.org$apache$spark$sql$streaming$StreamingQueryManager$$activeQueries().$minus$eq((Object)var11_11.id());
            // MONITOREXIT : object2
            throw throwable;
        }
    }

    public boolean startQuery$default$7() {
        return false;
    }

    public boolean startQuery$default$8() {
        return true;
    }

    public Trigger startQuery$default$9() {
        return new ProcessingTime(0L);
    }

    public Clock startQuery$default$10() {
        return new SystemClock();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void notifyQueryTermination(StreamingQuery terminatedQuery) {
        Object object2 = this.activeQueriesLock();
        // MONITORENTER : object2
        this.org$apache$spark$sql$streaming$StreamingQueryManager$$activeQueries().$minus$eq((Object)terminatedQuery.id());
        // MONITOREXIT : object2
        Object object = this.awaitTerminationLock();
        if (this.lastTerminatedQuery() == null || terminatedQuery.exception().nonEmpty()) {
            this.lastTerminatedQuery_$eq(terminatedQuery);
        }
        this.awaitTerminationLock().notifyAll();
        // MONITOREXIT : object
        this.stateStoreCoordinator().deactivateInstances(terminatedQuery.runId());
        return;
    }

    private final boolean isTimedout$1(long timeoutMs$1, long startTime$1) {
        return System.currentTimeMillis() - startTime$1 >= timeoutMs$1;
    }

    public StreamingQueryManager(SparkSession sparkSession) {
        this.org$apache$spark$sql$streaming$StreamingQueryManager$$sparkSession = sparkSession;
        Logging.class.$init$((Logging)this);
        this.stateStoreCoordinator = StateStoreCoordinatorRef$.MODULE$.forDriver(sparkSession.sparkContext().env());
        this.listenerBus = new StreamingQueryListenerBus(sparkSession.sparkContext().listenerBus());
        this.org$apache$spark$sql$streaming$StreamingQueryManager$$activeQueries = new HashMap();
        this.activeQueriesLock = new Object();
        this.awaitTerminationLock = new Object();
        this.lastTerminatedQuery = null;
        try {
            ((Option)sparkSession.sparkContext().conf().get((ConfigEntry)StaticSQLConf$.MODULE$.STREAMING_QUERY_LISTENERS())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ StreamingQueryManager $outer;

                public final void apply(Seq<String> classNames) {
                    Utils$.MODULE$.loadExtensions(StreamingQueryListener.class, classNames, this.$outer.org$apache$spark$sql$streaming$StreamingQueryManager$$sparkSession.sparkContext().conf()).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$1 $outer;

                        public final void apply(StreamingQueryListener listener) {
                            this.$outer.org$apache$spark$sql$streaming$StreamingQueryManager$$anonfun$$$outer().addListener(listener);
                            this.$outer.org$apache$spark$sql$streaming$StreamingQueryManager$$anonfun$$$outer().logInfo((Function0<String>)new Serializable(this, listener){
                                public static final long serialVersionUID = 0L;
                                private final StreamingQueryListener listener$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Registered listener ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.listener$1.getClass().getName()}));
                                }
                                {
                                    this.listener$1 = listener$1;
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ StreamingQueryManager org$apache$spark$sql$streaming$StreamingQueryManager$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        catch (Exception exception) {
            throw new SparkException("Exception when registering StreamingQueryListener", (Throwable)exception);
        }
    }
}

