/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.text;

import java.io.Closeable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.codegen.UnsafeRowWriter;
import org.apache.spark.sql.catalyst.util.CompressionCodecs$;
import org.apache.spark.sql.execution.datasources.CodecStreams$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.HadoopFileWholeTextReader;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.TextBasedFileFormat;
import org.apache.spark.sql.execution.datasources.text.TextFileFormat$$anonfun$readToUnsafeMem$1$;
import org.apache.spark.sql.execution.datasources.text.TextOptions;
import org.apache.spark.sql.execution.datasources.text.TextOutputWriter;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df\u0001B\u0001\u0003\u0001E\u0011a\u0002V3yi\u001aKG.\u001a$pe6\fGO\u0003\u0002\u0004\t\u0005!A/\u001a=u\u0015\t)a!A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0004\t\u0003%)\u00070Z2vi&|gN\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003\u0011I!!\u0006\u0003\u0003'Q+\u0007\u0010\u001e\"bg\u0016$g)\u001b7f\r>\u0014X.\u0019;\u0011\u0005]QR\"\u0001\r\u000b\u0005eA\u0011aB:pkJ\u001cWm]\u0005\u00037a\u0011!\u0003R1uCN{WO]2f%\u0016<\u0017n\u001d;fe\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\u0006E\u0001!\teI\u0001\ng\"|'\u000f\u001e(b[\u0016$\u0012\u0001\n\t\u0003K-r!AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\na\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\u0019\u0019FO]5oO*\u0011!f\n\u0005\u0006_\u0001!\teI\u0001\ti>\u001cFO]5oO\")\u0011\u0007\u0001C\u0005e\u0005aa/\u001a:jMf\u001c6\r[3nCR\u00111G\u000e\t\u0003MQJ!!N\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006oA\u0002\r\u0001O\u0001\u0007g\u000eDW-\\1\u0011\u0005ebT\"\u0001\u001e\u000b\u0005mB\u0011!\u0002;za\u0016\u001c\u0018BA\u001f;\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006\u007f\u0001!\t\u0005Q\u0001\fSN\u001c\u0006\u000f\\5uC\ndW\r\u0006\u0003B\t*{\u0005C\u0001\u0014C\u0013\t\u0019uEA\u0004C_>dW-\u00198\t\u000b\u0015s\u0004\u0019\u0001$\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\u001dCU\"\u0001\u0005\n\u0005%C!\u0001D*qCJ\\7+Z:tS>t\u0007\"B&?\u0001\u0004a\u0015aB8qi&|gn\u001d\t\u0005K5#C%\u0003\u0002O[\t\u0019Q*\u00199\t\u000bAs\u0004\u0019A)\u0002\tA\fG\u000f\u001b\t\u0003%^k\u0011a\u0015\u0006\u0003)V\u000b!AZ:\u000b\u0005Yc\u0011A\u00025bI>|\u0007/\u0003\u0002Y'\n!\u0001+\u0019;i\u0011\u0015Q\u0006\u0001\"\u0011\\\u0003-IgNZ3s'\u000eDW-\\1\u0015\tq{\u0006-\u0019\t\u0004MuC\u0014B\u00010(\u0005\u0019y\u0005\u000f^5p]\")Q)\u0017a\u0001\r\")1*\u0017a\u0001\u0019\")!-\u0017a\u0001G\u0006)a-\u001b7fgB\u0019A\r\\8\u000f\u0005\u0015TgB\u00014j\u001b\u00059'B\u00015\u0011\u0003\u0019a$o\\8u}%\t\u0001&\u0003\u0002lO\u00059\u0001/Y2lC\u001e,\u0017BA7o\u0005\r\u0019V-\u001d\u0006\u0003W\u001e\u0002\"A\u00159\n\u0005E\u001c&A\u0003$jY\u0016\u001cF/\u0019;vg\")1\u000f\u0001C!i\u0006a\u0001O]3qCJ,wK]5uKR9Q\u000f_=\u0002\u0004\u0005\u0015\u0001CA\nw\u0013\t9HAA\nPkR\u0004X\u000f^,sSR,'OR1di>\u0014\u0018\u0010C\u0003Fe\u0002\u0007a\tC\u0003{e\u0002\u000710A\u0002k_\n\u0004\"\u0001`@\u000e\u0003uT!A`+\u0002\u00135\f\u0007O]3ek\u000e,\u0017bAA\u0001{\n\u0019!j\u001c2\t\u000b-\u0013\b\u0019\u0001'\t\r\u0005\u001d!\u000f1\u00019\u0003)!\u0017\r^1TG\",W.\u0019\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0003-\u0011W/\u001b7e%\u0016\fG-\u001a:\u0015!\u0005=\u0011QFA\u0018\u0003c\t)$!\u000f\u0002F\u0005\u001d\u0003c\u0002\u0014\u0002\u0012\u0005U\u00111D\u0005\u0004\u0003'9#!\u0003$v]\u000e$\u0018n\u001c82!\r\u0019\u0012qC\u0005\u0004\u00033!!a\u0004)beRLG/[8oK\u00124\u0015\u000e\\3\u0011\u000b\u0011\fi\"!\t\n\u0007\u0005}aN\u0001\u0005Ji\u0016\u0014\u0018\r^8s!\u0011\t\u0019#!\u000b\u000e\u0005\u0005\u0015\"bAA\u0014\u0011\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002,\u0005\u0015\"aC%oi\u0016\u0014h.\u00197S_^Da!RA\u0005\u0001\u00041\u0005bBA\u0004\u0003\u0013\u0001\r\u0001\u000f\u0005\b\u0003g\tI\u00011\u00019\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007bBA\u001c\u0003\u0013\u0001\r\u0001O\u0001\u000fe\u0016\fX/\u001b:fIN\u001b\u0007.Z7b\u0011!\tY$!\u0003A\u0002\u0005u\u0012a\u00024jYR,'o\u001d\t\u0005I2\fy\u0004E\u0002\u0018\u0003\u0003J1!a\u0011\u0019\u0005\u00191\u0015\u000e\u001c;fe\"11*!\u0003A\u00021C\u0001\"!\u0013\u0002\n\u0001\u0007\u00111J\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005ES+\u0001\u0003d_:4\u0017\u0002BA+\u0003\u001f\u0012QbQ8oM&<WO]1uS>t\u0007bBA-\u0001\u0011%\u00111L\u0001\u0010e\u0016\fG\rV8V]N\fg-Z'f[RA\u0011QLA7\u0003\u000f\u000bI\tE\u0004'\u0003#\t)\"a\u0018\u0011\u000b\u0011\fi\"!\u0019\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KRA!a\u001a\u0002&\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\tY'!\u001a\u0003\u0013Us7/\u00194f%><\b\u0002CA)\u0003/\u0002\r!a\u001c\u0011\r\u0005E\u0014qOA>\u001b\t\t\u0019HC\u0002\u0002v)\t\u0011B\u0019:pC\u0012\u001c\u0017m\u001d;\n\t\u0005e\u00141\u000f\u0002\n\u0005J|\u0017\rZ2bgR\u0004B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0004\u0003\u0003S\u0011\u0001B;uS2LA!!\"\u0002\u0000\tI2+\u001a:jC2L'0\u00192mK\u000e{gNZ5hkJ\fG/[8o\u0011\u001d\t9$a\u0016A\u0002aB\u0001\"a#\u0002X\u0001\u0007\u0011QR\u0001\fi\u0016DHo\u00149uS>t7\u000fE\u0002!\u0003\u001fK1!!%\u0003\u0005-!V\r\u001f;PaRLwN\\:\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\u0006y1/\u001e9q_J$H)\u0019;b)f\u0004X\rF\u0003B\u00033\u000b\u0019\u000b\u0003\u0005\u0002\u001c\u0006M\u0005\u0019AAO\u0003!!\u0017\r^1UsB,\u0007cA\u001d\u0002 &\u0019\u0011\u0011\u0015\u001e\u0003\u0011\u0011\u000bG/\u0019+za\u0016Dq!!*\u0002\u0014\u0002\u0007\u0011)\u0001\u0006jgJ+\u0017\r\u001a)bi\"\u0004")
public class TextFileFormat
extends TextBasedFileFormat
implements DataSourceRegister {
    @Override
    public String shortName() {
        return "text";
    }

    public String toString() {
        return "Text";
    }

    private void verifySchema(StructType schema2) {
        if (schema2.size() != 1) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Text data source supports only a single column, and you have ", " columns."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)schema2.size())})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    @Override
    public boolean isSplitable(SparkSession sparkSession, Map<String, String> options, Path path) {
        TextOptions textOptions = new TextOptions(options);
        return super.isSplitable(sparkSession, options, path) && !textOptions.wholeText();
    }

    @Override
    public Option<StructType> inferSchema(SparkSession sparkSession, Map<String, String> options, Seq<FileStatus> files) {
        return new Some((Object)new StructType().add("value", (DataType)StringType$.MODULE$));
    }

    @Override
    public OutputWriterFactory prepareWrite(SparkSession sparkSession, Job job, Map<String, String> options, StructType dataSchema) {
        this.verifySchema(dataSchema);
        TextOptions textOptions = new TextOptions(options);
        Configuration conf = job.getConfiguration();
        textOptions.compressionCodec().foreach((Function1)new Serializable(this, conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(String codec) {
                CompressionCodecs$.MODULE$.setCodecConfiguration(this.conf$1, codec);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        return new OutputWriterFactory(this, textOptions){
            private final TextOptions textOptions$1;

            public OutputWriter newInstance(String path, StructType dataSchema, TaskAttemptContext context) {
                return new TextOutputWriter(path, dataSchema, this.textOptions$1.lineSeparatorInWrite(), context);
            }

            public String getFileExtension(TaskAttemptContext context) {
                return new StringBuilder().append((Object)".txt").append((Object)CodecStreams$.MODULE$.getCompressionExtension((JobContext)context)).toString();
            }
            {
                this.textOptions$1 = textOptions$1;
            }
        };
    }

    @Override
    public Function1<PartitionedFile, Iterator<InternalRow>> buildReader(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Predef$.MODULE$.assert(requiredSchema.length() <= 1, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Text data source only produces a single data column named \"value\".";
            }
        });
        TextOptions textOptions = new TextOptions(options);
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return this.readToUnsafeMem((Broadcast<SerializableConfiguration>)broadcastedHadoopConf, requiredSchema, textOptions);
    }

    private Function1<PartitionedFile, Iterator<UnsafeRow>> readToUnsafeMem(Broadcast<SerializableConfiguration> conf, StructType requiredSchema, TextOptions textOptions) {
        return new Serializable(this, conf, requiredSchema, textOptions){
            public static final long serialVersionUID = 0L;
            private final Broadcast conf$2;
            private final StructType requiredSchema$1;
            private final TextOptions textOptions$2;

            public final Iterator<UnsafeRow> apply(PartitionedFile file) {
                Iterator iterator2;
                Configuration confValue = ((SerializableConfiguration)this.conf$2.value()).value();
                Logging reader = this.textOptions$2.wholeText() ? new HadoopFileWholeTextReader(file, confValue) : new HadoopFileLinesReader(file, this.textOptions$2.lineSeparatorInRead(), confValue);
                Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new Serializable(this, (Iterator)reader){
                    public static final long serialVersionUID = 0L;
                    public final Iterator reader$1;

                    public final TaskContext apply(TaskContext x$1) {
                        return x$1.addTaskCompletionListener((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$readToUnsafeMem$1$$anonfun$apply$1 $outer;

                            public final void apply(TaskContext x$2) {
                                ((Closeable)this.$outer.reader$1).close();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    {
                        this.reader$1 = reader$1;
                    }
                });
                if (this.requiredSchema$1.isEmpty()) {
                    UnsafeRow emptyUnsafeRow = new UnsafeRow(0);
                    iterator2 = reader.map((Function1)new Serializable(this, emptyUnsafeRow){
                        public static final long serialVersionUID = 0L;
                        private final UnsafeRow emptyUnsafeRow$1;

                        public final UnsafeRow apply(Text x$3) {
                            return this.emptyUnsafeRow$1;
                        }
                        {
                            this.emptyUnsafeRow$1 = emptyUnsafeRow$1;
                        }
                    });
                } else {
                    UnsafeRowWriter unsafeRowWriter = new UnsafeRowWriter(1);
                    iterator2 = reader.map((Function1)new Serializable(this, unsafeRowWriter){
                        public static final long serialVersionUID = 0L;
                        private final UnsafeRowWriter unsafeRowWriter$1;

                        public final UnsafeRow apply(Text line) {
                            this.unsafeRowWriter$1.reset();
                            this.unsafeRowWriter$1.write(0, line.getBytes(), 0, line.getLength());
                            return this.unsafeRowWriter$1.getRow();
                        }
                        {
                            this.unsafeRowWriter$1 = unsafeRowWriter$1;
                        }
                    });
                }
                return iterator2;
            }
            {
                this.conf$2 = conf$2;
                this.requiredSchema$1 = requiredSchema$1;
                this.textOptions$2 = textOptions$2;
            }
        };
    }

    @Override
    public boolean supportDataType(DataType dataType, boolean isReadPath) {
        DataType dataType2 = dataType;
        StringType$ stringType$ = StringType$.MODULE$;
        return !(dataType2 != null ? !dataType2.equals(stringType$) : stringType$ != null);
    }
}

