/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Closeable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.shell.PathData;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001=\u0011Q\u0003S1e_>\u0004h)\u001b7f\u0019&tWm\u001d*fC\u0012,'O\u0003\u0002\u0004\t\u0005YA-\u0019;bg>,(oY3t\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\u0005\f+cA\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u00042aF\u0010#\u001d\tARD\u0004\u0002\u001a95\t!D\u0003\u0002\u001c\u001d\u00051AH]8pizJ\u0011aE\u0005\u0003=I\tq\u0001]1dW\u0006<W-\u0003\u0002!C\tA\u0011\n^3sCR|'O\u0003\u0002\u001f%A\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0003S>T!a\n\u0006\u0002\r!\fGm\\8q\u0013\tICE\u0001\u0003UKb$\bCA\u00160\u001b\u0005a#BA\u0013.\u0015\u0005q\u0013\u0001\u00026bm\u0006L!\u0001\r\u0017\u0003\u0013\rcwn]3bE2,\u0007C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\t\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u001c4\u0005\u001daunZ4j]\u001eD\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!O\u0001\u0005M&dW\r\u0005\u0002;w5\t!!\u0003\u0002=\u0005\ty\u0001+\u0019:uSRLwN\\3e\r&dW\r\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u00035a\u0017N\\3TKB\f'/\u0019;peB\u0019\u0011\u0003\u0011\"\n\u0005\u0005\u0013\"AB(qi&|g\u000eE\u0002\u0012\u0007\u0016K!\u0001\u0012\n\u0003\u000b\u0005\u0013(/Y=\u0011\u0005E1\u0015BA$\u0013\u0005\u0011\u0011\u0015\u0010^3\t\u0011%\u0003!\u0011!Q\u0001\n)\u000bAaY8oMB\u00111*T\u0007\u0002\u0019*\u0011\u0011JJ\u0005\u0003\u001d2\u0013QbQ8oM&<WO]1uS>t\u0007\"\u0002)\u0001\t\u0003\t\u0016A\u0002\u001fj]&$h\b\u0006\u0003S'R+\u0006C\u0001\u001e\u0001\u0011\u0015At\n1\u0001:\u0011\u0015qt\n1\u0001@\u0011\u0015Iu\n1\u0001K\u0011\u0015\u0001\u0006\u0001\"\u0001X)\r\u0011\u0006,\u0017\u0005\u0006qY\u0003\r!\u000f\u0005\u0006\u0013Z\u0003\rA\u0013\u0005\u00067\u0002!I\u0001X\u0001\rO\u0016$h)\u001b7f'Bd\u0017\u000e\u001e\u000b\u0004;\u001eD\u0007C\u00010f\u001b\u0005y&B\u00011b\u0003\u0015Ig\u000e];u\u0015\t\u00117-A\u0002mS\nT!\u0001\u001a\u0014\u0002\u00135\f\u0007O]3ek\u000e,\u0017B\u00014`\u0005%1\u0015\u000e\\3Ta2LG\u000fC\u000395\u0002\u0007\u0011\bC\u0003J5\u0002\u0007!\nC\u0004k\u0001\t\u0007I\u0011B6\u0002\u0011%$XM]1u_J,\u0012\u0001\u001c\t\u0004u5\u0014\u0013B\u00018\u0003\u0005Q\u0011VmY8sIJ+\u0017\rZ3s\u0013R,'/\u0019;pe\"1\u0001\u000f\u0001Q\u0001\n1\f\u0011\"\u001b;fe\u0006$xN\u001d\u0011\t\u000bI\u0004A\u0011I:\u0002\u000f!\f7OT3yiV\tA\u000f\u0005\u0002\u0012k&\u0011aO\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015A\b\u0001\"\u0011z\u0003\u0011qW\r\u001f;\u0015\u0003\tBQa\u001f\u0001\u0005Bq\fQa\u00197pg\u0016$\u0012! \t\u0003#yL!a \n\u0003\tUs\u0017\u000e\u001e")
public class HadoopFileLinesReader
implements Iterator<Text>,
Closeable,
Logging {
    private final RecordReaderIterator<Text> iterator;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Iterator<Text> seq() {
        return Iterator.class.seq((Iterator)this);
    }

    public boolean isEmpty() {
        return Iterator.class.isEmpty((Iterator)this);
    }

    public boolean isTraversableAgain() {
        return Iterator.class.isTraversableAgain((Iterator)this);
    }

    public boolean hasDefiniteSize() {
        return Iterator.class.hasDefiniteSize((Iterator)this);
    }

    public Iterator<Text> take(int n) {
        return Iterator.class.take((Iterator)this, (int)n);
    }

    public Iterator<Text> drop(int n) {
        return Iterator.class.drop((Iterator)this, (int)n);
    }

    public Iterator<Text> slice(int from, int until) {
        return Iterator.class.slice((Iterator)this, (int)from, (int)until);
    }

    public <B> Iterator<B> map(Function1<Text, B> f) {
        return Iterator.class.map((Iterator)this, f);
    }

    public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
        return Iterator.class.$plus$plus((Iterator)this, that);
    }

    public <B> Iterator<B> flatMap(Function1<Text, GenTraversableOnce<B>> f) {
        return Iterator.class.flatMap((Iterator)this, f);
    }

    public Iterator<Text> filter(Function1<Text, Object> p) {
        return Iterator.class.filter((Iterator)this, p);
    }

    public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<Text, B, Object> p) {
        return Iterator.class.corresponds((Iterator)this, that, p);
    }

    public Iterator<Text> withFilter(Function1<Text, Object> p) {
        return Iterator.class.withFilter((Iterator)this, p);
    }

    public Iterator<Text> filterNot(Function1<Text, Object> p) {
        return Iterator.class.filterNot((Iterator)this, p);
    }

    public <B> Iterator<B> collect(PartialFunction<Text, B> pf) {
        return Iterator.class.collect((Iterator)this, pf);
    }

    public <B> Iterator<B> scanLeft(B z, Function2<B, Text, B> op) {
        return Iterator.class.scanLeft((Iterator)this, z, op);
    }

    public <B> Iterator<B> scanRight(B z, Function2<Text, B, B> op) {
        return Iterator.class.scanRight((Iterator)this, z, op);
    }

    public Iterator<Text> takeWhile(Function1<Text, Object> p) {
        return Iterator.class.takeWhile((Iterator)this, p);
    }

    public Tuple2<Iterator<Text>, Iterator<Text>> partition(Function1<Text, Object> p) {
        return Iterator.class.partition((Iterator)this, p);
    }

    public Tuple2<Iterator<Text>, Iterator<Text>> span(Function1<Text, Object> p) {
        return Iterator.class.span((Iterator)this, p);
    }

    public Iterator<Text> dropWhile(Function1<Text, Object> p) {
        return Iterator.class.dropWhile((Iterator)this, p);
    }

    public <B> Iterator<Tuple2<Text, B>> zip(Iterator<B> that) {
        return Iterator.class.zip((Iterator)this, that);
    }

    public <A1> Iterator<A1> padTo(int len, A1 elem) {
        return Iterator.class.padTo((Iterator)this, (int)len, elem);
    }

    public Iterator<Tuple2<Text, Object>> zipWithIndex() {
        return Iterator.class.zipWithIndex((Iterator)this);
    }

    public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
        return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
    }

    public <U> void foreach(Function1<Text, U> f) {
        Iterator.class.foreach((Iterator)this, f);
    }

    public boolean forall(Function1<Text, Object> p) {
        return Iterator.class.forall((Iterator)this, p);
    }

    public boolean exists(Function1<Text, Object> p) {
        return Iterator.class.exists((Iterator)this, p);
    }

    public boolean contains(Object elem) {
        return Iterator.class.contains((Iterator)this, (Object)elem);
    }

    public Option<Text> find(Function1<Text, Object> p) {
        return Iterator.class.find((Iterator)this, p);
    }

    public int indexWhere(Function1<Text, Object> p) {
        return Iterator.class.indexWhere((Iterator)this, p);
    }

    public <B> int indexOf(B elem) {
        return Iterator.class.indexOf((Iterator)this, elem);
    }

    public BufferedIterator<Text> buffered() {
        return Iterator.class.buffered((Iterator)this);
    }

    public <B> Iterator.GroupedIterator<B> grouped(int size) {
        return Iterator.class.grouped((Iterator)this, (int)size);
    }

    public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
        return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
    }

    public int length() {
        return Iterator.class.length((Iterator)this);
    }

    public Tuple2<Iterator<Text>, Iterator<Text>> duplicate() {
        return Iterator.class.duplicate((Iterator)this);
    }

    public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
        return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
    }

    public <B> void copyToArray(Object xs, int start2, int len) {
        Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start2, (int)len);
    }

    public boolean sameElements(Iterator<?> that) {
        return Iterator.class.sameElements((Iterator)this, that);
    }

    public Traversable<Text> toTraversable() {
        return Iterator.class.toTraversable((Iterator)this);
    }

    public Iterator<Text> toIterator() {
        return Iterator.class.toIterator((Iterator)this);
    }

    public Stream<Text> toStream() {
        return Iterator.class.toStream((Iterator)this);
    }

    public String toString() {
        return Iterator.class.toString((Iterator)this);
    }

    public <B> int sliding$default$2() {
        return Iterator.class.sliding$default$2((Iterator)this);
    }

    public List<Text> reversed() {
        return TraversableOnce.class.reversed((TraversableOnce)this);
    }

    public int size() {
        return TraversableOnce.class.size((TraversableOnce)this);
    }

    public boolean nonEmpty() {
        return TraversableOnce.class.nonEmpty((TraversableOnce)this);
    }

    public int count(Function1<Text, Object> p) {
        return TraversableOnce.class.count((TraversableOnce)this, p);
    }

    public <B> Option<B> collectFirst(PartialFunction<Text, B> pf) {
        return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
    }

    public <B> B $div$colon(B z, Function2<B, Text, B> op) {
        return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
    }

    public <B> B $colon$bslash(B z, Function2<Text, B, B> op) {
        return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
    }

    public <B> B foldLeft(B z, Function2<B, Text, B> op) {
        return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
    }

    public <B> B foldRight(B z, Function2<Text, B, B> op) {
        return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
    }

    public <B> B reduceLeft(Function2<B, Text, B> op) {
        return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
    }

    public <B> B reduceRight(Function2<Text, B, B> op) {
        return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceLeftOption(Function2<B, Text, B> op) {
        return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
    }

    public <B> Option<B> reduceRightOption(Function2<Text, B, B> op) {
        return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
    }

    public <A1> A1 reduce(Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
    }

    public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
        return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
    }

    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
        return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
    }

    public <B> B aggregate(Function0<B> z, Function2<B, Text, B> seqop, Function2<B, B, B> combop) {
        return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
    }

    public <B> B sum(Numeric<B> num) {
        return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
    }

    public <B> B product(Numeric<B> num) {
        return (B)TraversableOnce.class.product((TraversableOnce)this, num);
    }

    public Object min(Ordering cmp) {
        return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
    }

    public Object max(Ordering cmp) {
        return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
    }

    public Object maxBy(Function1 f, Ordering cmp) {
        return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public Object minBy(Function1 f, Ordering cmp) {
        return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
    }

    public <B> void copyToBuffer(Buffer<B> dest) {
        TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
    }

    public <B> void copyToArray(Object xs, int start2) {
        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start2);
    }

    public <B> void copyToArray(Object xs) {
        TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
    }

    public <B> Object toArray(ClassTag<B> evidence$1) {
        return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
    }

    public List<Text> toList() {
        return TraversableOnce.class.toList((TraversableOnce)this);
    }

    public Iterable<Text> toIterable() {
        return TraversableOnce.class.toIterable((TraversableOnce)this);
    }

    public Seq<Text> toSeq() {
        return TraversableOnce.class.toSeq((TraversableOnce)this);
    }

    public IndexedSeq<Text> toIndexedSeq() {
        return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
    }

    public <B> Buffer<B> toBuffer() {
        return TraversableOnce.class.toBuffer((TraversableOnce)this);
    }

    public <B> Set<B> toSet() {
        return TraversableOnce.class.toSet((TraversableOnce)this);
    }

    public Vector<Text> toVector() {
        return TraversableOnce.class.toVector((TraversableOnce)this);
    }

    public <Col> Col to(CanBuildFrom<Nothing$, Text, Col> cbf) {
        return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
    }

    public <T, U> Map<T, U> toMap(Predef.$less$colon$less<Text, Tuple2<T, U>> ev) {
        return TraversableOnce.class.toMap((TraversableOnce)this, ev);
    }

    public String mkString(String start2, String sep, String end) {
        return TraversableOnce.class.mkString((TraversableOnce)this, (String)start2, (String)sep, (String)end);
    }

    public String mkString(String sep) {
        return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
    }

    public String mkString() {
        return TraversableOnce.class.mkString((TraversableOnce)this);
    }

    public StringBuilder addString(StringBuilder b, String start2, String sep, String end) {
        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start2, (String)sep, (String)end);
    }

    public StringBuilder addString(StringBuilder b, String sep) {
        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
    }

    public StringBuilder addString(StringBuilder b) {
        return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
    }

    private FileSplit getFileSplit(PartitionedFile file, Configuration conf) {
        FileSplit fileSplit;
        try {
            PathData pathData = new PathData(file.filePath(), conf);
            if (pathData.stat != null && pathData.stat.isSymlink()) {
                PathData symlinkPathData = FileUtil.checkPathForSymlink((Path)new Path(file.filePath()), (Configuration)conf);
                fileSplit = new FileSplit(symlinkPathData.path, file.start(), symlinkPathData.stat.getLen(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            } else {
                fileSplit = new FileSplit(new Path(new URI(file.filePath())), file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            this.log().warn("Symlink check failed. Please install latest mapr-patch to avoid this warning. See MAPR-SPARK-941 for ref");
            fileSplit = new FileSplit(new Path(new URI(file.filePath())), file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        }
        return fileSplit;
    }

    private RecordReaderIterator<Text> iterator() {
        return this.iterator;
    }

    public boolean hasNext() {
        return this.iterator().hasNext();
    }

    public Text next() {
        return this.iterator().next();
    }

    @Override
    public void close() {
        this.iterator().close();
    }

    public HadoopFileLinesReader(PartitionedFile file, Option<byte[]> lineSeparator, Configuration conf) {
        LineRecordReader lineRecordReader;
        TraversableOnce.class.$init$((TraversableOnce)this);
        Iterator.class.$init$((Iterator)this);
        Logging.class.$init$((Logging)this);
        FileSplit fileSplit = this.getFileSplit(file, conf);
        TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
        TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(conf, attemptId);
        Option<byte[]> option = lineSeparator;
        if (option instanceof Some) {
            Some some = (Some)option;
            byte[] sep = (byte[])some.x();
            lineRecordReader = new LineRecordReader(sep);
        } else {
            lineRecordReader = new LineRecordReader();
        }
        LineRecordReader reader = lineRecordReader;
        reader.initialize((InputSplit)fileSplit, (TaskAttemptContext)hadoopAttemptContext);
        this.iterator = new RecordReaderIterator(reader);
    }

    public HadoopFileLinesReader(PartitionedFile file, Configuration conf) {
        this(file, (Option<byte[]>)None$.MODULE$, conf);
    }
}

