/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.IntColumnStats;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.LongColumnStats;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.StringColumnStats;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.execution.columnar.compression.DictionaryEncoding;
import org.apache.spark.sql.execution.columnar.compression.DictionaryEncoding$;
import org.apache.spark.sql.execution.columnar.compression.DictionaryEncodingSuite$$anonf$$$$932a303e7ba8ef79552697d0ae2df695$$$$aryEncodingSuite$;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001#\t9B)[2uS>t\u0017M]=F]\u000e|G-\u001b8h'VLG/\u001a\u0006\u0003\u0007\u0011\t1bY8naJ,7o]5p]*\u0011QAB\u0001\tG>dW/\u001c8be*\u0011q\u0001C\u0001\nKb,7-\u001e;j_:T!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M!R\"\u0001\u0006\n\u0005UQ!!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0005!9A\u0004\u0001b\u0001\n\u0003i\u0012!\u00038vY24\u0016\r\\;f+\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#aA%oi\"1Q\u0005\u0001Q\u0001\ny\t!B\\;mYZ\u000bG.^3!\u0011\u00159\u0003\u0001\"\u0001)\u0003Y!Xm\u001d;ES\u000e$\u0018n\u001c8bef,enY8eS:<WCA\u0015;)\u0011QSf\r$\u0011\u0005}Y\u0013B\u0001\u0017!\u0005\u0011)f.\u001b;\t\u000b92\u0003\u0019A\u0018\u0002\u0017\r|G.^7o'R\fGo\u001d\t\u0003aEj\u0011\u0001B\u0005\u0003e\u0011\u00111bQ8mk6t7\u000b^1ug\")AG\na\u0001k\u0005Q1m\u001c7v[:$\u0016\u0010]3\u0011\u0007A2\u0004(\u0003\u00028\t\t\u0001b*\u0019;jm\u0016\u001cu\u000e\\;n]RK\b/\u001a\t\u0003sib\u0001\u0001B\u0003<M\t\u0007AHA\u0001U#\ti\u0004\t\u0005\u0002 }%\u0011q\b\t\u0002\b\u001d>$\b.\u001b8h!\t\tE)D\u0001C\u0015\t\u0019\u0005\"A\u0003usB,7/\u0003\u0002F\u0005\nQ\u0011\t^8nS\u000e$\u0016\u0010]3\t\u000f\u001d3\u0003\u0013!a\u0001\u0011\u0006qA/Z:u\t\u0016\u001cw.\u001c9sKN\u001c\bCA\u0010J\u0013\tQ\u0005EA\u0004C_>dW-\u00198\t\u000f1\u0003\u0011\u0013!C\u0001\u001b\u0006\u0001C/Z:u\t&\u001cG/[8oCJLXI\\2pI&tw\r\n3fM\u0006,H\u000e\u001e\u00134+\tq\u0015,F\u0001PU\tA\u0005kK\u0001R!\t\u0011v+D\u0001T\u0015\t!V+A\u0005v]\u000eDWmY6fI*\u0011a\u000bI\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001-T\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0006w-\u0013\r\u0001\u0010")
public class DictionaryEncodingSuite
extends SparkFunSuite {
    private final int nullValue;

    public int nullValue() {
        return this.nullValue;
    }

    public <T extends AtomicType> void testDictionaryEncoding(ColumnStats columnStats, NativeColumnType<T> columnType, boolean testDecompress) {
        String typeName = new StringOps(Predef$.MODULE$.augmentString(columnType.getClass().getSimpleName())).stripSuffix("$");
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": empty"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DictionaryEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DictionaryEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$DictionaryEncodingSuite$$skeleton$1(0, (Seq)Seq$.MODULE$.empty(), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        }, new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": simple case"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DictionaryEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DictionaryEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$DictionaryEncodingSuite$$skeleton$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0, 1})), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        }, new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": dictionary overflow"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DictionaryEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DictionaryEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$DictionaryEncodingSuite$$skeleton$1(DictionaryEncoding$.MODULE$.MAX_DICT_SIZE() + 1, (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), (int)DictionaryEncoding$.MODULE$.MAX_DICT_SIZE()), this.columnStats$1, this.columnType$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
            }
        }, new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": empty for decompress()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DictionaryEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType, testDecompress){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DictionaryEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;
            private final boolean testDecompress$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$DictionaryEncodingSuite$$skeletonForDecompress$1(0, (Seq)Seq$.MODULE$.empty(), this.columnStats$1, this.columnType$1, this.testDecompress$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
                this.testDecompress$1 = testDecompress$1;
            }
        }, new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": simple case for decompress()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DictionaryEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType, testDecompress){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DictionaryEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;
            private final boolean testDecompress$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$DictionaryEncodingSuite$$skeletonForDecompress$1(2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, this.$outer.nullValue(), 0, this.$outer.nullValue()})), this.columnStats$1, this.columnType$1, this.testDecompress$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
                this.testDecompress$1 = testDecompress$1;
            }
        }, new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " with ", ": dictionary overflow for decompress()"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DictionaryEncoding$.MODULE$, typeName})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, columnStats, columnType, testDecompress){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DictionaryEncodingSuite $outer;
            private final ColumnStats columnStats$1;
            private final NativeColumnType columnType$1;
            private final boolean testDecompress$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$apache$spark$sql$execution$columnar$compression$DictionaryEncodingSuite$$skeletonForDecompress$1(DictionaryEncoding$.MODULE$.MAX_DICT_SIZE() + 2, (Seq)((TraversableLike)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.nullValue()}))).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), DictionaryEncoding$.MODULE$.MAX_DICT_SIZE() - 1), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.nullValue()})), Seq$.MODULE$.canBuildFrom()), this.columnStats$1, this.columnType$1, this.testDecompress$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.columnStats$1 = columnStats$1;
                this.columnType$1 = columnType$1;
                this.testDecompress$1 = testDecompress$1;
            }
        }, new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
    }

    public <T extends AtomicType> boolean testDictionaryEncoding$default$3() {
        return true;
    }

    private final Map buildDictionary$1(ByteBuffer buffer, NativeColumnType columnType$1) {
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), buffer.getInt()).map((Function1)new Serializable(this, columnType$1, buffer){
            public static final long serialVersionUID = 0L;
            private final NativeColumnType columnType$1;
            private final ByteBuffer buffer$1;

            public final Tuple2<Object, Object> apply(int x$1) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.columnType$1.extract(this.buffer$1)), (Object)BoxesRunTime.boxToShort((short)((short)x$1)));
            }
            {
                this.columnType$1 = columnType$1;
                this.buffer$1 = buffer$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private final Seq stableDistinct$1(Seq seq) {
        Seq seq2;
        if (seq.isEmpty()) {
            seq2 = (Seq)Seq$.MODULE$.empty();
        } else {
            int n = BoxesRunTime.unboxToInt((Object)seq.head());
            seq2 = (Seq)((SeqLike)((TraversableLike)seq.tail()).filterNot((Function1)new Serializable(this, seq){
                public static final long serialVersionUID = 0L;
                private final Seq seq$1;

                public final boolean apply(int x$2) {
                    return this.apply$mcZI$sp(x$2);
                }

                public boolean apply$mcZI$sp(int x$2) {
                    return x$2 == BoxesRunTime.unboxToInt((Object)this.seq$1.head());
                }
                {
                    this.seq$1 = seq$1;
                }
            })).$plus$colon((Object)BoxesRunTime.boxToInteger((int)n), Seq$.MODULE$.canBuildFrom());
        }
        return seq2;
    }

    public final void org$apache$spark$sql$execution$columnar$compression$DictionaryEncodingSuite$$skeleton$1(int uniqueValueCount, Seq inputSeq, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)DictionaryEncoding$.MODULE$);
        Tuple2<Seq<Object>, Seq<GenericInternalRow>> tuple2 = ColumnarTestUtils$.MODULE$.makeUniqueValuesAndSingleValueRows(columnType$1, uniqueValueCount);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq values = (Seq)tuple2._1();
            Seq rows = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)values, (Object)rows);
            Seq values2 = (Seq)tuple23._1();
            Seq rows2 = (Seq)tuple23._2();
            Seq dictValues = this.stableDistinct$1(inputSeq);
            inputSeq.foreach((Function1)new Serializable(this, builder, rows2){
                public static final long serialVersionUID = 0L;
                private final TestCompressibleColumnBuilder builder$1;
                private final Seq rows$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.builder$1.appendFrom((InternalRow)this.rows$1.apply(i), 0);
                }
                {
                    this.builder$1 = builder$1;
                    this.rows$1 = rows$1;
                }
            });
            if (dictValues.length() > DictionaryEncoding$.MODULE$.MAX_DICT_SIZE()) {
                this.withClue("Dictionary overflowed, compression should fail", (Function0)new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DictionaryEncodingSuite $outer;
                    public final TestCompressibleColumnBuilder builder$1;

                    public final Throwable apply() {
                        return (Throwable)this.$outer.intercept((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonf$$$$932a303e7ba8ef79552697d0ae2df695$$$$aryEncodingSuite$$skeleton$1$2 $outer;

                            public final ByteBuffer apply() {
                                return this.$outer.builder$1.build();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, ClassTag$.MODULE$.apply(Throwable.class), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.builder$1 = builder$1;
                    }
                });
            } else {
                ByteBuffer buffer = builder.build();
                int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
                int dictionarySize = 4 + BoxesRunTime.unboxToInt((Object)((TraversableOnce)rows2.map((Function1)new Serializable(this, columnType$1){
                    public static final long serialVersionUID = 0L;
                    private final NativeColumnType columnType$1;

                    public final int apply(GenericInternalRow x$5) {
                        return this.columnType$1.actualSize((InternalRow)x$5, 0);
                    }
                    {
                        this.columnType$1 = columnType$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                int compressedSize = 4 + dictionarySize + 2 * inputSeq.length();
                this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
                buffer.position(headerSize);
                this.assertResult(BoxesRunTime.boxToInteger((int)DictionaryEncoding$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
                Map dictionary = this.buildDictionary$1(buffer, columnType$1).toMap(Predef$.MODULE$.$conforms());
                dictValues.foreach((Function1)new Serializable(this, values2, dictionary){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DictionaryEncodingSuite $outer;
                    private final Seq values$1;
                    private final Map dictionary$1;

                    public final Assertion apply(int i) {
                        return this.$outer.assertResult(BoxesRunTime.boxToInteger((int)i), "Wrong dictionary entry", this.dictionary$1.apply(this.values$1.apply(i)), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.values$1 = values$1;
                        this.dictionary$1 = dictionary$1;
                    }
                });
                inputSeq.foreach((Function1)new Serializable(this, buffer){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DictionaryEncodingSuite $outer;
                    private final ByteBuffer buffer$2;

                    public final Assertion apply(int i) {
                        return this.$outer.assertResult(BoxesRunTime.boxToShort((short)((short)i)), "Wrong column element value", BoxesRunTime.boxToShort((short)this.buffer$2.getShort()), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.buffer$2 = buffer$2;
                    }
                });
                buffer.rewind().position(headerSize + 4);
                DictionaryEncoding.Decoder decoder = DictionaryEncoding$.MODULE$.decoder(buffer, columnType$1);
                GenericInternalRow mutableRow = new GenericInternalRow(1);
                if (inputSeq.nonEmpty()) {
                    inputSeq.foreach((Function1)new Serializable(this, columnType$1, values2, decoder, mutableRow){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DictionaryEncodingSuite $outer;
                        private final NativeColumnType columnType$1;
                        private final Seq values$1;
                        private final DictionaryEncoding.Decoder decoder$1;
                        private final GenericInternalRow mutableRow$1;

                        public final Assertion apply(int i) {
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.decoder$1.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default());
                            this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
                            Object object = this.values$1.apply(i);
                            this.decoder$1.next((InternalRow)this.mutableRow$1, 0);
                            return this.$outer.assertResult(object, "Wrong decoded value", this.columnType$1.getField((InternalRow)this.mutableRow$1, 0), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.columnType$1 = columnType$1;
                            this.values$1 = values$1;
                            this.decoder$1 = decoder$1;
                            this.mutableRow$1 = mutableRow$1;
                        }
                    });
                }
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public final void org$apache$spark$sql$execution$columnar$compression$DictionaryEncodingSuite$$skeletonForDecompress$1(int uniqueValueCount, Seq inputSeq, ColumnStats columnStats$1, NativeColumnType columnType$1, boolean testDecompress$1) {
        if (testDecompress$1) {
            TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)DictionaryEncoding$.MODULE$);
            Tuple2<Seq<Object>, Seq<GenericInternalRow>> tuple2 = ColumnarTestUtils$.MODULE$.makeUniqueValuesAndSingleValueRows(columnType$1, uniqueValueCount);
            if (tuple2 != null) {
                Tuple2 tuple22;
                Seq values = (Seq)tuple2._1();
                Seq rows = (Seq)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)values, (Object)rows);
                Seq values2 = (Seq)tuple23._1();
                Seq rows2 = (Seq)tuple23._2();
                Seq dictValues = this.stableDistinct$1(inputSeq);
                GenericInternalRow nullRow = new GenericInternalRow(1);
                nullRow.setNullAt(0);
                inputSeq.foreach((Function1)new Serializable(this, builder, rows2, nullRow){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DictionaryEncodingSuite $outer;
                    private final TestCompressibleColumnBuilder builder$2;
                    private final Seq rows$2;
                    private final GenericInternalRow nullRow$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        if (i == this.$outer.nullValue()) {
                            this.builder$2.appendFrom((InternalRow)this.nullRow$1, 0);
                        } else {
                            this.builder$2.appendFrom((InternalRow)this.rows$2.apply(i), 0);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.builder$2 = builder$2;
                        this.rows$2 = rows$2;
                        this.nullRow$1 = nullRow$1;
                    }
                });
                ByteBuffer buffer = builder.build();
                int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
                buffer.position(headerSize);
                this.assertResult(BoxesRunTime.boxToInteger((int)DictionaryEncoding$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
                DictionaryEncoding.Decoder decoder = DictionaryEncoding$.MODULE$.decoder(buffer, columnType$1);
                OnHeapColumnVector columnVector = new OnHeapColumnVector(inputSeq.length(), (DataType)columnType$1.dataType());
                decoder.decompress((WritableColumnVector)columnVector, inputSeq.length());
                if (inputSeq.nonEmpty()) {
                    ((IterableLike)inputSeq.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, columnType$1, values2, columnVector){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ DictionaryEncodingSuite $outer;
                        private final NativeColumnType columnType$1;
                        private final Seq values$2;
                        private final OnHeapColumnVector columnVector$1;

                        public final Assertion apply(Tuple2<Object, Object> x0$1) {
                            Tuple2<Object, Object> tuple2;
                            block2: {
                                block7: {
                                    Assertion assertion;
                                    block4: {
                                        Assertion assertion2;
                                        block6: {
                                            NativeColumnType nativeColumnType;
                                            int n;
                                            int n2;
                                            block5: {
                                                block3: {
                                                    tuple2 = x0$1;
                                                    if (tuple2 == null) break block2;
                                                    int i = tuple2._1$mcI$sp();
                                                    int index = tuple2._2$mcI$sp();
                                                    n2 = i;
                                                    n = index;
                                                    if (n2 != this.$outer.nullValue()) break block3;
                                                    assertion = this.$outer.assertResult(BoxesRunTime.boxToBoolean((boolean)true), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong null ", "-th position"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), BoxesRunTime.boxToBoolean((boolean)this.columnVector$1.isNullAt(n)), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
                                                    break block4;
                                                }
                                                nativeColumnType = this.columnType$1;
                                                if (!INT$.MODULE$.equals(nativeColumnType)) break block5;
                                                assertion2 = this.$outer.assertResult(this.values$2.apply(n2), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong ", "-th decoded int value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), BoxesRunTime.boxToInteger((int)this.columnVector$1.getInt(n)), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                                                break block6;
                                            }
                                            if (!LONG$.MODULE$.equals(nativeColumnType)) break block7;
                                            assertion2 = this.$outer.assertResult(this.values$2.apply(n2), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Wrong ", "-th decoded long value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})), BoxesRunTime.boxToLong((long)this.columnVector$1.getLong(n)), Prettifier$.MODULE$.default(), new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
                                        }
                                        assertion = assertion2;
                                    }
                                    Assertion assertion3 = assertion;
                                    return assertion3;
                                }
                                throw this.$outer.fail("Unsupported type", new Position("DictionaryEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.columnType$1 = columnType$1;
                            this.values$2 = values$2;
                            this.columnVector$1 = columnVector$1;
                        }
                    });
                }
                return;
            }
            throw new MatchError(tuple2);
        }
    }

    public DictionaryEncodingSuite() {
        this.nullValue = -1;
        this.testDictionaryEncoding((ColumnStats)new IntColumnStats(), (NativeColumnType)INT$.MODULE$, this.testDictionaryEncoding$default$3());
        this.testDictionaryEncoding((ColumnStats)new LongColumnStats(), (NativeColumnType)LONG$.MODULE$, this.testDictionaryEncoding$default$3());
        this.testDictionaryEncoding((ColumnStats)new StringColumnStats(), (NativeColumnType)STRING$.MODULE$, false);
    }
}

