/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.arrow;

import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.arrow.ArrowUtils$;
import org.apache.spark.sql.execution.arrow.ArrowUtilsSuite$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001)2A!\u0001\u0002\u0001\u001f\ty\u0011I\u001d:poV#\u0018\u000e\\:Tk&$XM\u0003\u0002\u0004\t\u0005)\u0011M\u001d:po*\u0011QAB\u0001\nKb,7-\u001e;j_:T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0005\n\u0005MA!!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u0016\u0001\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0005!)!\u0004\u0001C\u00017\u0005I!o\\;oIR\u0014\u0018\u000e\u001d\u000b\u00039\t\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011A!\u00168ji\")1%\u0007a\u0001I\u0005\u0011A\r\u001e\t\u0003K!j\u0011A\n\u0006\u0003O\u0019\tQ\u0001^=qKNL!!\u000b\u0014\u0003\u0011\u0011\u000bG/\u0019+za\u0016\u0004")
public class ArrowUtilsSuite
extends SparkFunSuite {
    public void roundtrip(DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(ArrowUtils$.MODULE$.fromArrowSchema(ArrowUtils$.MODULE$.toArrowSchema(structType, null)));
            StructType $org_scalatest_assert_macro_right = structType;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.roundtrip((DataType)new StructType().add("value", dt));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public ArrowUtilsSuite() {
        this.test("simple", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrowUtilsSuite $outer;

            public final Assertion apply() {
                this.$outer.roundtrip((DataType)BooleanType$.MODULE$);
                this.$outer.roundtrip((DataType)ByteType$.MODULE$);
                this.$outer.roundtrip((DataType)ShortType$.MODULE$);
                this.$outer.roundtrip((DataType)IntegerType$.MODULE$);
                this.$outer.roundtrip((DataType)LongType$.MODULE$);
                this.$outer.roundtrip((DataType)FloatType$.MODULE$);
                this.$outer.roundtrip((DataType)DoubleType$.MODULE$);
                this.$outer.roundtrip((DataType)StringType$.MODULE$);
                this.$outer.roundtrip((DataType)BinaryType$.MODULE$);
                this.$outer.roundtrip((DataType)DecimalType$.MODULE$.SYSTEM_DEFAULT());
                this.$outer.roundtrip((DataType)DateType$.MODULE$);
                UnsupportedOperationException tsExMsg = (UnsupportedOperationException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$execution$arrow$ArrowUtilsSuite$$anonfun$$$outer().roundtrip((DataType)TimestampType$.MODULE$);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
                String $org_scalatest_assert_macro_left = tsExMsg.getMessage();
                String $org_scalatest_assert_macro_right = "timeZoneId";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            }

            public /* synthetic */ ArrowUtilsSuite org$apache$spark$sql$execution$arrow$ArrowUtilsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("timestamp", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrowUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.roundtripWithTz$1(DateTimeUtils$.MODULE$.defaultTimeZone().getID());
                this.roundtripWithTz$1("Asia/Tokyo");
                this.roundtripWithTz$1("UTC");
                this.roundtripWithTz$1("America/Los_Angeles");
            }

            private final void roundtripWithTz$1(String timeZoneId) {
                StructType schema2 = new StructType().add("value", (DataType)TimestampType$.MODULE$);
                Schema arrowSchema = ArrowUtils$.MODULE$.toArrowSchema(schema2, timeZoneId);
                ArrowType.Timestamp fieldType = (ArrowType.Timestamp)arrowSchema.findField("value").getType();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(fieldType.getTimezone());
                String $org_scalatest_assert_macro_right = timeZoneId;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(ArrowUtils$.MODULE$.fromArrowSchema(arrowSchema));
                StructType $org_scalatest_assert_macro_right2 = schema2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrowUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.roundtrip((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true));
                this.$outer.roundtrip((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false));
                this.$outer.roundtrip((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), true));
                this.$outer.roundtrip((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true));
                this.$outer.roundtrip((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, true), false));
                this.$outer.roundtrip((DataType)new ArrayType((DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        this.test("struct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrowUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.roundtrip((DataType)new StructType());
                this.$outer.roundtrip((DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$));
                this.$outer.roundtrip((DataType)new StructType().add("arr", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)));
                this.$outer.roundtrip((DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$).add("arr", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)));
                this.$outer.roundtrip((DataType)new StructType().add("struct", (DataType)new StructType().add("i", (DataType)IntegerType$.MODULE$).add("arr", (DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ArrowUtilsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
    }
}

