/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.kafka010.KafkaBatch;
import org.apache.spark.sql.kafka010.KafkaContinuousStream;
import org.apache.spark.sql.kafka010.KafkaMicroBatchStream;
import org.apache.spark.sql.kafka010.KafkaSourceProvider;
import org.apache.spark.sql.kafka010.KafkaSourceProvider$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0006\r\u0001]AQ\u0001\b\u0001\u0005\u0002uAq\u0001\t\u0001C\u0002\u0013%\u0011\u0005\u0003\u0004+\u0001\u0001\u0006IA\t\u0005\u0006W\u0001!\t\u0006\f\u0005\u0006g\u0001!I\u0001\u000e\u0005\u0006\u0017\u0002!I\u0001\u0014\u0005\u0006)\u0002!I!\u0016\u0005\u0006;\u0002!IA\u0018\u0005\u0006m\u0002!Ia\u001e\u0005\u0006s\u0002!IA\u001f\u0002\u0019\u0017\u000647.Y*pkJ\u001cW\r\u0015:pm&$WM]*vSR,'BA\u0007\u000f\u0003!Y\u0017MZ6baE\u0002$BA\b\u0011\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003#I\tQa\u001d9be.T!a\u0005\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0012aA8sO\u000e\u00011C\u0001\u0001\u0019!\tI\"$D\u0001\u0011\u0013\tY\u0002CA\u0007Ta\u0006\u00148NR;o'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0001\"a\b\u0001\u000e\u00031\t\u0001\"\u001a=qK\u000e$X\rZ\u000b\u0002EA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0005Y\u0006twMC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\"#AB*ue&tw-A\u0005fqB,7\r^3eA\u0005I\u0011M\u001a;fe\u0016\u000b7\r\u001b\u000b\u0002[A\u0011a&M\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t!QK\\5u\u0003M1XM]5gs\u001aKW\r\u001c3t\u0013:\u0014\u0015\r^2i)\u0011iS'Q\"\t\u000bY*\u0001\u0019A\u001c\u0002\u0007-,\u0017\u0010\u0005\u00029\u007f9\u0011\u0011(\u0010\t\u0003u=j\u0011a\u000f\u0006\u0003yY\ta\u0001\u0010:p_Rt\u0014B\u0001 0\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011\u0006\u0011\u0006\u0003}=BQAQ\u0003A\u0002]\nQA^1mk\u0016DQ\u0001R\u0003A\u0002\u0015\u000b\u0001B^1mS\u0012\fG/\u001a\t\u0005]\u0019CU&\u0003\u0002H_\tIa)\u001e8di&|g.\r\t\u0003?%K!A\u0013\u0007\u0003\u0015-\u000bgm[1CCR\u001c\u0007.\u0001\u0010wKJLg-\u001f$jK2$7/\u00138NS\u000e\u0014xNQ1uG\"\u001cFO]3b[R!Q&\u0014(P\u0011\u00151d\u00011\u00018\u0011\u0015\u0011e\u00011\u00018\u0011\u0015!e\u00011\u0001Q!\u0011qc)U\u0017\u0011\u0005}\u0011\u0016BA*\r\u0005UY\u0015MZ6b\u001b&\u001c'o\u001c\"bi\u000eD7\u000b\u001e:fC6\faD^3sS\u001aLh)[3mINLenQ8oi&tWo\\;t'R\u0014X-Y7\u0015\t52v\u000b\u0017\u0005\u0006m\u001d\u0001\ra\u000e\u0005\u0006\u0005\u001e\u0001\ra\u000e\u0005\u0006\t\u001e\u0001\r!\u0017\t\u0005]\u0019SV\u0006\u0005\u0002 7&\u0011A\f\u0004\u0002\u0016\u0017\u000647.Y\"p]RLg.^8vgN#(/Z1n\u0003A\u0012W/\u001b7e\u0007\u0006\u001cX-\u00138tK:\u001c\u0018\u000e^5wKN#(/\u001b8h\u001b\u0006\u0004hi\u001c:VaB,'/\u00118e\u0019><XM]&fsR\u0011qL\u001c\t\u0004A\u0016DgBA1d\u001d\tQ$-C\u00011\u0013\t!w&A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0019<'aA*fc*\u0011Am\f\t\u0003S2l\u0011A\u001b\u0006\u0003W:\tA!\u001e;jY&\u0011QN\u001b\u0002\u0019\u0007\u0006\u001cX-\u00138tK:\u001c\u0018\u000e^5wKN#(/\u001b8h\u001b\u0006\u0004\b\"B8\t\u0001\u0004\u0001\u0018aB8qi&|gn\u001d\t\u0004]E\u001c\u0018B\u0001:0\u0005)a$/\u001a9fCR,GM\u0010\t\u0005]Q<t'\u0003\u0002v_\t1A+\u001e9mKJ\n\u0001FY;jY\u0012\\\u0015MZ6b'>,(oY3DCN,\u0017J\\:f]NLG/\u001b<f'R\u0014\u0018N\\4NCB$\"\u0001\u001b=\t\u000b=L\u0001\u0019\u00019\u0002-\u001d,GoS1gW\u0006$\u0015\r^1T_V\u00148-Z*dC:$2a_A\u0004!\ra\u00181A\u0007\u0002{*\u0011ap`\u0001\u0005e\u0016\fGMC\u0002\u0002\u00029\t\u0011bY8o]\u0016\u001cGo\u001c:\n\u0007\u0005\u0015QP\u0001\u0003TG\u0006t\u0007\"B8\u000b\u0001\u0004A\u0007")
public class KafkaSourceProviderSuite
extends SparkFunSuite {
    private final String expected;

    private String expected() {
        return this.expected;
    }

    public void afterEach() {
        SparkEnv$.MODULE$.set(null);
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    private void verifyFieldsInBatch(String key, String value, Function1<KafkaBatch, BoxedUnit> validate) {
        this.buildCaseInsensitiveStringMapForUpperAndLowerKey((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)})).foreach((Function1 & Serializable & scala.Serializable)options -> {
            KafkaSourceProviderSuite.$anonfun$verifyFieldsInBatch$1(this, validate, options);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyFieldsInMicroBatchStream(String key, String value, Function1<KafkaMicroBatchStream, BoxedUnit> validate) {
        SparkEnv sparkEnv = (SparkEnv)Mockito.mock(SparkEnv.class);
        Mockito.when((Object)sparkEnv.conf()).thenReturn((Object)new SparkConf());
        SparkEnv$.MODULE$.set(sparkEnv);
        this.buildCaseInsensitiveStringMapForUpperAndLowerKey((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)})).foreach((Function1 & Serializable & scala.Serializable)options -> {
            KafkaSourceProviderSuite.$anonfun$verifyFieldsInMicroBatchStream$1(this, validate, options);
            return BoxedUnit.UNIT;
        });
    }

    private void verifyFieldsInContinuousStream(String key, String value, Function1<KafkaContinuousStream, BoxedUnit> validate) {
        this.buildCaseInsensitiveStringMapForUpperAndLowerKey((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value)})).foreach((Function1 & Serializable & scala.Serializable)options -> {
            KafkaSourceProviderSuite.$anonfun$verifyFieldsInContinuousStream$1(this, validate, options);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<CaseInsensitiveStringMap> buildCaseInsensitiveStringMapForUpperAndLowerKey(Seq<Tuple2<String, String>> options2) {
        return (Seq)((TraversableLike)new .colon.colon((Object)((Seq)options2.map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)((String)entry._1()).toUpperCase(Locale.ROOT), entry._2()), Seq$.MODULE$.canBuildFrom())), (List)new .colon.colon((Object)((Seq)options2.map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2((Object)((String)entry._1()).toLowerCase(Locale.ROOT), entry._2()), Seq$.MODULE$.canBuildFrom())), (List)Nil$.MODULE$))).map((Function1 & Serializable & scala.Serializable)options -> this.buildKafkaSourceCaseInsensitiveStringMap((Seq<Tuple2<String, String>>)options), Seq$.MODULE$.canBuildFrom());
    }

    private CaseInsensitiveStringMap buildKafkaSourceCaseInsensitiveStringMap(Seq<Tuple2<String, String>> options) {
        scala.collection.immutable.Map requiredOptions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kafka.bootstrap.servers"), (Object)"dummy"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"subscribe"), (Object)"dummy")}));
        return new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options.toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)requiredOptions)).asJava());
    }

    private Scan getKafkaDataSourceScan(CaseInsensitiveStringMap options) {
        KafkaSourceProvider provider = new KafkaSourceProvider();
        return provider.getTable(options).newScanBuilder(options).build();
    }

    public static final /* synthetic */ void $anonfun$new$2(KafkaSourceProviderSuite $this, KafkaBatch batch) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString($this.expected())).toLong()));
        long $org_scalatest_assert_macro_right = batch.pollTimeoutMs();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaSourceProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
    }

    public static final /* synthetic */ void $anonfun$new$4(KafkaSourceProviderSuite $this, KafkaMicroBatchStream stream) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString($this.expected())).toLong()));
        long $org_scalatest_assert_macro_right = stream.pollTimeoutMs();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaSourceProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
    }

    public static final /* synthetic */ void $anonfun$new$5(KafkaSourceProviderSuite $this, KafkaMicroBatchStream stream) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(new Some((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString($this.expected())).toLong())));
        Option $org_scalatest_assert_macro_right = stream.maxOffsetsPerTrigger();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaSourceProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
    }

    public static final /* synthetic */ void $anonfun$new$6(KafkaSourceProviderSuite $this, KafkaMicroBatchStream stream) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(new Some((Object)BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString($this.expected())).toLong())));
        Option $org_scalatest_assert_macro_right = stream.minOffsetPerTrigger();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaSourceProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
    }

    public static final /* synthetic */ void $anonfun$new$7(KafkaSourceProviderSuite $this, KafkaMicroBatchStream stream) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString($this.expected())).toLong()));
        long $org_scalatest_assert_macro_right = stream.maxTriggerDelayMs();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaSourceProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
    }

    public static final /* synthetic */ void $anonfun$new$8(KafkaSourceProviderSuite $this, KafkaMicroBatchStream stream) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString($this.expected())).toInt()));
        int $org_scalatest_assert_macro_right = stream.kafkaOffsetReader().maxOffsetFetchAttempts();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaSourceProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
    }

    public static final /* synthetic */ void $anonfun$new$9(KafkaSourceProviderSuite $this, KafkaMicroBatchStream stream) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString($this.expected())).toLong()));
        long $org_scalatest_assert_macro_right = stream.kafkaOffsetReader().offsetFetchAttemptIntervalMs();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaSourceProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
    }

    public static final /* synthetic */ void $anonfun$new$11(KafkaSourceProviderSuite $this, KafkaContinuousStream stream) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString($this.expected())).toLong()));
        long $org_scalatest_assert_macro_right = stream.pollTimeoutMs();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaSourceProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
    }

    public static final /* synthetic */ void $anonfun$new$12(KafkaSourceProviderSuite $this, KafkaContinuousStream stream) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString($this.expected())).toInt()));
        int $org_scalatest_assert_macro_right = stream.offsetReader().maxOffsetFetchAttempts();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaSourceProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
    }

    public static final /* synthetic */ void $anonfun$new$13(KafkaSourceProviderSuite $this, KafkaContinuousStream stream) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString($this.expected())).toLong()));
        long $org_scalatest_assert_macro_right = stream.offsetReader().offsetFetchAttemptIntervalMs();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("KafkaSourceProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
    }

    public static final /* synthetic */ void $anonfun$verifyFieldsInBatch$1(KafkaSourceProviderSuite $this, Function1 validate$1, CaseInsensitiveStringMap options) {
        Scan scan = $this.getKafkaDataSourceScan(options);
        KafkaBatch batch = (KafkaBatch)scan.toBatch();
        validate$1.apply((Object)batch);
    }

    public static final /* synthetic */ void $anonfun$verifyFieldsInMicroBatchStream$1(KafkaSourceProviderSuite $this, Function1 validate$2, CaseInsensitiveStringMap options) {
        Scan scan = $this.getKafkaDataSourceScan(options);
        KafkaMicroBatchStream stream = (KafkaMicroBatchStream)scan.toMicroBatchStream("dummy");
        validate$2.apply((Object)stream);
    }

    public static final /* synthetic */ void $anonfun$verifyFieldsInContinuousStream$1(KafkaSourceProviderSuite $this, Function1 validate$3, CaseInsensitiveStringMap options) {
        Scan scan = $this.getKafkaDataSourceScan(options);
        KafkaContinuousStream stream = (KafkaContinuousStream)scan.toContinuousStream("dummy");
        validate$3.apply((Object)stream);
    }

    public KafkaSourceProviderSuite() {
        this.expected = "1111";
        this.test("batch mode - options should be handled as case-insensitive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.verifyFieldsInBatch(KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), this.expected(), (Function1<KafkaBatch, BoxedUnit>)(Function1 & Serializable & scala.Serializable)batch -> {
            KafkaSourceProviderSuite.$anonfun$new$2(this, batch);
            return BoxedUnit.UNIT;
        }), new Position("KafkaSourceProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("micro-batch mode - options should be handled as case-insensitive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.verifyFieldsInMicroBatchStream(KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), this.expected(), (Function1<KafkaMicroBatchStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)stream -> {
                KafkaSourceProviderSuite.$anonfun$new$4(this, stream);
                return BoxedUnit.UNIT;
            });
            this.verifyFieldsInMicroBatchStream(KafkaSourceProvider$.MODULE$.MAX_OFFSET_PER_TRIGGER(), this.expected(), (Function1<KafkaMicroBatchStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)stream -> {
                KafkaSourceProviderSuite.$anonfun$new$5(this, stream);
                return BoxedUnit.UNIT;
            });
            this.verifyFieldsInMicroBatchStream(KafkaSourceProvider$.MODULE$.MIN_OFFSET_PER_TRIGGER(), this.expected(), (Function1<KafkaMicroBatchStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)stream -> {
                KafkaSourceProviderSuite.$anonfun$new$6(this, stream);
                return BoxedUnit.UNIT;
            });
            this.verifyFieldsInMicroBatchStream(KafkaSourceProvider$.MODULE$.MAX_TRIGGER_DELAY(), this.expected(), (Function1<KafkaMicroBatchStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)stream -> {
                KafkaSourceProviderSuite.$anonfun$new$7(this, stream);
                return BoxedUnit.UNIT;
            });
            this.verifyFieldsInMicroBatchStream(KafkaSourceProvider$.MODULE$.FETCH_OFFSET_NUM_RETRY(), this.expected(), (Function1<KafkaMicroBatchStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)stream -> {
                KafkaSourceProviderSuite.$anonfun$new$8(this, stream);
                return BoxedUnit.UNIT;
            });
            this.verifyFieldsInMicroBatchStream(KafkaSourceProvider$.MODULE$.FETCH_OFFSET_RETRY_INTERVAL_MS(), this.expected(), (Function1<KafkaMicroBatchStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)stream -> {
                KafkaSourceProviderSuite.$anonfun$new$9(this, stream);
                return BoxedUnit.UNIT;
            });
        }, new Position("KafkaSourceProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("continuous mode - options should be handled as case-insensitive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.verifyFieldsInContinuousStream(KafkaSourceProvider$.MODULE$.CONSUMER_POLL_TIMEOUT(), this.expected(), (Function1<KafkaContinuousStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)stream -> {
                KafkaSourceProviderSuite.$anonfun$new$11(this, stream);
                return BoxedUnit.UNIT;
            });
            this.verifyFieldsInContinuousStream(KafkaSourceProvider$.MODULE$.FETCH_OFFSET_NUM_RETRY(), this.expected(), (Function1<KafkaContinuousStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)stream -> {
                KafkaSourceProviderSuite.$anonfun$new$12(this, stream);
                return BoxedUnit.UNIT;
            });
            this.verifyFieldsInContinuousStream(KafkaSourceProvider$.MODULE$.FETCH_OFFSET_RETRY_INTERVAL_MS(), this.expected(), (Function1<KafkaContinuousStream, BoxedUnit>)(Function1 & Serializable & scala.Serializable)stream -> {
                KafkaSourceProviderSuite.$anonfun$new$13(this, stream);
                return BoxedUnit.UNIT;
            });
        }, new Position("KafkaSourceProviderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
    }
}

