/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.kafka010.consumer;

import java.io.Closeable;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.kafka010.KafkaConfigUpdater;
import org.apache.spark.kafka010.KafkaTokenClusterConf;
import org.apache.spark.kafka010.KafkaTokenUtil$;
import org.apache.spark.sql.kafka010.consumer.KafkaDataConsumer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd!\u0002\u000b\u0016\u0001]\t\u0003\u0002\u0003\u001c\u0001\u0005\u000b\u0007I\u0011\u0001\u001d\t\u0011\u0005\u0003!\u0011!Q\u0001\neB\u0001B\u0011\u0001\u0003\u0006\u0004%\ta\u0011\u0005\t/\u0002\u0011\t\u0011)A\u0005\t\")\u0001\f\u0001C\u00013\"9a\f\u0001b\u0001\n\u0003y\u0006B\u00021\u0001A\u0003%!\n\u0003\u0005b\u0001\t\u0007I\u0011A\u000bc\u0011\u0019a\u0007\u0001)A\u0005G\"QQ\u000e\u0001a\u0001\u0002\u0004%\t!F\"\t\u00159\u0004\u0001\u0019!a\u0001\n\u0003)r\u000eC\u0005v\u0001\u0001\u0007\t\u0011)Q\u0005\t\"9a\u0003\u0001b\u0001\n\u00131\bbBA\u0005\u0001\u0001\u0006Ia\u001e\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0011\u001d\t)\u0006\u0001C\u0001\u0003/Bq!!\u0017\u0001\t\u0003\nY\u0006C\u0004\u0002^\u0001!I!a\u0018\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d\t)\u0012J\u001c;fe:\fGnS1gW\u0006\u001cuN\\:v[\u0016\u0014(B\u0001\f\u0018\u0003!\u0019wN\\:v[\u0016\u0014(B\u0001\r\u001a\u0003!Y\u0017MZ6baE\u0002$B\u0001\u000e\u001c\u0003\r\u0019\u0018\u000f\u001c\u0006\u00039u\tQa\u001d9be.T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sON!\u0001A\t\u00161!\t\u0019\u0003&D\u0001%\u0015\t)c%\u0001\u0003mC:<'\"A\u0014\u0002\t)\fg/Y\u0005\u0003S\u0011\u0012aa\u00142kK\u000e$\bCA\u0016/\u001b\u0005a#BA\u0017'\u0003\tIw.\u0003\u00020Y\tI1\t\\8tK\u0006\u0014G.\u001a\t\u0003cQj\u0011A\r\u0006\u0003gm\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003kI\u0012q\u0001T8hO&tw-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0004\u0001U\t\u0011\b\u0005\u0002;\u007f5\t1H\u0003\u0002={\u000511m\\7n_:T!AP\u000f\u0002\u000b-\fgm[1\n\u0005\u0001[$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005Y1.\u00194lCB\u000b'/Y7t+\u0005!\u0005\u0003B#I\u0015\nj\u0011A\u0012\u0006\u0003\u000f\u001a\nA!\u001e;jY&\u0011\u0011J\u0012\u0002\u0004\u001b\u0006\u0004\bCA&U\u001d\ta%\u000b\u0005\u0002N!6\taJ\u0003\u0002Po\u00051AH]8pizR\u0011!U\u0001\u0006g\u000e\fG.Y\u0005\u0003'B\u000ba\u0001\u0015:fI\u00164\u0017BA+W\u0005\u0019\u0019FO]5oO*\u00111\u000bU\u0001\rW\u000647.\u0019)be\u0006l7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007icV\f\u0005\u0002\\\u00015\tQ\u0003C\u00037\u000b\u0001\u0007\u0011\bC\u0003C\u000b\u0001\u0007A)A\u0004he>,\b/\u00133\u0016\u0003)\u000b\u0001b\u001a:pkBLE\rI\u0001\u000eG2,8\u000f^3s\u0007>tg-[4\u0016\u0003\r\u00042\u0001Z3h\u001b\u0005\u0001\u0016B\u00014Q\u0005\u0019y\u0005\u000f^5p]B\u0011\u0001N[\u0007\u0002S*\u0011\u0001dG\u0005\u0003W&\u0014QcS1gW\u0006$vn[3o\u00072,8\u000f^3s\u0007>tg-\u0001\bdYV\u001cH/\u001a:D_:4\u0017n\u001a\u0011\u0002/-\fgm[1QCJ\fWn],ji\"\u001cVmY;sSRL\u0018aG6bM.\f\u0007+\u0019:b[N<\u0016\u000e\u001e5TK\u000e,(/\u001b;z?\u0012*\u0017\u000f\u0006\u0002qgB\u0011A-]\u0005\u0003eB\u0013A!\u00168ji\"9AoCA\u0001\u0002\u0004!\u0015a\u0001=%c\u0005A2.\u00194lCB\u000b'/Y7t/&$\bnU3dkJLG/\u001f\u0011\u0016\u0003]\u0004B\u0001\u001f?\u007f}6\t\u0011P\u0003\u0002\u0017u*\u001110P\u0001\bG2LWM\u001c;t\u0013\ti\u0018PA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u0005I~\f\u0019!C\u0002\u0002\u0002A\u0013Q!\u0011:sCf\u00042\u0001ZA\u0003\u0013\r\t9\u0001\u0015\u0002\u0005\u0005f$X-A\u0005d_:\u001cX/\\3sA\u0005)a-\u001a;dQR1\u0011qBA'\u0003#\u0002\u0012\u0002ZA\t\u0003+\t\t#a\n\n\u0007\u0005M\u0001K\u0001\u0004UkBdWm\r\t\u0006\u000b\u0006]\u00111D\u0005\u0004\u000331%\u0001\u0002'jgR\u0004R\u0001_A\u000f}zL1!a\bz\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u00042\u0001ZA\u0012\u0013\r\t)\u0003\u0015\u0002\u0005\u0019>tw\r\u0005\u0003\u0002*\u0005\u001dc\u0002BA\u0016\u0003\u0007rA!!\f\u0002B9!\u0011qFA \u001d\u0011\t\t$!\u0010\u000f\t\u0005M\u00121\b\b\u0005\u0003k\tIDD\u0002N\u0003oI\u0011\u0001I\u0005\u0003=}I!\u0001H\u000f\n\u0005iY\u0012B\u0001\r\u001a\u0013\t1r#C\u0002\u0002FU\t\u0011cS1gW\u0006$\u0015\r^1D_:\u001cX/\\3s\u0013\u0011\tI%a\u0013\u0003)\u00053\u0018-\u001b7bE2,wJ\u001a4tKR\u0014\u0016M\\4f\u0015\r\t)%\u0006\u0005\b\u0003\u001fz\u0001\u0019AA\u0011\u0003\u0019ygMZ:fi\"9\u00111K\bA\u0002\u0005\u0005\u0012!\u00049pY2$\u0016.\\3pkRl5/A\fhKR\fe/Y5mC\ndWm\u00144gg\u0016$(+\u00198hKR\u0011\u0011qE\u0001\u0006G2|7/\u001a\u000b\u0002a\u0006q1M]3bi\u0016\u001cuN\\:v[\u0016\u0014H#A<\u0002\tM,Wm\u001b\u000b\u0004a\u0006\u0015\u0004bBA('\u0001\u0007\u0011\u0011\u0005")
public class InternalKafkaConsumer
implements Closeable,
Logging {
    private final TopicPartition topicPartition;
    private final java.util.Map<String, Object> kafkaParams;
    private final String groupId;
    private final Option<KafkaTokenClusterConf> clusterConfig;
    private java.util.Map<String, Object> kafkaParamsWithSecurity;
    private final KafkaConsumer<byte[], byte[]> consumer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public java.util.Map<String, Object> kafkaParams() {
        return this.kafkaParams;
    }

    public String groupId() {
        return this.groupId;
    }

    public Option<KafkaTokenClusterConf> clusterConfig() {
        return this.clusterConfig;
    }

    public java.util.Map<String, Object> kafkaParamsWithSecurity() {
        return this.kafkaParamsWithSecurity;
    }

    public void kafkaParamsWithSecurity_$eq(java.util.Map<String, Object> x$1) {
        this.kafkaParamsWithSecurity = x$1;
    }

    private KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public Tuple3<List<ConsumerRecord<byte[], byte[]>>, Object, KafkaDataConsumer.AvailableOffsetRange> fetch(long offset, long pollTimeoutMs) {
        this.seek(offset);
        ConsumerRecords p = this.consumer().poll(Duration.ofMillis(pollTimeoutMs));
        List r = p.records(this.topicPartition());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(10).append("Polled ").append(this.groupId()).append(" ").append(p.partitions()).append("  ").append(r.size()).toString());
        long offsetAfterPoll = this.consumer().position(this.topicPartition());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Offset changed from ").append(offset).append(" to ").append(offsetAfterPoll).append(" after polling").toString());
        KafkaDataConsumer.AvailableOffsetRange range = this.getAvailableOffsetRange();
        Tuple3 fetchedData = new Tuple3((Object)r, (Object)BoxesRunTime.boxToLong((long)offsetAfterPoll), (Object)range);
        if (r.isEmpty()) {
            if (offset < range.earliest() || offset >= range.latest()) {
                throw new OffsetOutOfRangeException((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)offset)}))).asJava());
            }
            if (offset == offsetAfterPoll) {
                throw new TimeoutException(new StringBuilder(48).append("Cannot fetch record for offset ").append(offset).append(" in ").append(pollTimeoutMs).append(" milliseconds").toString());
            }
        }
        return fetchedData;
    }

    public KafkaDataConsumer.AvailableOffsetRange getAvailableOffsetRange() {
        this.consumer().seekToBeginning((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()}))).asJava());
        long earliestOffset = this.consumer().position(this.topicPartition());
        this.consumer().seekToEnd((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.topicPartition()}))).asJava());
        long latestOffset = this.consumer().position(this.topicPartition());
        return new KafkaDataConsumer.AvailableOffsetRange(earliestOffset, latestOffset);
    }

    @Override
    public void close() {
        this.consumer().close();
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<byte[], byte[]> createConsumer() {
        void var1_1;
        this.kafkaParamsWithSecurity_$eq(new KafkaConfigUpdater("executor", ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.kafkaParams()).asScala()).toMap(Predef$.MODULE$.$conforms())).setAuthenticationConfigIfNeeded(this.clusterConfig()).build());
        KafkaConsumer c = new KafkaConsumer(this.kafkaParamsWithSecurity());
        ArrayList<TopicPartition> tps = new ArrayList<TopicPartition>();
        tps.add(this.topicPartition());
        c.assign(tps);
        return var1_1;
    }

    private void seek(long offset) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Seeking to ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).toString());
        this.consumer().seek(this.topicPartition(), offset);
    }

    public InternalKafkaConsumer(TopicPartition topicPartition, java.util.Map<String, Object> kafkaParams) {
        this.topicPartition = topicPartition;
        this.kafkaParams = kafkaParams;
        Logging.$init$((Logging)this);
        this.groupId = (String)kafkaParams.get("group.id");
        this.clusterConfig = KafkaTokenUtil$.MODULE$.findMatchingTokenClusterConfig(SparkEnv$.MODULE$.get().conf(), (String)kafkaParams.get("bootstrap.servers"));
        this.consumer = this.createConsumer();
    }
}

