/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import java.io.BufferedReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.Logging$;
import org.apache.spark.repl.Main$;
import org.apache.spark.repl.SparkILoop;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m3Aa\u0003\u0007\u0001+!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001a\u0001\n\u0013)\u0003b\u0002\u0018\u0001\u0001\u0004%Ia\f\u0005\u0007q\u0001\u0001\u000b\u0015\u0002\u0014\t\u000be\u0002A\u0011\t\u001e\t\u000bm\u0002A\u0011\t\u001e\t\u000bq\u0002A\u0011A\u001f\t\u000b5\u0003A\u0011\u0001(\t\u000bE\u0003A\u0011\u0001*\t\u000b]\u0003A\u0011\u0001-\u0003\u0013I+\u0007\u000f\\*vSR,'BA\u0007\u000f\u0003\u0011\u0011X\r\u001d7\u000b\u0005=\u0001\u0012!B:qCJ\\'BA\t\u0013\u0003\u0019\t\u0007/Y2iK*\t1#A\u0002pe\u001e\u001c\u0001aE\u0002\u0001-i\u0001\"a\u0006\r\u000e\u00039I!!\u0007\b\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\tYb$D\u0001\u001d\u0015\ti\"#A\u0005tG\u0006d\u0017\r^3ti&\u0011q\u0004\b\u0002\u0012\u0005\u00164wN]3B]\u0012\fe\r^3s\u00032d\u0017A\u0002\u001fj]&$h\bF\u0001#!\t\u0019\u0003!D\u0001\r\u0003My'/[4j]\u0006d7\t\\1tg2{\u0017\rZ3s+\u00051\u0003CA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0011a\u0017M\\4\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\f\u00072\f7o\u001d'pC\u0012,'/A\fpe&<\u0017N\\1m\u00072\f7o\u001d'pC\u0012,'o\u0018\u0013fcR\u0011\u0001G\u000e\t\u0003cQj\u0011A\r\u0006\u0002g\u0005)1oY1mC&\u0011QG\r\u0002\u0005+:LG\u000fC\u00048\u0007\u0005\u0005\t\u0019\u0001\u0014\u0002\u0007a$\u0013'\u0001\u000bpe&<\u0017N\\1m\u00072\f7o\u001d'pC\u0012,'\u000fI\u0001\nE\u00164wN]3BY2$\u0012\u0001M\u0001\tC\u001a$XM]!mY\u0006q!/\u001e8J]R,'\u000f\u001d:fi\u0016\u0014Hc\u0001 J\u0017B\u0011qH\u0012\b\u0003\u0001\u0012\u0003\"!\u0011\u001a\u000e\u0003\tS!a\u0011\u000b\u0002\rq\u0012xn\u001c;?\u0013\t)%'\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000f\"\u0013aa\u0015;sS:<'BA#3\u0011\u0015Qu\u00011\u0001?\u0003\u0019i\u0017m\u001d;fe\")Aj\u0002a\u0001}\u0005)\u0011N\u001c9vi\u0006I\"/\u001e8J]R,'\u000f\u001d:fi\u0016\u0014\u0018J\u001c)bgR,Wj\u001c3f)\rqt\n\u0015\u0005\u0006\u0015\"\u0001\rA\u0010\u0005\u0006\u0019\"\u0001\rAP\u0001\u000fCN\u001cXM\u001d;D_:$\u0018-\u001b8t)\r\u00014+\u0016\u0005\u0006)&\u0001\rAP\u0001\b[\u0016\u001c8/Y4f\u0011\u00151\u0016\u00021\u0001?\u0003\u0019yW\u000f\u001e9vi\u0006!\u0012m]:feR$u.Z:O_R\u001cuN\u001c;bS:$2\u0001M-[\u0011\u0015!&\u00021\u0001?\u0011\u00151&\u00021\u0001?\u0001")
public class ReplSuite
extends SparkFunSuite {
    private ClassLoader originalClassLoader = null;

    private ClassLoader originalClassLoader() {
        return this.originalClassLoader;
    }

    private void originalClassLoader_$eq(ClassLoader x$1) {
        this.originalClassLoader = x$1;
    }

    public void beforeAll() {
        this.originalClassLoader_$eq(Thread.currentThread().getContextClassLoader());
    }

    public void afterAll() {
        block0: {
            if (this.originalClassLoader() == null) break block0;
            Thread.currentThread().setContextClassLoader(this.originalClassLoader());
        }
    }

    public String runInterpreter(String master, String input) {
        String CONF_EXECUTOR_CLASSPATH = "spark.executor.extraClassPath";
        String oldExecutorClasspath = System.getProperty(CONF_EXECUTOR_CLASSPATH);
        String classpath = System.getProperty("java.class.path");
        System.setProperty(CONF_EXECUTOR_CLASSPATH, classpath);
        Main$.MODULE$.sparkContext_$eq(null);
        Main$.MODULE$.sparkSession_$eq(null);
        Main$.MODULE$.conf().set("spark.master", master);
        BufferedReader in = new BufferedReader(new StringReader(new StringBuilder(1).append(input).append("\n").toString()));
        StringWriter out = new StringWriter();
        Main$.MODULE$.doMain((String[])((Object[])new String[]{"-classpath", classpath}), new SparkILoop(in, new PrintWriter(out)));
        String string = oldExecutorClasspath != null ? System.setProperty(CONF_EXECUTOR_CLASSPATH, oldExecutorClasspath) : System.clearProperty(CONF_EXECUTOR_CLASSPATH);
        return out.toString();
    }

    public String runInterpreterInPasteMode(String master, String input) {
        return this.runInterpreter(master, new StringBuilder(7).append(":paste\n").append(input).append((char)4).toString());
    }

    public void assertContains(String message, String output) {
        boolean isContain = output.contains(message);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(isContain, "isContain", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(39).append("Interpreter output did not contain '").append(message).append("':\n").append(output).toString(), Prettifier$.MODULE$.default(), new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
    }

    public void assertDoesNotContain(String message, String output) {
        boolean isContain = output.contains(message);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(isContain, "isContain", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(33).append("Interpreter output contained '").append(message).append("':\n").append(output).toString(), Prettifier$.MODULE$.default(), new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
    }

    public ReplSuite() {
        this.test("SPARK-15236: use Hive catalog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Logger rootLogger = (Logger)LogManager.getRootLogger();
            Level logLevel = rootLogger.getLevel();
            rootLogger.setLevel(Level.INFO);
            try {
                Main$.MODULE$.conf().set(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION().key(), "hive");
                String output = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n      |spark.sql(\"drop table if exists t_15236\")\n    ")).stripMargin());
                this.assertDoesNotContain("error:", output);
                this.assertDoesNotContain("Exception", output);
                if (SparkSession$.MODULE$.hiveClassesArePresent()) {
                    this.assertContains("HiveMetaStore", output);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.assertDoesNotContain("HiveMetaStore", output);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                rootLogger.setLevel(logLevel);
            }
            return boxedUnit;
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88));
        this.test("SPARK-15236: use in-memory catalog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Logger rootLogger = (Logger)LogManager.getRootLogger();
            Level logLevel = rootLogger.getLevel();
            rootLogger.setLevel(Level.INFO);
            try {
                Main$.MODULE$.conf().set(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION().key(), "in-memory");
                String output = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n          |spark.sql(\"drop table if exists t_16236\")\n        ")).stripMargin());
                this.assertDoesNotContain("error:", output);
                this.assertDoesNotContain("Exception", output);
                this.assertDoesNotContain("HiveMetaStore", output);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                rootLogger.setLevel(logLevel);
            }
            return boxedUnit;
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("broadcast vars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n        |var array = new Array[Int](5)\n        |val broadcastArray = sc.broadcast(array)\n        |sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n        |array(0) = 5\n        |sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n      ")).stripMargin());
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
            this.assertContains("res0: Array[Int] = Array(0, 0, 0, 0, 0)", output);
            this.assertContains("res2: Array[Int] = Array(5, 0, 0, 0, 0)", output);
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
        if (System.getenv("MESOS_NATIVE_JAVA_LIBRARY") != null) {
            this.test("running on Mesos", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String output = this.runInterpreter("localquiet", new StringOps(Predef$.MODULE$.augmentString("\n          |var v = 7\n          |def getV() = v\n          |sc.parallelize(1 to 10).map(x => getV()).collect().reduceLeft(_+_)\n          |v = 10\n          |sc.parallelize(1 to 10).map(x => getV()).collect().reduceLeft(_+_)\n          |var array = new Array[Int](5)\n          |val broadcastArray = sc.broadcast(array)\n          |sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n          |array(0) = 5\n          |sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n        ")).stripMargin());
                this.assertDoesNotContain("error:", output);
                this.assertDoesNotContain("Exception", output);
                this.assertContains("res0: Int = 70", output);
                this.assertContains("res1: Int = 100", output);
                this.assertContains("res2: Array[Int] = Array(0, 0, 0, 0, 0)", output);
                this.assertContains("res4: Array[Int] = Array(0, 0, 0, 0, 0)", output);
            }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        }
        this.test("line wrapper only initialized once when used as encoder outer scope", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n        |val fileName = \"repl-test-\" + System.currentTimeMillis\n        |val tmpDir = System.getProperty(\"java.io.tmpdir\")\n        |val file = new java.io.File(tmpDir, fileName)\n        |def createFile(): Unit = file.createNewFile()\n        |\n        |createFile();case class TestCaseClass(value: Int)\n        |sc.parallelize(1 to 10).map(x => TestCaseClass(x)).collect()\n        |\n        |file.delete()\n      ")).stripMargin());
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
        this.test("define case class and create Dataset together with paste mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output = this.runInterpreterInPasteMode("local-cluster[1,1,1024]", new StringOps(Predef$.MODULE$.augmentString("\n        |import spark.implicits._\n        |case class TestClass(value: Int)\n        |Seq(TestClass(1)).toDS()\n      ")).stripMargin());
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
        this.test(":replay should work correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n     |sc\n     |:replay\n     ")).stripMargin());
            this.assertDoesNotContain("error: not found: value sc", output);
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.test("spark-shell should find imported types in class constructors and extends clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n        |import org.apache.spark.Partition\n        |class P(p: Partition)\n        |class P(val index: Int) extends Partition\n      ")).stripMargin());
            this.assertDoesNotContain("error: not found: type Partition", output);
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        this.test("spark-shell should shadow val/def definitions correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output1 = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n        |def myMethod() = \"first definition\"\n        |val tmp = myMethod(); val out = tmp\n        |def myMethod() = \"second definition\"\n        |val tmp = myMethod(); val out = s\"$tmp aabbcc\"\n      ")).stripMargin());
            this.assertContains("second definition aabbcc", output1);
            String output2 = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n        |val a = 1\n        |val b = a; val c = b;\n        |val a = 2\n        |val b = a; val c = b;\n        |s\"!!$b!!\"\n      ")).stripMargin());
            this.assertContains("!!2!!", output2);
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
        this.test("SPARK-26633: ExecutorClassLoader.getResourceAsStream find REPL classes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output = this.runInterpreterInPasteMode("local-cluster[1,1,1024]", new StringOps(Predef$.MODULE$.augmentString("\n        |case class TestClass(value: Int)\n        |\n        |sc.parallelize(1 to 1).map { _ =>\n        |  val clz = classOf[TestClass]\n        |  val name = clz.getName.replace('.', '/') + \".class\";\n        |  val stream = clz.getClassLoader.getResourceAsStream(name)\n        |  if (stream == null) {\n        |    \"failed: stream is null\"\n        |  } else {\n        |    val magic = new Array[Byte](4)\n        |    try {\n        |      stream.read(magic)\n        |      // the magic number of a Java Class file\n        |      val expected = Array[Byte](0xCA.toByte, 0xFE.toByte, 0xBA.toByte, 0xBE.toByte)\n        |      if (magic sameElements expected) {\n        |        \"successful\"\n        |      } else {\n        |        \"failed: unexpected contents from stream\"\n        |      }\n        |    } finally {\n        |      stream.close()\n        |    }\n        |  }\n        |}.collect()\n      ")).stripMargin());
            this.assertDoesNotContain("failed", output);
            this.assertContains("successful", output);
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
        this.test("SPARK-30167: Log4j configuration for REPL should override root logger properly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String string;
            String testConfiguration = new StringOps(Predef$.MODULE$.augmentString("\n        |# Set everything to be logged to the console\n        |rootLogger.level = info\n        |rootLogger.appenderRef.stdout.ref = console\n        |\n        |appender.console.type = Console\n        |appender.console.name = console\n        |appender.console.target = SYSTEM_ERR\n        |appender.console.follow = true\n        |appender.console.layout.type = PatternLayout\n        |appender.console.layout.pattern = %d{yy/MM/dd HH:mm:ss} %p %c{1}: %m%n%ex\n        |\n        |# Set the log level for this class to ERROR same as the default setting.\n        |logger.repl.name = org.apache.spark.repl.Main\n        |logger.repl.level = error\n        |\n        |logger.customLogger2.name = customLogger2\n        |logger.customLogger2.level = info\n        |")).stripMargin();
            Path log4jprops = Files.createTempFile("log4j2.properties.d", "log4j2.properties", new FileAttribute[0]);
            Files.write(log4jprops, testConfiguration.getBytes(), new OpenOption[0]);
            Logger originalRootLogger = (Logger)LogManager.getRootLogger();
            Appender originalRootAppender = (Appender)originalRootLogger.getAppenders().get("file");
            PrintStream originalStderr = System.err;
            Level originalReplThresholdLevel = Logging$.MODULE$.sparkShellThresholdLevel();
            String replLoggerLogMessage = "Log level for REPL: ";
            String warnLogMessage1 = "warnLogMessage1 should not be output";
            String errorLogMessage1 = "errorLogMessage1 should be output";
            String infoLogMessage1 = "infoLogMessage2 should be output";
            String infoLogMessage2 = "infoLogMessage3 should be output";
            String debugLogMessage1 = "debugLogMessage1 should be output";
            try {
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                context.setConfigLocation(log4jprops.toUri());
                Main$.MODULE$.initializeForcefully(true, false);
                string = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(2142).append("\n           |import java.io.{ByteArrayOutputStream, PrintStream}\n           |\n           |import org.apache.logging.log4j.{Level, LogManager}\n           |import org.apache.logging.log4j.core.Logger\n           |\n           |val replLogger = LogManager.getLogger(\"").append(new StringOps(Predef$.MODULE$.augmentString(Main$.MODULE$.getClass().getName())).stripSuffix("$")).append("\")\n           |\n           |// Log level for REPL is expected to be ERROR\n           |\"").append(replLoggerLogMessage).append("\" + replLogger.getLevel()\n           |\n           |val bout = new ByteArrayOutputStream()\n           |\n           |// Configure stderr to let log messages output to ByteArrayOutputStream.\n           |val defaultErrStream: PrintStream = System.err\n           |try {\n           |  System.setErr(new PrintStream(bout))\n           |\n           |  // customLogger1 is not explicitly configured neither its log level nor appender\n           |  // so this inherits the settings of rootLogger\n           |  // but ConsoleAppender can use a different log level.\n           |  val customLogger1 = LogManager.getLogger(\"customLogger1\")\n           |  customLogger1.warn(\"").append(warnLogMessage1).append("\")\n           |  customLogger1.error(\"").append(errorLogMessage1).append("\")\n           |\n           |  // customLogger2 is explicitly configured its log level as INFO\n           |  // so info level messages logged via customLogger2 should be output.\n           |  val customLogger2 = LogManager.getLogger(\"customLogger2\").asInstanceOf[Logger]\n           |  customLogger2.info(\"").append(infoLogMessage1).append("\")\n           |\n           |  // customLogger2 is explicitly configured its log level\n           |  // so its child should inherit the settings.\n           |  val customLogger3 = LogManager.getLogger(\"customLogger2.child\")\n           |  customLogger3.info(\"").append(infoLogMessage2).append("\")\n           |\n           |  // customLogger4 is programmingly configured its log level as DEBUG\n           |  // so debug level messages logged via customLogger4 should be output.\n           |  val customLogger4 = LogManager.getLogger(\"customLogger4\").asInstanceOf[Logger]\n           |  customLogger4.setLevel(Level.DEBUG)\n           |  customLogger4.debug(\"").append(debugLogMessage1).append("\")\n           |\n           |  // echo log messages\n           |  bout.toString\n           |} finally {\n           |  System.setErr(defaultErrStream)\n           |}\n           |").toString())).stripMargin());
            }
            finally {
                URL log4jproperties = Thread.currentThread().getContextClassLoader().getResource("log4j2.properties");
                LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
                context.reconfigure();
                context.setConfigLocation(log4jproperties.toURI());
                context.updateLoggers();
                Logging$.MODULE$.sparkShellThresholdLevel_$eq(originalReplThresholdLevel);
            }
            String out = string;
            PrintStream $org_scalatest_assert_macro_left = originalStderr;
            PrintStream $org_scalatest_assert_macro_right = System.err;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "eq", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 381));
            Logger restoredRootLogger = (Logger)LogManager.getRootLogger();
            Appender restoredRootAppender = (Appender)restoredRootLogger.getAppenders().get("file");
            Class<?> $org_scalatest_assert_macro_left2 = originalRootAppender.getClass();
            Class<?> $org_scalatest_assert_macro_right2 = restoredRootAppender.getClass();
            Class<?> clazz = $org_scalatest_assert_macro_left2;
            Class<?> clazz2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", $org_scalatest_assert_macro_right2, !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
            Level $org_scalatest_assert_macro_left3 = originalRootLogger.getLevel();
            Level $org_scalatest_assert_macro_right3 = restoredRootLogger.getLevel();
            Level level = $org_scalatest_assert_macro_left3;
            Level level2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(level != null ? !level.equals(level2) : level2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
            Level $org_scalatest_assert_macro_left4 = LogManager.getLogger((String)"customLogger2").getLevel();
            Level $org_scalatest_assert_macro_right4 = Level.INFO;
            Level level3 = $org_scalatest_assert_macro_left4;
            Level level4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(level3 != null ? !level3.equals(level4) : level4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
            Level $org_scalatest_assert_macro_left5 = LogManager.getLogger((String)"customLogger2.child").getLevel();
            Level $org_scalatest_assert_macro_right5 = Level.INFO;
            Level level5 = $org_scalatest_assert_macro_left5;
            Level level6 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(level5 != null ? !level5.equals(level6) : level6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
            this.assertContains(new StringBuilder(5).append(replLoggerLogMessage).append("ERROR").toString(), out);
            this.assertDoesNotContain(warnLogMessage1, out);
            this.assertContains(errorLogMessage1, out);
            this.assertContains(infoLogMessage1, out);
            this.assertContains(infoLogMessage2, out);
            this.assertContains(debugLogMessage1, out);
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
    }
}

