/*
 * Decompiled with CFR 0.152.
 */
package org.eep_custom.orc.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.eep_custom.orc.OrcConf;
import org.eep_custom.orc.OrcFile;
import org.eep_custom.orc.Reader;
import org.eep_custom.orc.mapreduce.OrcMapreduceRecordReader;

public class OrcInputFormat<V extends WritableComparable>
extends FileInputFormat<NullWritable, V> {
    public static void setSearchArgument(Configuration conf, SearchArgument sarg, String[] columnNames) {
        org.eep_custom.orc.mapred.OrcInputFormat.setSearchArgument(conf, sarg, columnNames);
    }

    public RecordReader<NullWritable, V> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        FileSplit split = (FileSplit)inputSplit;
        Configuration conf = taskAttemptContext.getConfiguration();
        Reader file = OrcFile.createReader(split.getPath(), OrcFile.readerOptions(conf).maxLength(OrcConf.MAX_FILE_LENGTH.getLong(conf)));
        return new OrcMapreduceRecordReader(file, org.eep_custom.orc.mapred.OrcInputFormat.buildOptions(conf, file, split.getStart(), split.getLength()));
    }

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        List complete = super.listStatus(job);
        ArrayList<FileStatus> result = new ArrayList<FileStatus>(complete.size());
        for (FileStatus stat : complete) {
            if (stat.getLen() == 0L) continue;
            result.add(stat);
        }
        return result;
    }
}

