/*
 * Decompiled with CFR 0.152.
 */
package org.eep_custom.orc.impl.writer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eep_custom.orc.EncryptionAlgorithm;
import org.eep_custom.orc.EncryptionKey;
import org.eep_custom.orc.impl.HadoopShims;
import org.eep_custom.orc.impl.writer.WriterEncryptionVariant;
import org.jetbrains.annotations.NotNull;

public class WriterEncryptionKey
implements EncryptionKey {
    private final HadoopShims.KeyMetadata metadata;
    private final List<WriterEncryptionVariant> roots = new ArrayList<WriterEncryptionVariant>();
    private int id;

    public WriterEncryptionKey(HadoopShims.KeyMetadata key) {
        this.metadata = key;
    }

    public void addRoot(WriterEncryptionVariant root) {
        this.roots.add(root);
    }

    public HadoopShims.KeyMetadata getMetadata() {
        return this.metadata;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public String getKeyName() {
        return this.metadata.getKeyName();
    }

    @Override
    public int getKeyVersion() {
        return this.metadata.getVersion();
    }

    @Override
    public EncryptionAlgorithm getAlgorithm() {
        return this.metadata.getAlgorithm();
    }

    public WriterEncryptionVariant[] getEncryptionRoots() {
        return this.roots.toArray(new WriterEncryptionVariant[this.roots.size()]);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public int getId() {
        return this.id;
    }

    public void sortRoots() {
        Collections.sort(this.roots);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.compareTo((EncryptionKey)other) == 0;
    }

    @Override
    public int compareTo(@NotNull EncryptionKey other) {
        int result = this.getKeyName().compareTo(other.getKeyName());
        if (result == 0) {
            result = Integer.compare(this.getKeyVersion(), other.getKeyVersion());
        }
        return result;
    }

    public String toString() {
        return this.metadata.toString();
    }
}

