/*
 * Decompiled with CFR 0.152.
 */
package org.eep_custom.orc.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.eep_custom.orc.EncryptionAlgorithm;
import org.eep_custom.orc.impl.KeyProvider;

public interface HadoopShims {
    public DirectDecompressor getDirectDecompressor(DirectCompressionType var1);

    public ZeroCopyReaderShim getZeroCopyReader(FSDataInputStream var1, ByteBufferPoolShim var2) throws IOException;

    public boolean endVariableLengthBlock(OutputStream var1) throws IOException;

    public KeyProvider getHadoopKeyProvider(Configuration var1, Random var2) throws IOException;

    public static class KeyMetadata {
        private final String keyName;
        private final int version;
        private final EncryptionAlgorithm algorithm;

        public KeyMetadata(String key, int version, EncryptionAlgorithm algorithm) {
            this.keyName = key;
            this.version = version;
            this.algorithm = algorithm;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public EncryptionAlgorithm getAlgorithm() {
            return this.algorithm;
        }

        public int getVersion() {
            return this.version;
        }

        public String toString() {
            return this.keyName + '@' + this.version + ' ' + (Object)((Object)this.algorithm);
        }
    }

    public static enum KeyProviderKind {
        UNKNOWN(0),
        HADOOP(1),
        AWS(2),
        GCP(3),
        AZURE(4);

        private final int value;

        private KeyProviderKind(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static interface ZeroCopyReaderShim
    extends Closeable {
        public ByteBuffer readBuffer(int var1, boolean var2) throws IOException;

        public void releaseBuffer(ByteBuffer var1);

        @Override
        public void close() throws IOException;
    }

    public static interface ByteBufferPoolShim {
        public ByteBuffer getBuffer(boolean var1, int var2);

        public void putBuffer(ByteBuffer var1);
    }

    public static interface DirectDecompressor {
        public void decompress(ByteBuffer var1, ByteBuffer var2) throws IOException;

        public void reset();

        public void end();
    }

    public static enum DirectCompressionType {
        NONE,
        ZLIB_NOHEADER,
        ZLIB,
        SNAPPY;

    }
}

