/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.repl.Main$;
import org.apache.spark.repl.ReplSuite;
import org.apache.spark.repl.SparkILoop;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Ignore;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.reflect.internal.settings.MutableSettings;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.tools.nsc.Settings;
import scala.tools.nsc.interpreter.ILoop;
import scala.tools.nsc.interpreter.ILoop$;
import scala.tools.nsc.interpreter.InteractiveReader;
import scala.tools.nsc.interpreter.SimpleReader$;

@Ignore
@ScalaSignature(bytes="\u0006\u0001\u00153AAB\u0004\u0001!!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00015!)A\u0006\u0001C\u0001[!)\u0001\u0007\u0001C\u0001c!)!\b\u0001C\u0001w\tI!+\u001a9m'VLG/\u001a\u0006\u0003\u0011%\tAA]3qY*\u0011!bC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00195\ta!\u00199bG\",'\"\u0001\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0014\u001b\u0005I\u0011B\u0001\u000b\n\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011aB\u0001\u000feVt\u0017J\u001c;feB\u0014X\r^3s)\rY\u0002F\u000b\t\u00039\u0015r!!H\u0012\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001z\u0011A\u0002\u001fs_>$hHC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013%\u0001\u0004Qe\u0016$WMZ\u0005\u0003M\u001d\u0012aa\u0015;sS:<'B\u0001\u0013\"\u0011\u0015I#\u00011\u0001\u001c\u0003\u0019i\u0017m\u001d;fe\")1F\u0001a\u00017\u0005)\u0011N\u001c9vi\u0006I\"/\u001e8J]R,'\u000f\u001d:fi\u0016\u0014\u0018J\u001c)bgR,Wj\u001c3f)\rYbf\f\u0005\u0006S\r\u0001\ra\u0007\u0005\u0006W\r\u0001\raG\u0001\u000fCN\u001cXM\u001d;D_:$\u0018-\u001b8t)\r\u0011d\u0007\u000f\t\u0003gQj\u0011!I\u0005\u0003k\u0005\u0012A!\u00168ji\")q\u0007\u0002a\u00017\u00059Q.Z:tC\u001e,\u0007\"B\u001d\u0005\u0001\u0004Y\u0012AB8viB,H/\u0001\u000bbgN,'\u000f\u001e#pKNtu\u000e^\"p]R\f\u0017N\u001c\u000b\u0004eqj\u0004\"B\u001c\u0006\u0001\u0004Y\u0002\"B\u001d\u0006\u0001\u0004Y\u0002F\u0001\u0001@!\t\u00015)D\u0001B\u0015\t\u0011U\"A\u0005tG\u0006d\u0017\r^3ti&\u0011A)\u0011\u0002\u0007\u0013\u001etwN]3")
public class ReplSuite
extends SparkFunSuite {
    public String runInterpreter(String master, String input) {
        String CONF_EXECUTOR_CLASSPATH = "spark.executor.extraClassPath";
        String oldExecutorClasspath = System.getProperty(CONF_EXECUTOR_CLASSPATH);
        String classpath = System.getProperty("java.class.path");
        System.setProperty(CONF_EXECUTOR_CLASSPATH, classpath);
        Main$.MODULE$.sparkContext_$eq(null);
        Main$.MODULE$.sparkSession_$eq(null);
        Main$.MODULE$.conf().set("spark.master", master);
        BufferedReader in = new BufferedReader(new StringReader(new StringBuilder(1).append(input).append("\n").toString()));
        StringWriter out = new StringWriter();
        Main$.MODULE$.doMain((String[])((Object[])new String[]{"-classpath", classpath}), new SparkILoop(in, new PrintWriter(out)));
        String string = oldExecutorClasspath != null ? System.setProperty(CONF_EXECUTOR_CLASSPATH, oldExecutorClasspath) : System.clearProperty(CONF_EXECUTOR_CLASSPATH);
        return out.toString();
    }

    public String runInterpreterInPasteMode(String master, String input) {
        return this.runInterpreter(master, new StringBuilder(7).append(":paste\n").append(input).append((char)4).toString());
    }

    public void assertContains(String message, String output) {
        boolean isContain = output.contains(message);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(isContain, "isContain", Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(39).append("Interpreter output did not contain '").append(message).append("':\n").append(output).toString(), Prettifier$.MODULE$.default(), new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
    }

    public void assertDoesNotContain(String message, String output) {
        boolean isContain = output.contains(message);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(isContain, "isContain", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(33).append("Interpreter output contained '").append(message).append("':\n").append(output).toString(), Prettifier$.MODULE$.default(), new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
    }

    public ReplSuite() {
        this.test("propagation of local properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            StringWriter out = new StringWriter();
            public class Org_apache_spark_repl_ReplSuite$ILoop$1
            extends SparkILoop {
                public Org_apache_spark_repl_ReplSuite$ILoop$1(ReplSuite $outer, PrintWriter out) {
                    super((Option)None$.MODULE$, out);
                    this.settings_$eq(new Settings());
                    ((MutableSettings.SettingValue)this.settings().usejavacp()).value_$eq((Object)BoxesRunTime.boxToBoolean((boolean)true));
                    Main$.MODULE$.interp_$eq((SparkILoop)this);
                    this.in_$eq((InteractiveReader)SimpleReader$.MODULE$.apply(SimpleReader$.MODULE$.apply$default$1(), SimpleReader$.MODULE$.apply$default$2(), SimpleReader$.MODULE$.apply$default$3()));
                }
            }
            Main$.MODULE$.interp_$eq((SparkILoop)new Org_apache_spark_repl_ReplSuite$ILoop$1(null, new PrintWriter(out)));
            Main$.MODULE$.sparkContext_$eq(new SparkContext("local", "repl-test"));
            Main$.MODULE$.interp().createInterpreter();
            Main$.MODULE$.sparkContext().setLocalProperty("someKey", "someValue");
            ILoop$.MODULE$.loopToInterpreter((ILoop)Main$.MODULE$.interp()).interpret("org.apache.spark.repl.Main.sparkContext.getLocalProperty(\"someKey\")");
            String $org_scalatest_assert_macro_left = out.toString();
            String $org_scalatest_assert_macro_right = "someValue";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
            Main$.MODULE$.sparkContext().stop();
            return System.clearProperty("spark.driver.port");
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("SPARK-15236: use Hive catalog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Logger rootLogger = LogManager.getRootLogger();
            Level logLevel = rootLogger.getLevel();
            rootLogger.setLevel(Level.INFO);
            try {
                Main$.MODULE$.conf().set(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION().key(), "hive");
                String output = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n      |spark.sql(\"drop table if exists t_15236\")\n    ")).stripMargin());
                this.assertDoesNotContain("error:", output);
                this.assertDoesNotContain("Exception", output);
                if (SparkSession$.MODULE$.hiveClassesArePresent()) {
                    this.assertContains("HiveMetaStore", output);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.assertDoesNotContain("HiveMetaStore", output);
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                rootLogger.setLevel(logLevel);
            }
            return boxedUnit;
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("SPARK-15236: use in-memory catalog", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Logger rootLogger = LogManager.getRootLogger();
            Level logLevel = rootLogger.getLevel();
            rootLogger.setLevel(Level.INFO);
            try {
                Main$.MODULE$.conf().set(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION().key(), "in-memory");
                String output = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n          |spark.sql(\"drop table if exists t_16236\")\n        ")).stripMargin());
                this.assertDoesNotContain("error:", output);
                this.assertDoesNotContain("Exception", output);
                this.assertDoesNotContain("HiveMetaStore", output);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                rootLogger.setLevel(logLevel);
            }
            return boxedUnit;
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("broadcast vars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n        |var array = new Array[Int](5)\n        |val broadcastArray = sc.broadcast(array)\n        |sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n        |array(0) = 5\n        |sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n      ")).stripMargin());
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
            this.assertContains("res0: Array[Int] = Array(0, 0, 0, 0, 0)", output);
            this.assertContains("res2: Array[Int] = Array(5, 0, 0, 0, 0)", output);
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        if (System.getenv("MESOS_NATIVE_JAVA_LIBRARY") != null) {
            this.test("running on Mesos", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String output = this.runInterpreter("localquiet", new StringOps(Predef$.MODULE$.augmentString("\n          |var v = 7\n          |def getV() = v\n          |sc.parallelize(1 to 10).map(x => getV()).collect().reduceLeft(_+_)\n          |v = 10\n          |sc.parallelize(1 to 10).map(x => getV()).collect().reduceLeft(_+_)\n          |var array = new Array[Int](5)\n          |val broadcastArray = sc.broadcast(array)\n          |sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n          |array(0) = 5\n          |sc.parallelize(0 to 4).map(x => broadcastArray.value(x)).collect()\n        ")).stripMargin());
                this.assertDoesNotContain("error:", output);
                this.assertDoesNotContain("Exception", output);
                this.assertContains("res0: Int = 70", output);
                this.assertContains("res1: Int = 100", output);
                this.assertContains("res2: Array[Int] = Array(0, 0, 0, 0, 0)", output);
                this.assertContains("res4: Array[Int] = Array(0, 0, 0, 0, 0)", output);
            }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        }
        this.test("line wrapper only initialized once when used as encoder outer scope", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n        |val fileName = \"repl-test-\" + System.currentTimeMillis\n        |val tmpDir = System.getProperty(\"java.io.tmpdir\")\n        |val file = new java.io.File(tmpDir, fileName)\n        |def createFile(): Unit = file.createNewFile()\n        |\n        |createFile();case class TestCaseClass(value: Int)\n        |sc.parallelize(1 to 10).map(x => TestCaseClass(x)).collect()\n        |\n        |file.delete()\n      ")).stripMargin());
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("define case class and create Dataset together with paste mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output = this.runInterpreterInPasteMode("local-cluster[1,1,1024]", new StringOps(Predef$.MODULE$.augmentString("\n        |import spark.implicits._\n        |case class TestClass(value: Int)\n        |Seq(TestClass(1)).toDS()\n      ")).stripMargin());
            this.assertDoesNotContain("error:", output);
            this.assertDoesNotContain("Exception", output);
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.test(":replay should work correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n     |sc\n     |:replay\n     ")).stripMargin());
            this.assertDoesNotContain("error: not found: value sc", output);
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
        this.test("spark-shell should find imported types in class constructors and extends clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n        |import org.apache.spark.Partition\n        |class P(p: Partition)\n        |class P(val index: Int) extends Partition\n      ")).stripMargin());
            this.assertDoesNotContain("error: not found: type Partition", output);
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("spark-shell should shadow val/def definitions correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output1 = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n        |def myMethod() = \"first definition\"\n        |val tmp = myMethod(); val out = tmp\n        |def myMethod() = \"second definition\"\n        |val tmp = myMethod(); val out = s\"$tmp aabbcc\"\n      ")).stripMargin());
            this.assertContains("second definition aabbcc", output1);
            String output2 = this.runInterpreter("local", new StringOps(Predef$.MODULE$.augmentString("\n        |val a = 1\n        |val b = a; val c = b;\n        |val a = 2\n        |val b = a; val c = b;\n        |s\"!!$b!!\"\n      ")).stripMargin());
            this.assertContains("!!2!!", output2);
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        this.test("SPARK-26633: ExecutorClassLoader.getResourceAsStream find REPL classes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String output = this.runInterpreterInPasteMode("local-cluster[1,1,1024]", new StringOps(Predef$.MODULE$.augmentString("\n        |case class TestClass(value: Int)\n        |\n        |sc.parallelize(1 to 1).map { _ =>\n        |  val clz = classOf[TestClass]\n        |  val name = clz.getName.replace('.', '/') + \".class\";\n        |  val stream = clz.getClassLoader.getResourceAsStream(name)\n        |  if (stream == null) {\n        |    \"failed: stream is null\"\n        |  } else {\n        |    val magic = new Array[Byte](4)\n        |    try {\n        |      stream.read(magic)\n        |      // the magic number of a Java Class file\n        |      val expected = Array[Byte](0xCA.toByte, 0xFE.toByte, 0xBA.toByte, 0xBE.toByte)\n        |      if (magic sameElements expected) {\n        |        \"successful\"\n        |      } else {\n        |        \"failed: unexpected contents from stream\"\n        |      }\n        |    } finally {\n        |      stream.close()\n        |    }\n        |  }\n        |}.collect()\n      ")).stripMargin());
            this.assertDoesNotContain("failed", output);
            this.assertContains("successful", output);
        }, new Position("ReplSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
    }
}

