/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.repl;

import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.Enumeration;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.TestUtils$;
import org.apache.spark.repl.ExecutorClassLoader;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.util.Utils$;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Ignore;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.mockito.MockitoSugar;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@Ignore
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001\u0002\f\u0018\u0001\u0001BQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013\u0005A\b\u0003\u0004P\u0001\u0001\u0006I!\u0010\u0005\b!\u0002\u0011\r\u0011\"\u0001=\u0011\u0019\t\u0006\u0001)A\u0005{!9!\u000b\u0001b\u0001\n\u0003a\u0004BB*\u0001A\u0003%Q\bC\u0005U\u0001\u0001\u0007\t\u0019!C\u0001+\"IA\f\u0001a\u0001\u0002\u0004%\t!\u0018\u0005\nI\u0002\u0001\r\u0011!Q!\nYC\u0011\"\u001a\u0001A\u0002\u0003\u0007I\u0011A+\t\u0013\u0019\u0004\u0001\u0019!a\u0001\n\u00039\u0007\"C5\u0001\u0001\u0004\u0005\t\u0015)\u0003W\u0011%Q\u0007\u00011AA\u0002\u0013\u00051\u000eC\u0005w\u0001\u0001\u0007\t\u0019!C\u0001o\"I\u0011\u0010\u0001a\u0001\u0002\u0003\u0006K\u0001\u001c\u0005\nu\u0002\u0001\r\u00111A\u0005\u0002mD1\"a\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u000e!Q\u0011\u0011\u0003\u0001A\u0002\u0003\u0005\u000b\u0015\u0002?\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016!9\u0011q\u0003\u0001\u0005B\u0005U!\u0001G#yK\u000e,Ho\u001c:DY\u0006\u001c8\u000fT8bI\u0016\u00148+^5uK*\u0011\u0001$G\u0001\u0005e\u0016\u0004HN\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u0007CB\f7\r[3\u000b\u0003y\t1a\u001c:h\u0007\u0001\u0019R\u0001A\u0011&WE\u0002\"AI\u0012\u000e\u0003eI!\u0001J\r\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t1\u0013&D\u0001(\u0015\tAS$A\u0005tG\u0006d\u0017\r^3ti&\u0011!f\n\u0002\u0012\u0005\u00164wN]3B]\u0012\fe\r^3s\u00032d\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018(\u0003\u001diwnY6ji>L!\u0001M\u0017\u0003\u00195{7m[5u_N+x-\u0019:\u0011\u0005I*T\"A\u001a\u000b\u0005QJ\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005Y\u001a$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0002\"A\u000f\u0001\u000e\u0003]\tqb\u00195jY\u0012\u001cE.Y:t\u001d\u0006lWm]\u000b\u0002{A\u0019a(R$\u000e\u0003}R!\u0001Q!\u0002\u0013%lW.\u001e;bE2,'B\u0001\"D\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002\t\u0006)1oY1mC&\u0011ai\u0010\u0002\u0005\u0019&\u001cH\u000f\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006!A.\u00198h\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT%\u0003\rM#(/\u001b8h\u0003A\u0019\u0007.\u001b7e\u00072\f7o\u001d(b[\u0016\u001c\b%\u0001\tqCJ,g\u000e^\"mCN\u001ch*Y7fg\u0006\t\u0002/\u0019:f]R\u001cE.Y:t\u001d\u0006lWm\u001d\u0011\u0002'A\f'/\u001a8u%\u0016\u001cx.\u001e:dK:\u000bW.Z:\u0002)A\f'/\u001a8u%\u0016\u001cx.\u001e:dK:\u000bW.Z:!\u0003!!X-\u001c9ESJ\fT#\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0005e[\u0015AA5p\u0013\tY\u0006L\u0001\u0003GS2,\u0017\u0001\u0004;f[B$\u0015N]\u0019`I\u0015\fHC\u00010c!\ty\u0006-D\u0001D\u0013\t\t7I\u0001\u0003V]&$\bbB2\n\u0003\u0003\u0005\rAV\u0001\u0004q\u0012\n\u0014!\u0003;f[B$\u0015N]\u0019!\u0003!!X-\u001c9ESJ\u0014\u0014\u0001\u0004;f[B$\u0015N\u001d\u001a`I\u0015\fHC\u00010i\u0011\u001d\u0019G\"!AA\u0002Y\u000b\u0011\u0002^3na\u0012K'O\r\u0011\u0002\tU\u0014H.M\u000b\u0002YB\u0011Q\u000e\u001e\b\u0003]J\u0004\"a\\\"\u000e\u0003AT!!]\u0010\u0002\rq\u0012xn\u001c;?\u0013\t\u00198)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001dVT!a]\"\u0002\u0011U\u0014H.M0%KF$\"A\u0018=\t\u000f\r|\u0011\u0011!a\u0001Y\u0006)QO\u001d72A\u0005)QO\u001d7teU\tA\u0010E\u0002`{~L!A`\"\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u0002L\u0003\rqW\r^\u0005\u0005\u0003\u0013\t\u0019AA\u0002V%2\u000b\u0011\"\u001e:mgJzF%Z9\u0015\u0007y\u000by\u0001C\u0004d%\u0005\u0005\t\u0019\u0001?\u0002\rU\u0014Hn\u001d\u001a!\u0003%\u0011WMZ8sK\u0006cG\u000eF\u0001_\u0003!\tg\r^3s\u00032d\u0007f\u0001\u0001\u0002\u001cA\u0019a%!\b\n\u0007\u0005}qE\u0001\u0004JO:|'/\u001a")
public class ExecutorClassLoaderSuite
extends SparkFunSuite
implements MockitoSugar {
    private final List<String> childClassNames;
    private final List<String> parentClassNames;
    private final List<String> parentResourceNames;
    private File tempDir1;
    private File tempDir2;
    private String url1;
    private URL[] urls2;

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    public List<String> childClassNames() {
        return this.childClassNames;
    }

    public List<String> parentClassNames() {
        return this.parentClassNames;
    }

    public List<String> parentResourceNames() {
        return this.parentResourceNames;
    }

    public File tempDir1() {
        return this.tempDir1;
    }

    public void tempDir1_$eq(File x$1) {
        this.tempDir1 = x$1;
    }

    public File tempDir2() {
        return this.tempDir2;
    }

    public void tempDir2_$eq(File x$1) {
        this.tempDir2 = x$1;
    }

    public String url1() {
        return this.url1;
    }

    public void url1_$eq(String x$1) {
        this.url1 = x$1;
    }

    public URL[] urls2() {
        return this.urls2;
    }

    public void urls2_$eq(URL[] x$1) {
        this.urls2 = x$1;
    }

    public void beforeAll() {
        super.beforeAll();
        this.tempDir1_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        this.tempDir2_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        this.url1_$eq(this.tempDir1().toURI().toURL().toString());
        this.urls2_$eq((URL[])new .colon.colon((Object)this.tempDir2().toURI().toURL(), (List)Nil$.MODULE$).toArray(ClassTag$.MODULE$.apply(URL.class)));
        this.childClassNames().foreach((Function1 & Serializable & scala.Serializable)x$1 -> TestUtils$.MODULE$.createCompiledClass(x$1, this.tempDir1(), "1", TestUtils$.MODULE$.createCompiledClass$default$4(), TestUtils$.MODULE$.createCompiledClass$default$5()));
        this.parentResourceNames().foreach((Function1 & Serializable & scala.Serializable)x -> {
            ExecutorClassLoaderSuite.$anonfun$beforeAll$2(this, x);
            return BoxedUnit.UNIT;
        });
        this.parentClassNames().foreach((Function1 & Serializable & scala.Serializable)x$2 -> TestUtils$.MODULE$.createCompiledClass(x$2, this.tempDir2(), "2", TestUtils$.MODULE$.createCompiledClass$default$4(), TestUtils$.MODULE$.createCompiledClass$default$5()));
    }

    public void afterAll() {
        try {
            Utils$.MODULE$.deleteRecursively(this.tempDir1());
            Utils$.MODULE$.deleteRecursively(this.tempDir2());
            SparkEnv$.MODULE$.set(null);
        }
        finally {
            super.afterAll();
        }
    }

    public static final /* synthetic */ void $anonfun$beforeAll$2(ExecutorClassLoaderSuite $this, String x) {
        Files.write((byte[])"resource".getBytes(StandardCharsets.UTF_8), (File)new File($this.tempDir2(), x));
    }

    public ExecutorClassLoaderSuite() {
        MockitoSugar.$init$((MockitoSugar)this);
        this.childClassNames = new .colon.colon((Object)"ReplFakeClass1", (List)new .colon.colon((Object)"ReplFakeClass2", (List)Nil$.MODULE$));
        this.parentClassNames = new .colon.colon((Object)"ReplFakeClass1", (List)new .colon.colon((Object)"ReplFakeClass2", (List)new .colon.colon((Object)"ReplFakeClass3", (List)Nil$.MODULE$)));
        this.parentResourceNames = new .colon.colon((Object)"fake-resource.txt", (List)Nil$.MODULE$);
        this.test("child over system classloader", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SimpleJavaFileObject scalaOptionFile = new SimpleJavaFileObject(null){

                public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                    return "package scala; class Option {}";
                }
            };
            ToolProvider.getSystemJavaCompiler().getTask(null, null, null, null, null, Collections.singletonList(scalaOptionFile)).call();
            File scalaDir = new File(this.tempDir1(), "scala");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(scalaDir.mkdir(), "scalaDir.mkdir()", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(38).append("Failed to create 'scala' directory in ").append(this.tempDir1()).toString(), Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            String filename = "Option.class";
            File result = new File(filename);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(result.exists(), "result.exists()", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)new StringBuilder(25).append("Compiled file not found: ").append(result.getAbsolutePath()).toString(), Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
            File out = new File(scalaDir, filename);
            Files.move((File)result, (File)out);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(out.exists(), "out.exists()", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringBuilder(28).append("Destination file not moved: ").append(out.getAbsolutePath()).toString(), Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            URLClassLoader parentLoader = new URLClassLoader(this.urls2(), null);
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.url1(), (ClassLoader)parentLoader, true);
            Class<?> optionClass = Class.forName("scala.Option", false, (ClassLoader)classLoader);
            ClassLoader $org_scalatest_assert_macro_left = optionClass.getClassLoader();
            ExecutorClassLoader $org_scalatest_assert_macro_right = classLoader;
            ClassLoader classLoader2 = $org_scalatest_assert_macro_left;
            ExecutorClassLoader executorClassLoader = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(classLoader2 != null ? !classLoader2.equals(executorClassLoader) : executorClassLoader != null), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"scala.Option didn't come from ExecutorClassLoader", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("child first", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            URLClassLoader parentLoader = new URLClassLoader(this.urls2(), null);
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.url1(), (ClassLoader)parentLoader, true);
            Object fakeClass = classLoader.loadClass("ReplFakeClass2").getConstructor(new Class[0]).newInstance(new Object[0]);
            String fakeClassVersion = fakeClass.toString();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(fakeClassVersion);
            String $org_scalatest_assert_macro_right = "1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        this.test("parent first", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            URLClassLoader parentLoader = new URLClassLoader(this.urls2(), null);
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.url1(), (ClassLoader)parentLoader, false);
            Object fakeClass = classLoader.loadClass("ReplFakeClass1").getConstructor(new Class[0]).newInstance(new Object[0]);
            String fakeClassVersion = fakeClass.toString();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(fakeClassVersion);
            String $org_scalatest_assert_macro_right = "2";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        this.test("child first can fall back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            URLClassLoader parentLoader = new URLClassLoader(this.urls2(), null);
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.url1(), (ClassLoader)parentLoader, true);
            Object fakeClass = classLoader.loadClass("ReplFakeClass3").getConstructor(new Class[0]).newInstance(new Object[0]);
            String fakeClassVersion = fakeClass.toString();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(fakeClassVersion);
            String $org_scalatest_assert_macro_right = "2";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("child first can fail", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            URLClassLoader parentLoader = new URLClassLoader(this.urls2(), null);
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.url1(), (ClassLoader)parentLoader, true);
            return (ClassNotFoundException)this.intercept((Function0 & Serializable & scala.Serializable)() -> classLoader.loadClass("ReplFakeClassDoesNotExist").getConstructor(new Class[0]).newInstance(new Object[0]), ClassTag$.MODULE$.apply(ClassNotFoundException.class), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        this.test("resource from parent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            InputStream is;
            URLClassLoader parentLoader = new URLClassLoader(this.urls2(), null);
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.url1(), (ClassLoader)parentLoader, true);
            String resourceName = (String)this.parentResourceNames().head();
            InputStream $org_scalatest_assert_macro_left = is = classLoader.getResourceAsStream(resourceName);
            Object $org_scalatest_assert_macro_right = null;
            InputStream inputStream = $org_scalatest_assert_macro_left;
            Object var8_7 = null;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, inputStream == null ? var8_7 != null : !inputStream.equals(var8_7), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append("Resource ").append(resourceName).append(" not found").toString(), Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            BufferedSource bufferedSource = Source$.MODULE$.fromInputStream(is, "UTF-8");
            return (Assertion)Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> {
                String content;
                String $org_scalatest_assert_macro_left = content = (String)bufferedSource.getLines().next();
                String $org_scalatest_assert_macro_right = "resource";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"File doesn't contain 'resource'", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> bufferedSource.close());
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
        this.test("resources from parent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            URLClassLoader parentLoader = new URLClassLoader(this.urls2(), null);
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), null, this.url1(), (ClassLoader)parentLoader, true);
            String resourceName = (String)this.parentResourceNames().head();
            Enumeration resources = classLoader.getResources(resourceName);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(resources.hasMoreElements(), "resources.hasMoreElements()", Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(19).append("Resource ").append(resourceName).append(" not found").toString(), Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            BufferedSource bufferedSource = Source$.MODULE$.fromInputStream(((URL)resources.nextElement()).openStream(), Codec$.MODULE$.fallbackSystemCodec());
            return (Assertion)Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> {
                BufferedReader fileReader = bufferedSource.bufferedReader();
                String $org_scalatest_assert_macro_left = fileReader.readLine();
                String $org_scalatest_assert_macro_right = "resource";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"File doesn't contain 'resource'", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> bufferedSource.close());
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test("fetch classes using Spark's RpcEnv", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Assertion assertion;
            SparkEnv env = (SparkEnv)this.mock(ClassTag$.MODULE$.apply(SparkEnv.class));
            RpcEnv rpcEnv = (RpcEnv)this.mock(ClassTag$.MODULE$.apply(RpcEnv.class));
            Mockito.when((Object)env.rpcEnv()).thenReturn((Object)rpcEnv);
            Mockito.when((Object)rpcEnv.openChannel(ArgumentMatchers.anyString())).thenAnswer((Answer)new Answer<ReadableByteChannel>(this){
                private final /* synthetic */ ExecutorClassLoaderSuite $outer;

                public ReadableByteChannel answer(InvocationOnMock invocation) {
                    URI uri = new URI((String)invocation.getArguments()[0]);
                    Path path = Paths.get(this.$outer.tempDir1().getAbsolutePath(), new StringOps(Predef$.MODULE$.augmentString(uri.getPath())).stripPrefix("/"));
                    return FileChannel.open(path, StandardOpenOption.READ);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            ExecutorClassLoader classLoader = new ExecutorClassLoader(new SparkConf(), env, "spark://localhost:1234", this.getClass().getClassLoader(), false);
            Object fakeClass = classLoader.loadClass("ReplFakeClass2").getConstructor(new Class[0]).newInstance(new Object[0]);
            String fakeClassVersion = fakeClass.toString();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(fakeClassVersion);
            String $org_scalatest_assert_macro_right = "1";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> classLoader.loadClass("ReplFakeClassDoesNotExist").getConstructor(new Class[0]).newInstance(new Object[0]), ClassTag$.MODULE$.apply(ClassNotFoundException.class), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            try (InputStream fakeClassInputStream = classLoader.getResourceAsStream("ReplFakeClass2.class");){
                byte[] magic = new byte[4];
                fakeClassInputStream.read(magic);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(magic);
                byte[] $org_scalatest_assert_macro_right2 = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{(byte)202, (byte)254, (byte)186, (byte)190}), ClassTag$.MODULE$.Byte());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                assertion = this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            }
            return assertion;
        }, new Position("ExecutorClassLoaderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
    }
}

