/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jpmml.model;

import java.util.ArrayList;
import java.util.List;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static List<String> parse(String string, boolean enableQuotes) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean quoted = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (quoted) {
                if (c == '\\' && i < string.length() - 1) {
                    c = string.charAt(i + 1);
                    if (c == '\"') {
                        sb.append('\"');
                        ++i;
                        continue;
                    }
                    sb.append('\\');
                    continue;
                }
                sb.append(c);
                if (c != '\"') continue;
                result.add(ArrayUtil.createToken(sb, enableQuotes));
                quoted = false;
                continue;
            }
            if (c == '\"' && enableQuotes) {
                if (sb.length() > 0) {
                    result.add(ArrayUtil.createToken(sb, enableQuotes));
                }
                sb.append('\"');
                quoted = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (sb.length() <= 0) continue;
                result.add(ArrayUtil.createToken(sb, enableQuotes));
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            result.add(ArrayUtil.createToken(sb, enableQuotes));
        }
        return result;
    }

    private static String createToken(StringBuilder sb, boolean enableQuotes) {
        String result = sb.length() > 1 && sb.charAt(0) == '\"' && sb.charAt(sb.length() - 1) == '\"' && enableQuotes ? sb.substring(1, sb.length() - 1) : sb.substring(0, sb.length());
        sb.setLength(0);
        return result;
    }
}

