/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml.mining;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.spark_project.dmg.pmml.EmbeddedModel;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.LocalTransformations;
import org.spark_project.dmg.pmml.MathContext;
import org.spark_project.dmg.pmml.MiningFunction;
import org.spark_project.dmg.pmml.MiningSchema;
import org.spark_project.dmg.pmml.Model;
import org.spark_project.dmg.pmml.ModelExplanation;
import org.spark_project.dmg.pmml.ModelStats;
import org.spark_project.dmg.pmml.ModelVerification;
import org.spark_project.dmg.pmml.Output;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.Targets;
import org.spark_project.dmg.pmml.Version;
import org.spark_project.dmg.pmml.Visitable;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;
import org.spark_project.dmg.pmml.mining.Segmentation;
import org.spark_project.dmg.pmml.regression.Regression;
import org.spark_project.dmg.pmml.tree.DecisionTree;
import org.spark_project.jpmml.model.annotations.Added;
import org.spark_project.jpmml.model.annotations.Deprecated;
import org.spark_project.jpmml.model.annotations.Optional;
import org.spark_project.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "embeddedModels", "segmentation", "modelVerification"})
@XmlRootElement(name="MiningModel", namespace="http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"modelName", "miningFunction", "algorithmName", "scorable", "mathContext", "extensions", "miningSchema", "output", "modelStats", "modelExplanation", "targets", "localTransformations", "embeddedModels", "segmentation", "modelVerification"})
public class MiningModel
extends Model
implements HasExtensions<MiningModel> {
    @XmlAttribute(name="modelName")
    @JsonProperty(value="modelName")
    private String modelName;
    @XmlAttribute(name="functionName", required=true)
    @JsonProperty(value="functionName")
    private MiningFunction miningFunction;
    @XmlAttribute(name="algorithmName")
    @JsonProperty(value="algorithmName")
    private String algorithmName;
    @XmlAttribute(name="isScorable")
    @Added(value=Version.PMML_4_1)
    @JsonProperty(value="isScorable")
    private Boolean scorable;
    @XmlAttribute(name="x-mathContext")
    @org.spark_project.jpmml.model.annotations.Extension
    @JsonProperty(value="x-mathContext")
    private MathContext mathContext;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    @XmlElement(name="MiningSchema", namespace="http://www.dmg.org/PMML-4_3", required=true)
    @JsonProperty(value="MiningSchema")
    private MiningSchema miningSchema;
    @XmlElement(name="Output", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Output")
    private Output output;
    @XmlElement(name="ModelStats", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="ModelStats")
    private ModelStats modelStats;
    @XmlElement(name="ModelExplanation", namespace="http://www.dmg.org/PMML-4_3")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="ModelExplanation")
    private ModelExplanation modelExplanation;
    @XmlElement(name="Targets", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Targets")
    private Targets targets;
    @XmlElement(name="LocalTransformations", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="LocalTransformations")
    private LocalTransformations localTransformations;
    @XmlElements(value={@XmlElement(name="Regression", namespace="http://www.dmg.org/PMML-4_3", type=Regression.class), @XmlElement(name="DecisionTree", namespace="http://www.dmg.org/PMML-4_3", type=DecisionTree.class)})
    @Deprecated(value=Version.PMML_4_1)
    @Optional(value=Version.PMML_4_0)
    @JsonProperty(value="EmbeddedModel")
    @JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
    @JsonSubTypes(value={@JsonSubTypes.Type(name="Regression", value=Regression.class), @JsonSubTypes.Type(name="DecisionTree", value=DecisionTree.class)})
    private List<EmbeddedModel> embeddedModels;
    @XmlElement(name="Segmentation", namespace="http://www.dmg.org/PMML-4_3")
    @Added(value=Version.PMML_4_0)
    @JsonProperty(value="Segmentation")
    private Segmentation segmentation;
    @XmlElement(name="ModelVerification", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="ModelVerification")
    private ModelVerification modelVerification;
    private static final Boolean DEFAULT_SCORABLE = true;
    private static final long serialVersionUID = 67305485L;

    public MiningModel() {
    }

    public MiningModel(@Property(value="miningFunction") MiningFunction miningFunction, @Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningFunction = miningFunction;
        this.miningSchema = miningSchema;
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public MiningModel setModelName(@Property(value="modelName") String modelName) {
        this.modelName = modelName;
        return this;
    }

    @Override
    public MiningFunction getMiningFunction() {
        return this.miningFunction;
    }

    @Override
    public MiningModel setMiningFunction(@Property(value="miningFunction") MiningFunction miningFunction) {
        this.miningFunction = miningFunction;
        return this;
    }

    @Override
    public String getAlgorithmName() {
        return this.algorithmName;
    }

    @Override
    public MiningModel setAlgorithmName(@Property(value="algorithmName") String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    @Override
    public boolean isScorable() {
        if (this.scorable == null) {
            return DEFAULT_SCORABLE;
        }
        return this.scorable;
    }

    @Override
    public MiningModel setScorable(@Property(value="scorable") Boolean scorable) {
        this.scorable = scorable;
        return this;
    }

    @Override
    public MathContext getMathContext() {
        if (this.mathContext == null) {
            return MathContext.DOUBLE;
        }
        return this.mathContext;
    }

    @Override
    public MiningModel setMathContext(@Property(value="mathContext") MathContext mathContext) {
        this.mathContext = mathContext;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public MiningModel addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public MiningSchema getMiningSchema() {
        return this.miningSchema;
    }

    @Override
    public MiningModel setMiningSchema(@Property(value="miningSchema") MiningSchema miningSchema) {
        this.miningSchema = miningSchema;
        return this;
    }

    @Override
    public Output getOutput() {
        return this.output;
    }

    @Override
    public MiningModel setOutput(@Property(value="output") Output output) {
        this.output = output;
        return this;
    }

    @Override
    public ModelStats getModelStats() {
        return this.modelStats;
    }

    @Override
    public MiningModel setModelStats(@Property(value="modelStats") ModelStats modelStats) {
        this.modelStats = modelStats;
        return this;
    }

    @Override
    public ModelExplanation getModelExplanation() {
        return this.modelExplanation;
    }

    @Override
    public MiningModel setModelExplanation(@Property(value="modelExplanation") ModelExplanation modelExplanation) {
        this.modelExplanation = modelExplanation;
        return this;
    }

    @Override
    public Targets getTargets() {
        return this.targets;
    }

    @Override
    public MiningModel setTargets(@Property(value="targets") Targets targets) {
        this.targets = targets;
        return this;
    }

    @Override
    public LocalTransformations getLocalTransformations() {
        return this.localTransformations;
    }

    @Override
    public MiningModel setLocalTransformations(@Property(value="localTransformations") LocalTransformations localTransformations) {
        this.localTransformations = localTransformations;
        return this;
    }

    public boolean hasEmbeddedModels() {
        return this.embeddedModels != null && this.embeddedModels.size() > 0;
    }

    public List<EmbeddedModel> getEmbeddedModels() {
        if (this.embeddedModels == null) {
            this.embeddedModels = new ArrayList<EmbeddedModel>();
        }
        return this.embeddedModels;
    }

    public MiningModel addEmbeddedModels(EmbeddedModel ... embeddedModels) {
        this.getEmbeddedModels().addAll(Arrays.asList(embeddedModels));
        return this;
    }

    public Segmentation getSegmentation() {
        return this.segmentation;
    }

    public MiningModel setSegmentation(@Property(value="segmentation") Segmentation segmentation) {
        this.segmentation = segmentation;
        return this;
    }

    @Override
    public ModelVerification getModelVerification() {
        return this.modelVerification;
    }

    @Override
    public MiningModel setModelVerification(@Property(value="modelVerification") ModelVerification modelVerification) {
        this.modelVerification = modelVerification;
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, this.getMiningSchema(), this.getOutput(), this.getModelStats(), this.getModelExplanation(), this.getTargets(), this.getLocalTransformations());
            }
            if (status == VisitorAction.CONTINUE && this.hasEmbeddedModels()) {
                status = PMMLObject.traverse(visitor, this.getEmbeddedModels());
            }
            if (status == VisitorAction.CONTINUE) {
                status = PMMLObject.traverse(visitor, (Visitable)this.getSegmentation(), (Visitable)this.getModelVerification());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }
}

