/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.FieldName;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.HasFieldReference;
import org.spark_project.dmg.pmml.HasValue;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.Predicate;
import org.spark_project.dmg.pmml.StringValue;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;
import org.spark_project.dmg.pmml.adapters.FieldNameAdapter;
import org.spark_project.jpmml.model.annotations.Property;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="SimplePredicate", namespace="http://www.dmg.org/PMML-4_3")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonPropertyOrder(value={"field", "operator", "value", "extensions"})
public class SimplePredicate
extends Predicate
implements HasExtensions<SimplePredicate>,
HasFieldReference<SimplePredicate>,
HasValue<SimplePredicate> {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    @JsonProperty(value="field")
    private FieldName field;
    @XmlAttribute(name="operator", required=true)
    @JsonProperty(value="operator")
    private Operator operator;
    @XmlAttribute(name="value")
    @JsonProperty(value="value")
    private String value;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    @JsonProperty(value="Extension")
    private List<Extension> extensions;
    private static final long serialVersionUID = 67305485L;

    public SimplePredicate() {
    }

    public SimplePredicate(@Property(value="field") FieldName field, @Property(value="operator") Operator operator) {
        this.field = field;
        this.operator = operator;
    }

    @Override
    public FieldName getField() {
        return this.field;
    }

    @Override
    public SimplePredicate setField(@Property(value="field") FieldName field) {
        this.field = field;
        return this;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public SimplePredicate setOperator(@Property(value="operator") Operator operator) {
        this.operator = operator;
        return this;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public SimplePredicate setValue(@Property(value="value") String value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public SimplePredicate addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Operator implements StringValue<Operator>
    {
        EQUAL("equal"),
        NOT_EQUAL("notEqual"),
        LESS_THAN("lessThan"),
        LESS_OR_EQUAL("lessOrEqual"),
        GREATER_THAN("greaterThan"),
        GREATER_OR_EQUAL("greaterOrEqual"),
        IS_MISSING("isMissing"),
        IS_NOT_MISSING("isNotMissing");

        private final String value;

        private Operator(String v) {
            this.value = v;
        }

        @Override
        public String value() {
            return this.value;
        }

        public static Operator fromValue(String v) {
            for (Operator c : Operator.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }

        public String toString() {
            return this.value();
        }
    }
}

