/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.stat.distribution;

import org.apache.spark.ml.SparkMLFunSuite;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.stat.distribution.MultivariateGaussian;
import org.apache.spark.ml.util.TestingUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001e1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\tIR*\u001e7uSZ\f'/[1uK\u001e\u000bWo]:jC:\u001cV/\u001b;f\u0015\t!Q!\u0001\u0007eSN$(/\u001b2vi&|gN\u0003\u0002\u0007\u000f\u0005!1\u000f^1u\u0015\tA\u0011\"\u0001\u0002nY*\u0011!bC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00195\ta!\u00199bG\",'\"\u0001\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0014\u001b\u00059\u0011B\u0001\u000b\b\u0005=\u0019\u0006/\u0019:l\u001b23UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0004\u0001")
public class MultivariateGaussianSuite
extends SparkMLFunSuite {
    public MultivariateGaussianSuite() {
        this.test("univariate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            Vector x1 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
            Vector x2 = Vectors$.MODULE$.dense(1.5, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
            Vector mu = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[0]));
            Matrix sigma1 = Matrices$.MODULE$.dense(1, 1, new double[]{1.0});
            MultivariateGaussian dist1 = new MultivariateGaussian(mu, sigma1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist1.logpdf(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(-0.9189385332046727).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist1.logpdf(x1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(-0.9189385332046727).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist1.logpdf(x2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(-2.0439385332046727).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist1.logpdf(x2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(-2.0439385332046727).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist1.pdf(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.39894).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist1.pdf(x1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.39894).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist1.pdf(x2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.12952).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist1.pdf(x2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.12952).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            Matrix sigma2 = Matrices$.MODULE$.dense(1, 1, new double[]{4.0});
            MultivariateGaussian dist2 = new MultivariateGaussian(mu, sigma2);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist2.logpdf(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(-1.612085713764618).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist2.logpdf(x1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(-1.612085713764618).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist2.logpdf(x2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(-1.893335713764618).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist2.logpdf(x2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(-1.893335713764618).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist2.pdf(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.19947).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist2.pdf(x1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.19947).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist2.pdf(x2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.15057).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist2.pdf(x2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.15057).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
        }, new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
        this.test("multivariate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            Vector x1 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
            Vector x2 = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}));
            Vector mu = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
            Matrix sigma1 = Matrices$.MODULE$.dense(2, 2, new double[]{1.0, 0.0, 0.0, 1.0});
            MultivariateGaussian dist1 = new MultivariateGaussian(mu, sigma1);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist1.logpdf(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(-1.8378770664093453).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist1.logpdf(x1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(-1.8378770664093453).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist1.logpdf(x2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(-2.8378770664093453).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist1.logpdf(x2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(-2.8378770664093453).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist1.pdf(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.15915).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist1.pdf(x1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.15915).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist1.pdf(x2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.05855).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist1.pdf(x2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.05855).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            Matrix sigma2 = Matrices$.MODULE$.dense(2, 2, new double[]{4.0, -1.0, -1.0, 2.0});
            MultivariateGaussian dist2 = new MultivariateGaussian(mu, sigma2);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist2.logpdf(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(-2.810832140937002).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist2.logpdf(x1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(-2.810832140937002).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist2.logpdf(x2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(-3.3822607123655732).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist2.logpdf(x2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(-3.3822607123655732).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist2.pdf(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.060155).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist2.pdf(x1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.060155).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 63));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist2.pdf(x2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.033971).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist2.pdf(x2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.033971).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        }, new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("multivariate degenerate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            Vector x1 = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
            Vector x2 = Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0}));
            Vector mu = Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0}));
            Matrix sigma = Matrices$.MODULE$.dense(2, 2, new double[]{1.0, 1.0, 1.0, 1.0});
            MultivariateGaussian dist = new MultivariateGaussian(mu, sigma);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist.pdf(x1)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.11254).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist.pdf(x1)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.11254).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist.pdf(x2)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(0.068259).absTol(1.0E-5)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist.pdf(x2)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(0.068259).absTol(1.0E-5))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
        }, new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("SPARK-11302", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & java.io.Serializable & Serializable)() -> {
            Vector x = Vectors$.MODULE$.dense(629.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{640.0, 1.7188, 618.19}));
            Vector mu = Vectors$.MODULE$.dense(1055.3910505836575, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1070.489299610895, 1.39020554474708, 1040.5907503867697}));
            Matrix sigma = Matrices$.MODULE$.dense(4, 4, new double[]{166769.00466698944, 169336.6705268059, 12.820670788921873, 164243.93314092053, 169336.6705268059, 172041.5670061245, 21.62590020524533, 166678.01075856484, 12.820670788921873, 21.62590020524533, 0.872524191943962, 4.283255814732373, 164243.93314092053, 166678.01075856484, 4.283255814732373, 161848.9196719207});
            MultivariateGaussian dist = new MultivariateGaussian(mu, sigma);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.DoubleWithAlmostEquals(dist.pdf(x)).$tilde$eq$eq(TestingUtils$.MODULE$.DoubleWithAlmostEquals(7.154782224045512E-5).absTol(1.0E-9)), "org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(dist.pdf(x)).~==(org.apache.spark.ml.util.TestingUtils.DoubleWithAlmostEquals(7.154782224045512E-5).absTol(1.0E-9))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        }, new Position("MultivariateGaussianSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
    }
}

