/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import breeze.generic.UFunc;
import breeze.linalg.CSCMatrix;
import breeze.linalg.Matrix$;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Random;
import org.apache.spark.ml.SparkMLFunSuite;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.ml.linalg.SparseMatrix$;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.TestingUtils$;
import org.mockito.Mockito;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatestplus.mockito.MockitoSugar$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001]1AAA\u0002\u0001\u001d!)1\u0003\u0001C\u0001)\tiQ*\u0019;sS\u000e,7oU;ji\u0016T!\u0001B\u0003\u0002\r1Lg.\u00197h\u0015\t1q!\u0001\u0002nY*\u0011\u0001\"C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0015-\ta!\u00199bG\",'\"\u0001\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001y\u0001C\u0001\t\u0012\u001b\u0005)\u0011B\u0001\n\u0006\u0005=\u0019\u0006/\u0019:l\u001b23UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0004\u0001")
public class MatricesSuite
extends SparkMLFunSuite {
    public static final /* synthetic */ boolean $anonfun$new$60(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).size() <= 50;
    }

    public static final /* synthetic */ boolean $anonfun$new$62(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).size() <= 100;
    }

    public MatricesSuite() {
        this.test("dense matrix construction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int m = 3;
            int n = 2;
            double[] values = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
            DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.dense(m, n, values);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = m;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = n;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
            double[] $org_scalatest_assert_macro_left3 = mat.values();
            double[] $org_scalatest_assert_macro_right3 = values;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "eq", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"should not copy data", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 38));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("dense matrix construction with wrong dimension", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (RuntimeException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Matrices$.MODULE$.dense(3, 2, new double[]{0.0, 1.0, 2.0}), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 42)), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 41));
        this.test("sparse matrix construction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int m = 3;
            int n = 4;
            double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
            int[] colPtrs = new int[]{0, 2, 2, 4, 4};
            int[] rowIndices = new int[]{1, 2, 1, 2};
            SparseMatrix mat = (SparseMatrix)Matrices$.MODULE$.sparse(m, n, colPtrs, rowIndices, values);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = m;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = n;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            double[] $org_scalatest_assert_macro_left3 = mat.values();
            double[] $org_scalatest_assert_macro_right3 = values;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "eq", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"should not copy data", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            int[] $org_scalatest_assert_macro_left4 = mat.colPtrs();
            int[] $org_scalatest_assert_macro_right4 = colPtrs;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "eq", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"should not copy data", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            int[] $org_scalatest_assert_macro_left5 = mat.rowIndices();
            int[] $org_scalatest_assert_macro_right5 = rowIndices;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "eq", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"should not copy data", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
            Tuple3[] entries = (Tuple3[])((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)3.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)1.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)2), (Object)BoxesRunTime.boxToDouble((double)2.0)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToDouble((double)0.0))});
            SparseMatrix mat2 = SparseMatrix$.MODULE$.fromCOO(m, n, (Iterable)Predef$.MODULE$.wrapRefArray((Object[])entries));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(mat.asBreeze());
            breeze.linalg.Matrix $org_scalatest_assert_macro_right6 = mat2.asBreeze();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            double[] $org_scalatest_assert_macro_left7 = mat2.values();
            int $org_scalatest_assert_macro_right7 = 4;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left7, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        this.test("sparse matrix construction with wrong number of elements", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Matrices$.MODULE$.sparse(3, 2, new int[]{0, 1}, new int[]{1, 2, 1}, new double[]{0.0, 1.0, 2.0}), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Matrices$.MODULE$.sparse(3, 2, new int[]{0, 1, 2}, new int[]{1, 2}, new double[]{0.0, 1.0, 2.0}), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("index in matrices incorrect input", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Matrix sm = Matrices$.MODULE$.sparse(3, 2, new int[]{0, 2, 3}, new int[]{1, 2, 1}, new double[]{0.0, 1.0, 2.0});
            Matrix dm = Matrices$.MODULE$.dense(3, 2, new double[]{0.0, 2.3, 1.4, 3.2, 1.0, 9.1});
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Matrix[]{sm, dm})).foreach((Function1 & Serializable & scala.Serializable)mat -> {
                this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> mat.index(4, 1), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
                this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> mat.index(1, 4), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
                this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> mat.index(-1, 2), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
                return (IllegalArgumentException)this.intercept((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> mat.index(1, -2), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            });
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("equals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Matrix dm1 = Matrices$.MODULE$.dense(2, 2, new double[]{0.0, 1.0, 2.0, 3.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dm1);
            Matrix $org_scalatest_assert_macro_right = dm1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(dm1);
            Matrix $org_scalatest_assert_macro_right2 = dm1.transpose();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "!==", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$bang$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
            Matrix dm2 = Matrices$.MODULE$.dense(2, 2, new double[]{0.0, 2.0, 1.0, 3.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(dm1);
            Matrix $org_scalatest_assert_macro_right3 = dm2.transpose();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            SparseMatrix sm1 = ((DenseMatrix)dm1).toSparse();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(sm1);
            SparseMatrix $org_scalatest_assert_macro_right4 = sm1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(sm1);
            Matrix $org_scalatest_assert_macro_right5 = dm1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(sm1);
            SparseMatrix $org_scalatest_assert_macro_right6 = sm1.transpose();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "!==", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$bang$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            SparseMatrix sm2 = ((DenseMatrix)dm2).toSparse();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(sm1);
            SparseMatrix $org_scalatest_assert_macro_right7 = sm2.transpose();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(sm1);
            Matrix $org_scalatest_assert_macro_right8 = dm2.transpose();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("matrix copies are deep copies", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            double[] $org_scalatest_assert_macro_right;
            double[] $org_scalatest_assert_macro_left;
            int m = 3;
            int n = 2;
            Matrix denseMat = Matrices$.MODULE$.dense(m, n, new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0});
            Matrix denseCopy = denseMat.copy();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "eq", (Object)$org_scalatest_assert_macro_right, ($org_scalatest_assert_macro_left = denseMat.toArray()) == ($org_scalatest_assert_macro_right = denseCopy.toArray()), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
            int[] colPtrs = new int[]{0, 2, 4};
            int[] rowIndices = new int[]{1, 2, 1, 2};
            Matrix sparseMat = Matrices$.MODULE$.sparse(m, n, colPtrs, rowIndices, values);
            Matrix sparseCopy = sparseMat.copy();
            double[] $org_scalatest_assert_macro_left2 = sparseMat.toArray();
            double[] $org_scalatest_assert_macro_right2 = sparseCopy.toArray();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "eq", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("matrix indexing and updating", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int m = 3;
            int n = 2;
            double[] allValues = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 0.0};
            DenseMatrix denseMat = new DenseMatrix(m, n, allValues);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.apply(0, 1)));
            double $org_scalatest_assert_macro_right = 3.0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.apply(0, 1)));
            double $org_scalatest_assert_macro_right2 = denseMat.values()[3];
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.apply(0, 1)));
            double $org_scalatest_assert_macro_right3 = denseMat.apply(3);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.apply(0, 0)));
            double $org_scalatest_assert_macro_right4 = 0.0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            denseMat.update(0, 0, 10.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.apply(0, 0)));
            double $org_scalatest_assert_macro_right5 = 10.0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)denseMat.values()[0]));
            double $org_scalatest_assert_macro_right6 = 10.0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            double[] sparseValues = new double[]{1.0, 2.0, 3.0, 4.0};
            int[] colPtrs = new int[]{0, 2, 4};
            int[] rowIndices = new int[]{1, 2, 0, 1};
            SparseMatrix sparseMat = new SparseMatrix(m, n, colPtrs, rowIndices, sparseValues);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sparseMat.apply(0, 1)));
            double $org_scalatest_assert_macro_right7 = 3.0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sparseMat.apply(0, 1)));
            double $org_scalatest_assert_macro_right8 = sparseMat.values()[2];
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sparseMat.apply(0, 0)));
            double $org_scalatest_assert_macro_right9 = 0.0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> sparseMat.update(0, 0, 10.0), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> sparseMat.update(2, 1, 10.0), ClassTag$.MODULE$.apply(NoSuchElementException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            sparseMat.update(0, 1, 10.0);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sparseMat.apply(0, 1)));
            double $org_scalatest_assert_macro_right10 = 10.0;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sparseMat.values()[2]));
            double $org_scalatest_assert_macro_right11 = 10.0;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        this.test("dense to dense", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseMatrix dm1 = new DenseMatrix(2, 3, new double[]{4.0, -1.0, 2.0, 7.0, -8.0, 4.0});
            DenseMatrix dm2 = new DenseMatrix(2, 3, new double[]{5.0, -9.0, 4.0, 1.0, -3.0, -8.0}, true);
            DenseMatrix dm8 = dm1.toDenseColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dm8);
            DenseMatrix $org_scalatest_assert_macro_right = dm1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(dm8.isColMajor(), "dm8.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(dm8.values().equals(dm1.values()), "dm8.values.equals(dm1.values)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            DenseMatrix dm5 = dm2.toDenseColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(dm5);
            DenseMatrix $org_scalatest_assert_macro_right2 = dm2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(dm5.isColMajor(), "dm5.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(dm5.values());
            double[] $org_scalatest_assert_macro_right3 = new double[]{5.0, 1.0, -9.0, -3.0, 4.0, -8.0};
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            DenseMatrix dm4 = dm1.toDenseRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(dm4);
            DenseMatrix $org_scalatest_assert_macro_right4 = dm1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(dm4.isRowMajor(), "dm4.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(dm4.values());
            double[] $org_scalatest_assert_macro_right5 = new double[]{4.0, 2.0, -8.0, -1.0, 7.0, 4.0};
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            DenseMatrix dm6 = dm2.toDenseRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(dm6);
            DenseMatrix $org_scalatest_assert_macro_right6 = dm2;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(dm6.isRowMajor(), "dm6.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(dm6.values().equals(dm2.values()), "dm6.values.equals(dm2.values)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            DenseMatrix dm3 = dm1.toDense();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(dm3);
            DenseMatrix $org_scalatest_assert_macro_right7 = dm1;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(dm3.isColMajor(), "dm3.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(dm3.values().equals(dm1.values()), "dm3.values.equals(dm1.values)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
            DenseMatrix dm9 = dm2.toDense();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(dm9);
            DenseMatrix $org_scalatest_assert_macro_right8 = dm2;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(dm9.isRowMajor(), "dm9.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(dm9.values().equals(dm2.values()), "dm9.values.equals(dm2.values)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        this.test("dense to sparse", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseMatrix dm1 = new DenseMatrix(2, 3, new double[]{0.0, 0.0, 4.0, 2.0, 5.0, 0.0});
            DenseMatrix dm2 = new DenseMatrix(2, 3, new double[]{0.0, 4.0, 5.0, 0.0, 2.0, 0.0}, true);
            DenseMatrix dm3 = new DenseMatrix(2, 3, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
            SparseMatrix sm1 = dm1.toSparseColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(sm1);
            DenseMatrix $org_scalatest_assert_macro_right = dm1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(sm1.isColMajor(), "sm1.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(sm1.values());
            double[] $org_scalatest_assert_macro_right2 = new double[]{4.0, 2.0, 5.0};
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            SparseMatrix sm3 = dm2.toSparseColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(sm3);
            DenseMatrix $org_scalatest_assert_macro_right3 = dm2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(sm3.isColMajor(), "sm3.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(sm3.values());
            double[] $org_scalatest_assert_macro_right4 = new double[]{4.0, 2.0, 5.0};
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
            SparseMatrix sm5 = dm3.toSparseColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(sm5);
            DenseMatrix $org_scalatest_assert_macro_right5 = dm3;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(sm5.values());
            double[] $org_scalatest_assert_macro_right6 = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(sm5.isColMajor(), "sm5.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            SparseMatrix sm2 = dm1.toSparseRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(sm2);
            DenseMatrix $org_scalatest_assert_macro_right7 = dm1;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(sm2.isRowMajor(), "sm2.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(sm2.values());
            double[] $org_scalatest_assert_macro_right8 = new double[]{4.0, 5.0, 2.0};
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            SparseMatrix sm4 = dm2.toSparseRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(sm4);
            DenseMatrix $org_scalatest_assert_macro_right9 = dm2;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(sm4.isRowMajor(), "sm4.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(sm4.values());
            double[] $org_scalatest_assert_macro_right10 = new double[]{4.0, 5.0, 2.0};
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
            SparseMatrix sm6 = dm3.toSparseRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(sm6);
            DenseMatrix $org_scalatest_assert_macro_right11 = dm3;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(sm6.values());
            double[] $org_scalatest_assert_macro_right12 = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(sm6.isRowMajor(), "sm6.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 248));
            SparseMatrix sm7 = dm1.toSparse();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(sm7);
            DenseMatrix $org_scalatest_assert_macro_right13 = dm1;
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(sm7.values());
            double[] $org_scalatest_assert_macro_right14 = new double[]{4.0, 2.0, 5.0};
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right14, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(sm7.isColMajor(), "sm7.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
            SparseMatrix sm10 = dm2.toSparse();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(sm10);
            DenseMatrix $org_scalatest_assert_macro_right15 = dm2;
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)$org_scalatest_assert_macro_right15, $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)$org_scalatest_assert_macro_right15, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.convertToEqualizer(sm10.values());
            double[] $org_scalatest_assert_macro_right16 = new double[]{4.0, 5.0, 2.0};
            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)$org_scalatest_assert_macro_right16, $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)$org_scalatest_assert_macro_right16, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.simpleMacroBool(sm10.isRowMajor(), "sm10.isRowMajor", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
        this.test("sparse to sparse", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparseMatrix sm1 = new SparseMatrix(2, 3, new int[]{0, 0, 2, 3}, new int[]{0, 1, 0}, new double[]{4.0, 2.0, 5.0});
            SparseMatrix sm2 = new SparseMatrix(2, 3, new int[]{0, 2, 3}, new int[]{1, 2, 1}, new double[]{4.0, 5.0, 2.0}, true);
            SparseMatrix sm3 = new SparseMatrix(2, 3, new int[]{0, 0, 2, 4}, new int[]{0, 1, 0, 1}, new double[]{4.0, 2.0, 5.0, 0.0});
            SparseMatrix sm4 = new SparseMatrix(2, 3, new int[]{0, 2, 4}, new int[]{1, 2, 1, 2}, new double[]{4.0, 5.0, 2.0, 0.0}, true);
            SparseMatrix smZeros = new SparseMatrix(2, 3, new int[]{0, 2, 4, 6}, new int[]{0, 1, 0, 1, 0, 1}, new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0});
            SparseMatrix sm6 = sm1.toSparseColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(sm6);
            SparseMatrix $org_scalatest_assert_macro_right = sm1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(sm6.isColMajor(), "sm6.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(sm6.values().equals(sm1.values()), "sm6.values.equals(sm1.values)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            SparseMatrix sm7 = sm2.toSparseColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(sm7);
            SparseMatrix $org_scalatest_assert_macro_right2 = sm2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(sm7.isColMajor(), "sm7.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 285));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(sm7.values());
            double[] $org_scalatest_assert_macro_right3 = new double[]{4.0, 2.0, 5.0};
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 286));
            SparseMatrix sm16 = sm3.toSparseColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(sm16);
            SparseMatrix $org_scalatest_assert_macro_right4 = sm3;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(sm16.isColMajor(), "sm16.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(sm16.values());
            double[] $org_scalatest_assert_macro_right5 = new double[]{4.0, 2.0, 5.0};
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
            SparseMatrix sm14 = sm4.toSparseColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(sm14);
            SparseMatrix $org_scalatest_assert_macro_right6 = sm4;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(sm14.values());
            double[] $org_scalatest_assert_macro_right7 = new double[]{4.0, 2.0, 5.0};
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(sm14.isColMajor(), "sm14.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
            SparseMatrix sm15 = smZeros.toSparseColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(sm15);
            SparseMatrix $org_scalatest_assert_macro_right8 = smZeros;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(sm15.values());
            double[] $org_scalatest_assert_macro_right9 = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(sm15.isColMajor(), "sm15.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
            SparseMatrix sm5 = sm1.toSparseRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(sm5);
            SparseMatrix $org_scalatest_assert_macro_right10 = sm1;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(sm5.isRowMajor(), "sm5.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 305));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(sm5.values());
            double[] $org_scalatest_assert_macro_right11 = new double[]{4.0, 5.0, 2.0};
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
            SparseMatrix sm8 = sm2.toSparseRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(sm8);
            SparseMatrix $org_scalatest_assert_macro_right12 = sm2;
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(sm8.isRowMajor(), "sm8.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(sm8.values().equals(sm2.values()), "sm8.values.equals(sm2.values)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
            SparseMatrix sm10 = sm3.toSparseRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(sm10);
            SparseMatrix $org_scalatest_assert_macro_right13 = sm3;
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(sm10.values());
            double[] $org_scalatest_assert_macro_right14 = new double[]{4.0, 5.0, 2.0};
            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right14, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
            Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.simpleMacroBool(sm10.isRowMajor(), "sm10.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
            SparseMatrix sm11 = sm4.toSparseRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(sm11);
            SparseMatrix $org_scalatest_assert_macro_right15 = sm4;
            Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)$org_scalatest_assert_macro_right15, $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)$org_scalatest_assert_macro_right15, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.convertToEqualizer(sm11.values());
            double[] $org_scalatest_assert_macro_right16 = new double[]{4.0, 5.0, 2.0};
            Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)$org_scalatest_assert_macro_right16, $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)$org_scalatest_assert_macro_right16, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
            Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.simpleMacroBool(sm11.isRowMajor(), "sm11.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
            SparseMatrix sm17 = smZeros.toSparseRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.convertToEqualizer(sm17);
            SparseMatrix $org_scalatest_assert_macro_right17 = smZeros;
            Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)$org_scalatest_assert_macro_right17, $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)$org_scalatest_assert_macro_right17, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = this.convertToEqualizer(sm17.values());
            double[] $org_scalatest_assert_macro_right18 = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
            Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)$org_scalatest_assert_macro_right18, $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)$org_scalatest_assert_macro_right18, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
            Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.simpleMacroBool(sm17.isRowMajor(), "sm17.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
            SparseMatrix sm9 = sm3.toSparse();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left19 = this.convertToEqualizer(sm9);
            SparseMatrix $org_scalatest_assert_macro_right19 = sm3;
            Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "===", (Object)$org_scalatest_assert_macro_right19, $org_scalatest_assert_macro_left19.$eq$eq$eq((Object)$org_scalatest_assert_macro_right19, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left20 = this.convertToEqualizer(sm9.values());
            double[] $org_scalatest_assert_macro_right20 = new double[]{4.0, 2.0, 5.0};
            Bool $org_scalatest_assert_macro_expr32 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left20, "===", (Object)$org_scalatest_assert_macro_right20, $org_scalatest_assert_macro_left20.$eq$eq$eq((Object)$org_scalatest_assert_macro_right20, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr32, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
            Bool $org_scalatest_assert_macro_expr33 = Bool$.MODULE$.simpleMacroBool(sm9.isColMajor(), "sm9.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr33, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
            SparseMatrix sm12 = sm4.toSparse();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left21 = this.convertToEqualizer(sm12);
            SparseMatrix $org_scalatest_assert_macro_right21 = sm4;
            Bool $org_scalatest_assert_macro_expr34 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "===", (Object)$org_scalatest_assert_macro_right21, $org_scalatest_assert_macro_left21.$eq$eq$eq((Object)$org_scalatest_assert_macro_right21, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr34, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left22 = this.convertToEqualizer(sm12.values());
            double[] $org_scalatest_assert_macro_right22 = new double[]{4.0, 5.0, 2.0};
            Bool $org_scalatest_assert_macro_expr35 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left22, "===", (Object)$org_scalatest_assert_macro_right22, $org_scalatest_assert_macro_left22.$eq$eq$eq((Object)$org_scalatest_assert_macro_right22, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr35, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
            Bool $org_scalatest_assert_macro_expr36 = Bool$.MODULE$.simpleMacroBool(sm12.isRowMajor(), "sm12.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr36, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
            SparseMatrix sm13 = smZeros.toSparse();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left23 = this.convertToEqualizer(sm13);
            SparseMatrix $org_scalatest_assert_macro_right23 = smZeros;
            Bool $org_scalatest_assert_macro_expr37 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left23, "===", (Object)$org_scalatest_assert_macro_right23, $org_scalatest_assert_macro_left23.$eq$eq$eq((Object)$org_scalatest_assert_macro_right23, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr37, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left24 = this.convertToEqualizer(sm13.values());
            double[] $org_scalatest_assert_macro_right24 = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
            Bool $org_scalatest_assert_macro_expr38 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left24, "===", (Object)$org_scalatest_assert_macro_right24, $org_scalatest_assert_macro_left24.$eq$eq$eq((Object)$org_scalatest_assert_macro_right24, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr38, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
            Bool $org_scalatest_assert_macro_expr39 = Bool$.MODULE$.simpleMacroBool(sm13.isColMajor(), "sm13.isColMajor", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr39, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 341));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        this.test("sparse to dense", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparseMatrix sm1 = new SparseMatrix(2, 3, new int[]{0, 0, 2, 3}, new int[]{0, 1, 0}, new double[]{4.0, 2.0, 5.0});
            SparseMatrix sm2 = new SparseMatrix(2, 3, new int[]{0, 2, 3}, new int[]{1, 2, 1}, new double[]{4.0, 5.0, 2.0}, true);
            SparseMatrix sm3 = new SparseMatrix(2, 3, new int[]{0, 0, 0, 0}, (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()));
            DenseMatrix dm6 = sm1.toDenseColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dm6);
            SparseMatrix $org_scalatest_assert_macro_right = sm1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(dm6.isColMajor(), "dm6.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(dm6.values());
            double[] $org_scalatest_assert_macro_right2 = new double[]{0.0, 0.0, 4.0, 2.0, 5.0, 0.0};
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 360));
            DenseMatrix dm7 = sm2.toDenseColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(dm7);
            SparseMatrix $org_scalatest_assert_macro_right3 = sm2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(dm7.isColMajor(), "dm7.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 364));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(dm7.values());
            double[] $org_scalatest_assert_macro_right4 = new double[]{0.0, 0.0, 4.0, 2.0, 5.0, 0.0};
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
            DenseMatrix dm2 = sm1.toDenseRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(dm2);
            SparseMatrix $org_scalatest_assert_macro_right5 = sm1;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(dm2.isRowMajor(), "dm2.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(dm2.values());
            double[] $org_scalatest_assert_macro_right6 = new double[]{0.0, 4.0, 5.0, 0.0, 2.0, 0.0};
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
            DenseMatrix dm4 = sm2.toDenseRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(dm4);
            SparseMatrix $org_scalatest_assert_macro_right7 = sm2;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(dm4.isRowMajor(), "dm4.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(dm4.values());
            double[] $org_scalatest_assert_macro_right8 = new double[]{0.0, 4.0, 5.0, 0.0, 2.0, 0.0};
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
            DenseMatrix dm1 = sm1.toDense();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(dm1);
            SparseMatrix $org_scalatest_assert_macro_right9 = sm1;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 378));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(dm1.isColMajor(), "dm1.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 379));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(dm1.values());
            double[] $org_scalatest_assert_macro_right10 = new double[]{0.0, 0.0, 4.0, 2.0, 5.0, 0.0};
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            DenseMatrix dm3 = sm2.toDense();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(dm3);
            SparseMatrix $org_scalatest_assert_macro_right11 = sm2;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 383));
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(dm3.isRowMajor(), "dm3.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 384));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(dm3.values());
            double[] $org_scalatest_assert_macro_right12 = new double[]{0.0, 4.0, 5.0, 0.0, 2.0, 0.0};
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)$org_scalatest_assert_macro_right12, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
            DenseMatrix dm5 = sm3.toDense();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(dm5);
            SparseMatrix $org_scalatest_assert_macro_right13 = sm3;
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.simpleMacroBool(dm5.isColMajor(), "dm5.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(dm5.values());
            double[] $org_scalatest_assert_macro_right14 = (double[])Array$.MODULE$.fill(6, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)$org_scalatest_assert_macro_right14, $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)$org_scalatest_assert_macro_right14, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 390));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        this.test("compressed dense", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseMatrix dm1 = new DenseMatrix(3, 4, (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Array$.MODULE$.fill(2, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()))).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Array$.MODULE$.fill(10, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            SparseMatrix cm1 = (SparseMatrix)dm1.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(cm1);
            DenseMatrix $org_scalatest_assert_macro_right = dm1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(cm1.isRowMajor(), "cm1.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
            long $org_scalatest_assert_macro_left2 = cm1.getSizeInBytes();
            long $org_scalatest_assert_macro_right2 = dm1.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
            SparseMatrix cm2 = (SparseMatrix)dm1.compressedColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(cm2);
            DenseMatrix $org_scalatest_assert_macro_right3 = dm1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(cm2.isColMajor(), "cm2.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
            long $org_scalatest_assert_macro_left4 = cm2.getSizeInBytes();
            long $org_scalatest_assert_macro_right4 = dm1.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
            DenseMatrix dm2 = dm1.transpose();
            SparseMatrix cm3 = (SparseMatrix)dm2.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(cm3);
            DenseMatrix $org_scalatest_assert_macro_right5 = dm2;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 421));
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(cm3.isColMajor(), "cm3.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
            long $org_scalatest_assert_macro_left6 = cm3.getSizeInBytes();
            long $org_scalatest_assert_macro_right6 = dm2.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "<", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 < $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
            DenseMatrix dm3 = new DenseMatrix(3, 4, (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Array$.MODULE$.fill(7, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()))).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Array$.MODULE$.fill(5, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            DenseMatrix dm4 = new DenseMatrix(3, 4, (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Array$.MODULE$.fill(7, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()))).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Array$.MODULE$.fill(5, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), true);
            DenseMatrix cm4 = (DenseMatrix)dm3.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(cm4);
            DenseMatrix $org_scalatest_assert_macro_right7 = dm3;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)$org_scalatest_assert_macro_right7, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(cm4.isColMajor(), "cm4.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 440));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(cm4.values().equals(dm3.values()), "cm4.values.equals(dm3.values)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cm4.getSizeInBytes()));
            long $org_scalatest_assert_macro_right8 = dm3.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
            DenseMatrix cm5 = (DenseMatrix)dm3.compressedRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(cm5);
            DenseMatrix $org_scalatest_assert_macro_right9 = dm3;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(cm5.isRowMajor(), "cm5.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cm5.getSizeInBytes()));
            long $org_scalatest_assert_macro_right10 = dm3.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
            DenseMatrix cm6 = (DenseMatrix)dm4.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(cm6);
            DenseMatrix $org_scalatest_assert_macro_right11 = dm4;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)$org_scalatest_assert_macro_right11, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(cm6.isRowMajor(), "cm6.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.simpleMacroBool(cm6.values().equals(dm4.values()), "cm6.values.equals(dm4.values)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 453));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cm6.getSizeInBytes()));
            long $org_scalatest_assert_macro_right12 = dm4.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 454));
            DenseMatrix cm7 = (DenseMatrix)dm4.compressedColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(cm7);
            DenseMatrix $org_scalatest_assert_macro_right13 = dm4;
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.simpleMacroBool(cm7.isColMajor(), "cm7.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cm7.getSizeInBytes()));
            long $org_scalatest_assert_macro_right14 = dm4.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 459));
            DenseMatrix dm5 = new DenseMatrix(4, 4, (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Array$.MODULE$.fill(7, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()))).$plus$plus((GenTraversableOnce)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])Array$.MODULE$.fill(9, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            DenseMatrix cm8 = (DenseMatrix)dm5.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cm8.getSizeInBytes()));
            long $org_scalatest_assert_macro_right15 = dm5.toSparseColMajor().getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right15), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 465));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 393));
        this.test("compressed sparse", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparseMatrix sm1 = new SparseMatrix(4, 2, new int[]{0, 0, 1}, new int[]{0}, new double[]{-1.0});
            SparseMatrix sm2 = sm1.transpose();
            SparseMatrix cm1 = (SparseMatrix)sm1.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(cm1);
            SparseMatrix $org_scalatest_assert_macro_right = sm1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 484));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(cm1.isColMajor(), "cm1.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 485));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(cm1.values().equals(sm1.values()), "cm1.values.equals(sm1.values)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cm1.getSizeInBytes()));
            long $org_scalatest_assert_macro_right2 = sm1.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
            SparseMatrix cm2 = (SparseMatrix)sm1.compressedRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(cm2);
            SparseMatrix $org_scalatest_assert_macro_right3 = sm1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 490));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(cm2.isRowMajor(), "cm2.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 491));
            long $org_scalatest_assert_macro_left4 = cm2.getSizeInBytes();
            long $org_scalatest_assert_macro_right4 = sm1.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 > $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
            long $org_scalatest_assert_macro_left5 = cm2.getSizeInBytes();
            long $org_scalatest_assert_macro_right5 = sm1.toDense().getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left5), "<", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 < $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
            SparseMatrix cm9 = (SparseMatrix)sm1.compressedColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(cm9);
            SparseMatrix $org_scalatest_assert_macro_right6 = sm1;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.simpleMacroBool(cm9.values().equals(sm1.values()), "cm9.values.equals(sm1.values)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cm9.getSizeInBytes()));
            long $org_scalatest_assert_macro_right7 = sm1.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499));
            SparseMatrix cm3 = (SparseMatrix)sm2.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(cm3);
            SparseMatrix $org_scalatest_assert_macro_right8 = sm2;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)$org_scalatest_assert_macro_right8, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 502));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(cm3.isRowMajor(), "cm3.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.simpleMacroBool(cm3.values().equals(sm2.values()), "cm3.values.equals(sm2.values)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cm3.getSizeInBytes()));
            long $org_scalatest_assert_macro_right9 = sm2.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 505));
            SparseMatrix cm8 = (SparseMatrix)sm2.compressedColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(cm8);
            SparseMatrix $org_scalatest_assert_macro_right10 = sm2;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 508));
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.simpleMacroBool(cm8.isColMajor(), "cm8.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
            long $org_scalatest_assert_macro_left11 = cm8.getSizeInBytes();
            long $org_scalatest_assert_macro_right11 = sm2.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left11), ">", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11 > $org_scalatest_assert_macro_right11, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
            long $org_scalatest_assert_macro_left12 = cm8.getSizeInBytes();
            long $org_scalatest_assert_macro_right12 = sm2.toDense().getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left12), "<", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12 < $org_scalatest_assert_macro_right12, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 512));
            SparseMatrix cm10 = (SparseMatrix)sm2.compressedRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(cm10);
            SparseMatrix $org_scalatest_assert_macro_right13 = sm2;
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)$org_scalatest_assert_macro_right13, $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)$org_scalatest_assert_macro_right13, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 515));
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.simpleMacroBool(cm10.isRowMajor(), "cm10.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.simpleMacroBool(cm10.values().equals(sm2.values()), "cm10.values.equals(sm2.values)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 517));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cm10.getSizeInBytes()));
            long $org_scalatest_assert_macro_right14 = sm2.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
            SparseMatrix sm3 = new SparseMatrix(3, 2, new int[]{0, 2, 5}, new int[]{1, 2, 0, 1, 2}, new double[]{2.0, -4.0, -1.0, 3.0, 9.0});
            DenseMatrix cm4 = (DenseMatrix)sm3.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(cm4);
            SparseMatrix $org_scalatest_assert_macro_right15 = sm3;
            Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)$org_scalatest_assert_macro_right15, $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)$org_scalatest_assert_macro_right15, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 532));
            Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.simpleMacroBool(cm4.isColMajor(), "cm4.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
            long $org_scalatest_assert_macro_left16 = cm4.getSizeInBytes();
            long $org_scalatest_assert_macro_right16 = sm3.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left16), "<", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16 < $org_scalatest_assert_macro_right16, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 534));
            DenseMatrix cm5 = (DenseMatrix)sm3.compressedRowMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.convertToEqualizer(cm5);
            SparseMatrix $org_scalatest_assert_macro_right17 = sm3;
            Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)$org_scalatest_assert_macro_right17, $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)$org_scalatest_assert_macro_right17, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 537));
            Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.simpleMacroBool(cm5.isRowMajor(), "cm5.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
            long $org_scalatest_assert_macro_left18 = cm5.getSizeInBytes();
            long $org_scalatest_assert_macro_right18 = sm3.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left18), "<", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right18), $org_scalatest_assert_macro_left18 < $org_scalatest_assert_macro_right18, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
            DenseMatrix cm11 = (DenseMatrix)sm3.compressedColMajor();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left19 = this.convertToEqualizer(cm11);
            SparseMatrix $org_scalatest_assert_macro_right19 = sm3;
            Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "===", (Object)$org_scalatest_assert_macro_right19, $org_scalatest_assert_macro_left19.$eq$eq$eq((Object)$org_scalatest_assert_macro_right19, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
            Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.simpleMacroBool(cm11.isColMajor(), "cm11.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543));
            long $org_scalatest_assert_macro_left20 = cm11.getSizeInBytes();
            long $org_scalatest_assert_macro_right20 = sm3.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr32 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left20), "<", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right20), $org_scalatest_assert_macro_left20 < $org_scalatest_assert_macro_right20, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr32, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
            SparseMatrix sm4 = new SparseMatrix(Integer.MAX_VALUE, 1, new int[]{0, 1}, new int[]{0}, new double[]{1.0});
            SparseMatrix cm6 = (SparseMatrix)sm4.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left21 = this.convertToEqualizer(cm6);
            SparseMatrix $org_scalatest_assert_macro_right21 = sm4;
            Bool $org_scalatest_assert_macro_expr33 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "===", (Object)$org_scalatest_assert_macro_right21, $org_scalatest_assert_macro_left21.$eq$eq$eq((Object)$org_scalatest_assert_macro_right21, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr33, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 556));
            Bool $org_scalatest_assert_macro_expr34 = Bool$.MODULE$.simpleMacroBool(cm6.isColMajor(), "cm6.isColMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr34, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
            long $org_scalatest_assert_macro_left22 = cm6.getSizeInBytes();
            long $org_scalatest_assert_macro_right22 = sm4.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr35 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left22), "<=", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right22), $org_scalatest_assert_macro_left22 <= $org_scalatest_assert_macro_right22, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr35, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 558));
            SparseMatrix sm5 = new SparseMatrix(1, Integer.MAX_VALUE, new int[]{0, 1}, new int[]{0}, new double[]{1.0}, true);
            SparseMatrix cm7 = (SparseMatrix)sm5.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left23 = this.convertToEqualizer(cm7);
            SparseMatrix $org_scalatest_assert_macro_right23 = sm5;
            Bool $org_scalatest_assert_macro_expr36 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left23, "===", (Object)$org_scalatest_assert_macro_right23, $org_scalatest_assert_macro_left23.$eq$eq$eq((Object)$org_scalatest_assert_macro_right23, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr36, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 563));
            Bool $org_scalatest_assert_macro_expr37 = Bool$.MODULE$.simpleMacroBool(cm7.isRowMajor(), "cm7.isRowMajor", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr37, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
            long $org_scalatest_assert_macro_left24 = cm7.getSizeInBytes();
            long $org_scalatest_assert_macro_right24 = sm5.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr38 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left24), "<=", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right24), $org_scalatest_assert_macro_left24 <= $org_scalatest_assert_macro_right24, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr38, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
            SparseMatrix sm6 = new SparseMatrix(4, 4, new int[]{0, 4, 7, 7, 7}, new int[]{0, 1, 2, 3, 0, 1, 2}, (double[])Array$.MODULE$.fill(7, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 1.0, ClassTag$.MODULE$.Double()));
            DenseMatrix cm12 = (DenseMatrix)sm6.compressed();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left25 = this.convertToEqualizer(BoxesRunTime.boxToLong((long)cm12.getSizeInBytes()));
            long $org_scalatest_assert_macro_right25 = sm6.getSizeInBytes();
            Bool $org_scalatest_assert_macro_expr39 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left25, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right25), $org_scalatest_assert_macro_left25.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right25), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr39, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 572));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
        this.test("map, update", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int m = 3;
            int n = 2;
            double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
            double[] allValues = new double[]{1.0, 2.0, 0.0, 0.0, 4.0, 5.0};
            int[] colPtrs = new int[]{0, 2, 4};
            int[] rowIndices = new int[]{0, 1, 1, 2};
            SparseMatrix spMat1 = new SparseMatrix(m, n, colPtrs, rowIndices, values);
            DenseMatrix deMat1 = new DenseMatrix(m, n, allValues);
            DenseMatrix deMat2 = deMat1.map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$1 -> x$1 * (double)2);
            SparseMatrix spMat2 = spMat1.map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$2 -> x$2 * (double)2);
            deMat1.update((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$3 -> x$3 * (double)2);
            spMat1.update((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> x$4 * (double)2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(spMat1.toArray());
            double[] $org_scalatest_assert_macro_right = spMat2.toArray();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 590));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(deMat1.toArray());
            double[] $org_scalatest_assert_macro_right2 = deMat2.toArray();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 591));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 575));
        this.test("transpose", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseMatrix dA = new DenseMatrix(4, 3, new double[]{0.0, 1.0, 0.0, 0.0, 2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 3.0});
            SparseMatrix sA = new SparseMatrix(4, 3, new int[]{0, 1, 3, 4}, new int[]{1, 0, 2, 3}, new double[]{1.0, 2.0, 1.0, 3.0});
            DenseMatrix dAT = dA.transpose();
            SparseMatrix sAT = sA.transpose();
            DenseMatrix dATexpected = new DenseMatrix(3, 4, new double[]{0.0, 2.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 3.0});
            SparseMatrix sATexpected = new SparseMatrix(3, 4, new int[]{0, 1, 2, 3, 4}, new int[]{1, 0, 1, 2}, new double[]{2.0, 1.0, 1.0, 3.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(dAT.asBreeze());
            breeze.linalg.Matrix $org_scalatest_assert_macro_right = dATexpected.asBreeze();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(sAT.asBreeze());
            breeze.linalg.Matrix $org_scalatest_assert_macro_right2 = sATexpected.asBreeze();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 607));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)dA.apply(1, 0)));
            double $org_scalatest_assert_macro_right3 = dAT.apply(0, 1);
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 608));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)dA.apply(2, 1)));
            double $org_scalatest_assert_macro_right4 = dAT.apply(1, 2);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 609));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sA.apply(1, 0)));
            double $org_scalatest_assert_macro_right5 = sAT.apply(0, 1);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 610));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)sA.apply(2, 1)));
            double $org_scalatest_assert_macro_right6 = sAT.apply(1, 2);
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 611));
            double[] $org_scalatest_assert_macro_left7 = dA.toArray();
            double[] $org_scalatest_assert_macro_right7 = dAT.toArray();
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "eq", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"has to have a new array", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
            double[] $org_scalatest_assert_macro_left8 = dA.values();
            double[] $org_scalatest_assert_macro_right8 = dAT.transpose().values();
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "eq", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"should not copy array", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 614));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(dAT.toSparse().asBreeze());
            breeze.linalg.Matrix $org_scalatest_assert_macro_right9 = sATexpected.asBreeze();
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)$org_scalatest_assert_macro_right9, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(sAT.toDense().asBreeze());
            breeze.linalg.Matrix $org_scalatest_assert_macro_right10 = dATexpected.asBreeze();
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)$org_scalatest_assert_macro_right10, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 617));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
        this.test("foreachActive", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int m = 3;
            int n = 2;
            double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
            double[] allValues = new double[]{1.0, 2.0, 0.0, 0.0, 4.0, 5.0};
            int[] colPtrs = new int[]{0, 2, 4};
            int[] rowIndices = new int[]{0, 1, 1, 2};
            SparseMatrix sp2 = new SparseMatrix(m, n, colPtrs, rowIndices, values);
            DenseMatrix dn = new DenseMatrix(m, n, allValues);
            Map dnMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            dn.foreachActive((Function3 & Serializable & scala.Serializable)(i, j, value) -> {
                dnMap.put((Object)new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j)), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)value)));
                return BoxedUnit.UNIT;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)dnMap.size()));
            int $org_scalatest_assert_macro_right = 6;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(0, 0)));
            double $org_scalatest_assert_macro_right2 = 1.0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 636));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(1, 0)));
            double $org_scalatest_assert_macro_right3 = 2.0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(2, 0)));
            double $org_scalatest_assert_macro_right4 = 0.0;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(0, 1)));
            double $org_scalatest_assert_macro_right5 = 0.0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(1, 1)));
            double $org_scalatest_assert_macro_right6 = 4.0;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 640));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(dnMap.apply((Object)new Tuple2.mcII.sp(2, 1)));
            double $org_scalatest_assert_macro_right7 = 5.0;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 641));
            Map spMap = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            sp2.foreachActive((Function3 & Serializable & scala.Serializable)(i, j, value) -> {
                spMap.put((Object)new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)i), BoxesRunTime.unboxToInt((Object)j)), (Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)value)));
                return BoxedUnit.UNIT;
            });
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spMap.size()));
            int $org_scalatest_assert_macro_right8 = 4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 647));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(spMap.apply((Object)new Tuple2.mcII.sp(0, 0)));
            double $org_scalatest_assert_macro_right9 = 1.0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(spMap.apply((Object)new Tuple2.mcII.sp(1, 0)));
            double $org_scalatest_assert_macro_right10 = 2.0;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 649));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(spMap.apply((Object)new Tuple2.mcII.sp(1, 1)));
            double $org_scalatest_assert_macro_right11 = 4.0;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 650));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(spMap.apply((Object)new Tuple2.mcII.sp(2, 1)));
            double $org_scalatest_assert_macro_right12 = 5.0;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 651));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 620));
        this.test("horzcat, vertcat, eye, speye", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            int m = 3;
            int n = 2;
            double[] values = new double[]{1.0, 2.0, 4.0, 5.0};
            double[] allValues = new double[]{1.0, 2.0, 0.0, 0.0, 4.0, 5.0};
            int[] colPtrs = new int[]{0, 2, 4};
            int[] rowIndices = new int[]{0, 1, 1, 2};
            double[] allValuesT = new double[]{1.0, 0.0, 2.0, 4.0, 0.0, 5.0};
            int[] colPtrsT = new int[]{0, 1, 3, 4};
            int[] rowIndicesT = new int[]{0, 0, 1, 1};
            SparseMatrix spMat1 = new SparseMatrix(m, n, colPtrs, rowIndices, values);
            DenseMatrix deMat1 = new DenseMatrix(m, n, allValues);
            SparseMatrix spMat1T = new SparseMatrix(n, m, colPtrsT, rowIndicesT, values);
            DenseMatrix deMat1T = new DenseMatrix(n, m, allValuesT);
            SparseMatrix spMat1TT = spMat1T.transpose();
            DenseMatrix deMat1TT = deMat1T.transpose();
            Matrix deMat2 = Matrices$.MODULE$.eye(3);
            Matrix spMat2 = Matrices$.MODULE$.speye(3);
            Matrix deMat3 = Matrices$.MODULE$.eye(2);
            Matrix spMat3 = Matrices$.MODULE$.speye(2);
            Matrix spHorz = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{spMat1, spMat2}));
            Matrix spHorz2 = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{spMat1, deMat2}));
            Matrix spHorz3 = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{deMat1, spMat2}));
            Matrix deHorz1 = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{deMat1, deMat2}));
            Matrix deHorz2 = Matrices$.MODULE$.horzcat((Matrix[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Matrix.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deHorz1.numRows()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 686));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz2.numRows()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 687));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz3.numRows()));
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz.numRows()));
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deHorz1.numCols()));
            int $org_scalatest_assert_macro_right5 = 5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz2.numCols()));
            int $org_scalatest_assert_macro_right6 = 5;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 691));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz3.numCols()));
            int $org_scalatest_assert_macro_right7 = 5;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 692));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spHorz.numCols()));
            int $org_scalatest_assert_macro_right8 = 5;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 693));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deHorz2.numRows()));
            int $org_scalatest_assert_macro_right9 = 0;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 694));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deHorz2.numCols()));
            int $org_scalatest_assert_macro_right10 = 0;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deHorz2.toArray().length));
            int $org_scalatest_assert_macro_right11 = 0;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right11), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 696));
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deHorz1).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)((SparseMatrix)spHorz2).toDense()).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(deHorz1).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spHorz2.asInstanceOf[org.apache.spark.ml.linalg.SparseMatrix].toDense).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 698));
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz2).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spHorz2).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spHorz3).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 699));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left12 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(0, 0)));
            double $org_scalatest_assert_macro_right12 = 1.0;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), $org_scalatest_assert_macro_left12.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right12), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 700));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left13 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(2, 1)));
            double $org_scalatest_assert_macro_right13 = 5.0;
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), $org_scalatest_assert_macro_left13.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right13), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 701));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left14 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(0, 2)));
            double $org_scalatest_assert_macro_right14 = 1.0;
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left14, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right14), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 702));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left15 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(1, 2)));
            double $org_scalatest_assert_macro_right15 = 0.0;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left15, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right15), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left16 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(1, 3)));
            double $org_scalatest_assert_macro_right16 = 1.0;
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left16, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right16), $org_scalatest_assert_macro_left16.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right16), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 704));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left17 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(2, 4)));
            double $org_scalatest_assert_macro_right17 = 1.0;
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left17, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right17), $org_scalatest_assert_macro_left17.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right17), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left18 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spHorz.apply(1, 4)));
            double $org_scalatest_assert_macro_right18 = 0.0;
            Bool $org_scalatest_assert_macro_expr20 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left18, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right18), $org_scalatest_assert_macro_left18.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right18), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr20, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left19 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(0, 0)));
            double $org_scalatest_assert_macro_right19 = 1.0;
            Bool $org_scalatest_assert_macro_expr21 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left19, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right19), $org_scalatest_assert_macro_left19.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right19), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr21, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 707));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left20 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(2, 1)));
            double $org_scalatest_assert_macro_right20 = 5.0;
            Bool $org_scalatest_assert_macro_expr22 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left20, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right20), $org_scalatest_assert_macro_left20.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right20), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr22, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 708));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left21 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(0, 2)));
            double $org_scalatest_assert_macro_right21 = 1.0;
            Bool $org_scalatest_assert_macro_expr23 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left21, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right21), $org_scalatest_assert_macro_left21.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right21), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr23, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
            double $org_scalatest_assert_macro_left22 = deHorz1.apply(1, 2);
            double $org_scalatest_assert_macro_right22 = 0.0;
            Bool $org_scalatest_assert_macro_expr24 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left22), "==", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right22), $org_scalatest_assert_macro_left22 == $org_scalatest_assert_macro_right22, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr24, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 710));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left23 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(1, 3)));
            double $org_scalatest_assert_macro_right23 = 1.0;
            Bool $org_scalatest_assert_macro_expr25 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left23, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right23), $org_scalatest_assert_macro_left23.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right23), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr25, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left24 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(2, 4)));
            double $org_scalatest_assert_macro_right24 = 1.0;
            Bool $org_scalatest_assert_macro_expr26 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left24, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right24), $org_scalatest_assert_macro_left24.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right24), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr26, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left25 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deHorz1.apply(1, 4)));
            double $org_scalatest_assert_macro_right25 = 0.0;
            Bool $org_scalatest_assert_macro_expr27 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left25, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right25), $org_scalatest_assert_macro_left25.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right25), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr27, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 713));
            Matrix spHorzT = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{spMat1TT, spMat2}));
            Matrix spHorz2T = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{spMat1TT, deMat2}));
            Matrix spHorz3T = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{deMat1TT, spMat2}));
            Matrix deHorz1T = Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{deMat1TT, deMat2}));
            Bool $org_scalatest_assert_macro_expr28 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deHorz1T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deHorz1).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(deHorz1T).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(deHorz1).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr28, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 721));
            Bool $org_scalatest_assert_macro_expr29 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorzT).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spHorzT).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spHorz).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr29, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 722));
            Bool $org_scalatest_assert_macro_expr30 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz2T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spHorz2T).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spHorz2).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr30, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
            Bool $org_scalatest_assert_macro_expr31 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz3T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spHorz3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spHorz3T).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spHorz3).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr31, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{spMat1, spMat3})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 726));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Matrices$.MODULE$.horzcat((Matrix[])((Object[])new Matrix[]{deMat1, spMat3})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 730));
            Matrix spVert = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{spMat1, spMat3}));
            Matrix deVert1 = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{deMat1, deMat3}));
            Matrix spVert2 = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{spMat1, deMat3}));
            Matrix spVert3 = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{deMat1, spMat3}));
            Matrix deVert2 = Matrices$.MODULE$.vertcat((Matrix[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Matrix.class)));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left26 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deVert1.numRows()));
            int $org_scalatest_assert_macro_right26 = 5;
            Bool $org_scalatest_assert_macro_expr32 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left26, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right26), $org_scalatest_assert_macro_left26.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right26), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr32, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 740));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left27 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert2.numRows()));
            int $org_scalatest_assert_macro_right27 = 5;
            Bool $org_scalatest_assert_macro_expr33 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left27, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right27), $org_scalatest_assert_macro_left27.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right27), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr33, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 741));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left28 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert3.numRows()));
            int $org_scalatest_assert_macro_right28 = 5;
            Bool $org_scalatest_assert_macro_expr34 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left28, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right28), $org_scalatest_assert_macro_left28.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right28), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr34, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 742));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left29 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert.numRows()));
            int $org_scalatest_assert_macro_right29 = 5;
            Bool $org_scalatest_assert_macro_expr35 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left29, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right29), $org_scalatest_assert_macro_left29.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right29), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr35, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left30 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deVert1.numCols()));
            int $org_scalatest_assert_macro_right30 = 2;
            Bool $org_scalatest_assert_macro_expr36 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left30, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right30), $org_scalatest_assert_macro_left30.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right30), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr36, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 744));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left31 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert2.numCols()));
            int $org_scalatest_assert_macro_right31 = 2;
            Bool $org_scalatest_assert_macro_expr37 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left31, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right31), $org_scalatest_assert_macro_left31.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right31), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr37, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 745));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left32 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert3.numCols()));
            int $org_scalatest_assert_macro_right32 = 2;
            Bool $org_scalatest_assert_macro_expr38 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left32, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right32), $org_scalatest_assert_macro_left32.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right32), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr38, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 746));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left33 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)spVert.numCols()));
            int $org_scalatest_assert_macro_right33 = 2;
            Bool $org_scalatest_assert_macro_expr39 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left33, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right33), $org_scalatest_assert_macro_left33.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right33), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr39, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left34 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deVert2.numRows()));
            int $org_scalatest_assert_macro_right34 = 0;
            Bool $org_scalatest_assert_macro_expr40 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left34, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right34), $org_scalatest_assert_macro_left34.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right34), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr40, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 748));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left35 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deVert2.numCols()));
            int $org_scalatest_assert_macro_right35 = 0;
            Bool $org_scalatest_assert_macro_expr41 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left35, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right35), $org_scalatest_assert_macro_left35.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right35), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr41, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 749));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left36 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)deVert2.toArray().length));
            int $org_scalatest_assert_macro_right36 = 0;
            Bool $org_scalatest_assert_macro_expr42 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left36, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right36), $org_scalatest_assert_macro_left36.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right36), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr42, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 750));
            Bool $org_scalatest_assert_macro_expr43 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deVert1).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals((Matrix)((SparseMatrix)spVert2).toDense()).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(deVert1).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spVert2.asInstanceOf[org.apache.spark.ml.linalg.SparseMatrix].toDense).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr43, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 752));
            Bool $org_scalatest_assert_macro_expr44 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert2).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spVert2).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spVert3).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr44, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 753));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left37 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spVert.apply(0, 0)));
            double $org_scalatest_assert_macro_right37 = 1.0;
            Bool $org_scalatest_assert_macro_expr45 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left37, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right37), $org_scalatest_assert_macro_left37.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right37), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr45, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 754));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left38 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spVert.apply(2, 1)));
            double $org_scalatest_assert_macro_right38 = 5.0;
            Bool $org_scalatest_assert_macro_expr46 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left38, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right38), $org_scalatest_assert_macro_left38.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right38), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr46, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 755));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left39 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spVert.apply(3, 0)));
            double $org_scalatest_assert_macro_right39 = 1.0;
            Bool $org_scalatest_assert_macro_expr47 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left39, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right39), $org_scalatest_assert_macro_left39.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right39), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr47, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 756));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left40 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spVert.apply(3, 1)));
            double $org_scalatest_assert_macro_right40 = 0.0;
            Bool $org_scalatest_assert_macro_expr48 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left40, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right40), $org_scalatest_assert_macro_left40.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right40), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr48, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 757));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left41 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)spVert.apply(4, 1)));
            double $org_scalatest_assert_macro_right41 = 1.0;
            Bool $org_scalatest_assert_macro_expr49 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left41, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right41), $org_scalatest_assert_macro_left41.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right41), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr49, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 758));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left42 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deVert1.apply(0, 0)));
            double $org_scalatest_assert_macro_right42 = 1.0;
            Bool $org_scalatest_assert_macro_expr50 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left42, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right42), $org_scalatest_assert_macro_left42.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right42), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr50, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 759));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left43 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deVert1.apply(2, 1)));
            double $org_scalatest_assert_macro_right43 = 5.0;
            Bool $org_scalatest_assert_macro_expr51 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left43, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right43), $org_scalatest_assert_macro_left43.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right43), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr51, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 760));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left44 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deVert1.apply(3, 0)));
            double $org_scalatest_assert_macro_right44 = 1.0;
            Bool $org_scalatest_assert_macro_expr52 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left44, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right44), $org_scalatest_assert_macro_left44.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right44), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr52, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left45 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deVert1.apply(3, 1)));
            double $org_scalatest_assert_macro_right45 = 0.0;
            Bool $org_scalatest_assert_macro_expr53 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left45, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right45), $org_scalatest_assert_macro_left45.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right45), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr53, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 762));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left46 = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)deVert1.apply(4, 1)));
            double $org_scalatest_assert_macro_right46 = 1.0;
            Bool $org_scalatest_assert_macro_expr54 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left46, "===", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right46), $org_scalatest_assert_macro_left46.$eq$eq$eq((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right46), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr54, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 763));
            Matrix spVertT = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{spMat1TT, spMat3}));
            Matrix deVert1T = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{deMat1TT, deMat3}));
            Matrix spVert2T = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{spMat1TT, deMat3}));
            Matrix spVert3T = Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{deMat1TT, spMat3}));
            Bool $org_scalatest_assert_macro_expr55 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deVert1T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(deVert1).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(deVert1T).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(deVert1).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr55, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 771));
            Bool $org_scalatest_assert_macro_expr56 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVertT).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spVertT).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spVert).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr56, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 772));
            Bool $org_scalatest_assert_macro_expr57 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert2T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert2).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spVert2T).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spVert2).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr57, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
            Bool $org_scalatest_assert_macro_expr58 = Bool$.MODULE$.simpleMacroBool(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert3T).$tilde$eq$eq(TestingUtils$.MODULE$.MatrixWithAlmostEquals(spVert3).absTol(1.0E-15)), "org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spVert3T).~==(org.apache.spark.ml.util.TestingUtils.MatrixWithAlmostEquals(spVert3).absTol(1.0E-15))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr58, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 774));
            this.intercept((Function0 & Serializable & scala.Serializable)() -> Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{spMat1, spMat2})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 776));
            return (IllegalArgumentException)this.intercept((Function0 & Serializable & scala.Serializable)() -> Matrices$.MODULE$.vertcat((Matrix[])((Object[])new Matrix[]{deMat1, spMat2})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 780));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 654));
        this.test("zeros", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.zeros(2, 3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 787));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 788));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$5 -> x$5 == 0.0), "scala.Predef.doubleArrayOps(mat.values).forall(((x$5: Double) => x$5.==(0.0)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 789));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 785));
        this.test("ones", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.ones(2, 3);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 794));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 795));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$6 -> x$6 == 1.0), "scala.Predef.doubleArrayOps(mat.values).forall(((x$6: Double) => x$6.==(1.0)))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 796));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 792));
        this.test("eye", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.eye(2);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 802));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).toSeq());
            Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 0.0, 1.0}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 803));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 799));
        this.test("rand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = (Random)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Random.class));
            Mockito.when((Object)BoxesRunTime.boxToDouble((double)rng.nextDouble())).thenReturn((Object)BoxesRunTime.boxToDouble((double)1.0), ScalaRunTime$.MODULE$.toObjectArray((Object)new double[]{2.0, 3.0, 4.0}));
            DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.rand(2, 2, rng);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 810));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).toSeq());
            Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0, 4.0}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 806));
        this.test("randn", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = (Random)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Random.class));
            Mockito.when((Object)BoxesRunTime.boxToDouble((double)rng.nextGaussian())).thenReturn((Object)BoxesRunTime.boxToDouble((double)1.0), ScalaRunTime$.MODULE$.toObjectArray((Object)new double[]{2.0, 3.0, 4.0}));
            DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.randn(2, 2, rng);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 819));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 820));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).toSeq());
            Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0, 4.0}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 821));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 815));
        this.test("diag", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            DenseMatrix mat = (DenseMatrix)Matrices$.MODULE$.diag(Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{2.0})));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 826));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 827));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).toSeq());
            Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 0.0, 0.0, 2.0}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 828));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 824));
        this.test("sprand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = (Random)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Random.class));
            Mockito.when((Object)BoxesRunTime.boxToInteger((int)rng.nextInt(4))).thenReturn((Object)BoxesRunTime.boxToInteger((int)0), ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{1, 1, 3, 2, 2, 0, 1, 3, 0}));
            Mockito.when((Object)BoxesRunTime.boxToDouble((double)rng.nextDouble())).thenReturn((Object)BoxesRunTime.boxToDouble((double)1.0), ScalaRunTime$.MODULE$.toObjectArray((Object)new double[]{2.0, 3.0, 4.0, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}));
            SparseMatrix mat = SparseMatrix$.MODULE$.sprand(4, 4, 0.25, rng);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 836));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 837));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mat.rowIndices())).toSeq());
            Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 2, 1}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 838));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).toSeq());
            Seq $org_scalatest_assert_macro_right4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0, 4.0}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 839));
            SparseMatrix mat2 = SparseMatrix$.MODULE$.sprand(2, 3, 1.0, rng);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mat2.rowIndices())).toSeq());
            Seq $org_scalatest_assert_macro_right5 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0, 1, 0, 1}));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 841));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mat2.colPtrs())).toSeq());
            Seq $org_scalatest_assert_macro_right6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 4, 6}));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 842));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 831));
        this.test("sprandn", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Random rng = (Random)MockitoSugar$.MODULE$.mock(ClassTag$.MODULE$.apply(Random.class));
            Mockito.when((Object)BoxesRunTime.boxToInteger((int)rng.nextInt(4))).thenReturn((Object)BoxesRunTime.boxToInteger((int)0), ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{1, 1, 3, 2, 2, 0, 1, 3, 0}));
            Mockito.when((Object)BoxesRunTime.boxToDouble((double)rng.nextGaussian())).thenReturn((Object)BoxesRunTime.boxToDouble((double)1.0), ScalaRunTime$.MODULE$.toObjectArray((Object)new double[]{2.0, 3.0, 4.0}));
            SparseMatrix mat = SparseMatrix$.MODULE$.sprandn(4, 4, 0.25, rng);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numRows()));
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 850));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)mat.numCols()));
            int $org_scalatest_assert_macro_right2 = 4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 851));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mat.rowIndices())).toSeq());
            Seq $org_scalatest_assert_macro_right3 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 2, 1}));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 852));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(mat.values())).toSeq());
            Seq $org_scalatest_assert_macro_right4 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0, 4.0}));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 853));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
        this.test("toString", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Matrix empty = Matrices$.MODULE$.ones(0, 0);
            empty.toString(0, 0);
            Matrix mat = Matrices$.MODULE$.rand(5, 10, new Random());
            mat.toString(-1, -5);
            mat.toString(0, 0);
            mat.toString(Integer.MIN_VALUE, Integer.MIN_VALUE);
            mat.toString(Integer.MAX_VALUE, Integer.MAX_VALUE);
            String[] lines = new StringOps(Predef$.MODULE$.augmentString(mat.toString(6, 50))).split('\n');
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])lines);
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_right2 = $org_scalatest_assert_macro_left2.value() ? Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MatricesSuite.$anonfun$new$60(x$7))), "scala.Predef.refArrayOps[String](lines).forall(((x$7: String) => scala.Predef.augmentString(x$7).size.<=(50)))", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866));
            lines = new StringOps(Predef$.MODULE$.augmentString(mat.toString(5, 100))).split('\n');
            Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])lines);
            int $org_scalatest_assert_macro_right3 = 5;
            Bool $org_scalatest_assert_macro_left4 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left3).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_right4 = $org_scalatest_assert_macro_left4.value() ? Bool$.MODULE$.simpleMacroBool(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MatricesSuite.$anonfun$new$62(x$8))), "scala.Predef.refArrayOps[String](lines).forall(((x$8: String) => scala.Predef.augmentString(x$8).size.<=(100)))", Prettifier$.MODULE$.default()) : Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "&&", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 869));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 856));
        this.test("numNonzeros and numActives", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Matrix dm1 = Matrices$.MODULE$.dense(3, 2, new double[]{0.0, 0.0, -1.0, 1.0, 0.0, 1.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)dm1.numNonzeros()));
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 874));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)dm1.numActives()));
            int $org_scalatest_assert_macro_right2 = 6;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 875));
            Matrix sm1 = Matrices$.MODULE$.sparse(3, 2, new int[]{0, 2, 3}, new int[]{0, 2, 1}, new double[]{0.0, -1.2, 0.0});
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sm1.numNonzeros()));
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 878));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)sm1.numActives()));
            int $org_scalatest_assert_macro_right4 = 3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 879));
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 872));
        this.test("fromBreeze with sparse matrix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            CSCMatrix.mcD.sp bm1 = new CSCMatrix.mcD.sp(new double[]{1.0, 1.0, 1.0}, 3, 3, new int[]{0, 1, 2, 3}, new int[]{0, 1, 2}, (Zero)Zero.DoubleZero$.MODULE$);
            CSCMatrix.mcD.sp bm2 = new CSCMatrix.mcD.sp(new double[]{1.0, 2.0, 2.0, 4.0}, 3, 3, new int[]{0, 0, 2, 4}, new int[]{1, 2, 1, 2}, (Zero)Zero.DoubleZero$.MODULE$);
            breeze.linalg.Matrix sum = (breeze.linalg.Matrix)bm1.$plus((Object)bm2, (UFunc.UImpl2)Matrix$.MODULE$.op_M_DM_Double_OpAdd());
            return Matrices$.MODULE$.fromBreeze(sum);
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 882));
        this.test("row/col iterator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DenseMatrix dm = new DenseMatrix(3, 2, new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 0.0});
            SparseMatrix sm = dm.toSparse();
            Seq rows = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{3.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(1.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(2.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0})), (List)Nil$.MODULE$)));
            Seq cols = (Seq)new .colon.colon((Object)Vectors$.MODULE$.dense(0.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0})), (List)new .colon.colon((Object)Vectors$.MODULE$.dense(3.0, (Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{4.0, 0.0})), (List)Nil$.MODULE$));
            ((IterableLike)new .colon.colon((Object)dm, (List)new .colon.colon((Object)sm, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)m -> {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(m.rowIter().toSeq());
                Seq $org_scalatest_assert_macro_right = rows;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 899));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(m.colIter().toSeq());
                Seq $org_scalatest_assert_macro_right2 = cols;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 900));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(m.transpose().rowIter().toSeq());
                Seq $org_scalatest_assert_macro_right3 = cols;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 901));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(m.transpose().colIter().toSeq());
                Seq $org_scalatest_assert_macro_right4 = rows;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 902));
            });
        }, new Position("MatricesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 893));
    }
}

