/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.time.Period;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.datasources.FileBasedDataSourceTest;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.parquet.ParquetTest;
import org.apache.spark.sql.hive.HiveParquetSourceSuite$;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.ParquetPartitioningTest;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple1;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001%2Aa\u0001\u0003\u0001\u001f!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C!E\t1\u0002*\u001b<f!\u0006\u0014\u0018/^3u'>,(oY3Tk&$XM\u0003\u0002\u0006\r\u0005!\u0001.\u001b<f\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0003\u0006\t\u0003#Ii\u0011\u0001B\u0005\u0003'\u0011\u0011q\u0003U1scV,G\u000fU1si&$\u0018n\u001c8j]\u001e$Vm\u001d;\u0011\u0005UaR\"\u0001\f\u000b\u0005]A\u0012a\u00029beF,X\r\u001e\u0006\u00033i\t1\u0002Z1uCN|WO]2fg*\u00111DB\u0001\nKb,7-\u001e;j_:L!!\b\f\u0003\u0017A\u000b'/];fiR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\u0005\u0001\u0002\u0013\t,gm\u001c:f\u00032dG#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\tUs\u0017\u000e\u001e")
public class HiveParquetSourceSuite
extends ParquetPartitioningTest
implements ParquetTest {
    private final String dataSourceName;
    private final String vectorizedReaderEnabledKey;
    private final String vectorizedReaderNestedEnabledKey;

    public void readParquetFile(String path, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f) {
        ParquetTest.readParquetFile$((ParquetTest)this, (String)path, (boolean)testVectorized, f);
    }

    public boolean readParquetFile$default$2() {
        return ParquetTest.readParquetFile$default$2$((ParquetTest)this);
    }

    public <T extends Product> void withParquetFile(Seq<T> data, Function1<String, BoxedUnit> f, ClassTag<T> evidence$1, TypeTags.TypeTag<T> evidence$2) {
        ParquetTest.withParquetFile$((ParquetTest)this, data, f, evidence$1, evidence$2);
    }

    public <T extends Product> void withParquetDataFrame(Seq<T> data, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f, ClassTag<T> evidence$3, TypeTags.TypeTag<T> evidence$4) {
        ParquetTest.withParquetDataFrame$((ParquetTest)this, data, (boolean)testVectorized, f, evidence$3, evidence$4);
    }

    public <T extends Product> boolean withParquetDataFrame$default$2() {
        return ParquetTest.withParquetDataFrame$default$2$((ParquetTest)this);
    }

    public <T extends Product> void withParquetTable(Seq<T> data, String tableName, boolean testVectorized, Function0<BoxedUnit> f, ClassTag<T> evidence$5, TypeTags.TypeTag<T> evidence$6) {
        ParquetTest.withParquetTable$((ParquetTest)this, data, (String)tableName, (boolean)testVectorized, f, evidence$5, evidence$6);
    }

    public <T extends Product> boolean withParquetTable$default$3() {
        return ParquetTest.withParquetTable$default$3$((ParquetTest)this);
    }

    public <T extends Product> void makeParquetFile(Seq<T> data, File path, ClassTag<T> evidence$7, TypeTags.TypeTag<T> evidence$8) {
        ParquetTest.makeParquetFile$((ParquetTest)this, data, (File)path, evidence$7, evidence$8);
    }

    public <T extends Product> void makeParquetFile(Dataset<Row> df, File path, ClassTag<T> evidence$9, TypeTags.TypeTag<T> evidence$10) {
        ParquetTest.makeParquetFile$((ParquetTest)this, df, (File)path, evidence$9, evidence$10);
    }

    public File makePartitionDir(File basePath, String defaultPartitionName, Seq<Tuple2<String, Object>> partitionCols) {
        return ParquetTest.makePartitionDir$((ParquetTest)this, (File)basePath, (String)defaultPartitionName, partitionCols);
    }

    public void writeMetadata(StructType schema, Path path, Configuration configuration) {
        ParquetTest.writeMetadata$((ParquetTest)this, (StructType)schema, (Path)path, (Configuration)configuration);
    }

    public void writeMetadata(MessageType parquetSchema, Path path, Configuration configuration, Map<String, String> extraMetadata) {
        ParquetTest.writeMetadata$((ParquetTest)this, (MessageType)parquetSchema, (Path)path, (Configuration)configuration, extraMetadata);
    }

    public Map<String, String> writeMetadata$default$4() {
        return ParquetTest.writeMetadata$default$4$((ParquetTest)this);
    }

    public Seq<Footer> readAllFootersWithoutSummaryFiles(Path path, Configuration configuration) {
        return ParquetTest.readAllFootersWithoutSummaryFiles$((ParquetTest)this, (Path)path, (Configuration)configuration);
    }

    public ParquetMetadata readFooter(Path path, Configuration configuration) {
        return ParquetTest.readFooter$((ParquetTest)this, (Path)path, (Configuration)configuration);
    }

    public void testStandardAndLegacyModes(String testName, Function0<BoxedUnit> f) {
        ParquetTest.testStandardAndLegacyModes$((ParquetTest)this, (String)testName, f);
    }

    public Dataset<Row> readResourceParquetFile(String name) {
        return ParquetTest.readResourceParquetFile$((ParquetTest)this, (String)name);
    }

    public String getResourceParquetFilePath(String name) {
        return ParquetTest.getResourceParquetFilePath$((ParquetTest)this, (String)name);
    }

    public void withAllParquetReaders(Function0<BoxedUnit> code) {
        ParquetTest.withAllParquetReaders$((ParquetTest)this, code);
    }

    public void withAllParquetWriters(Function0<BoxedUnit> code) {
        ParquetTest.withAllParquetWriters$((ParquetTest)this, code);
    }

    public Map<String, String> getMetaData(File dir) {
        return ParquetTest.getMetaData$((ParquetTest)this, (File)dir);
    }

    public void readFile(String path, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f) {
        FileBasedDataSourceTest.readFile$((FileBasedDataSourceTest)this, (String)path, (boolean)testVectorized, f);
    }

    public boolean readFile$default$2() {
        return FileBasedDataSourceTest.readFile$default$2$((FileBasedDataSourceTest)this);
    }

    public <T extends Product> void withDataSourceFile(Seq<T> data, Function1<String, BoxedUnit> f, ClassTag<T> evidence$1, TypeTags.TypeTag<T> evidence$2) {
        FileBasedDataSourceTest.withDataSourceFile$((FileBasedDataSourceTest)this, data, f, evidence$1, evidence$2);
    }

    public <T extends Product> void withDataSourceDataFrame(Seq<T> data, boolean testVectorized, Function1<Dataset<Row>, BoxedUnit> f, ClassTag<T> evidence$3, TypeTags.TypeTag<T> evidence$4) {
        FileBasedDataSourceTest.withDataSourceDataFrame$((FileBasedDataSourceTest)this, data, (boolean)testVectorized, f, evidence$3, evidence$4);
    }

    public <T extends Product> boolean withDataSourceDataFrame$default$2() {
        return FileBasedDataSourceTest.withDataSourceDataFrame$default$2$((FileBasedDataSourceTest)this);
    }

    public <T extends Product> void withDataSourceTable(Seq<T> data, String tableName, boolean testVectorized, Function0<BoxedUnit> f, ClassTag<T> evidence$5, TypeTags.TypeTag<T> evidence$6) {
        FileBasedDataSourceTest.withDataSourceTable$((FileBasedDataSourceTest)this, data, (String)tableName, (boolean)testVectorized, f, evidence$5, evidence$6);
    }

    public <T extends Product> boolean withDataSourceTable$default$3() {
        return FileBasedDataSourceTest.withDataSourceTable$default$3$((FileBasedDataSourceTest)this);
    }

    public <T extends Product> void makeDataSourceFile(Seq<T> data, File path, ClassTag<T> evidence$7, TypeTags.TypeTag<T> evidence$8) {
        FileBasedDataSourceTest.makeDataSourceFile$((FileBasedDataSourceTest)this, data, (File)path, evidence$7, evidence$8);
    }

    public <T extends Product> void makeDataSourceFile(Dataset<Row> df, File path, ClassTag<T> evidence$9, TypeTags.TypeTag<T> evidence$10) {
        FileBasedDataSourceTest.makeDataSourceFile$((FileBasedDataSourceTest)this, df, (File)path, evidence$9, evidence$10);
    }

    public Seq<Tuple3<Dataset<Row>, String, Function1<Object, Object>>> withNestedDataFrame(Dataset<Row> inputDF) {
        return FileBasedDataSourceTest.withNestedDataFrame$((FileBasedDataSourceTest)this, inputDF);
    }

    public String dataSourceName() {
        return this.dataSourceName;
    }

    public String vectorizedReaderEnabledKey() {
        return this.vectorizedReaderEnabledKey;
    }

    public String vectorizedReaderNestedEnabledKey() {
        return this.vectorizedReaderNestedEnabledKey;
    }

    public void org$apache$spark$sql$execution$datasources$parquet$ParquetTest$_setter_$dataSourceName_$eq(String x$1) {
        this.dataSourceName = x$1;
    }

    public void org$apache$spark$sql$execution$datasources$parquet$ParquetTest$_setter_$vectorizedReaderEnabledKey_$eq(String x$1) {
        this.vectorizedReaderEnabledKey = x$1;
    }

    public void org$apache$spark$sql$execution$datasources$parquet$ParquetTest$_setter_$vectorizedReaderNestedEnabledKey_$eq(String x$1) {
        this.vectorizedReaderNestedEnabledKey = x$1;
    }

    @Override
    public void beforeAll() {
        super.beforeAll();
        this.dropTables((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partitioned_parquet", "partitioned_parquet_with_key", "partitioned_parquet_with_complextypes", "partitioned_parquet_with_key_and_complextypes", "normal_parquet"}));
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(151).append("\n        |CREATE TEMPORARY VIEW partitioned_parquet\n        |USING org.apache.spark.sql.parquet\n        |OPTIONS (\n        |  path '").append(this.partitionedTableDir().toURI()).append("'\n        |)\n      ").toString())).stripMargin());
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(160).append("\n        |CREATE TEMPORARY VIEW partitioned_parquet_with_key\n        |USING org.apache.spark.sql.parquet\n        |OPTIONS (\n        |  path '").append(this.partitionedTableDirWithKey().toURI()).append("'\n        |)\n      ").toString())).stripMargin());
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(146).append("\n        |CREATE TEMPORARY VIEW normal_parquet\n        |USING org.apache.spark.sql.parquet\n        |OPTIONS (\n        |  path '").append(new File(this.partitionedTableDir(), "p=1").toURI()).append("'\n        |)\n      ").toString())).stripMargin());
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(177).append("\n        |CREATE TEMPORARY VIEW partitioned_parquet_with_key_and_complextypes\n        |USING org.apache.spark.sql.parquet\n        |OPTIONS (\n        |  path '").append(this.partitionedTableDirWithKeyAndComplexTypes().toURI()).append("'\n        |)\n      ").toString())).stripMargin());
        this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(169).append("\n        |CREATE TEMPORARY VIEW partitioned_parquet_with_complextypes\n        |USING org.apache.spark.sql.parquet\n        |OPTIONS (\n        |  path '").append(this.partitionedTableDirWithComplexTypes().toURI()).append("'\n        |)\n      ").toString())).stripMargin());
    }

    public static final /* synthetic */ Tuple1 $anonfun$new$3(int x$1) {
        return new Tuple1.mcI.sp(x$1);
    }

    public static final /* synthetic */ Tuple1 $anonfun$new$6(int x$2) {
        return new Tuple1.mcI.sp(x$2);
    }

    private static final String checkErrorMsg$1(String path) {
        return new StringBuilder(135).append("Path: ").append(path).append(" is a directory, which is not supported by the record reader ").append("when `mapreduce.input.fileinputformat.input.dir.recursive` is false.").toString();
    }

    public HiveParquetSourceSuite() {
        FileBasedDataSourceTest.$init$((FileBasedDataSourceTest)this);
        ParquetTest.$init$((ParquetTest)this);
        this.test("SPARK-6016 make sure to use the latest footers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "spark_6016_fix";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveParquetSourceSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator6$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator6$1(HiveParquetSourceSuite $outer) {
                    }
                }
                Dataset df1 = this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)x$1 -> HiveParquetSourceSuite.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom()), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})).coalesce(2);
                df1.write().mode(SaveMode.Overwrite).format("parquet").saveAsTable(tableName);
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("select * from ").append(tableName).toString()), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))})), IndexedSeq$.MODULE$.canBuildFrom()));
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(HiveParquetSourceSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator16$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple1"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$));
                    }

                    public Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator16$1(HiveParquetSourceSuite $outer) {
                    }
                }
                Dataset df2 = this.testImplicits().localSeqToDatasetHolder((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)x$2 -> HiveParquetSourceSuite.$anonfun$new$6(BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom()), this.testImplicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator16$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})).coalesce(4);
                df2.write().mode(SaveMode.Overwrite).format("parquet").saveAsTable(tableName);
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("select * from ").append(tableName).toString()), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i))})), IndexedSeq$.MODULE$.canBuildFrom()));
            });
        }, new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("SPARK-8811: compatibility with array of struct in Hive", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)dir -> {
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"array_of_struct"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Seq conf = (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)"false"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()), (Object)"false"), (List)Nil$.MODULE$)));
                $this.withSQLConf((Seq<Tuple2<String, String>>)conf, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(245).append("CREATE TABLE array_of_struct\n               |STORED AS PARQUET LOCATION '").append(dir.toURI()).append("'\n               |AS SELECT\n               |  '1st' AS a,\n               |  '2nd' AS b,\n               |  ARRAY(NAMED_STRUCT('a', 'val_a', 'b', 'val_b')) AS c\n             ").toString())).stripMargin());
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> $this.spark().read().parquet(dir.getCanonicalPath()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"1st", "2nd", new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"val_a", "val_b"})), (List)Nil$.MODULE$)})));
                });
            });
            return BoxedUnit.UNIT;
        }), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        this.test("Verify the PARQUET conversion parameter: CONVERT_METASTORE_PARQUET", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempView((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"single"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveParquetSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator26$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator26$1(HiveParquetSourceSuite $outer) {
                }
            }
            Dataset singleRowDF = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)"foo"), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator26$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"key", "value"}));
            singleRowDF.createOrReplaceTempView("single");
            ((IterableLike)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)parquetConversion -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)parquetConversion)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String tableName = "test_parquet_ctas";
                    $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        $this.sql().apply((Object)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(129).append("\n                 |CREATE TABLE ").append(tableName).append(" STORED AS PARQUET\n                 |AS SELECT tmp.key, tmp.value FROM single tmp\n               ").toString())).stripMargin());
                        Dataset df = $this.spark().sql(new StringBuilder(26).append("SELECT * FROM ").append(tableName).append(" WHERE key=0").toString());
                        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> df, singleRowDF$1);
                        QueryExecution queryExecution = df.queryExecution();
                        String string = parquetConversion;
                        String string2 = "true";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            queryExecution.analyzed().collectFirst((PartialFunction)new scala.Serializable(null){
                                public static final long serialVersionUID = 0L;

                                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                    A1 A1 = x1;
                                    Object object = A1 instanceof LogicalRelation ? BoxedUnit.UNIT : function1.apply(x1);
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(LogicalPlan x1) {
                                    LogicalPlan logicalPlan = x1;
                                    boolean bl = logicalPlan instanceof LogicalRelation;
                                    return bl;
                                }
                            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.fail(new StringBuilder(70).append("Expecting the query plan to convert parquet to data sources, ").append("but got:\n").append(queryExecution).toString(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165)));
                        } else {
                            queryExecution.analyzed().collectFirst((PartialFunction)new scala.Serializable(null){
                                public static final long serialVersionUID = 0L;

                                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                    A1 A1 = x2;
                                    Object object = A1 instanceof HiveTableRelation ? BoxedUnit.UNIT : function1.apply(x2);
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(LogicalPlan x2) {
                                    LogicalPlan logicalPlan = x2;
                                    boolean bl = logicalPlan instanceof HiveTableRelation;
                                    return bl;
                                }
                            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.fail(new StringBuilder(63).append("Expecting no conversion from parquet to data sources, ").append("but got:\n").append(queryExecution).toString(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172)));
                        }
                    });
                });
                return BoxedUnit.UNIT;
            });
        }), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
        this.test("values in arrays and maps stored in parquet are always nullable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Tuple2 tuple2 = new Tuple2((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)3))})), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6})));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveParquetSourceSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator31$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection.immutable").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.immutable.Map"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                }

                public Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator31$1(HiveParquetSourceSuite $outer) {
                }
            }
            Dataset df = this.spark().createDataFrame((Seq)Nil$.MODULE$.$colon$colon((Object)tuple2), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator31$1(null))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"m", "a"}));
            MapType mapType1 = new MapType((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, false);
            ArrayType arrayType1 = new ArrayType((DataType)IntegerType$.MODULE$, false);
            StructField structField = new StructField("m", (DataType)mapType1, true, StructField$.MODULE$.apply$default$4());
            StructField structField2 = new StructField("a", (DataType)arrayType1, true, StructField$.MODULE$.apply$default$4());
            StructType expectedSchema1 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(df.schema());
            StructType $org_scalatest_assert_macro_right = expectedSchema1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alwaysNullable"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                df.write().format("parquet").saveAsTable("alwaysNullable");
                MapType mapType2 = new MapType((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$, true);
                ArrayType arrayType2 = new ArrayType((DataType)IntegerType$.MODULE$, true);
                StructField structField = new StructField("m", (DataType)mapType2, true, StructField$.MODULE$.apply$default$4());
                StructField structField2 = new StructField("a", (DataType)arrayType2, true, StructField$.MODULE$.apply$default$4());
                StructType expectedSchema2 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.spark().table("alwaysNullable").schema());
                StructType $org_scalatest_assert_macro_right = expectedSchema2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
                this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)"SELECT m, a FROM alwaysNullable"), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)BoxesRunTime.boxToInteger((int)3))})), Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5, 6}))})));
            });
        }, new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        this.test("SPARK-25993 CREATE EXTERNAL TABLE with subdirectories", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)parquetConversion -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HiveUtils$.MODULE$.CONVERT_METASTORE_PARQUET().key()), (Object)parquetConversion)}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempPath((Function1 & Serializable & scala.Serializable)path -> {
                $this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"parq_tbl1", "parq_tbl2", "parq_tbl3", "tbl1", "tbl2", "tbl3", "tbl4", "tbl5", "tbl6"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    BoxedUnit boxedUnit2;
                    BoxedUnit boxedUnit3;
                    BoxedUnit boxedUnit4;
                    BoxedUnit boxedUnit5;
                    String parquetTblStatement1 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(208).append("\n                 |CREATE EXTERNAL TABLE parq_tbl1(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '").append(path.getCanonicalPath()).append("/l1/").append("'").toString())).stripMargin();
                    $this.sql().apply((Object)parquetTblStatement1);
                    String parquetTblInsertL1 = new StringOps(Predef$.MODULE$.augmentString("INSERT INTO TABLE parq_tbl1 VALUES (1, 1, 'parq1'), (2, 2, 'parq2')")).stripMargin();
                    $this.sql().apply((Object)parquetTblInsertL1);
                    String parquetTblStatement2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(211).append("\n                 |CREATE EXTERNAL TABLE parq_tbl2(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '").append(path.getCanonicalPath()).append("/l1/l2/").append("'").toString())).stripMargin();
                    $this.sql().apply((Object)parquetTblStatement2);
                    String parquetTblInsertL2 = new StringOps(Predef$.MODULE$.augmentString("INSERT INTO TABLE parq_tbl2 VALUES (3, 3, 'parq3'), (4, 4, 'parq4')")).stripMargin();
                    $this.sql().apply((Object)parquetTblInsertL2);
                    String parquetTblStatement3 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(214).append("\n                 |CREATE EXTERNAL TABLE parq_tbl3(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '").append(path.getCanonicalPath()).append("/l1/l2/l3/").append("'").toString())).stripMargin();
                    $this.sql().apply((Object)parquetTblStatement3);
                    String parquetTblInsertL3 = new StringOps(Predef$.MODULE$.augmentString("INSERT INTO TABLE parq_tbl3 VALUES (5, 5, 'parq5'), (6, 6, 'parq6')")).stripMargin();
                    $this.sql().apply((Object)parquetTblInsertL3);
                    String topDirStatement = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(199).append("\n                 |CREATE EXTERNAL TABLE tbl1(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '").append(path.getCanonicalPath()).append("'").toString())).stripMargin();
                    $this.sql().apply((Object)topDirStatement);
                    String string = parquetConversion$2;
                    String string2 = "true";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM tbl1"), (Seq)Nil$.MODULE$);
                        boxedUnit5 = BoxedUnit.UNIT;
                    } else {
                        String msg;
                        String $org_scalatest_assert_macro_left = msg = ((Throwable)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Dataset)$this.sql().apply((Object)"SELECT * FROM tbl1")).show(), ClassTag$.MODULE$.apply(IOException.class), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276))).getMessage();
                        String $org_scalatest_assert_macro_right = HiveParquetSourceSuite.checkErrorMsg$1(new StringBuilder(3).append(path).append("/l1").toString());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        boxedUnit5 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
                    }
                    String l1DirStatement = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(203).append("\n                 |CREATE EXTERNAL TABLE tbl2(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '").append(path.getCanonicalPath()).append("/l1/").append("'").toString())).stripMargin();
                    $this.sql().apply((Object)l1DirStatement);
                    String string3 = parquetConversion$2;
                    String string4 = "true";
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM tbl2"), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(4).append("parq").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom()));
                        boxedUnit4 = BoxedUnit.UNIT;
                    } else {
                        String msg;
                        String $org_scalatest_assert_macro_left = msg = ((Throwable)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Dataset)$this.sql().apply((Object)"SELECT * FROM tbl2")).show(), ClassTag$.MODULE$.apply(IOException.class), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294))).getMessage();
                        String $org_scalatest_assert_macro_right = HiveParquetSourceSuite.checkErrorMsg$1(new StringBuilder(6).append(path).append("/l1/l2").toString());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        boxedUnit4 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
                    }
                    String l2DirStatement = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(206).append("\n                 |CREATE EXTERNAL TABLE tbl3(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '").append(path.getCanonicalPath()).append("/l1/l2/").append("'").toString())).stripMargin();
                    $this.sql().apply((Object)l2DirStatement);
                    String string5 = parquetConversion$2;
                    String string6 = "true";
                    if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM tbl3"), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 4).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(4).append("parq").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom()));
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        String msg;
                        String $org_scalatest_assert_macro_left = msg = ((Throwable)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Dataset)$this.sql().apply((Object)"SELECT * FROM tbl3")).show(), ClassTag$.MODULE$.apply(IOException.class), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312))).getMessage();
                        String $org_scalatest_assert_macro_right = HiveParquetSourceSuite.checkErrorMsg$1(new StringBuilder(9).append(path).append("/l1/l2/l3").toString());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        boxedUnit3 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
                    }
                    String wildcardTopDirStatement = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(199).append("\n                 |CREATE EXTERNAL TABLE tbl4(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '").append(new File(new StringBuilder(2).append(path).append("/*").toString()).toURI()).append("'").toString())).stripMargin();
                    $this.sql().apply((Object)wildcardTopDirStatement);
                    String string7 = parquetConversion$2;
                    String string8 = "true";
                    if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM tbl4"), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(4).append("parq").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom()));
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        String msg;
                        String $org_scalatest_assert_macro_left = msg = ((Throwable)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Dataset)$this.sql().apply((Object)"SELECT * FROM tbl4")).show(), ClassTag$.MODULE$.apply(IOException.class), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330))).getMessage();
                        String $org_scalatest_assert_macro_right = HiveParquetSourceSuite.checkErrorMsg$1(new StringBuilder(6).append(path).append("/l1/l2").toString());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        boxedUnit2 = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
                    }
                    String wildcardL1DirStatement = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(199).append("\n                 |CREATE EXTERNAL TABLE tbl5(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '").append(new File(new StringBuilder(5).append(path).append("/l1/*").toString()).toURI()).append("'").toString())).stripMargin();
                    $this.sql().apply((Object)wildcardL1DirStatement);
                    String string9 = parquetConversion$2;
                    String string10 = "true";
                    if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                        $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM tbl5"), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 4).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(4).append("parq").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom()));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String msg;
                        String $org_scalatest_assert_macro_left = msg = ((Throwable)$this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Dataset)$this.sql().apply((Object)"SELECT * FROM tbl5")).show(), ClassTag$.MODULE$.apply(IOException.class), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348))).getMessage();
                        String $org_scalatest_assert_macro_right = HiveParquetSourceSuite.checkErrorMsg$1(new StringBuilder(9).append(path).append("/l1/l2/l3").toString());
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                        boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
                    }
                    String wildcardL2DirStatement = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(199).append("\n                 |CREATE EXTERNAL TABLE tbl6(\n                 |  c1 int,\n                 |  c2 int,\n                 |  c3 string)\n                 |STORED AS parquet\n                 |LOCATION '").append(new File(new StringBuilder(8).append(path).append("/l1/l2/*").toString()).toURI()).append("'").toString())).stripMargin();
                    $this.sql().apply((Object)wildcardL2DirStatement);
                    $this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)$this.sql().apply((Object)"SELECT * FROM tbl6"), (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 6).map((Function1 & Serializable & scala.Serializable)i -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)i)), new StringBuilder(4).append("parq").append(BoxesRunTime.unboxToInt((Object)i)).toString()})), IndexedSeq$.MODULE$.canBuildFrom()));
                });
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        this.test("SPARK-36941: Save/load ANSI intervals to Hive Parquet table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = "tbl_ansi_intervals";
            this.withTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Tuple2 tuple2 = new Tuple2((Object)Period.ofMonths(10), (Object)Duration.ofDays(1L));
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Period ym = (Period)tuple2._1();
                Duration dt = (Duration)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)ym, (Object)dt);
                Tuple2 tuple23 = tuple22;
                Period ym2 = (Period)tuple23._1();
                Duration dt2 = (Duration)tuple23._2();
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(HiveParquetSourceSuite.class.getClassLoader());
                public final class Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator37$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("java.time.Period").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.time.Duration").asType().toTypeConstructor(), (List)Nil$.MODULE$)));
                    }

                    public Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator37$1(HiveParquetSourceSuite $outer) {
                    }
                }
                Dataset df = this.testImplicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple2((Object)ym2, (Object)dt2), (List)Nil$.MODULE$), this.testImplicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hive_HiveParquetSourceSuite$$typecreator37$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ym", "dt"}));
                df.write().mode(SaveMode.Overwrite).format("parquet").saveAsTable(tableName);
                this.withAllParquetReaders((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.checkAnswer((Function0 & Serializable & scala.Serializable)() -> (Dataset)this.sql().apply((Object)new StringBuilder(14).append("select * from ").append(tableName).toString()), Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ym2, dt2}))));
            });
        }, new Position("HiveParquetSourceSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
    }
}

