/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.mapred;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MultiValuedColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.orc.OrcConf;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.mapred.OrcKey;
import org.apache.orc.mapred.OrcList;
import org.apache.orc.mapred.OrcMap;
import org.apache.orc.mapred.OrcStruct;
import org.apache.orc.mapred.OrcTimestamp;
import org.apache.orc.mapred.OrcUnion;
import org.apache.orc.mapred.OrcValue;

public class OrcMapredRecordWriter<V extends Writable>
implements RecordWriter<NullWritable, V> {
    private static final int GROWTH_FACTOR = 3;
    private final Writer writer;
    private final VectorizedRowBatch batch;
    private final TypeDescription schema;
    private final boolean isTopStruct;
    private final List<MultiValuedColumnVector> variableLengthColumns = new ArrayList<MultiValuedColumnVector>();
    private final int maxChildLength;
    private static final ThreadLocal<byte[]> SPACE_BUFFER = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            byte[] result = new byte[100];
            Arrays.fill(result, (byte)32);
            return result;
        }
    };

    public OrcMapredRecordWriter(Writer writer) {
        this(writer, 1024);
    }

    public OrcMapredRecordWriter(Writer writer, int rowBatchSize) {
        this(writer, rowBatchSize, (Integer)OrcConf.ROW_BATCH_CHILD_LIMIT.getDefaultValue());
    }

    public OrcMapredRecordWriter(Writer writer, int rowBatchSize, int maxChildLength) {
        this.writer = writer;
        this.schema = writer.getSchema();
        this.batch = this.schema.createRowBatch(rowBatchSize);
        OrcMapredRecordWriter.addVariableLengthColumns(this.variableLengthColumns, this.batch);
        this.isTopStruct = this.schema.getCategory() == TypeDescription.Category.STRUCT;
        this.maxChildLength = maxChildLength;
    }

    private static void addVariableLengthColumns(List<MultiValuedColumnVector> result, ColumnVector vector) {
        switch (vector.type) {
            case LIST: {
                ListColumnVector cv = (ListColumnVector)vector;
                result.add((MultiValuedColumnVector)cv);
                OrcMapredRecordWriter.addVariableLengthColumns(result, cv.child);
                break;
            }
            case MAP: {
                MapColumnVector cv = (MapColumnVector)vector;
                result.add((MultiValuedColumnVector)cv);
                OrcMapredRecordWriter.addVariableLengthColumns(result, cv.keys);
                OrcMapredRecordWriter.addVariableLengthColumns(result, cv.values);
                break;
            }
            case STRUCT: {
                for (ColumnVector child : ((StructColumnVector)vector).fields) {
                    OrcMapredRecordWriter.addVariableLengthColumns(result, child);
                }
                break;
            }
            case UNION: {
                for (ColumnVector child : ((UnionColumnVector)vector).fields) {
                    OrcMapredRecordWriter.addVariableLengthColumns(result, child);
                }
                break;
            }
        }
    }

    public static void addVariableLengthColumns(List<MultiValuedColumnVector> result, VectorizedRowBatch batch) {
        for (ColumnVector cv : batch.cols) {
            OrcMapredRecordWriter.addVariableLengthColumns(result, cv);
        }
    }

    static void setLongValue(ColumnVector vector, int row, long value) {
        ((LongColumnVector)vector).vector[row] = value;
    }

    static void setDoubleValue(ColumnVector vector, int row, double value) {
        ((DoubleColumnVector)vector).vector[row] = value;
    }

    static void setBinaryValue(ColumnVector vector, int row, BinaryComparable value) {
        ((BytesColumnVector)vector).setVal(row, value.getBytes(), 0, value.getLength());
    }

    static void setBinaryValue(ColumnVector vector, int row, BinaryComparable value, int maxLength) {
        ((BytesColumnVector)vector).setVal(row, value.getBytes(), 0, Math.min(maxLength, value.getLength()));
    }

    static void setCharValue(BytesColumnVector vector, int row, Text value, int length) {
        int actualLength = value.getLength();
        if (actualLength >= length) {
            OrcMapredRecordWriter.setBinaryValue((ColumnVector)vector, row, (BinaryComparable)value, length);
        } else {
            byte[] spaces = SPACE_BUFFER.get();
            if (length - actualLength > spaces.length) {
                spaces = new byte[length - actualLength];
                Arrays.fill(spaces, (byte)32);
                SPACE_BUFFER.set(spaces);
            }
            vector.setConcat(row, value.getBytes(), 0, actualLength, spaces, 0, length - actualLength);
        }
    }

    static void setStructValue(TypeDescription schema, StructColumnVector vector, int row, OrcStruct value) {
        List<TypeDescription> children = schema.getChildren();
        for (int c = 0; c < value.getNumFields(); ++c) {
            OrcMapredRecordWriter.setColumn(children.get(c), vector.fields[c], row, (Writable)value.getFieldValue(c));
        }
    }

    static void setUnionValue(TypeDescription schema, UnionColumnVector vector, int row, OrcUnion value) {
        int tag;
        List<TypeDescription> children = schema.getChildren();
        vector.tags[row] = tag = value.getTag() & 0xFF;
        OrcMapredRecordWriter.setColumn(children.get(tag), vector.fields[tag], row, value.getObject());
    }

    static void setListValue(TypeDescription schema, ListColumnVector vector, int row, OrcList value) {
        TypeDescription elemType = schema.getChildren().get(0);
        vector.offsets[row] = vector.childCount;
        vector.lengths[row] = value.size();
        vector.childCount = (int)((long)vector.childCount + vector.lengths[row]);
        if (vector.child.isNull.length < vector.childCount) {
            vector.child.ensureSize(vector.childCount * 3, vector.offsets[row] != 0L);
        }
        int e = 0;
        while ((long)e < vector.lengths[row]) {
            OrcMapredRecordWriter.setColumn(elemType, vector.child, (int)vector.offsets[row] + e, (Writable)value.get(e));
            ++e;
        }
    }

    static void setMapValue(TypeDescription schema, MapColumnVector vector, int row, OrcMap<?, ?> value) {
        TypeDescription keyType = schema.getChildren().get(0);
        TypeDescription valueType = schema.getChildren().get(1);
        vector.offsets[row] = vector.childCount;
        vector.lengths[row] = value.size();
        vector.childCount = (int)((long)vector.childCount + vector.lengths[row]);
        if (vector.keys.isNull.length < vector.childCount) {
            vector.keys.ensureSize(vector.childCount * 3, vector.offsets[row] != 0L);
        }
        if (vector.values.isNull.length < vector.childCount) {
            vector.values.ensureSize(vector.childCount * 3, vector.offsets[row] != 0L);
        }
        int e = 0;
        for (Map.Entry entry : value.entrySet()) {
            OrcMapredRecordWriter.setColumn(keyType, vector.keys, (int)vector.offsets[row] + e, (Writable)entry.getKey());
            OrcMapredRecordWriter.setColumn(valueType, vector.values, (int)vector.offsets[row] + e, (Writable)entry.getValue());
            ++e;
        }
    }

    public static void setColumn(TypeDescription schema, ColumnVector vector, int row, Writable value) {
        if (value == null) {
            vector.noNulls = false;
            vector.isNull[row] = true;
        } else {
            switch (schema.getCategory()) {
                case BOOLEAN: {
                    OrcMapredRecordWriter.setLongValue(vector, row, ((BooleanWritable)value).get() ? 1L : 0L);
                    break;
                }
                case BYTE: {
                    OrcMapredRecordWriter.setLongValue(vector, row, ((ByteWritable)value).get());
                    break;
                }
                case SHORT: {
                    OrcMapredRecordWriter.setLongValue(vector, row, ((ShortWritable)value).get());
                    break;
                }
                case INT: {
                    OrcMapredRecordWriter.setLongValue(vector, row, ((IntWritable)value).get());
                    break;
                }
                case LONG: {
                    OrcMapredRecordWriter.setLongValue(vector, row, ((LongWritable)value).get());
                    break;
                }
                case FLOAT: {
                    OrcMapredRecordWriter.setDoubleValue(vector, row, ((FloatWritable)value).get());
                    break;
                }
                case DOUBLE: {
                    OrcMapredRecordWriter.setDoubleValue(vector, row, ((DoubleWritable)value).get());
                    break;
                }
                case STRING: {
                    OrcMapredRecordWriter.setBinaryValue(vector, row, (BinaryComparable)((Text)value));
                    break;
                }
                case CHAR: {
                    OrcMapredRecordWriter.setCharValue((BytesColumnVector)vector, row, (Text)value, schema.getMaxLength());
                    break;
                }
                case VARCHAR: {
                    OrcMapredRecordWriter.setBinaryValue(vector, row, (BinaryComparable)((Text)value), schema.getMaxLength());
                    break;
                }
                case BINARY: {
                    OrcMapredRecordWriter.setBinaryValue(vector, row, (BinaryComparable)((BytesWritable)value));
                    break;
                }
                case DATE: {
                    OrcMapredRecordWriter.setLongValue(vector, row, ((DateWritable)value).getDays());
                    break;
                }
                case TIMESTAMP: 
                case TIMESTAMP_INSTANT: {
                    ((TimestampColumnVector)vector).set(row, (Timestamp)((OrcTimestamp)value));
                    break;
                }
                case DECIMAL: {
                    ((DecimalColumnVector)vector).set(row, (HiveDecimalWritable)value);
                    break;
                }
                case STRUCT: {
                    OrcMapredRecordWriter.setStructValue(schema, (StructColumnVector)vector, row, (OrcStruct)value);
                    break;
                }
                case UNION: {
                    OrcMapredRecordWriter.setUnionValue(schema, (UnionColumnVector)vector, row, (OrcUnion)value);
                    break;
                }
                case LIST: {
                    OrcMapredRecordWriter.setListValue(schema, (ListColumnVector)vector, row, (OrcList)value);
                    break;
                }
                case MAP: {
                    OrcMapredRecordWriter.setMapValue(schema, (MapColumnVector)vector, row, (OrcMap)value);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type " + schema);
                }
            }
        }
    }

    public static int getMaxChildLength(List<MultiValuedColumnVector> columns) {
        int result = 0;
        for (MultiValuedColumnVector cv : columns) {
            result = Math.max(result, cv.childCount);
        }
        return result;
    }

    public void write(NullWritable nullWritable, V v) throws IOException {
        if (this.batch.size == this.batch.getMaxSize() || OrcMapredRecordWriter.getMaxChildLength(this.variableLengthColumns) >= this.maxChildLength) {
            this.writer.addRowBatch(this.batch);
            this.batch.reset();
        }
        int row = this.batch.size++;
        if (v instanceof OrcKey) {
            v = ((OrcKey)v).key;
        } else if (v instanceof OrcValue) {
            v = ((OrcValue)v).value;
        }
        if (this.isTopStruct) {
            for (int f = 0; f < this.schema.getChildren().size(); ++f) {
                OrcMapredRecordWriter.setColumn(this.schema.getChildren().get(f), this.batch.cols[f], row, (Writable)((OrcStruct)v).getFieldValue(f));
            }
        } else {
            OrcMapredRecordWriter.setColumn(this.schema, this.batch.cols[0], row, v);
        }
    }

    public void close(Reporter reporter) throws IOException {
        if (this.batch.size != 0) {
            this.writer.addRowBatch(this.batch);
            this.batch.reset();
        }
        this.writer.close();
    }
}

