/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hive.service.cli.CLIServiceUtils;
import org.apache.hive.service.cli.OperationState;
import org.apache.hive.service.cli.RowSet;
import org.apache.hive.service.cli.operation.GetSchemasOperation;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.SparkOperation;
import org.apache.spark.sql.internal.NonClosableMutableURLClassLoader;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.PartialFunction;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001}3Q!\u0003\u0006\u0001\u0019YA\u0001\u0002\f\u0001\u0003\u0006\u0004%\tA\f\u0005\tg\u0001\u0011\t\u0011)A\u0005_!AA\u0007\u0001B\u0001B\u0003%Q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u0011!I\u0005A!A!\u0002\u0013a\u0004\"\u0002&\u0001\t\u0003Y\u0005\"B)\u0001\t\u0003\u0012\u0006BC,\u0001!\u0003\u0005\t\u0011!C\u00011\nA2\u000b]1sW\u001e+GoU2iK6\f7o\u00149fe\u0006$\u0018n\u001c8\u000b\u0005-a\u0011\u0001\u0004;ie&4Go]3sm\u0016\u0014(BA\u0007\u000f\u0003\u0011A\u0017N^3\u000b\u0005=\u0001\u0012aA:rY*\u0011\u0011CE\u0001\u0006gB\f'o\u001b\u0006\u0003'Q\ta!\u00199bG\",'\"A\u000b\u0002\u0007=\u0014xm\u0005\u0003\u0001/\t2\u0003C\u0001\r!\u001b\u0005I\"B\u0001\u000e\u001c\u0003%y\u0007/\u001a:bi&|gN\u0003\u0002\u001d;\u0005\u00191\r\\5\u000b\u0005yy\u0012aB:feZL7-\u001a\u0006\u0003\u001bII!!I\r\u0003'\u001d+GoU2iK6\f7o\u00149fe\u0006$\u0018n\u001c8\u0011\u0005\r\"S\"\u0001\u0006\n\u0005\u0015R!AD*qCJ\\w\n]3sCRLwN\u001c\t\u0003O)j\u0011\u0001\u000b\u0006\u0003SA\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003W!\u0012q\u0001T8hO&tw-\u0001\u0006tc2\u001cuN\u001c;fqR\u001c\u0001!F\u00010!\t\u0001\u0014'D\u0001\u000f\u0013\t\u0011dB\u0001\u0006T#2\u001buN\u001c;fqR\f1b]9m\u0007>tG/\u001a=uA\u0005i\u0001/\u0019:f]R\u001cVm]:j_:\u0004\"AN\u001d\u000e\u0003]R!\u0001O\u000e\u0002\u000fM,7o]5p]&\u0011!h\u000e\u0002\f\u0011&4XmU3tg&|g.A\u0006dCR\fGn\\4OC6,\u0007CA\u001fG\u001d\tqD\t\u0005\u0002@\u00056\t\u0001I\u0003\u0002B[\u00051AH]8pizR\u0011aQ\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000b\n\u000ba\u0001\u0015:fI\u00164\u0017BA$I\u0005\u0019\u0019FO]5oO*\u0011QIQ\u0001\u000bg\u000eDW-\\1OC6,\u0017A\u0002\u001fj]&$h\bF\u0003M\u001b:{\u0005\u000b\u0005\u0002$\u0001!)AF\u0002a\u0001_!)AG\u0002a\u0001k!)1H\u0002a\u0001y!)\u0011J\u0002a\u0001y\u0005Y!/\u001e8J]R,'O\\1m)\u0005\u0019\u0006C\u0001+V\u001b\u0005\u0011\u0015B\u0001,C\u0005\u0011)f.\u001b;\u0002!A\u0014x\u000e^3di\u0016$GE]8x'\u0016$HCA-^!\tQ6,D\u0001\u001c\u0013\ta6D\u0001\u0004S_^\u001cV\r\u001e\u0005\b=\"\t\t\u00111\u0001M\u0003\rAH%\r")
public class SparkGetSchemasOperation
extends GetSchemasOperation
implements SparkOperation {
    private final SQLContext sqlContext;
    private final HiveSession parentSession;
    private final String catalogName;
    private final String schemaName;
    private String statementId;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$run() {
        super.run();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$close() {
        super.close();
    }

    @Override
    public /* synthetic */ OperationState org$apache$spark$sql$hive$thriftserver$SparkOperation$$super$setState(OperationState newState) {
        return super.setState(newState);
    }

    @Override
    public void cleanup() {
        SparkOperation.cleanup$(this);
    }

    @Override
    public void run() {
        SparkOperation.run$(this);
    }

    @Override
    public void close() {
        SparkOperation.close$(this);
    }

    @Override
    public <T> T withLocalProperties(Function0<T> f) {
        return (T)SparkOperation.withLocalProperties$(this, f);
    }

    @Override
    public String tableTypeString(CatalogTableType tableType) {
        return SparkOperation.tableTypeString$(this, tableType);
    }

    @Override
    public PartialFunction<Throwable, BoxedUnit> onError() {
        return SparkOperation.onError$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String statementId() {
        return this.statementId;
    }

    @Override
    public void statementId_$eq(String x$1) {
        this.statementId = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public /* synthetic */ RowSet protected$rowSet(SparkGetSchemasOperation x$1) {
        return x$1.rowSet;
    }

    @Override
    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    @Override
    public void runInternal() {
        Object object;
        String cmdStr = new StringBuilder(28).append("catalog : ").append(this.catalogName).append(", schemaPattern : ").append(this.schemaName).toString();
        String logMsg = new StringBuilder(20).append("Listing databases '").append(cmdStr).append("'").toString();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(6).append(logMsg).append(" with ").append(this.statementId()).toString());
        this.setState(OperationState.RUNNING);
        NonClosableMutableURLClassLoader executionHiveClassLoader = this.sqlContext().sharedState().jarClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)executionHiveClassLoader);
        if (this.isAuthV2Enabled()) {
            this.authorizeMetaGets(HiveOperationType.GET_TABLES, null, cmdStr);
        }
        HiveThriftServer2$.MODULE$.eventManager().onStatementStart(this.statementId(), this.parentSession.getSessionHandle().getSessionId().toString(), logMsg, this.statementId(), this.parentSession.getUsername());
        try {
            String schemaPattern = this.convertSchemaPattern(this.schemaName);
            this.sqlContext().sessionState().catalog().listDatabases(schemaPattern).foreach((Function1 & Serializable & scala.Serializable)dbName -> this.protected$rowSet(this).addRow(new Object[]{dbName, ""}));
            String globalTempViewDb = this.sqlContext().sessionState().catalog().globalTempViewManager().database();
            Pattern databasePattern = Pattern.compile(CLIServiceUtils.patternToRegex(this.schemaName));
            Object object2 = this.schemaName == null || this.schemaName.isEmpty() || databasePattern.matcher(globalTempViewDb).matches() ? this.rowSet.addRow(new Object[]{globalTempViewDb, ""}) : BoxedUnit.UNIT;
            object = this.setState(OperationState.FINISHED);
        }
        catch (Throwable x$1) {
            PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError();
            if (catchExpr$1.isDefinedAt((Object)x$1)) {
                object = catchExpr$1.apply((Object)x$1);
            }
            throw x$1;
        }
        HiveThriftServer2$.MODULE$.eventManager().onStatementFinish(this.statementId());
    }

    public SparkGetSchemasOperation(SQLContext sqlContext, HiveSession parentSession, String catalogName, String schemaName) {
        this.sqlContext = sqlContext;
        this.parentSession = parentSession;
        this.catalogName = catalogName;
        this.schemaName = schemaName;
        super(parentSession, catalogName, schemaName);
        Logging.$init$((Logging)this);
        SparkOperation.$init$(this);
    }
}

