/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.MapRSecurityUtil;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.thrift.DBTokenStore;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.thrift.HiveDelegationTokenManager;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hive.FipsUtil;
import org.apache.hive.service.auth.KerberosSaslHelper;
import org.apache.hive.service.auth.MapRSecSaslHelper;
import org.apache.hive.service.auth.PlainSaslHelper;
import org.apache.hive.service.auth.SaslQOP;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveAuthFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HiveAuthFactory.class);
    private HadoopThriftAuthBridge.Server saslServer;
    private String authTypeStr;
    private final String transportMode;
    private final HiveConf conf;
    private HiveDelegationTokenManager delegationTokenManager = null;
    public static final String HS2_PROXY_USER = "hive.server2.proxy.user";
    public static final String HS2_CLIENT_TOKEN = "hiveserver2ClientToken";
    public static final String BCFKS_KEYSTORE_TYPE = "bcfks";
    private static Field keytabFile = null;
    private static Method getKeytab = null;

    public HiveAuthFactory(HiveConf conf) throws TTransportException, IOException {
        boolean isAuthTypeSecured;
        this.conf = conf;
        this.transportMode = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE);
        this.authTypeStr = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION);
        boolean bl = isAuthTypeSecured = "KERBEROS".equalsIgnoreCase(this.authTypeStr) || "MAPRSASL".equalsIgnoreCase(this.authTypeStr);
        if ("http".equalsIgnoreCase(this.transportMode)) {
            if (this.authTypeStr == null) {
                this.authTypeStr = AuthTypes.NOSASL.getAuthName();
            }
        } else {
            if (this.authTypeStr == null) {
                this.authTypeStr = AuthTypes.NONE.getAuthName();
            }
            if (isAuthTypeSecured || "PAM".equalsIgnoreCase(this.authTypeStr) && ShimLoader.getHadoopShims().isSecurityEnabled()) {
                String principal = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
                String keytab = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
                this.saslServer = HiveAuthFactory.needUgiLogin(UserGroupInformation.getCurrentUser(), SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0"), keytab) ? ShimLoader.getHadoopThriftAuthBridge().createServer(principal, keytab) : new HadoopThriftAuthBridge.Server();
                this.saslServer = ShimLoader.getHadoopThriftAuthBridge().createServer(conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB), conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL));
                this.delegationTokenManager = new HiveDelegationTokenManager();
                try {
                    RawStore rawStore = null;
                    String tokenStoreClass = conf.getVar(HiveConf.ConfVars.METASTORE_CLUSTER_DELEGATION_TOKEN_STORE_CLS);
                    if (tokenStoreClass.equals(DBTokenStore.class.getName())) {
                        HiveMetaStore.HMSHandler baseHandler = new HiveMetaStore.HMSHandler("new db based metaserver", conf, true);
                        rawStore = baseHandler.getMS();
                    }
                    this.delegationTokenManager.startDelegationTokenSecretManager((Configuration)conf, rawStore, HadoopThriftAuthBridge.Server.ServerMode.HIVESERVER2);
                    this.saslServer.setSecretManager(this.delegationTokenManager.getSecretManager());
                }
                catch (IOException | MetaException e) {
                    throw new TTransportException("Failed to start token manager", e);
                }
            } else {
                this.saslServer = null;
            }
        }
    }

    public Map<String, String> getSaslProperties() {
        HashMap<String, String> saslProps = new HashMap<String, String>();
        SaslQOP saslQOP = SaslQOP.fromString(this.conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_SASL_QOP));
        saslProps.put("javax.security.sasl.qop", saslQOP.toString());
        saslProps.put("javax.security.sasl.server.authentication", "true");
        return saslProps;
    }

    public TTransportFactory getAuthTransFactory() throws LoginException {
        TTransportFactory transportFactory;
        if (this.authTypeStr.equalsIgnoreCase(AuthTypes.KERBEROS.getAuthName()) || this.authTypeStr.equalsIgnoreCase(AuthTypes.MAPRSASL.getAuthName())) {
            try {
                transportFactory = this.saslServer.createTransportFactory(this.getSaslProperties());
            }
            catch (TTransportException e) {
                throw new LoginException(e.getMessage());
            }
        }
        if (this.authTypeStr.equalsIgnoreCase(AuthTypes.NONE.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.LDAP.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.PAM.getAuthName())) {
            if (ShimLoader.getHadoopShims().isSecurityEnabled()) {
                try {
                    transportFactory = this.saslServer.createTransportFactory(this.getSaslProperties());
                }
                catch (TTransportException e) {
                    throw new LoginException(e.getMessage());
                }
                PlainSaslHelper.addPlainDefinitionToFactory(this.authTypeStr, transportFactory, this.saslServer);
            } else {
                transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
            }
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.NOSASL.getAuthName())) {
            transportFactory = new TTransportFactory();
        } else if (this.authTypeStr.equalsIgnoreCase(AuthTypes.CUSTOM.getAuthName())) {
            transportFactory = PlainSaslHelper.getPlainTransportFactory(this.authTypeStr);
        } else {
            throw new LoginException("Unsupported authentication type " + this.authTypeStr);
        }
        return transportFactory;
    }

    public TProcessorFactory getAuthProcFactory(ThriftCLIService service) throws LoginException {
        if (this.authTypeStr.equalsIgnoreCase(AuthTypes.KERBEROS.getAuthName())) {
            return KerberosSaslHelper.getKerberosProcessorFactory(this.saslServer, service);
        }
        if (this.authTypeStr.equalsIgnoreCase(AuthTypes.MAPRSASL.getAuthName())) {
            return MapRSecSaslHelper.getProcessorFactory(this.saslServer, service);
        }
        return PlainSaslHelper.getPlainProcessorFactory(service);
    }

    public String getRemoteUser() {
        return this.saslServer == null ? null : this.saslServer.getRemoteUser();
    }

    public String getIpAddress() {
        if (this.saslServer == null || this.saslServer.getRemoteAddress() == null) {
            return null;
        }
        return this.saslServer.getRemoteAddress().getHostAddress();
    }

    public static void loginFromKeytab(HiveConf hiveConf) throws IOException {
        String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
        String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
        if (principal.isEmpty() || keyTabFile.isEmpty()) {
            throw new IOException("HiveServer2 Kerberos principal or keytab is not correctly configured");
        }
        UserGroupInformation.loginUserFromKeytab((String)SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0"), (String)keyTabFile);
    }

    public static UserGroupInformation loginFromSpnegoKeytabAndReturnUGI(HiveConf hiveConf) throws IOException {
        String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_PRINCIPAL);
        String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_KEYTAB);
        if (principal.isEmpty() || keyTabFile.isEmpty()) {
            throw new IOException("HiveServer2 SPNEGO principal or keytab is not correctly configured");
        }
        return UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0"), (String)keyTabFile);
    }

    public static TTransport getSocketTransport(String host, int port, int loginTimeout) throws TTransportException {
        return new TSocket(host, port, loginTimeout);
    }

    public static TTransport getSSLSocket(String host, int port, int loginTimeout) throws TTransportException {
        return TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)loginTimeout);
    }

    public static TTransport getSSLSocket(String host, int port, int loginTimeout, String trustStorePath, String trustStorePassWord, String sslProtocolVersion) throws TTransportException, KeyStoreException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters(sslProtocolVersion, null);
        if (FipsUtil.isFips()) {
            String trustManagerType = TrustManagerFactory.getDefaultAlgorithm();
            String trustStoreType = KeyStore.getInstance(BCFKS_KEYSTORE_TYPE).getType();
            params.setTrustStore(trustStorePath, trustStorePassWord, trustManagerType, trustStoreType);
        } else {
            params.setTrustStore(trustStorePath, trustStorePassWord);
        }
        params.requireClientAuth(true);
        return TSSLTransportFactory.getClientSocket((String)host, (int)port, (int)loginTimeout, (TSSLTransportFactory.TSSLTransportParameters)params);
    }

    public static TTransport getTrustAllSSLSocket(String host, int port, int loginTimeout) throws TTransportException {
        SSLSocket socket;
        TrustManager[] trustAllCerts = new TrustManager[]{new X509ExtendedTrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
            }
        }};
        try {
            SSLContext sslContext = FipsUtil.isFips() ? SSLContext.getInstance(MapRSecurityUtil.getSslProtocolVersion(), (Provider)new BouncyCastleJsseProvider()) : SSLContext.getInstance(MapRSecurityUtil.getSslProtocolVersion());
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory factory = sslContext.getSocketFactory();
            socket = (SSLSocket)factory.createSocket(host, port);
            socket.setSoTimeout(loginTimeout);
        }
        catch (IOException | KeyManagementException | NoSuchAlgorithmException e) {
            throw new TTransportException("Couldn't create Trust All SSL socket", (Throwable)e);
        }
        return new TSocket((Socket)socket);
    }

    public static TServerSocket getServerSocket(String hiveHost, int portNum) throws TTransportException {
        InetSocketAddress serverAddress = hiveHost == null || hiveHost.isEmpty() ? new InetSocketAddress(portNum) : new InetSocketAddress(hiveHost, portNum);
        return new TServerSocket(serverAddress);
    }

    public static TServerSocket getServerSSLSocket(String hiveHost, int portNum, String keyStorePath, String keyStorePassWord, List<String> sslVersionBlacklist, String sslProtocolVersion) throws TTransportException, UnknownHostException, KeyStoreException {
        TSSLTransportFactory.TSSLTransportParameters params = new TSSLTransportFactory.TSSLTransportParameters(sslProtocolVersion, null);
        if (FipsUtil.isFips()) {
            String keyManagerType = TrustManagerFactory.getDefaultAlgorithm();
            String keyStoreType = KeyStore.getInstance(BCFKS_KEYSTORE_TYPE).getType();
            params.setKeyStore(keyStorePath, keyStorePassWord, keyManagerType, keyStoreType);
        } else {
            params.setKeyStore(keyStorePath, keyStorePassWord);
        }
        InetSocketAddress serverAddress = hiveHost == null || hiveHost.isEmpty() ? new InetSocketAddress(portNum) : new InetSocketAddress(hiveHost, portNum);
        TServerSocket thriftServerSocket = TSSLTransportFactory.getServerSocket((int)portNum, (int)0, (InetAddress)serverAddress.getAddress(), (TSSLTransportFactory.TSSLTransportParameters)params);
        if (thriftServerSocket.getServerSocket() instanceof SSLServerSocket) {
            ArrayList<String> sslVersionBlacklistLocal = new ArrayList<String>();
            for (String sslVersion : sslVersionBlacklist) {
                sslVersionBlacklistLocal.add(sslVersion.trim().toLowerCase(Locale.ROOT));
            }
            SSLServerSocket sslServerSocket = (SSLServerSocket)thriftServerSocket.getServerSocket();
            ArrayList<String> enabledProtocols = new ArrayList<String>();
            for (String protocol : sslServerSocket.getEnabledProtocols()) {
                if (sslVersionBlacklistLocal.contains(protocol.toLowerCase(Locale.ROOT))) {
                    LOG.debug("Disabling SSL Protocol: " + protocol);
                    continue;
                }
                enabledProtocols.add(protocol);
            }
            sslServerSocket.setEnabledProtocols(enabledProtocols.toArray(new String[0]));
            LOG.info("SSL Server Socket Enabled Protocols: " + Arrays.toString(sslServerSocket.getEnabledProtocols()));
        }
        return thriftServerSocket;
    }

    public String getDelegationToken(String owner, String renewer, String remoteAddr) throws HiveSQLException {
        if (this.delegationTokenManager == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            String tokenStr = this.delegationTokenManager.getDelegationTokenWithService(owner, renewer, HS2_CLIENT_TOKEN, remoteAddr);
            if (tokenStr == null || tokenStr.isEmpty()) {
                throw new HiveSQLException("Received empty retrieving delegation token for user " + owner, "08S01");
            }
            return tokenStr;
        }
        catch (IOException e) {
            throw new HiveSQLException("Error retrieving delegation token for user " + owner, "08S01", e);
        }
        catch (InterruptedException e) {
            throw new HiveSQLException("delegation token retrieval interrupted", "08S01", e);
        }
    }

    public void cancelDelegationToken(String delegationToken) throws HiveSQLException {
        if (this.delegationTokenManager == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            this.delegationTokenManager.cancelDelegationToken(delegationToken);
        }
        catch (IOException e) {
            throw new HiveSQLException("Error canceling delegation token " + delegationToken, "08S01", e);
        }
    }

    public void renewDelegationToken(String delegationToken) throws HiveSQLException {
        if (this.delegationTokenManager == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            this.delegationTokenManager.renewDelegationToken(delegationToken);
        }
        catch (IOException e) {
            throw new HiveSQLException("Error renewing delegation token " + delegationToken, "08S01", e);
        }
    }

    public String verifyDelegationToken(String delegationToken) throws HiveSQLException {
        if (this.delegationTokenManager == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            return this.delegationTokenManager.verifyDelegationToken(delegationToken);
        }
        catch (IOException e) {
            String msg = "Error verifying delegation token " + delegationToken;
            LOG.error(msg, (Throwable)e);
            throw new HiveSQLException(msg, "08S01", e);
        }
    }

    public String getUserFromToken(String delegationToken) throws HiveSQLException {
        if (this.delegationTokenManager == null) {
            throw new HiveSQLException("Delegation token only supported over kerberos authentication", "08S01");
        }
        try {
            return this.delegationTokenManager.getUserFromToken(delegationToken);
        }
        catch (IOException e) {
            throw new HiveSQLException("Error extracting user from delegation token " + delegationToken, "08S01", e);
        }
    }

    public static void verifyProxyAccess(String realUser, String proxyUser, String ipAddress, HiveConf hiveConf) throws HiveSQLException {
        try {
            UserGroupInformation sessionUgi;
            if (UserGroupInformation.isSecurityEnabled()) {
                HadoopShims.KerberosNameShim kerbName = ShimLoader.getHadoopShims().getKerberosNameShim(realUser);
                sessionUgi = UserGroupInformation.createProxyUser((String)kerbName.getServiceName(), (UserGroupInformation)UserGroupInformation.getLoginUser());
            } else {
                sessionUgi = UserGroupInformation.createRemoteUser((String)realUser);
            }
            if (!proxyUser.equalsIgnoreCase(realUser)) {
                ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)hiveConf);
                ProxyUsers.authorize((UserGroupInformation)UserGroupInformation.createProxyUser((String)proxyUser, (UserGroupInformation)sessionUgi), (String)ipAddress, (Configuration)hiveConf);
            }
        }
        catch (IOException e) {
            throw new HiveSQLException("Failed to validate proxy privilege of " + realUser + " for " + proxyUser, "08S01", e);
        }
    }

    public static boolean needUgiLogin(UserGroupInformation ugi, String principal, String keytab) {
        return null == ugi || !ugi.hasKerberosCredentials() || !ugi.getUserName().equals(principal) || !Objects.equals(keytab, HiveAuthFactory.getKeytabFromUgi());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getKeytabFromUgi() {
        Class<UserGroupInformation> clazz = UserGroupInformation.class;
        synchronized (UserGroupInformation.class) {
            try {
                if (keytabFile != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return (String)keytabFile.get(null);
                }
                if (getKeytab != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return (String)getKeytab.invoke((Object)UserGroupInformation.getCurrentUser(), new Object[0]);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            catch (Exception e) {
                LOG.debug("Fail to get keytabFile path via reflection", (Throwable)e);
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
        }
    }

    static {
        Class<UserGroupInformation> clz = UserGroupInformation.class;
        try {
            keytabFile = clz.getDeclaredField("keytabFile");
            keytabFile.setAccessible(true);
        }
        catch (NoSuchFieldException nfe) {
            LOG.debug("Cannot find private field \"keytabFile\" in class: " + UserGroupInformation.class.getCanonicalName(), (Throwable)nfe);
            keytabFile = null;
        }
        try {
            getKeytab = clz.getDeclaredMethod("getKeytab", new Class[0]);
            getKeytab.setAccessible(true);
        }
        catch (NoSuchMethodException nme) {
            LOG.debug("Cannot find private method \"getKeytab\" in class:" + UserGroupInformation.class.getCanonicalName(), (Throwable)nme);
            getKeytab = null;
        }
    }

    public static enum AuthTypes {
        NOSASL("NOSASL"),
        NONE("NONE"),
        LDAP("LDAP"),
        KERBEROS("KERBEROS"),
        CUSTOM("CUSTOM"),
        PAM("PAM"),
        MAPRSASL("MAPRSASL");

        private final String authType;

        private AuthTypes(String authType) {
            this.authType = authType;
        }

        public String getAuthName() {
            return this.authType;
        }
    }
}

