/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.server.HiveServer2;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServerErrors$;
import org.apache.spark.sql.hive.thriftserver.ReflectedCompositeService;
import org.apache.spark.sql.hive.thriftserver.ReflectionUtils$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLSessionManager;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001a3Qa\u0002\u0005\u0001\u0015QA\u0001B\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!)q\u0006\u0001C\u0001a!)A\u0007\u0001C!k!)q\t\u0001C!\u0011\")\u0011\n\u0001C!\u0015\n\u00112\u000b]1sWN\u000bFj\u0011'J'\u0016\u0014h/[2f\u0015\tI!\"\u0001\u0007uQJLg\r^:feZ,'O\u0003\u0002\f\u0019\u0005!\u0001.\u001b<f\u0015\tia\"A\u0002tc2T!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\n\u0004\u0001Uq\u0002C\u0001\f\u001d\u001b\u00059\"B\u0001\r\u001a\u0003\r\u0019G.\u001b\u0006\u00035m\tqa]3sm&\u001cWM\u0003\u0002\f!%\u0011Qd\u0006\u0002\u000b\u00072K5+\u001a:wS\u000e,\u0007CA\u0010!\u001b\u0005A\u0011BA\u0011\t\u0005e\u0011VM\u001a7fGR,GmQ8na>\u001c\u0018\u000e^3TKJ4\u0018nY3\u0002\u0015!Lg/Z*feZ,'o\u0001\u0001\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0005\u001dJ\u0012AB:feZ,'/\u0003\u0002*M\tY\u0001*\u001b<f'\u0016\u0014h/\u001a:3\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003Y5j\u0011\u0001D\u0005\u0003]1\u0011!bU)M\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q\u0019\u0011GM\u001a\u0011\u0005}\u0001\u0001\"\u0002\u0012\u0004\u0001\u0004!\u0003\"\u0002\u0016\u0004\u0001\u0004Y\u0013\u0001B5oSR$\"A\u000e\u001f\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\tUs\u0017\u000e\u001e\u0005\u0006{\u0011\u0001\rAP\u0001\tQ&4XmQ8oMB\u0011q(R\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0005G>tgM\u0003\u0002\f\u0007*\u0011A\tE\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0019\u0003%\u0001\u0003%jm\u0016\u001cuN\u001c4\u0002\u000bM$\u0018M\u001d;\u0015\u0003Y\nqaZ3u\u0013:4w\u000eF\u0002L\u001dN\u0003\"A\u0006'\n\u00055;\"\u0001D$fi&sgm\u001c,bYV,\u0007\"B(\u0007\u0001\u0004\u0001\u0016!D:fgNLwN\u001c%b]\u0012dW\r\u0005\u0002\u0017#&\u0011!k\u0006\u0002\u000e'\u0016\u001c8/[8o\u0011\u0006tG\r\\3\t\u000bQ3\u0001\u0019A+\u0002\u0017\u001d,G/\u00138g_RK\b/\u001a\t\u0003-YK!aV\f\u0003\u0017\u001d+G/\u00138g_RK\b/\u001a")
public class SparkSQLCLIService
extends CLIService
implements ReflectedCompositeService {
    private final HiveServer2 hiveServer;
    private final SQLContext sqlContext;
    private final Function1<String, BoxedUnit> org$apache$spark$sql$hive$thriftserver$ReflectedCompositeService$$logInfo;
    private final Function2<String, Throwable, BoxedUnit> org$apache$spark$sql$hive$thriftserver$ReflectedCompositeService$$logError;

    @Override
    public void initCompositeService(HiveConf hiveConf) {
        ReflectedCompositeService.initCompositeService$(this, hiveConf);
    }

    @Override
    public void startCompositeService() {
        ReflectedCompositeService.startCompositeService$(this);
    }

    @Override
    public Function1<String, BoxedUnit> org$apache$spark$sql$hive$thriftserver$ReflectedCompositeService$$logInfo() {
        return this.org$apache$spark$sql$hive$thriftserver$ReflectedCompositeService$$logInfo;
    }

    @Override
    public Function2<String, Throwable, BoxedUnit> org$apache$spark$sql$hive$thriftserver$ReflectedCompositeService$$logError() {
        return this.org$apache$spark$sql$hive$thriftserver$ReflectedCompositeService$$logError;
    }

    @Override
    public final void org$apache$spark$sql$hive$thriftserver$ReflectedCompositeService$_setter_$org$apache$spark$sql$hive$thriftserver$ReflectedCompositeService$$logInfo_$eq(Function1<String, BoxedUnit> x$1) {
        this.org$apache$spark$sql$hive$thriftserver$ReflectedCompositeService$$logInfo = x$1;
    }

    @Override
    public final void org$apache$spark$sql$hive$thriftserver$ReflectedCompositeService$_setter_$org$apache$spark$sql$hive$thriftserver$ReflectedCompositeService$$logError_$eq(Function2<String, Throwable, BoxedUnit> x$1) {
        this.org$apache$spark$sql$hive$thriftserver$ReflectedCompositeService$$logError = x$1;
    }

    @Override
    public void init(HiveConf hiveConf) {
        ReflectionUtils$.MODULE$.setSuperField(this, "hiveConf", hiveConf);
        SparkSQLSessionManager sparkSqlSessionManager = new SparkSQLSessionManager(this.hiveServer, this.sqlContext);
        ReflectionUtils$.MODULE$.setSuperField(this, "sessionManager", sparkSqlSessionManager);
        this.addService(sparkSqlSessionManager);
        UserGroupInformation sparkServiceUGI = null;
        UserGroupInformation httpUGI = null;
        if (hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_AUTHENTICATION).equalsIgnoreCase(HiveAuthFactory.AuthTypes.KERBEROS.toString())) {
            try {
                UserGroupInformation userGroupInformation;
                String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_PRINCIPAL);
                String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_KERBEROS_KEYTAB);
                if (principal.isEmpty() || keyTabFile.isEmpty()) {
                    throw QueryExecutionErrors$.MODULE$.invalidKerberosConfigForHiveServer2Error();
                }
                UserGroupInformation originalUgi = UserGroupInformation.getCurrentUser();
                if (HiveAuthFactory.needUgiLogin(originalUgi, SecurityUtil.getServerPrincipal((String)principal, (String)"0.0.0.0"), keyTabFile)) {
                    HiveAuthFactory.loginFromKeytab(hiveConf);
                    userGroupInformation = Utils.getUGI();
                } else {
                    userGroupInformation = originalUgi;
                }
                sparkServiceUGI = userGroupInformation;
                ReflectionUtils$.MODULE$.setSuperField(this, "serviceUGI", sparkServiceUGI);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IOException ? true : throwable2 instanceof LoginException) {
                    throw HiveThriftServerErrors$.MODULE$.cannotLoginToKerberosError(throwable2);
                }
                throw throwable;
            }
            String principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_PRINCIPAL).trim();
            String keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_KEYTAB).trim();
            if (new StringOps(Predef$.MODULE$.augmentString(principal)).nonEmpty() && new StringOps(Predef$.MODULE$.augmentString(keyTabFile)).nonEmpty()) {
                try {
                    httpUGI = HiveAuthFactory.loginFromSpnegoKeytabAndReturnUGI(hiveConf);
                    ReflectionUtils$.MODULE$.setSuperField(this, "httpUGI", httpUGI);
                }
                catch (IOException e) {
                    throw HiveThriftServerErrors$.MODULE$.cannotLoginToSpnegoError(principal, keyTabFile, e);
                }
            }
        }
        this.initCompositeService(hiveConf);
    }

    @Override
    public void start() {
        this.startCompositeService();
    }

    @Override
    public GetInfoValue getInfo(SessionHandle sessionHandle, GetInfoType getInfoType) {
        GetInfoType getInfoType2 = getInfoType;
        if (((Object)((Object)GetInfoType.CLI_SERVER_NAME)).equals((Object)getInfoType2)) {
            return new GetInfoValue("Spark SQL");
        }
        if (((Object)((Object)GetInfoType.CLI_DBMS_NAME)).equals((Object)getInfoType2)) {
            return new GetInfoValue("Spark SQL");
        }
        if (((Object)((Object)GetInfoType.CLI_DBMS_VER)).equals((Object)getInfoType2)) {
            return new GetInfoValue(this.sqlContext.sparkContext().version());
        }
        return super.getInfo(sessionHandle, getInfoType);
    }

    public SparkSQLCLIService(HiveServer2 hiveServer, SQLContext sqlContext) {
        this.hiveServer = hiveServer;
        this.sqlContext = sqlContext;
        super(hiveServer);
        ReflectedCompositeService.$init$(this);
    }
}

