/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.processors.AddResourceProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.DeleteResourceProcessor;
import org.apache.hadoop.hive.ql.processors.ListResourceProcessor;
import org.apache.hadoop.hive.ql.processors.ResetProcessor;
import org.apache.hadoop.hive.ql.processors.SetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.util.StringUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLDriver$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@ScalaSignature(bytes="\u0006\u0001\u0005\rvA\u0002\u0011\"\u0011\u0003\u0019SF\u0002\u00040C!\u00051\u0005\r\u0005\u0006{\u0005!\ta\u0010\u0005\b\u0001\u0006\u0011\r\u0011\"\u0003B\u0011\u0019Q\u0015\u0001)A\u0005\u0005\"91*\u0001b\u0001\n\u0013a\u0005BB,\u0002A\u0003%Q\nC\u0005Y\u0003\u0001\u0007\t\u0019!C\u00053\"I\u0011-\u0001a\u0001\u0002\u0004%IA\u0019\u0005\nQ\u0006\u0001\r\u0011!Q!\niCq![\u0001C\u0002\u00135!\u000e\u0003\u0004o\u0003\u0001\u0006ia\u001b\u0005\u0006_\u0006!\t\u0001\u001d\u0005\u0006c\u0006!\tA\u001d\u0005\u0006q\u0006!\t!\u001f\u0004\u0007_\u0005\u00021%!\u0005\t\ruzA\u0011AA\r\u0011%\tib\u0004b\u0001\n\u0013\ty\u0002C\u0004\u0002\"=\u0001\u000b\u0011B@\t\u0013\u0005\rrB1A\u0005\n\u0005\u0015\u0002\u0002CA\u001a\u001f\u0001\u0006I!a\n\t\u0013\u0005UrB1A\u0005\n\u0005]\u0002\u0002CA)\u001f\u0001\u0006I!!\u000f\t\u0011a|!\u0019!C\u0005\u0003'Bq!!\u0016\u0010A\u0003%!\u0010C\u0005\u0002X=\u0011\r\u0011\"\u0003\u0002Z!A\u0011QM\b!\u0002\u0013\tY\u0006C\u0004\u0002h=!\t%!\u001b\t\r\u0005mt\u0002\"\u0001q\u0011\u001d\tih\u0004C!\u0003\u007fBq!a#\u0010\t\u0003\ni\t\u0003\u0005\u0002\u0018>!\taIAM\u0003E\u0019\u0006/\u0019:l'Fc5\tT%Ee&4XM\u001d\u0006\u0003E\r\nA\u0002\u001e5sS\u001a$8/\u001a:wKJT!\u0001J\u0013\u0002\t!Lg/\u001a\u0006\u0003M\u001d\n1a]9m\u0015\tA\u0013&A\u0003ta\u0006\u00148N\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<\u0007C\u0001\u0018\u0002\u001b\u0005\t#!E*qCJ\\7+\u0015'D\u0019&#%/\u001b<feN\u0019\u0011!M\u001c\u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g!\tA4(D\u0001:\u0015\tQt%\u0001\u0005j]R,'O\\1m\u0013\ta\u0014HA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!L\u0001\u0007aJ|W\u000e\u001d;\u0016\u0003\t\u0003\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\t1\fgn\u001a\u0006\u0002\u000f\u0006!!.\u0019<b\u0013\tIEI\u0001\u0004TiJLgnZ\u0001\baJ|W\u000e\u001d;!\u0003=\u0019wN\u001c;j]V,G\r\u0015:p[B$X#A'\u0011\u00059+fBA(T!\t\u00016'D\u0001R\u0015\t\u0011f(\u0001\u0004=e>|GOP\u0005\u0003)N\na\u0001\u0015:fI\u00164\u0017BA%W\u0015\t!6'\u0001\td_:$\u0018N\\;fIB\u0013x.\u001c9uA\u0005IAO]1ogB|'\u000f^\u000b\u00025B\u00111lX\u0007\u00029*\u0011\u0001,\u0018\u0006\u0003=&\na\u0001\u001e5sS\u001a$\u0018B\u00011]\u0005\u001d!6k\\2lKR\fQ\u0002\u001e:b]N\u0004xN\u001d;`I\u0015\fHCA2g!\t\u0011D-\u0003\u0002fg\t!QK\\5u\u0011\u001d9\u0007\"!AA\u0002i\u000b1\u0001\u001f\u00132\u0003)!(/\u00198ta>\u0014H\u000fI\u0001\u0019'B\u000b%kS0I\u0003\u0012{u\nU0Q%>\u0003v\f\u0015*F\r&CV#A6\u0010\u00031\f\u0013!\\\u0001\u000egB\f'o\u001b\u0018iC\u0012|w\u000e\u001d\u0018\u00023M\u0003\u0016IU&`\u0011\u0006#uj\u0014)`!J{\u0005k\u0018)S\u000b\u001aK\u0005\fI\u0001\u0015S:\u001cH/\u00197m'&<g.\u00197IC:$G.\u001a:\u0015\u0003\r\fA!\\1j]R\u00111m\u001d\u0005\u0006i6\u0001\r!^\u0001\u0005CJ<7\u000fE\u00023m6K!a^\u001a\u0003\u000b\u0005\u0013(/Y=\u0002\u0019%\u001c(+Z7pi\u0016lu\u000eZ3\u0015\u0005il\bC\u0001\u001a|\u0013\ta8GA\u0004C_>dW-\u00198\t\u000byt\u0001\u0019A@\u0002\u000bM$\u0018\r^3\u0011\t\u0005\u0005\u0011QB\u0007\u0003\u0003\u0007QA!!\u0002\u0002\b\u0005\u00191\r\\5\u000b\u0007\u0011\nIAC\u0002\u0002\f%\na\u0001[1e_>\u0004\u0018\u0002BA\b\u0003\u0007\u0011qb\u00117j'\u0016\u001c8/[8o'R\fG/Z\n\u0005\u001f\u0005Mq\u0007\u0005\u0003\u0002\u0002\u0005U\u0011\u0002BA\f\u0003\u0007\u0011\u0011b\u00117j\tJLg/\u001a:\u0015\u0005\u0005m\u0001C\u0001\u0018\u0010\u00031\u0019Xm]:j_:\u001cF/\u0019;f+\u0005y\u0018!D:fgNLwN\\*uCR,\u0007%A\u0002M\u001f\u001e+\"!a\n\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\f,\u0003\u0015\u0019HN\u001a\u001bk\u0013\u0011\t\t$a\u000b\u0003\r1{wmZ3s\u0003\u0011auj\u0012\u0011\u0002\u000f\r|gn]8mKV\u0011\u0011\u0011\b\t\u0005\u0003w\tYE\u0004\u0003\u0002>\u0005\u001dSBAA \u0015\u0011\t\t%a\u0011\u0002\u000fM,7o]5p]*!\u0011QIA\u0004\u0003\t\tH.\u0003\u0003\u0002J\u0005}\u0012\u0001D*fgNLwN\\*uCR,\u0017\u0002BA'\u0003\u001f\u0012\u0011\u0002T8h\u0011\u0016d\u0007/\u001a:\u000b\t\u0005%\u0013qH\u0001\tG>t7o\u001c7fAU\t!0A\u0007jgJ+Wn\u001c;f\u001b>$W\rI\u0001\u0005G>tg-\u0006\u0002\u0002\\A!\u0011QLA1\u001b\t\tyF\u0003\u0003\u0002X\u0005%\u0011\u0002BA2\u0003?\u0012QbQ8oM&<WO]1uS>t\u0017!B2p]\u001a\u0004\u0013\u0001E:fi\"Kg/\u001a,be&\f'\r\\3t)\r\u0019\u00171\u000e\u0005\b\u0003[Z\u0002\u0019AA8\u00035A\u0017N^3WCJL\u0017M\u00197fgB1\u0011\u0011OA<\u001b6k!!a\u001d\u000b\u0007\u0005Ud)\u0001\u0003vi&d\u0017\u0002BA=\u0003g\u00121!T1q\u0003M\u0001(/\u001b8u\u001b\u0006\u001cH/\u001a:B]\u0012\f\u0005\u000f]%e\u0003)\u0001(o\\2fgN\u001cU\u000e\u001a\u000b\u0005\u0003\u0003\u000b9\tE\u00023\u0003\u0007K1!!\"4\u0005\rIe\u000e\u001e\u0005\u0007\u0003\u0013k\u0002\u0019A'\u0002\u0007\rlG-A\u0006qe>\u001cWm]:MS:,GCBAA\u0003\u001f\u000b\u0019\n\u0003\u0004\u0002\u0012z\u0001\r!T\u0001\u0005Y&tW\r\u0003\u0004\u0002\u0016z\u0001\rA_\u0001\u0012C2dwn^%oi\u0016\u0014(/\u001e9uS:<\u0017AD:qY&$8+Z7j\u0007>dwN\u001c\u000b\u0005\u00037\u000b\t\u000bE\u0003\u0002r\u0005uU*\u0003\u0003\u0002 \u0006M$\u0001\u0002'jgRDa!!% \u0001\u0004i\u0005")
public class SparkSQLCLIDriver
extends CliDriver
implements Logging {
    private final CliSessionState sessionState;
    private final Logger LOG;
    private final SessionState.LogHelper org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console;
    private final boolean isRemoteMode;
    private final Configuration conf;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void main(String[] stringArray) {
        SparkSQLCLIDriver$.MODULE$.main(stringArray);
    }

    public static void installSignalHandler() {
        SparkSQLCLIDriver$.MODULE$.installSignalHandler();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private CliSessionState sessionState() {
        return this.sessionState;
    }

    private Logger LOG() {
        return this.LOG;
    }

    public SessionState.LogHelper org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console() {
        return this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console;
    }

    private boolean isRemoteMode() {
        return this.isRemoteMode;
    }

    private Configuration conf() {
        return this.conf;
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(hiveVariables).asScala()).foreach((Function1 & Serializable & scala.Serializable)kv -> {
            SparkSQLCLIDriver.$anonfun$setHiveVariables$1(kv);
            return BoxedUnit.UNIT;
        });
    }

    public void printMasterAndAppId() {
        String master = SparkSQLEnv$.MODULE$.sparkContext().master();
        String appId = SparkSQLEnv$.MODULE$.sparkContext().applicationId();
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(new StringBuilder(32).append("Spark master: ").append(master).append(", Application Id: ").append(appId).toString());
    }

    public int processCmd(String cmd) {
        int ret;
        block17: {
            String cmd_trimmed = cmd.trim();
            String cmd_lower = cmd_trimmed.toLowerCase(Locale.ROOT);
            String[] tokens = cmd_trimmed.split("\\s+");
            String cmd_1 = cmd_trimmed.substring(tokens[0].length()).trim();
            if (cmd_lower.equals("quit") || cmd_lower.equals("exit")) {
                this.sessionState().close();
                System.exit(0);
            }
            if (tokens[0].toLowerCase(Locale.ROOT).equals("source") || cmd_trimmed.startsWith("!") || this.isRemoteMode()) {
                long startTimeNs = System.nanoTime();
                super.processCmd(cmd);
                long endTimeNs = System.nanoTime();
                double timeTaken = (double)TimeUnit.NANOSECONDS.toMillis(endTimeNs - startTimeNs) / 1000.0;
                this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(new StringBuilder(20).append("Time taken: ").append(timeTaken).append(" seconds").toString());
                return 0;
            }
            ret = 0;
            HiveConf hconf = (HiveConf)this.conf();
            CommandProcessor proc = CommandProcessorFactory.get((String[])tokens, (HiveConf)hconf);
            if (proc == null) break block17;
            if (proc instanceof Driver || proc instanceof SetProcessor || proc instanceof AddResourceProcessor || proc instanceof ListResourceProcessor || proc instanceof DeleteResourceProcessor || proc instanceof ResetProcessor) {
                SparkSQLDriver driver = new SparkSQLDriver(SparkSQLDriver$.MODULE$.$lessinit$greater$default$1());
                driver.init();
                PrintStream out = this.sessionState().out;
                PrintStream err = this.sessionState().err;
                long startTimeNs = System.nanoTime();
                if (this.sessionState().getIsVerbose()) {
                    out.println(cmd);
                }
                CommandProcessorResponse rc = driver.run(cmd);
                long endTimeNs = System.nanoTime();
                double timeTaken = (double)TimeUnit.NANOSECONDS.toMillis(endTimeNs - startTimeNs) / 1000.0;
                ret = rc.getResponseCode();
                if (ret != 0) {
                    Throwable throwable = rc.getException();
                    if (throwable instanceof AnalysisException) {
                        AnalysisException analysisException = (AnalysisException)throwable;
                        Option option = analysisException.cause();
                        if (option instanceof Some && !this.sessionState().getIsSilent()) {
                            err.println(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("Error in query: ").append(analysisException.getMessage()).append("\n                       |").append(StringUtils.stringifyException((Throwable)analysisException)).append("\n                     ").toString())).stripMargin());
                        } else {
                            err.println(new StringBuilder(16).append("Error in query: ").append(analysisException.getMessage()).toString());
                        }
                    } else {
                        err.println(rc.getErrorMessage());
                    }
                    driver.close();
                    return ret;
                }
                ArrayList res = new ArrayList();
                if (HiveConf.getBoolVar((Configuration)this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CLI_PRINT_HEADER) || SparkSQLEnv$.MODULE$.sqlContext().conf().cliPrintHeader()) {
                    Option$.MODULE$.apply((Object)driver.getSchema().getFieldSchemas()).foreach((Function1 & Serializable & scala.Serializable)fields -> {
                        out.println(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(fields).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getName(), Buffer$.MODULE$.canBuildFrom())).mkString("\t"));
                        return BoxedUnit.UNIT;
                    });
                }
                IntRef counter = IntRef.create((int)0);
                try {
                    while (!out.checkError() && driver.getResults(res)) {
                        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(res).asScala()).foreach((Function1 & Serializable & scala.Serializable)l -> {
                            SparkSQLCLIDriver.$anonfun$processCmd$3(counter, out, l);
                            return BoxedUnit.UNIT;
                        });
                        res.clear();
                    }
                }
                catch (IOException e) {
                    this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printError(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(63).append("Failed with exception ").append(e.getClass().getName()).append(": ").append(e.getMessage()).append("\n                   |").append(StringUtils.stringifyException((Throwable)e)).append("\n                 ").toString())).stripMargin());
                    ret = 1;
                }
                int cret = driver.close();
                if (ret == 0) {
                    ret = cret;
                }
                String responseMsg = new StringBuilder(20).append("Time taken: ").append(timeTaken).append(" seconds").toString();
                if (counter.elem != 0) {
                    responseMsg = new StringBuilder(17).append(responseMsg).append(", Fetched ").append(counter.elem).append(" row(s)").toString();
                }
                this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo(responseMsg, null);
                driver.destroy();
            } else {
                if (this.sessionState().getIsVerbose()) {
                    this.sessionState().out.println(new StringBuilder(1).append(tokens[0]).append(" ").append(cmd_1).toString());
                }
                ret = proc.run(cmd_1).getResponseCode();
            }
        }
        return ret;
    }

    public int processLine(String line, boolean allowInterrupting) {
        int n;
        Object object = new Object();
        try {
            SignalHandler oldSignal = null;
            Signal interruptSignal = null;
            if (allowInterrupting) {
                interruptSignal = new Signal("INT");
                oldSignal = Signal.handle(interruptSignal, new SignalHandler(this){
                    private boolean interruptRequested;
                    private final /* synthetic */ SparkSQLCLIDriver $outer;

                    private boolean interruptRequested() {
                        return this.interruptRequested;
                    }

                    private void interruptRequested_$eq(boolean x$1) {
                        this.interruptRequested = x$1;
                    }

                    public void handle(Signal signal) {
                        boolean initialRequest = !this.interruptRequested();
                        this.interruptRequested_$eq(true);
                        if (!initialRequest) {
                            this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Exiting the JVM");
                            System.exit(127);
                        }
                        this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Interrupting... Be patient, this might take some time.");
                        this.$outer.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console().printInfo("Press Ctrl+C again to kill JVM");
                        HiveInterruptUtils.interrupt();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.interruptRequested = false;
                    }
                });
            }
            try {
                IntRef lastRet = IntRef.create((int)0);
                Buffer commands = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.splitSemiColon(line)).asScala();
                ObjectRef command = ObjectRef.create((Object)"");
                commands.foreach((Function1 & Serializable & scala.Serializable)oneCmd -> {
                    SparkSQLCLIDriver.$anonfun$processLine$1(this, command, lastRet, object, oneCmd);
                    return BoxedUnit.UNIT;
                });
                CommandProcessorFactory.clean((HiveConf)((HiveConf)this.conf()));
                n = lastRet.elem;
            }
            catch (Throwable throwable) {
                if (oldSignal != null && interruptSignal != null) {
                    Signal.handle(interruptSignal, oldSignal);
                }
                throw throwable;
            }
            if (oldSignal != null && interruptSignal != null) {
                Signal.handle(interruptSignal, oldSignal);
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                n = ex.value$mcI$sp();
            }
            throw ex;
        }
        return n;
    }

    public List<String> splitSemiColon(String line) {
        BooleanRef insideSingleQuote = BooleanRef.create((boolean)false);
        BooleanRef insideDoubleQuote = BooleanRef.create((boolean)false);
        BooleanRef insideSimpleComment = BooleanRef.create((boolean)false);
        IntRef bracketedCommentLevel = IntRef.create((int)0);
        BooleanRef escape = BooleanRef.create((boolean)false);
        IntRef beginIndex = IntRef.create((int)0);
        BooleanRef leavingBracketedComment = BooleanRef.create((boolean)false);
        BooleanRef isStatement = BooleanRef.create((boolean)false);
        ArrayList<String> ret = new ArrayList<String>();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), line.length()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            if (leavingBracketedComment$1.elem) {
                --bracketedCommentLevel$1.elem;
                leavingBracketedComment$1.elem = false;
            }
            if (line.charAt(index) == '\'' && !SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel)) {
                if (!escape$1.elem && !insideDoubleQuote$1.elem) {
                    insideSingleQuote$1.elem = !insideSingleQuote$1.elem;
                }
            } else if (line.charAt(index) == '\"' && !SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel)) {
                if (!escape$1.elem && !insideSingleQuote$1.elem) {
                    insideDoubleQuote$1.elem = !insideDoubleQuote$1.elem;
                }
            } else if (line.charAt(index) == '-') {
                boolean hasNext;
                boolean bl = hasNext = index + 1 < line.length();
                if (!insideDoubleQuote$1.elem && !insideSingleQuote$1.elem && !SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel) && hasNext && line.charAt(index + 1) == '-') {
                    insideSimpleComment$1.elem = true;
                }
            } else if (line.charAt(index) == ';') {
                if (!(insideSingleQuote$1.elem || insideDoubleQuote$1.elem || SparkSQLCLIDriver.insideComment$1(insideSimpleComment, bracketedCommentLevel))) {
                    Object object = isStatement$1.elem ? BoxesRunTime.boxToBoolean((boolean)ret.add(line.substring(beginIndex$1.elem, index))) : BoxedUnit.UNIT;
                    beginIndex$1.elem = index + 1;
                    isStatement$1.elem = false;
                }
            } else if (line.charAt(index) == '\n') {
                if (!escape$1.elem) {
                    insideSimpleComment$1.elem = false;
                }
            } else if (line.charAt(index) == '/' && !insideSimpleComment$1.elem) {
                boolean hasNext;
                boolean bl = hasNext = index + 1 < line.length();
                if (!insideSingleQuote$1.elem && !insideDoubleQuote$1.elem) {
                    if (SparkSQLCLIDriver.insideBracketedComment$1(bracketedCommentLevel) && line.charAt(index - 1) == '*') {
                        leavingBracketedComment$1.elem = true;
                    } else if (hasNext && line.charAt(index + 1) == '*') {
                        ++bracketedCommentLevel$1.elem;
                    }
                }
            }
            if (escape$1.elem) {
                escape$1.elem = false;
            } else if (line.charAt(index) == '\\') {
                escape$1.elem = true;
            }
            isStatement$1.elem = SparkSQLCLIDriver.statementInProgress$1(index, isStatement, beginIndex, line, insideSimpleComment, bracketedCommentLevel);
        });
        boolean endOfBracketedComment = leavingBracketedComment.elem && bracketedCommentLevel.elem == 1;
        Object object = !endOfBracketedComment && (isStatement.elem || SparkSQLCLIDriver.insideBracketedComment$1(bracketedCommentLevel)) ? BoxesRunTime.boxToBoolean((boolean)ret.add(line.substring(beginIndex.elem))) : BoxedUnit.UNIT;
        return ret;
    }

    public static final /* synthetic */ void $anonfun$setHiveVariables$1(Tuple2 kv) {
        SparkSQLEnv$.MODULE$.sqlContext().conf().setConfString((String)kv._1(), (String)kv._2());
    }

    public static final /* synthetic */ void $anonfun$processCmd$3(IntRef counter$1, PrintStream out$1, String l) {
        ++counter$1.elem;
        out$1.println(l);
    }

    public static final /* synthetic */ void $anonfun$processLine$1(SparkSQLCLIDriver $this, ObjectRef command$1, IntRef lastRet$1, Object nonLocalReturnKey1$1, String oneCmd) {
        if (org.apache.commons.lang3.StringUtils.endsWith((CharSequence)oneCmd, (CharSequence)"\\")) {
            command$1.elem = new StringBuilder(1).append((String)command$1.elem).append(org.apache.commons.lang3.StringUtils.chop((String)oneCmd)).append(";").toString();
            return;
        }
        command$1.elem = new StringBuilder(0).append((String)command$1.elem).append(oneCmd).toString();
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((String)command$1.elem))) {
            int ret = $this.processCmd((String)command$1.elem);
            command$1.elem = "";
            lastRet$1.elem = ret;
            boolean ignoreErrors = HiveConf.getBoolVar((Configuration)$this.conf(), (HiveConf.ConfVars)HiveConf.ConfVars.CLIIGNOREERRORS);
            if (ret != 0 && !ignoreErrors) {
                CommandProcessorFactory.clean((HiveConf)((HiveConf)$this.conf()));
                throw new NonLocalReturnControl.mcI.sp(nonLocalReturnKey1$1, ret);
            }
            return;
        }
    }

    private static final boolean insideBracketedComment$1(IntRef bracketedCommentLevel$1) {
        return bracketedCommentLevel$1.elem > 0;
    }

    private static final boolean insideComment$1(BooleanRef insideSimpleComment$1, IntRef bracketedCommentLevel$1) {
        return insideSimpleComment$1.elem || SparkSQLCLIDriver.insideBracketedComment$1(bracketedCommentLevel$1);
    }

    private static final boolean statementInProgress$1(int index, BooleanRef isStatement$1, IntRef beginIndex$1, String line$1, BooleanRef insideSimpleComment$1, IntRef bracketedCommentLevel$1) {
        return isStatement$1.elem || !SparkSQLCLIDriver.insideComment$1(insideSimpleComment$1, bracketedCommentLevel$1) && index > beginIndex$1.elem && !String.valueOf(BoxesRunTime.boxToCharacter((char)line$1.charAt(index))).trim().isEmpty();
    }

    public SparkSQLCLIDriver() {
        Logging.$init$((Logging)this);
        this.sessionState = (CliSessionState)SessionState.get();
        this.LOG = LoggerFactory.getLogger(SparkSQLCLIDriver.class);
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$console = new SessionState.LogHelper(this.LOG());
        this.isRemoteMode = SparkSQLCLIDriver$.MODULE$.isRemoteMode(this.sessionState());
        Object object = this.conf = this.sessionState() != null ? this.sessionState().getConf() : new Configuration();
        if (!this.isRemoteMode()) {
            SparkSQLEnv$.MODULE$.init();
            if (this.sessionState().getIsSilent()) {
                SparkSQLEnv$.MODULE$.sparkContext().setLogLevel("warn");
            }
        } else {
            throw QueryExecutionErrors$.MODULE$.remoteOperationsUnsupportedError();
        }
    }
}

