/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver.ui;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.internal.config.Status$;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2;
import org.apache.spark.sql.hive.thriftserver.ui.ExecutionInfo;
import org.apache.spark.sql.hive.thriftserver.ui.HiveThriftServer2AppStatusStore;
import org.apache.spark.sql.hive.thriftserver.ui.HiveThriftServer2Listener;
import org.apache.spark.sql.hive.thriftserver.ui.HiveThriftServer2Listener$;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationCanceled;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationClosed;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationError;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationFinish;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationParsed;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationStart;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationStart$;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerOperationTimeout;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerSessionClosed;
import org.apache.spark.sql.hive.thriftserver.ui.SparkListenerThriftServerSessionCreated;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.util.kvstore.InMemoryStore;
import org.apache.spark.util.kvstore.KVStore;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfter;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001M3Aa\u0002\u0005\u0001/!)!\u0005\u0001C\u0001G!Ia\u0005\u0001a\u0001\u0002\u0004%Ia\n\u0005\n]\u0001\u0001\r\u00111A\u0005\n=B\u0011\u0002\u000f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0015\t\u000be\u0002A\u0011\u0002\u001e\t\u000b\r\u0003A\u0011\u0002#\u0003=!Kg/\u001a+ie&4GoU3sm\u0016\u0014(\u0007T5ti\u0016tWM]*vSR,'BA\u0005\u000b\u0003\t)\u0018N\u0003\u0002\f\u0019\u0005aA\u000f\u001b:jMR\u001cXM\u001d<fe*\u0011QBD\u0001\u0005Q&4XM\u0003\u0002\u0010!\u0005\u00191/\u001d7\u000b\u0005E\u0011\u0012!B:qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001aE\u0002\u00011q\u0001\"!\u0007\u000e\u000e\u0003AI!a\u0007\t\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\ti\u0002%D\u0001\u001f\u0015\tyB#A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011E\b\u0002\u000f\u0005\u00164wN]3B]\u0012\fe\r^3s\u0003\u0019a\u0014N\\5u}Q\tA\u0005\u0005\u0002&\u00015\t\u0001\"A\u0004lmN$xN]3\u0016\u0003!\u0002\"!\u000b\u0017\u000e\u0003)R!a\u000b\t\u0002\rM$\u0018\r^;t\u0013\ti#F\u0001\u000bFY\u0016lWM\u001c;Ue\u0006\u001c7.\u001b8h'R|'/Z\u0001\fWZ\u001cHo\u001c:f?\u0012*\u0017\u000f\u0006\u00021mA\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t!QK\\5u\u0011\u001d94!!AA\u0002!\n1\u0001\u001f\u00132\u0003!Ygo\u001d;pe\u0016\u0004\u0013\u0001E2sK\u0006$X\r\u0015:pa\u0016\u0014H/[3t+\u0005Y\u0004C\u0001\u001fB\u001b\u0005i$B\u0001 @\u0003\u0011)H/\u001b7\u000b\u0003\u0001\u000bAA[1wC&\u0011!)\u0010\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001F2sK\u0006$X-\u00119q'R\fG/^:Ti>\u0014X\r\u0006\u0002F\u001dB!\u0011G\u0012%L\u0013\t9%G\u0001\u0004UkBdWM\r\t\u0003K%K!A\u0013\u0005\u0003?!Kg/\u001a+ie&4GoU3sm\u0016\u0014('\u00119q'R\fG/^:Ti>\u0014X\r\u0005\u0002&\u0019&\u0011Q\n\u0003\u0002\u001a\u0011&4X\r\u00165sS\u001a$8+\u001a:wKJ\u0014D*[:uK:,'\u000fC\u0003P\r\u0001\u0007\u0001+\u0001\u0003mSZ,\u0007CA\u0019R\u0013\t\u0011&GA\u0004C_>dW-\u00198")
public class HiveThriftServer2ListenerSuite
extends SparkFunSuite
implements BeforeAndAfter {
    private ElementTrackingStore kvstore;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, (Option)testName, (Args)args);
    }

    public void before(Function0<Object> fun, Position pos) {
        BeforeAndAfter.before$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public void after(Function0<Object> fun, Position pos) {
        BeforeAndAfter.after$((BeforeAndAfter)this, fun, (Position)pos);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.runTest$((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.run$((BeforeAndAfter)this, testName, (Args)args);
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public final void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference<Option<Function0<Object>>> x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    private ElementTrackingStore kvstore() {
        return this.kvstore;
    }

    private void kvstore_$eq(ElementTrackingStore x$1) {
        this.kvstore = x$1;
    }

    private Properties createProperties() {
        Properties properties = new Properties();
        properties.setProperty(SparkContext$.MODULE$.SPARK_JOB_GROUP_ID(), "groupId");
        return properties;
    }

    private Tuple2<HiveThriftServer2AppStatusStore, HiveThriftServer2Listener> createAppStatusStore(boolean live) {
        SparkConf sparkConf = new SparkConf();
        sparkConf.set(Status$.MODULE$.ASYNC_TRACKING_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false)).set(SQLConf$.MODULE$.THRIFTSERVER_UI_SESSION_LIMIT(), (Object)BoxesRunTime.boxToInteger((int)1)).set(Status$.MODULE$.LIVE_ENTITY_UPDATE_PERIOD(), (Object)BoxesRunTime.boxToLong((long)0L));
        this.kvstore_$eq(new ElementTrackingStore((KVStore)new InMemoryStore(), sparkConf));
        if (live) {
            HiveThriftServer2 server = (HiveThriftServer2)Mockito.mock(HiveThriftServer2.class, (Answer)Mockito.RETURNS_SMART_NULLS);
            HiveThriftServer2Listener listener = new HiveThriftServer2Listener(this.kvstore(), sparkConf, (Option)new Some((Object)server), HiveThriftServer2Listener$.MODULE$.$lessinit$greater$default$4());
            return new Tuple2((Object)new HiveThriftServer2AppStatusStore((KVStore)this.kvstore()), (Object)listener);
        }
        return new Tuple2((Object)new HiveThriftServer2AppStatusStore((KVStore)this.kvstore()), (Object)new HiveThriftServer2Listener(this.kvstore(), sparkConf, (Option)None$.MODULE$, false));
    }

    public HiveThriftServer2ListenerSuite() {
        BeforeAndAfter.$init$((BeforeAndAfter)this);
        this.after((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            if (this.kvstore() != null) {
                this.kvstore().close();
                this.kvstore_$eq(null);
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }, new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)live -> {
            this.test(new StringBuilder(51).append("listener events should store successfully (live = ").append(BoxesRunTime.unboxToBoolean((Object)live)).append(")").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                HiveThriftServer2AppStatusStore hiveThriftServer2AppStatusStore;
                HiveThriftServer2Listener listener;
                block7: {
                    Tuple2<HiveThriftServer2AppStatusStore, HiveThriftServer2Listener> tuple2;
                    block6: {
                        tuple2 = $this.createAppStatusStore(live);
                        if (tuple2 == null) break block6;
                        HiveThriftServer2AppStatusStore statusStore = (HiveThriftServer2AppStatusStore)tuple2._1();
                        listener = (HiveThriftServer2Listener)tuple2._2();
                        if (statusStore == null) break block6;
                        hiveThriftServer2AppStatusStore = statusStore;
                        if (listener != null) break block7;
                    }
                    throw new MatchError(tuple2);
                }
                HiveThriftServer2Listener hiveThriftServer2Listener = listener;
                Tuple2 tuple2 = new Tuple2((Object)hiveThriftServer2AppStatusStore, (Object)hiveThriftServer2Listener);
                HiveThriftServer2AppStatusStore statusStore = (HiveThriftServer2AppStatusStore)tuple2._1();
                HiveThriftServer2Listener listener2 = (HiveThriftServer2Listener)tuple2._2();
                listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerSessionCreated("localhost", "sessionId", "user", System.currentTimeMillis()));
                listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationStart("id", "sessionId", "dummy query", "groupId", System.currentTimeMillis(), "user"));
                listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationParsed("id", "dummy plan"));
                listener2.onJobStart(new SparkListenerJobStart(0, System.currentTimeMillis(), (Seq)Nil$.MODULE$, $this.createProperties()));
                listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationFinish("id", System.currentTimeMillis()));
                listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationClosed("id", System.currentTimeMillis()));
                if (live) {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)statusStore.getOnlineSessionNum()));
                    int $org_scalatest_assert_macro_right = 1;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerSessionClosed("sessionId", System.currentTimeMillis()));
                if (!live) {
                    $this.kvstore().close(false);
                }
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)statusStore.getOnlineSessionNum()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)statusStore.getExecutionList().size()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
                ExecutionInfo storeExecData = (ExecutionInfo)statusStore.getExecutionList().head();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(storeExecData.execId());
                String $org_scalatest_assert_macro_right3 = "id";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = $this.convertToEqualizer(storeExecData.sessionId());
                String $org_scalatest_assert_macro_right4 = "sessionId";
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = $this.convertToEqualizer(storeExecData.executePlan());
                String $org_scalatest_assert_macro_right5 = "dummy plan";
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = $this.convertToEqualizer(storeExecData.jobId());
                Seq $org_scalatest_assert_macro_right6 = (Seq)new .colon.colon((Object)"0", (List)Nil$.MODULE$);
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(listener2.noLiveData(), "listener.noLiveData()", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            }, new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            return BoxedUnit.UNIT;
        });
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)live -> {
            this.test(new StringBuilder(50).append("cleanup session if exceeds the threshold (live = ").append(BoxesRunTime.unboxToBoolean((Object)live)).append(")").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
                HiveThriftServer2AppStatusStore hiveThriftServer2AppStatusStore;
                HiveThriftServer2Listener listener;
                block5: {
                    Tuple2<HiveThriftServer2AppStatusStore, HiveThriftServer2Listener> tuple2;
                    block4: {
                        tuple2 = $this.createAppStatusStore(true);
                        if (tuple2 == null) break block4;
                        HiveThriftServer2AppStatusStore statusStore = (HiveThriftServer2AppStatusStore)tuple2._1();
                        listener = (HiveThriftServer2Listener)tuple2._2();
                        if (statusStore == null) break block4;
                        hiveThriftServer2AppStatusStore = statusStore;
                        if (listener != null) break block5;
                    }
                    throw new MatchError(tuple2);
                }
                HiveThriftServer2Listener hiveThriftServer2Listener = listener;
                Tuple2 tuple2 = new Tuple2((Object)hiveThriftServer2AppStatusStore, (Object)hiveThriftServer2Listener);
                HiveThriftServer2AppStatusStore statusStore = (HiveThriftServer2AppStatusStore)tuple2._1();
                HiveThriftServer2Listener listener2 = (HiveThriftServer2Listener)tuple2._2();
                int time = 0;
                listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerSessionCreated("localhost", "sessionId1", "user", (long)time));
                listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerSessionCreated("localhost", "sessionId2", "user", (long)(++time)));
                listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerSessionClosed("sessionId1", (long)(++time)));
                listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerSessionClosed("sessionId2", (long)(++time)));
                listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerSessionCreated("localhost", "sessionId3", "user", (long)time));
                listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerSessionClosed("sessionId3", (long)(++time)));
                if (!live) {
                    $this.kvstore().close(false);
                }
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)statusStore.getOnlineSessionNum()));
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)statusStore.getSessionCount()));
                int $org_scalatest_assert_macro_right2 = 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(statusStore.getSession("sessionId1"));
                None$ $org_scalatest_assert_macro_right3 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(listener2.noLiveData(), "listener.noLiveData()", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
            }, new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            return BoxedUnit.UNIT;
        });
        this.test("update execution info when jobstart event come after execution end event", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            HiveThriftServer2AppStatusStore hiveThriftServer2AppStatusStore;
            HiveThriftServer2Listener listener;
            block3: {
                Tuple2<HiveThriftServer2AppStatusStore, HiveThriftServer2Listener> tuple2;
                block2: {
                    tuple2 = this.createAppStatusStore(true);
                    if (tuple2 == null) break block2;
                    HiveThriftServer2AppStatusStore statusStore = (HiveThriftServer2AppStatusStore)tuple2._1();
                    listener = (HiveThriftServer2Listener)tuple2._2();
                    if (statusStore == null) break block2;
                    hiveThriftServer2AppStatusStore = statusStore;
                    if (listener != null) break block3;
                }
                throw new MatchError(tuple2);
            }
            HiveThriftServer2Listener hiveThriftServer2Listener = listener;
            Tuple2 tuple2 = new Tuple2((Object)hiveThriftServer2AppStatusStore, (Object)hiveThriftServer2Listener);
            HiveThriftServer2AppStatusStore statusStore = (HiveThriftServer2AppStatusStore)tuple2._1();
            HiveThriftServer2Listener listener2 = (HiveThriftServer2Listener)tuple2._2();
            listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerSessionCreated("localhost", "sessionId", "user", System.currentTimeMillis()));
            listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationStart("id", "sessionId", "dummy query", "groupId", System.currentTimeMillis(), "user"));
            listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationParsed("id", "dummy plan"));
            listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationFinish("id", System.currentTimeMillis()));
            listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationClosed("id", System.currentTimeMillis()));
            listener2.onJobStart(new SparkListenerJobStart(0, System.currentTimeMillis(), (Seq)Nil$.MODULE$, this.createProperties()));
            listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerSessionClosed("sessionId", System.currentTimeMillis()));
            Option exec = statusStore.getExecution("id");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(exec.isDefined(), "exec.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(((ExecutionInfo)exec.get()).jobId());
            Seq $org_scalatest_assert_macro_right = (Seq)new .colon.colon((Object)"0", (List)Nil$.MODULE$);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(listener2.noLiveData(), "listener.noLiveData()", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        }, new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("SPARK-31387 - listener update methods should not throw exception with unknown input", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            HiveThriftServer2AppStatusStore hiveThriftServer2AppStatusStore;
            HiveThriftServer2Listener listener;
            block3: {
                Tuple2<HiveThriftServer2AppStatusStore, HiveThriftServer2Listener> tuple2;
                block2: {
                    tuple2 = this.createAppStatusStore(true);
                    if (tuple2 == null) break block2;
                    HiveThriftServer2AppStatusStore statusStore = (HiveThriftServer2AppStatusStore)tuple2._1();
                    listener = (HiveThriftServer2Listener)tuple2._2();
                    if (statusStore == null) break block2;
                    hiveThriftServer2AppStatusStore = statusStore;
                    if (listener != null) break block3;
                }
                throw new MatchError(tuple2);
            }
            HiveThriftServer2Listener hiveThriftServer2Listener = listener;
            Tuple2 tuple2 = new Tuple2((Object)hiveThriftServer2AppStatusStore, (Object)hiveThriftServer2Listener);
            HiveThriftServer2AppStatusStore statusStore = (HiveThriftServer2AppStatusStore)tuple2._1();
            HiveThriftServer2Listener listener2 = (HiveThriftServer2Listener)tuple2._2();
            String unknownSession = "unknown_session";
            String unknownOperation = "unknown_operation";
            listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerSessionClosed(unknownSession, 0L));
            listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationStart("id", unknownSession, "stmt", "groupId", 0L, SparkListenerThriftServerOperationStart$.MODULE$.apply$default$6()));
            listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationParsed(unknownOperation, "query"));
            listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationCanceled(unknownOperation, 0L));
            listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationTimeout(unknownOperation, 0L));
            listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationError(unknownOperation, "msg", "trace", 0L));
            listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationFinish(unknownOperation, 0L));
            listener2.onOtherEvent((SparkListenerEvent)new SparkListenerThriftServerOperationClosed(unknownOperation, 0L));
        }, new Position("HiveThriftServer2ListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
    }
}

