/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx.lib;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.LocalSparkContext;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.VertexRDD$;
import org.apache.spark.graphx.lib.GridPageRank$;
import org.apache.spark.graphx.util.GraphGenerators$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001-2Aa\u0001\u0003\u0001\u001f!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;\ti\u0001+Y4f%\u0006t7nU;ji\u0016T!!\u0002\u0004\u0002\u00071L'M\u0003\u0002\b\u0011\u00051qM]1qQbT!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0003\u0006\t\u0003#Ii\u0011\u0001C\u0005\u0003'!\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\u000b\u0017\u001b\u00051\u0011BA\f\u0007\u0005EaunY1m'B\f'o[\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0001\"a\u0007\u0001\u000e\u0003\u0011\tAbY8na\u0006\u0014XMU1oWN$2A\b\u0013*!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019!u.\u001e2mK\")QE\u0001a\u0001M\u0005\t\u0011\rE\u0002\u0016OyI!\u0001\u000b\u0004\u0003\u0013Y+'\u000f^3y%\u0012#\u0005\"\u0002\u0016\u0003\u0001\u00041\u0013!\u00012")
public class PageRankSuite
extends SparkFunSuite
implements LocalSparkContext {
    @Override
    public <T> T withSpark(Function1<SparkContext, T> f) {
        return (T)LocalSparkContext.withSpark$(this, f);
    }

    public double compareRanks(VertexRDD<Object> a, VertexRDD<Object> b) {
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(a.leftJoin(b, (Function3 & Serializable & scala.Serializable)(x0$1, x1$1, x2$1) -> BoxesRunTime.boxToDouble((double)PageRankSuite.$anonfun$compareRanks$1(BoxesRunTime.unboxToLong((Object)x0$1), BoxesRunTime.unboxToDouble((Object)x1$1), x2$1)), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double()).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToDouble((double)PageRankSuite.$anonfun$compareRanks$4(x0$2)), ClassTag$.MODULE$.Double())).sum();
    }

    public static final /* synthetic */ double $anonfun$compareRanks$1(long x0$1, double x1$1, Option x2$1) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)BoxesRunTime.boxToDouble((double)x1$1), (Object)x2$1);
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        double a = BoxesRunTime.unboxToDouble((Object)tuple3._2());
        Option bOpt = (Option)tuple3._3();
        double d = (a - BoxesRunTime.unboxToDouble((Object)bOpt.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0))) * (a - BoxesRunTime.unboxToDouble((Object)bOpt.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0)));
        return d;
    }

    public static final /* synthetic */ double $anonfun$compareRanks$4(Tuple2 x0$2) {
        double error;
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double d = error = tuple2._2$mcD$sp();
        return d;
    }

    public static final /* synthetic */ int $anonfun$new$3(long vid, double pr1, double pr2) {
        return pr1 != pr2 ? 1 : 0;
    }

    public static final /* synthetic */ int $anonfun$new$4(Tuple2 x0$1) {
        int test;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int n = test = tuple2._2$mcI$sp();
        return n;
    }

    public static final /* synthetic */ double $anonfun$new$8(long x0$2, Vector x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$2), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector vector = (Vector)tuple2._2();
        double d = vector.apply(0);
        return d;
    }

    public static final /* synthetic */ double $anonfun$new$10(long x0$3, Vector x1$2) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$3), (Object)x1$2);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector vector = (Vector)tuple2._2();
        double d = vector.apply(1);
        return d;
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$16(int x) {
        return new Tuple2.mcII.sp(x, x + 1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$21(long source$1, double a$1, double resetProb$2, long vid) {
        double rank = vid < source$1 ? 0.0 : a$1 * Math.pow(1.0 - resetProb$2, vid - source$1);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)vid)), (Object)BoxesRunTime.boxToDouble((double)rank));
    }

    public static final /* synthetic */ double $anonfun$new$22(long x0$6, Vector x1$3) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$6), (Object)x1$3);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector vector = (Vector)tuple2._2();
        double d = vector.apply(0);
        return d;
    }

    public PageRankSuite() {
        LocalSparkContext.$init$(this);
        this.test("Star PageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            int nVertices = 100;
            Graph starGraph = GraphGenerators$.MODULE$.starGraph(sc, nVertices).cache();
            double resetProb = 0.15;
            double tol = 1.0E-4;
            int numIter = 2;
            double errorTol = 1.0E-5;
            VertexRDD staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPageRank(numIter, resetProb).vertices().cache();
            VertexRDD staticRanks2 = Graph$.MODULE$.graphToGraphOps(starGraph, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPageRank(numIter + 1, resetProb).vertices();
            double notMatching = RDD$.MODULE$.numericRDDToDoubleRDDFunctions(staticRanks.innerZipJoin(staticRanks2, (Function3 & Serializable & scala.Serializable)(vid, pr1, pr2) -> BoxesRunTime.boxToInteger((int)PageRankSuite.$anonfun$new$3(BoxesRunTime.unboxToLong((Object)vid), BoxesRunTime.unboxToDouble((Object)pr1), BoxesRunTime.unboxToDouble((Object)pr2))), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)PageRankSuite.$anonfun$new$4(x0$1)), ClassTag$.MODULE$.Int()), (Numeric)Numeric.IntIsIntegral$.MODULE$).sum();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToDouble((double)notMatching));
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            VertexRDD dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).pageRank(tol, resetProb).vertices().cache();
            double $org_scalatest_assert_macro_left2 = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
            double $org_scalatest_assert_macro_right2 = errorTol;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            double centerRank = 0.462394787 * (double)nVertices;
            double othersRank = 0.005430356 * (double)nVertices;
            double d = centerRank;
            Seq igraphPR = (Seq)((SeqLike)Seq$.MODULE$.fill(nVertices - 1, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> othersRank)).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), Seq$.MODULE$.canBuildFrom());
            VertexRDD ranks = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)nVertices)).zip((GenIterable)igraphPR, IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
            double $org_scalatest_assert_macro_left3 = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)ranks);
            double $org_scalatest_assert_macro_right3 = errorTol;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            double $org_scalatest_assert_macro_left4 = this.compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)ranks);
            double $org_scalatest_assert_macro_right4 = errorTol;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        this.test("Star PersonalPageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            int nVertices = 100;
            Graph starGraph = GraphGenerators$.MODULE$.starGraph(sc, nVertices).cache();
            double resetProb = 0.15;
            double tol = 1.0E-4;
            int numIter = 2;
            double errorTol = 1.0E-5;
            VertexRDD staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(0L, numIter, resetProb).vertices().cache();
            VertexRDD dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).personalizedPageRank(0L, tol, resetProb).vertices().cache();
            double $org_scalatest_assert_macro_left = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
            double $org_scalatest_assert_macro_right = errorTol;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            Graph qual$1 = Graph$.MODULE$.graphToGraphOps(starGraph, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticParallelPersonalizedPageRank(new long[]{0L}, numIter, resetProb);
            Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> BoxesRunTime.boxToDouble((double)PageRankSuite.$anonfun$new$8(BoxesRunTime.unboxToLong((Object)x0$2), x1$1));
            ClassTag x$2 = ClassTag$.MODULE$.Double();
            Null$ x$3 = qual$1.mapVertices$default$3((Function2)x$1);
            VertexRDD parallelStaticRanks = (VertexRDD)qual$1.mapVertices((Function2)x$1, x$2, null).vertices().cache();
            double $org_scalatest_assert_macro_left2 = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)parallelStaticRanks);
            double $org_scalatest_assert_macro_right2 = errorTol;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
            double d = 1.0;
            Seq igraphPR0 = (Seq)((SeqLike)Seq$.MODULE$.fill(nVertices - 1, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0)).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), Seq$.MODULE$.canBuildFrom());
            VertexRDD ranks0 = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)nVertices)).zip((GenIterable)igraphPR0, IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
            double $org_scalatest_assert_macro_left3 = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)ranks0);
            double $org_scalatest_assert_macro_right3 = errorTol;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            double $org_scalatest_assert_macro_left4 = this.compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)ranks0);
            double $org_scalatest_assert_macro_right4 = errorTol;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
            VertexRDD otherStaticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(1L, numIter, resetProb).vertices().cache();
            VertexRDD otherDynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).personalizedPageRank(1L, tol, resetProb).vertices().cache();
            Graph qual$2 = Graph$.MODULE$.graphToGraphOps(starGraph, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticParallelPersonalizedPageRank(new long[]{0L, 1L}, numIter, resetProb);
            Function2 & Serializable & scala.Serializable x$4 = (Function2 & Serializable & scala.Serializable)(x0$3, x1$2) -> BoxesRunTime.boxToDouble((double)PageRankSuite.$anonfun$new$10(BoxesRunTime.unboxToLong((Object)x0$3), x1$2));
            ClassTag x$5 = ClassTag$.MODULE$.Double();
            Null$ x$6 = qual$2.mapVertices$default$3((Function2)x$4);
            VertexRDD otherParallelStaticRanks = (VertexRDD)qual$2.mapVertices((Function2)x$4, x$5, null).vertices().cache();
            double $org_scalatest_assert_macro_left5 = this.compareRanks((VertexRDD<Object>)otherDynamicRanks, (VertexRDD<Object>)otherStaticRanks);
            double $org_scalatest_assert_macro_right5 = errorTol;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 < $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            double $org_scalatest_assert_macro_left6 = this.compareRanks((VertexRDD<Object>)otherStaticRanks, (VertexRDD<Object>)otherParallelStaticRanks);
            double $org_scalatest_assert_macro_right6 = errorTol;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 < $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            double $org_scalatest_assert_macro_left7 = this.compareRanks((VertexRDD<Object>)otherDynamicRanks, (VertexRDD<Object>)otherParallelStaticRanks);
            double $org_scalatest_assert_macro_right7 = errorTol;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 < $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
            double centerRank = 0.4594595;
            double sourceRank = 0.5405405;
            double d2 = centerRank;
            double d3 = sourceRank;
            Seq igraphPR1 = (Seq)((SeqLike)((SeqLike)Seq$.MODULE$.fill(nVertices - 2, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0)).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d3), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d2), Seq$.MODULE$.canBuildFrom());
            VertexRDD ranks1 = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)nVertices)).zip((GenIterable)igraphPR1, IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
            double $org_scalatest_assert_macro_left8 = this.compareRanks((VertexRDD<Object>)otherStaticRanks, (VertexRDD<Object>)ranks1);
            double $org_scalatest_assert_macro_right8 = errorTol;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 < $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            double $org_scalatest_assert_macro_left9 = this.compareRanks((VertexRDD<Object>)otherDynamicRanks, (VertexRDD<Object>)ranks1);
            double $org_scalatest_assert_macro_right9 = errorTol;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left9), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 < $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            double $org_scalatest_assert_macro_left10 = this.compareRanks((VertexRDD<Object>)otherParallelStaticRanks, (VertexRDD<Object>)ranks1);
            double $org_scalatest_assert_macro_right10 = errorTol;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left10), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 < $org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("Grid PageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            int rows = 10;
            int cols = 10;
            double resetProb = 0.15;
            double tol = 1.0E-4;
            int numIter = 50;
            double errorTol = 1.0E-5;
            Graph gridGraph = GraphGenerators$.MODULE$.gridGraph(sc, rows, cols).cache();
            VertexRDD staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(gridGraph, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double()).staticPageRank(numIter, resetProb).vertices().cache();
            VertexRDD dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(gridGraph, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double()).pageRank(tol, resetProb).vertices().cache();
            VertexRDD referenceRanks = (VertexRDD)VertexRDD$.MODULE$.apply(sc.parallelize(GridPageRank$.MODULE$.apply(rows, cols, numIter, resetProb), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double()).cache();
            double $org_scalatest_assert_macro_left = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)referenceRanks);
            double $org_scalatest_assert_macro_right = errorTol;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
            double $org_scalatest_assert_macro_left2 = this.compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)referenceRanks);
            double $org_scalatest_assert_macro_right2 = errorTol;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("Chain PageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            IndexedSeq chain1 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 9).map((Function1 & Serializable & scala.Serializable)x -> PageRankSuite.$anonfun$new$16(BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
            RDD rawEdges = sc.parallelize((Seq)chain1, 1, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
                Tuple2 tuple2 = x0$4;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int s = tuple2._1$mcI$sp();
                int d = tuple2._2$mcI$sp();
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp((long)s, (long)d);
                return sp2;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            Graph chain = Graph$.MODULE$.fromEdgeTuples(rawEdges, (Object)BoxesRunTime.boxToDouble((double)1.0), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), ClassTag$.MODULE$.Double()).cache();
            double resetProb = 0.15;
            double tol = 1.0E-4;
            int numIter = 10;
            double errorTol = 1.0E-5;
            VertexRDD staticRanks = Graph$.MODULE$.graphToGraphOps(chain, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).staticPageRank(numIter, resetProb).vertices();
            VertexRDD dynamicRanks = Graph$.MODULE$.graphToGraphOps(chain, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).pageRank(tol, resetProb).vertices();
            double $org_scalatest_assert_macro_left = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
            double $org_scalatest_assert_macro_right = errorTol;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test("Chain PersonalizedPageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            long vertexIdOffset = (long)Integer.MAX_VALUE + 1L;
            int sourceOffest = 4;
            long source = vertexIdOffset + (long)sourceOffest;
            int numIter = 10;
            NumericRange.Exclusive vertices = new RichLong(Predef$.MODULE$.longWrapper(vertexIdOffset)).until((Object)BoxesRunTime.boxToLong((long)(vertexIdOffset + (long)numIter)));
            IndexedSeq chain1 = (IndexedSeq)vertices.zip((GenIterable)vertices.tail(), IndexedSeq$.MODULE$.canBuildFrom());
            RDD rawEdges = sc.parallelize((Seq)chain1, 1, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long s = tuple2._1$mcJ$sp();
                long d = tuple2._2$mcJ$sp();
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(s, d);
                return sp2;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            Graph chain = Graph$.MODULE$.fromEdgeTuples(rawEdges, (Object)BoxesRunTime.boxToDouble((double)1.0), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), ClassTag$.MODULE$.Double()).cache();
            double resetProb = 0.15;
            double tol = 1.0E-4;
            double errorTol = 0.1;
            double a = resetProb / (1.0 - Math.pow(1.0 - resetProb, numIter - sourceOffest));
            RDD expectedRanks = sc.parallelize((Seq)vertices, sc.parallelize$default$2(), ClassTag$.MODULE$.Long()).map((Function1 & Serializable & scala.Serializable)vid -> PageRankSuite.$anonfun$new$21(source, a, resetProb, BoxesRunTime.unboxToLong((Object)vid)), ClassTag$.MODULE$.apply(Tuple2.class));
            VertexRDD expected = VertexRDD$.MODULE$.apply(expectedRanks, ClassTag$.MODULE$.Double());
            VertexRDD staticRanks = Graph$.MODULE$.graphToGraphOps(chain, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(source, numIter, resetProb).vertices();
            double $org_scalatest_assert_macro_left = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)expected);
            double $org_scalatest_assert_macro_right = errorTol;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            VertexRDD dynamicRanks = Graph$.MODULE$.graphToGraphOps(chain, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).personalizedPageRank(source, tol, resetProb).vertices();
            double $org_scalatest_assert_macro_left2 = this.compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)expected);
            double $org_scalatest_assert_macro_right2 = errorTol;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
            Graph qual$3 = Graph$.MODULE$.graphToGraphOps(chain, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).staticParallelPersonalizedPageRank(new long[]{source}, numIter, resetProb);
            Function2 & Serializable & scala.Serializable x$7 = (Function2 & Serializable & scala.Serializable)(x0$6, x1$3) -> BoxesRunTime.boxToDouble((double)PageRankSuite.$anonfun$new$22(BoxesRunTime.unboxToLong((Object)x0$6), x1$3));
            ClassTag x$8 = ClassTag$.MODULE$.Double();
            Null$ x$9 = qual$3.mapVertices$default$3((Function2)x$7);
            VertexRDD parallelStaticRanks = (VertexRDD)qual$3.mapVertices((Function2)x$7, x$8, null).vertices().cache();
            double $org_scalatest_assert_macro_left3 = this.compareRanks((VertexRDD<Object>)parallelStaticRanks, (VertexRDD<Object>)expected);
            double $org_scalatest_assert_macro_right3 = errorTol;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        this.test("Loop with source PageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(1L, 2L);
            Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(2L, 3L);
            Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(3L, 4L);
            Tuple2.mcJJ.sp sp5 = new Tuple2.mcJJ.sp(4L, 2L);
            RDD edges = sc.parallelize((Seq)Nil$.MODULE$.$colon$colon((Object)sp5).$colon$colon((Object)sp4).$colon$colon((Object)sp3).$colon$colon((Object)sp2), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
            Graph g = Graph$.MODULE$.fromEdgeTuples(edges, (Object)BoxesRunTime.boxToInteger((int)1), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), ClassTag$.MODULE$.Int());
            double resetProb = 0.15;
            double tol = 1.0E-4;
            int numIter = 50;
            double errorTol = 1.0E-5;
            VertexRDD staticRanks = Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPageRank(numIter, resetProb).vertices();
            VertexRDD dynamicRanks = Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).pageRank(tol, resetProb).vertices();
            double $org_scalatest_assert_macro_left = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
            double $org_scalatest_assert_macro_right = errorTol;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
            Seq igraphPR = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0375, 0.3326045, 0.3202138, 0.3096817}))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$10 -> x$10 * (double)4, Seq$.MODULE$.canBuildFrom());
            VertexRDD ranks = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)4L)).zip((GenIterable)igraphPR, IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
            double $org_scalatest_assert_macro_left2 = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)ranks);
            double $org_scalatest_assert_macro_right2 = errorTol;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
            double $org_scalatest_assert_macro_left3 = this.compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)ranks);
            double $org_scalatest_assert_macro_right3 = errorTol;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
        this.test("Loop with sink PageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> (Assertion)this.withSpark((Function1 & Serializable & scala.Serializable)sc -> {
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(1L, 2L);
            Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(2L, 3L);
            Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(3L, 1L);
            Tuple2.mcJJ.sp sp5 = new Tuple2.mcJJ.sp(1L, 4L);
            RDD edges = sc.parallelize((Seq)Nil$.MODULE$.$colon$colon((Object)sp5).$colon$colon((Object)sp4).$colon$colon((Object)sp3).$colon$colon((Object)sp2), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
            Graph g = Graph$.MODULE$.fromEdgeTuples(edges, (Object)BoxesRunTime.boxToInteger((int)1), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), ClassTag$.MODULE$.Int());
            double resetProb = 0.15;
            double tol = 1.0E-4;
            int numIter = 20;
            double errorTol = 1.0E-5;
            VertexRDD staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPageRank(numIter, resetProb).vertices().cache();
            VertexRDD dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).pageRank(tol, resetProb).vertices().cache();
            double $org_scalatest_assert_macro_left = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
            double $org_scalatest_assert_macro_right = errorTol;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
            Seq igraphPR = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.3078534, 0.2137622, 0.2646223, 0.2137622}))).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$15 -> x$15 * (double)4, Seq$.MODULE$.canBuildFrom());
            VertexRDD ranks = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)4L)).zip((GenIterable)igraphPR, IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
            double $org_scalatest_assert_macro_left2 = this.compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)ranks);
            double $org_scalatest_assert_macro_right2 = errorTol;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            double $org_scalatest_assert_macro_left3 = this.compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)ranks);
            double $org_scalatest_assert_macro_right3 = errorTol;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            VertexRDD p1staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(1L, numIter, resetProb).vertices().cache();
            VertexRDD p1dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).personalizedPageRank(1L, tol, resetProb).vertices().cache();
            VertexRDD p1parallelDynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticParallelPersonalizedPageRank(new long[]{1L, 2L, 3L, 4L}, numIter, resetProb).vertices().mapValues((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToDouble((double)v.apply(0)), ClassTag$.MODULE$.Double()).cache();
            Seq igraphPR2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.4522329, 0.192199, 0.1633691, 0.192199}));
            VertexRDD ranks2 = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)4L)).zip((GenIterable)igraphPR2, IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
            double $org_scalatest_assert_macro_left4 = this.compareRanks((VertexRDD<Object>)p1staticRanks, (VertexRDD<Object>)ranks2);
            double $org_scalatest_assert_macro_right4 = errorTol;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
            double $org_scalatest_assert_macro_left5 = this.compareRanks((VertexRDD<Object>)p1dynamicRanks, (VertexRDD<Object>)ranks2);
            double $org_scalatest_assert_macro_right5 = errorTol;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 < $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
            double $org_scalatest_assert_macro_left6 = this.compareRanks((VertexRDD<Object>)p1parallelDynamicRanks, (VertexRDD<Object>)ranks2);
            double $org_scalatest_assert_macro_right6 = errorTol;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 < $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            return this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
        }), new Position("PageRankSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
    }
}

