/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx.lib;

import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.LocalSparkContext;
import org.apache.spark.graphx.LocalSparkContext$class;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.VertexRDD$;
import org.apache.spark.graphx.lib.GridPageRank$;
import org.apache.spark.graphx.lib.PageRankSuite$;
import org.apache.spark.graphx.util.GraphGenerators$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001-2A!\u0001\u0002\u0001\u001b\ti\u0001+Y4f%\u0006t7nU;ji\u0016T!a\u0001\u0003\u0002\u00071L'M\u0003\u0002\u0006\r\u00051qM]1qQbT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001aB\u0005\t\u0003\u001fAi\u0011AB\u0005\u0003#\u0019\u0011Qb\u00159be.4UO\\*vSR,\u0007CA\n\u0015\u001b\u0005!\u0011BA\u000b\u0005\u0005EaunY1m'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006/\u0001!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003\tAQ\u0001\b\u0001\u0005\u0002u\tAbY8na\u0006\u0014XMU1oWN$2A\b\u0013*!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019!u.\u001e2mK\")Qe\u0007a\u0001M\u0005\t\u0011\rE\u0002\u0014OyI!\u0001\u000b\u0003\u0003\u0013Y+'\u000f^3y%\u0012#\u0005\"\u0002\u0016\u001c\u0001\u00041\u0013!\u00012")
public class PageRankSuite
extends SparkFunSuite
implements LocalSparkContext {
    @Override
    public <T> T withSpark(Function1<SparkContext, T> f) {
        return (T)LocalSparkContext$class.withSpark(this, f);
    }

    public double compareRanks(VertexRDD<Object> a, VertexRDD<Object> b) {
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(a.leftJoin(b, (Function3)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(long x0$1, double x1$1, Option<Object> x2$1) {
                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)x0$1), (Object)BoxesRunTime.boxToDouble((double)x1$1), x2$1);
                if (tuple3 != null) {
                    double a = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                    Option bOpt = (Option)tuple3._3();
                    double d = (a - BoxesRunTime.unboxToDouble((Object)bOpt.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return 0.0;
                        }
                    }))) * (a - BoxesRunTime.unboxToDouble((Object)bOpt.getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return 0.0;
                        }
                    })));
                    return d;
                }
                throw new MatchError((Object)tuple3);
            }
        }, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    double error;
                    double d = error = tuple2._2$mcD$sp();
                    return d;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.Double())).sum();
    }

    public PageRankSuite() {
        LocalSparkContext$class.$init$(this);
        this.test("Star PageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PageRankSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSpark(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(SparkContext sc) {
                        int nVertices = 100;
                        Graph starGraph2 = GraphGenerators$.MODULE$.starGraph(sc, nVertices).cache();
                        double resetProb = 0.15;
                        double tol = 1.0E-4;
                        int numIter = 2;
                        double errorTol = 1.0E-5;
                        VertexRDD staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPageRank(numIter, resetProb).vertices().cache();
                        VertexRDD staticRanks2 = Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPageRank(numIter + 1, resetProb).vertices();
                        double notMatching = RDD$.MODULE$.numericRDDToDoubleRDDFunctions(staticRanks.innerZipJoin(staticRanks2, (Function3)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(long vid, double pr1, double pr2) {
                                return pr1 != pr2 ? 1 : 0;
                            }
                        }, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Tuple2<Object, Object> x0$3) {
                                Tuple2<Object, Object> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    int test;
                                    int n = test = tuple2._2$mcI$sp();
                                    return n;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, ClassTag$.MODULE$.Int()), (Numeric)Numeric.IntIsIntegral$.MODULE$).sum();
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToDouble((double)notMatching));
                        int $org_scalatest_assert_macro_right = 0;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        VertexRDD dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).pageRank(tol, resetProb).vertices().cache();
                        double $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
                        double $org_scalatest_assert_macro_right2 = errorTol;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        double centerRank = 0.462394787 * (double)nVertices;
                        double othersRank = 0.005430356 * (double)nVertices;
                        double d = centerRank;
                        Seq igraphPR = (Seq)((SeqLike)Seq$.MODULE$.fill(nVertices - 1, (Function0)new Serializable(this, othersRank){
                            public static final long serialVersionUID = 0L;
                            private final double othersRank$1;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return this.othersRank$1;
                            }
                            {
                                this.othersRank$1 = othersRank$1;
                            }
                        })).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), Seq$.MODULE$.canBuildFrom());
                        VertexRDD ranks = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)nVertices)).zip((GenIterable)igraphPR, IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
                        double $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)ranks);
                        double $org_scalatest_assert_macro_right3 = errorTol;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        double $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)ranks);
                        double $org_scalatest_assert_macro_right4 = errorTol;
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PageRankSuite org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Star PersonalPageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PageRankSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSpark(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final void apply(SparkContext sc) {
                        int nVertices = 100;
                        Graph starGraph2 = GraphGenerators$.MODULE$.starGraph(sc, nVertices).cache();
                        double resetProb = 0.15;
                        double tol = 1.0E-4;
                        int numIter = 2;
                        double errorTol = 1.0E-5;
                        VertexRDD staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(0L, numIter, resetProb).vertices().cache();
                        VertexRDD dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).personalizedPageRank(0L, tol, resetProb).vertices().cache();
                        double $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
                        double $org_scalatest_assert_macro_right = errorTol;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Graph qual$1 = Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticParallelPersonalizedPageRank(new long[]{0L}, numIter, resetProb);
                        Serializable x$16 = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(long x0$4, Vector x1$2) {
                                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$4), (Object)x1$2);
                                if (tuple2 != null) {
                                    Vector vector = (Vector)tuple2._2();
                                    double d = vector.apply(0);
                                    return d;
                                }
                                throw new MatchError((Object)tuple2);
                            }
                        };
                        ClassTag x$17 = ClassTag$.MODULE$.Double();
                        qual$1.mapVertices$default$3((Function2)x$16);
                        Object x$18 = null;
                        VertexRDD parallelStaticRanks = (VertexRDD)qual$1.mapVertices((Function2)x$16, x$17, null).vertices().cache();
                        double $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)parallelStaticRanks);
                        double $org_scalatest_assert_macro_right2 = errorTol;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        double d = 1.0;
                        Seq igraphPR0 = (Seq)((SeqLike)Seq$.MODULE$.fill(nVertices - 1, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return 0.0;
                            }
                        })).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d), Seq$.MODULE$.canBuildFrom());
                        VertexRDD ranks0 = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)nVertices)).zip((GenIterable)igraphPR0, IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
                        double $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)ranks0);
                        double $org_scalatest_assert_macro_right3 = errorTol;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        double $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)ranks0);
                        double $org_scalatest_assert_macro_right4 = errorTol;
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        VertexRDD otherStaticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(1L, numIter, resetProb).vertices().cache();
                        VertexRDD otherDynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).personalizedPageRank(1L, tol, resetProb).vertices().cache();
                        Graph qual$2 = Graph$.MODULE$.graphToGraphOps(starGraph2, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticParallelPersonalizedPageRank(new long[]{0L, 1L}, numIter, resetProb);
                        Serializable x$19 = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(long x0$5, Vector x1$3) {
                                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$5), (Object)x1$3);
                                if (tuple2 != null) {
                                    Vector vector = (Vector)tuple2._2();
                                    double d = vector.apply(1);
                                    return d;
                                }
                                throw new MatchError((Object)tuple2);
                            }
                        };
                        ClassTag x$20 = ClassTag$.MODULE$.Double();
                        qual$2.mapVertices$default$3((Function2)x$19);
                        Object x$21 = null;
                        VertexRDD otherParallelStaticRanks = (VertexRDD)qual$2.mapVertices((Function2)x$19, x$20, null).vertices().cache();
                        double $org_scalatest_assert_macro_left5 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)otherDynamicRanks, (VertexRDD<Object>)otherStaticRanks);
                        double $org_scalatest_assert_macro_right5 = errorTol;
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 < $org_scalatest_assert_macro_right5);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                        double $org_scalatest_assert_macro_left6 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)otherStaticRanks, (VertexRDD<Object>)otherParallelStaticRanks);
                        double $org_scalatest_assert_macro_right6 = errorTol;
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 < $org_scalatest_assert_macro_right6);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                        double $org_scalatest_assert_macro_left7 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)otherDynamicRanks, (VertexRDD<Object>)otherParallelStaticRanks);
                        double $org_scalatest_assert_macro_right7 = errorTol;
                        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left7), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 < $org_scalatest_assert_macro_right7);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                        double centerRank = 0.4594595;
                        double sourceRank = 0.5405405;
                        double d2 = centerRank;
                        double d3 = sourceRank;
                        Seq igraphPR1 = (Seq)((SeqLike)((SeqLike)Seq$.MODULE$.fill(nVertices - 2, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return 0.0;
                            }
                        })).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d3), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)BoxesRunTime.boxToDouble((double)d2), Seq$.MODULE$.canBuildFrom());
                        VertexRDD ranks1 = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)nVertices)).zip((GenIterable)igraphPR1, IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
                        double $org_scalatest_assert_macro_left8 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)otherStaticRanks, (VertexRDD<Object>)ranks1);
                        double $org_scalatest_assert_macro_right8 = errorTol;
                        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left8), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 < $org_scalatest_assert_macro_right8);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                        double $org_scalatest_assert_macro_left9 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)otherDynamicRanks, (VertexRDD<Object>)ranks1);
                        double $org_scalatest_assert_macro_right9 = errorTol;
                        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left9), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left9 < $org_scalatest_assert_macro_right9);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                        double $org_scalatest_assert_macro_left10 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)otherParallelStaticRanks, (VertexRDD<Object>)ranks1);
                        double $org_scalatest_assert_macro_right10 = errorTol;
                        Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left10), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 < $org_scalatest_assert_macro_right10);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PageRankSuite org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Grid PageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PageRankSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSpark(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final void apply(SparkContext sc) {
                        int rows = 10;
                        int cols = 10;
                        double resetProb = 0.15;
                        double tol = 1.0E-4;
                        int numIter = 50;
                        double errorTol = 1.0E-5;
                        Graph gridGraph = GraphGenerators$.MODULE$.gridGraph(sc, rows, cols).cache();
                        VertexRDD staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(gridGraph, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double()).staticPageRank(numIter, resetProb).vertices().cache();
                        VertexRDD dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(gridGraph, ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double()).pageRank(tol, resetProb).vertices().cache();
                        VertexRDD referenceRanks = (VertexRDD)VertexRDD$.MODULE$.apply(sc.parallelize(GridPageRank$.MODULE$.apply(rows, cols, numIter, resetProb), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double()).cache();
                        double $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)referenceRanks);
                        double $org_scalatest_assert_macro_right = errorTol;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        double $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)referenceRanks);
                        double $org_scalatest_assert_macro_right2 = errorTol;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PageRankSuite org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Chain PageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PageRankSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSpark(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final void apply(SparkContext sc) {
                        IndexedSeq chain1 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 9).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(int x) {
                                return new Tuple2.mcII.sp(x, x + 1);
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                        RDD rawEdges = sc.parallelize((Seq)chain1, 1, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$6) {
                                Tuple2<Object, Object> tuple2 = x0$6;
                                if (tuple2 != null) {
                                    int s = tuple2._1$mcI$sp();
                                    int d = tuple2._2$mcI$sp();
                                    Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp((long)s, (long)d);
                                    return sp2;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class));
                        Graph chain = Graph$.MODULE$.fromEdgeTuples(rawEdges, (Object)BoxesRunTime.boxToDouble((double)1.0), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), ClassTag$.MODULE$.Double()).cache();
                        double resetProb = 0.15;
                        double tol = 1.0E-4;
                        int numIter = 10;
                        double errorTol = 1.0E-5;
                        VertexRDD staticRanks = Graph$.MODULE$.graphToGraphOps(chain, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).staticPageRank(numIter, resetProb).vertices();
                        VertexRDD dynamicRanks = Graph$.MODULE$.graphToGraphOps(chain, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).pageRank(tol, resetProb).vertices();
                        double $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
                        double $org_scalatest_assert_macro_right = errorTol;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PageRankSuite org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Chain PersonalizedPageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PageRankSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSpark(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final void apply(SparkContext sc) {
                        IndexedSeq chain1 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 9).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(int x) {
                                return new Tuple2.mcII.sp(x, x + 1);
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                        RDD rawEdges = sc.parallelize((Seq)chain1, 1, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x0$7) {
                                Tuple2<Object, Object> tuple2 = x0$7;
                                if (tuple2 != null) {
                                    int s = tuple2._1$mcI$sp();
                                    int d = tuple2._2$mcI$sp();
                                    Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp((long)s, (long)d);
                                    return sp2;
                                }
                                throw new MatchError(tuple2);
                            }
                        }, ClassTag$.MODULE$.apply(Tuple2.class));
                        Graph chain = Graph$.MODULE$.fromEdgeTuples(rawEdges, (Object)BoxesRunTime.boxToDouble((double)1.0), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), ClassTag$.MODULE$.Double()).cache();
                        double resetProb = 0.15;
                        double tol = 1.0E-4;
                        int numIter = 10;
                        double errorTol = 0.1;
                        VertexRDD staticRanks = Graph$.MODULE$.graphToGraphOps(chain, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(4L, numIter, resetProb).vertices();
                        VertexRDD dynamicRanks = Graph$.MODULE$.graphToGraphOps(chain, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).personalizedPageRank(4L, tol, resetProb).vertices();
                        double $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
                        double $org_scalatest_assert_macro_right = errorTol;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Graph qual$3 = Graph$.MODULE$.graphToGraphOps(chain, ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int()).staticParallelPersonalizedPageRank(new long[]{4L}, numIter, resetProb);
                        Serializable x$22 = new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(long x0$8, Vector x1$4) {
                                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$8), (Object)x1$4);
                                if (tuple2 != null) {
                                    Vector vector = (Vector)tuple2._2();
                                    double d = vector.apply(0);
                                    return d;
                                }
                                throw new MatchError((Object)tuple2);
                            }
                        };
                        ClassTag x$23 = ClassTag$.MODULE$.Double();
                        qual$3.mapVertices$default$3((Function2)x$22);
                        Object x$24 = null;
                        VertexRDD parallelStaticRanks = (VertexRDD)qual$3.mapVertices((Function2)x$22, x$23, null).vertices().cache();
                        double $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)parallelStaticRanks);
                        double $org_scalatest_assert_macro_right2 = errorTol;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PageRankSuite org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Loop with source PageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PageRankSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSpark(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final void apply(SparkContext sc) {
                        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(1L, 2L);
                        Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(2L, 3L);
                        Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(3L, 4L);
                        Tuple2.mcJJ.sp sp5 = new Tuple2.mcJJ.sp(4L, 2L);
                        RDD edges = sc.parallelize((Seq)Nil$.MODULE$.$colon$colon((Object)sp5).$colon$colon((Object)sp4).$colon$colon((Object)sp3).$colon$colon((Object)sp2), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
                        Graph g = Graph$.MODULE$.fromEdgeTuples(edges, (Object)BoxesRunTime.boxToInteger((int)1), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), ClassTag$.MODULE$.Int());
                        double resetProb = 0.15;
                        double tol = 1.0E-4;
                        int numIter = 50;
                        double errorTol = 1.0E-5;
                        VertexRDD staticRanks = Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPageRank(numIter, resetProb).vertices();
                        VertexRDD dynamicRanks = Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).pageRank(tol, resetProb).vertices();
                        double $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
                        double $org_scalatest_assert_macro_right = errorTol;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Seq igraphPR = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0375, 0.3326045, 0.3202138, 0.3096817}))).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(double x$10) {
                                return this.apply$mcDD$sp(x$10);
                            }

                            public double apply$mcDD$sp(double x$10) {
                                return x$10 * (double)4;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        VertexRDD ranks = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)4L)).zip((GenIterable)igraphPR, IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
                        double $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)ranks);
                        double $org_scalatest_assert_macro_right2 = errorTol;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        double $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)ranks);
                        double $org_scalatest_assert_macro_right3 = errorTol;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PageRankSuite org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Loop with sink PageRank", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PageRankSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.withSpark(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;

                    public final void apply(SparkContext sc) {
                        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(1L, 2L);
                        Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(2L, 3L);
                        Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(3L, 1L);
                        Tuple2.mcJJ.sp sp5 = new Tuple2.mcJJ.sp(1L, 4L);
                        RDD edges = sc.parallelize((Seq)Nil$.MODULE$.$colon$colon((Object)sp5).$colon$colon((Object)sp4).$colon$colon((Object)sp3).$colon$colon((Object)sp2), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
                        Graph g = Graph$.MODULE$.fromEdgeTuples(edges, (Object)BoxesRunTime.boxToInteger((int)1), Graph$.MODULE$.fromEdgeTuples$default$3(), Graph$.MODULE$.fromEdgeTuples$default$4(), Graph$.MODULE$.fromEdgeTuples$default$5(), ClassTag$.MODULE$.Int());
                        double resetProb = 0.15;
                        double tol = 1.0E-4;
                        int numIter = 20;
                        double errorTol = 1.0E-5;
                        VertexRDD staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPageRank(numIter, resetProb).vertices().cache();
                        VertexRDD dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).pageRank(tol, resetProb).vertices().cache();
                        double $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)dynamicRanks);
                        double $org_scalatest_assert_macro_right = errorTol;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Seq igraphPR = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.3078534, 0.2137622, 0.2646223, 0.2137622}))).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(double x$15) {
                                return this.apply$mcDD$sp(x$15);
                            }

                            public double apply$mcDD$sp(double x$15) {
                                return x$15 * (double)4;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        VertexRDD ranks = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)4L)).zip((GenIterable)igraphPR, IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
                        double $org_scalatest_assert_macro_left2 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)staticRanks, (VertexRDD<Object>)ranks);
                        double $org_scalatest_assert_macro_right2 = errorTol;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left2), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 < $org_scalatest_assert_macro_right2);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        double $org_scalatest_assert_macro_left3 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)dynamicRanks, (VertexRDD<Object>)ranks);
                        double $org_scalatest_assert_macro_right3 = errorTol;
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 < $org_scalatest_assert_macro_right3);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        VertexRDD p1staticRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticPersonalizedPageRank(1L, numIter, resetProb).vertices().cache();
                        VertexRDD p1dynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).personalizedPageRank(1L, tol, resetProb).vertices().cache();
                        VertexRDD p1parallelDynamicRanks = (VertexRDD)Graph$.MODULE$.graphToGraphOps(g, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int()).staticParallelPersonalizedPageRank(new long[]{1L, 2L, 3L, 4L}, numIter, resetProb).vertices().mapValues((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(Vector v) {
                                return v.apply(0);
                            }
                        }, ClassTag$.MODULE$.Double()).cache();
                        Seq igraphPR2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.4522329, 0.192199, 0.1633691, 0.192199}));
                        VertexRDD ranks2 = VertexRDD$.MODULE$.apply(sc.parallelize((Seq)new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)4L)).zip((GenIterable)igraphPR2, IndexedSeq$.MODULE$.canBuildFrom()), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Double());
                        double $org_scalatest_assert_macro_left4 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)p1staticRanks, (VertexRDD<Object>)ranks2);
                        double $org_scalatest_assert_macro_right4 = errorTol;
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 < $org_scalatest_assert_macro_right4);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                        double $org_scalatest_assert_macro_left5 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)p1dynamicRanks, (VertexRDD<Object>)ranks2);
                        double $org_scalatest_assert_macro_right5 = errorTol;
                        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left5), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left5 < $org_scalatest_assert_macro_right5);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                        double $org_scalatest_assert_macro_left6 = this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().compareRanks((VertexRDD<Object>)p1parallelDynamicRanks, (VertexRDD<Object>)ranks2);
                        double $org_scalatest_assert_macro_right6 = errorTol;
                        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left6 < $org_scalatest_assert_macro_right6);
                        this.$outer.org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PageRankSuite org$apache$spark$graphx$lib$PageRankSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

