/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HllSketchEstimate$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(expr) - Returns the estimated number of unique values given the binary representation\n    of a Datasketches HllSketch. ", examples="\n    Examples:\n      > SELECT _FUNC_(hll_sketch_agg(col)) FROM VALUES (1), (1), (2), (2), (3) tab(col);\n       3\n  ", group="misc_funcs", since="3.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Ef\u0001\u0002\r\u001a\u0001\u001aB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\")!\n\u0001C\u0001\u0017\")a\n\u0001C)\u001f\")!\u000b\u0001C!'\")q\f\u0001C!A\")q\u000e\u0001C!a\")A\u000f\u0001C!k\"91\u0010AA\u0001\n\u0003a\bb\u0002@\u0001#\u0003%\ta \u0005\n\u0003+\u0001\u0011\u0011!C!\u0003/A\u0011\"a\n\u0001\u0003\u0003%\t!!\u000b\t\u0013\u0005E\u0002!!A\u0005\u0002\u0005M\u0002\"CA\u001d\u0001\u0005\u0005I\u0011IA\u001e\u0011%\tI\u0005AA\u0001\n\u0003\tY\u0005C\u0005\u0002V\u0001\t\t\u0011\"\u0011\u0002X\u001dI\u00111P\r\u0002\u0002#\u0005\u0011Q\u0010\u0004\t1e\t\t\u0011#\u0001\u0002\u0000!1!J\u0005C\u0001\u0003\u001bC\u0011\"a$\u0013\u0003\u0003%)%!%\t\u0013\u0005M%#!A\u0005\u0002\u0006U\u0005\"CAM%\u0005\u0005I\u0011QAN\u0011%\t9KEA\u0001\n\u0013\tIKA\tIY2\u001c6.\u001a;dQ\u0016\u001bH/[7bi\u0016T!AG\u000e\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u00039u\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003=}\t1a]9m\u0015\t\u0001\u0013%A\u0003ta\u0006\u00148N\u0003\u0002#G\u00051\u0011\r]1dQ\u0016T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\b\u0001\u001dZ\u0013\u0007N\u001eB!\tA\u0013&D\u0001\u001a\u0013\tQ\u0013DA\bV]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\tas&D\u0001.\u0015\tq\u0013$A\u0004d_\u0012,w-\u001a8\n\u0005Aj#aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005!\u0012\u0014BA\u001a\u001a\u0005E)\u0005\u0010]3diNLe\u000e];u)f\u0004Xm\u001d\t\u0003kar!\u0001\u000b\u001c\n\u0005]J\u0012a\u00029bG.\fw-Z\u0005\u0003si\u0012aBT;mY&sGo\u001c7fe\u0006tGO\u0003\u000283A\u0011AhP\u0007\u0002{)\ta(A\u0003tG\u0006d\u0017-\u0003\u0002A{\t9\u0001K]8ek\u000e$\bC\u0001\u001fC\u0013\t\u0019UH\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0003dQ&dG-F\u0001G!\tAs)\u0003\u0002I3\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0011A*\u0014\t\u0003Q\u0001AQ\u0001R\u0002A\u0002\u0019\u000bAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGC\u0001'Q\u0011\u0015\tF\u00011\u0001G\u0003!qWm^\"iS2$\u0017A\u00039sKR$\u0018PT1nKV\tA\u000b\u0005\u0002V9:\u0011aK\u0017\t\u0003/vj\u0011\u0001\u0017\u0006\u00033\u0016\na\u0001\u0010:p_Rt\u0014BA.>\u0003\u0019\u0001&/\u001a3fM&\u0011QL\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005mk\u0014AC5oaV$H+\u001f9fgV\t\u0011\rE\u0002cM&t!aY3\u000f\u0005]#\u0017\"\u0001 \n\u0005]j\u0014BA4i\u0005\r\u0019V-\u001d\u0006\u0003ou\u0002\"A[7\u000e\u0003-T!\u0001\\\u000f\u0002\u000bQL\b/Z:\n\u00059\\'\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,W#A9\u0011\u0005)\u0014\u0018BA:l\u0005!!\u0015\r^1UsB,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dGC\u0001<z!\tat/\u0003\u0002y{\t\u0019\u0011I\\=\t\u000biD\u0001\u0019\u0001<\u0002\u000b%t\u0007/\u001e;\u0002\t\r|\u0007/\u001f\u000b\u0003\u0019vDq\u0001R\u0005\u0011\u0002\u0003\u0007a)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005!f\u0001$\u0002\u0004-\u0012\u0011Q\u0001\t\u0005\u0003\u000f\t\t\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0010u\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019\"!\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u00033\u0001B!a\u0007\u0002&5\u0011\u0011Q\u0004\u0006\u0005\u0003?\t\t#\u0001\u0003mC:<'BAA\u0012\u0003\u0011Q\u0017M^1\n\u0007u\u000bi\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002,A\u0019A(!\f\n\u0007\u0005=RHA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002w\u0003kA\u0011\"a\u000e\u000e\u0003\u0003\u0005\r!a\u000b\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u0004E\u0003\u0002@\u0005\u0015c/\u0004\u0002\u0002B)\u0019\u00111I\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002H\u0005\u0005#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\u0014\u0002TA\u0019A(a\u0014\n\u0007\u0005ESHA\u0004C_>dW-\u00198\t\u0011\u0005]r\"!AA\u0002Y\fa!Z9vC2\u001cH\u0003BA'\u00033B\u0001\"a\u000e\u0011\u0003\u0003\u0005\rA\u001e\u0015\u0014\u0001\u0005u\u00131MA3\u0003S\nY'a\u001c\u0002r\u0005U\u0014q\u000f\t\u0004Q\u0005}\u0013bAA13\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA4\u0003\u0005\u001d!\u0002\t\u0011!A}3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!KN$\u0018.\\1uK\u0012\u0004c.^7cKJ\u0004sN\u001a\u0011v]&\fX/\u001a\u0011wC2,Xm\u001d\u0011hSZ,g\u000e\t;iK\u0002\u0012\u0017N\\1ss\u0002\u0012X\r\u001d:fg\u0016tG/\u0019;j_:T\u0001\u0005\t\u0011!_\u001a\u0004\u0013\r\t#bi\u0006\u001c8.\u001a;dQ\u0016\u001c\b\u0005\u00137m'.,Go\u00195/A\u0005AQ\r_1na2,7/\t\u0002\u0002n\u0005\u0019(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b5mY~\u001b8.\u001a;dQ~\u000bwm\u001a\u0015d_2L\u0013\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003&M\u0015-A!\n\u0014\u0006\f\u0011)e%b\u0003\u0005\u000b\u001a*Y\u0001B3'\u000b\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005M\u0014AC7jg\u000e|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011\u0011P\u0001\u0006g9*d\u0006M\u0001\u0012\u00112d7k[3uG\",5\u000f^5nCR,\u0007C\u0001\u0015\u0013'\u0011\u0011\u0012\u0011Q!\u0011\r\u0005\r\u0015\u0011\u0012$M\u001b\t\t)IC\u0002\u0002\bv\nqA];oi&lW-\u0003\u0003\u0002\f\u0006\u0015%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011\u0011QP\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011D\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u0019\u0006]\u0005\"\u0002#\u0016\u0001\u00041\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003;\u000b\u0019\u000b\u0005\u0003=\u0003?3\u0015bAAQ{\t1q\n\u001d;j_:D\u0001\"!*\u0017\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a+\u0011\t\u0005m\u0011QV\u0005\u0005\u0003_\u000biB\u0001\u0004PE*,7\r\u001e")
public class HllSketchEstimate
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(HllSketchEstimate hllSketchEstimate) {
        return HllSketchEstimate$.MODULE$.unapply(hllSketchEstimate);
    }

    public static <A> Function1<Expression, A> andThen(Function1<HllSketchEstimate, A> function1) {
        return HllSketchEstimate$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, HllSketchEstimate> compose(Function1<A, Expression> function1) {
        return HllSketchEstimate$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public HllSketchEstimate withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    @Override
    public String prettyName() {
        return "hll_sketch_estimate";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object input) {
        Long l;
        byte[] buffer = (byte[])input;
        try {
            l = BoxesRunTime.boxToLong((long)Math.round(HllSketch.heapify((Memory)Memory.wrap((byte[])buffer)).getEstimate()));
        }
        catch (Error error) {
            throw QueryExecutionErrors$.MODULE$.hllInvalidInputSketchBuffer(this.prettyName());
        }
        return l;
    }

    public HllSketchEstimate copy(Expression child) {
        return new HllSketchEstimate(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "HllSketchEstimate";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HllSketchEstimate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HllSketchEstimate)) return false;
        boolean bl = true;
        if (!bl) return false;
        HllSketchEstimate hllSketchEstimate = (HllSketchEstimate)x$1;
        Expression expression = this.child();
        Expression expression2 = hllSketchEstimate.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!hllSketchEstimate.canEqual(this)) return false;
        return true;
    }

    public HllSketchEstimate(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

