/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;

public final class UnsafeRowUtils$ {
    public static UnsafeRowUtils$ MODULE$;

    static {
        new UnsafeRowUtils$();
    }

    private Option<String> validateStructuralIntegrityWithReasonImpl(UnsafeRow row, StructType expectedSchema) {
        Option option;
        Object object = new Object();
        try {
            if (expectedSchema.fields().length != row.numFields()) {
                return new Some((Object)new StringBuilder(43).append("Field length mismatch: ").append("expected: ").append(expectedSchema.fields().length).append(", actual: ").append(row.numFields()).toString());
            }
            int bitSetWidthInBytes = UnsafeRow.calculateBitSetWidthInBytes(row.numFields());
            int rowSizeInBytes = row.getSizeInBytes();
            if (expectedSchema.fields().length > 0 && bitSetWidthInBytes >= rowSizeInBytes) {
                return new Some((Object)new StringBuilder(91).append("rowSizeInBytes should not exceed bitSetWidthInBytes, ").append("bitSetWidthInBytes: ").append(bitSetWidthInBytes).append(", rowSizeInBytes: ").append(rowSizeInBytes).toString());
            }
            IntRef varLenFieldsSizeInBytes = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedSchema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                UnsafeRowUtils$.$anonfun$validateStructuralIntegrityWithReasonImpl$1(row, bitSetWidthInBytes, rowSizeInBytes, object, varLenFieldsSizeInBytes, x0$1);
                return BoxedUnit.UNIT;
            });
            if (bitSetWidthInBytes + 8 * row.numFields() + varLenFieldsSizeInBytes.elem > rowSizeInBytes) {
                return new Some((Object)new StringBuilder(55).append("Row total length invalid: ").append("calculated: ").append(bitSetWidthInBytes + 8 * row.numFields() + varLenFieldsSizeInBytes.elem).append(" ").append("rowSizeInBytes: ").append(rowSizeInBytes).toString());
            }
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public Option<String> validateStructuralIntegrityWithReason(UnsafeRow row, StructType expectedSchema) {
        return this.validateStructuralIntegrityWithReasonImpl(row, expectedSchema).map((Function1 & Serializable & scala.Serializable)errorMessage -> new StringBuilder(38).append("Error message is: ").append((String)errorMessage).append(", ").append("UnsafeRow status: ").append(MODULE$.getStructuralIntegrityStatus(row, expectedSchema)).toString());
    }

    public Tuple2<Object, Object> getOffsetAndSize(UnsafeRow row, int index) {
        long offsetAndSize = row.getLong(index);
        int offset = (int)(offsetAndSize >> 32);
        int size = (int)offsetAndSize;
        return new Tuple2.mcII.sp(offset, size);
    }

    public boolean avoidSetNullAt(DataType dt) {
        DecimalType decimalType;
        DataType dataType = dt;
        if (dataType instanceof DecimalType && (decimalType = (DecimalType)dataType).precision() > Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return true;
        }
        return CalendarIntervalType$.MODULE$.equals(dataType);
    }

    public String getStructuralIntegrityStatus(UnsafeRow row, StructType expectedSchema) {
        int minLength = Math.min(row.numFields(), expectedSchema.fields().length);
        String[] fieldStatusArr = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expectedSchema.fields())).take(minLength))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String string;
                StructField field = (StructField)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (!UnsafeRow.isFixedLength(field.dataType())) {
                    Tuple2<Object, Object> tuple22 = MODULE$.getOffsetAndSize(row, index);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    int offset = tuple22._1$mcI$sp();
                    int size = tuple22._2$mcI$sp();
                    Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(offset, size);
                    int offset2 = sp2._1$mcI$sp();
                    int size2 = sp2._2$mcI$sp();
                    string = new StringBuilder(16).append("offset: ").append(offset2).append(", size: ").append(size2).toString();
                } else {
                    string = "";
                }
                String offsetAndSizeStr = string;
                return new StringBuilder(80).append("[UnsafeRowFieldStatus] index: ").append(index).append(", ").append("expectedFieldType: ").append(field.dataType()).append(", isNull: ").append(row.isNullAt(index)).append(", ").append("isFixedLength: ").append(UnsafeRow.isFixedLength(field.dataType())).append(". ").append(offsetAndSizeStr).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        return new StringBuilder(128).append("[UnsafeRowStatus] expectedSchema: ").append(expectedSchema).append(", ").append("expectedSchemaNumFields: ").append(expectedSchema.fields().length).append(", numFields: ").append(row.numFields()).append(", ").append("bitSetWidthInBytes: ").append(UnsafeRow.calculateBitSetWidthInBytes(row.numFields())).append(", ").append("rowSizeInBytes: ").append(row.getSizeInBytes()).append("\nfieldStatus:\n").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldStatusArr)).mkString("\n")).toString();
    }

    public static final /* synthetic */ void $anonfun$validateStructuralIntegrityWithReasonImpl$1(UnsafeRow row$1, int bitSetWidthInBytes$1, int rowSizeInBytes$1, Object nonLocalReturnKey1$1, IntRef varLenFieldsSizeInBytes$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (!UnsafeRow.isFixedLength(field.dataType()) && !row$1.isNullAt(index)) {
                Tuple2<Object, Object> tuple22 = MODULE$.getOffsetAndSize(row$1, index);
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                int offset = tuple22._1$mcI$sp();
                int size = tuple22._2$mcI$sp();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(offset, size);
                int offset2 = sp2._1$mcI$sp();
                int size2 = sp2._2$mcI$sp();
                if (size2 < 0 || offset2 < bitSetWidthInBytes$1 + 8 * row$1.numFields() || offset2 + size2 > rowSizeInBytes$1) {
                    throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(56).append("Variable-length field validation error: field: ").append(field).append(", index: ").append(index).toString()));
                }
                varLenFieldsSizeInBytes$1.elem += size2;
                return;
            }
        }
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (UnsafeRow.isFixedLength(field.dataType()) && !row$1.isNullAt(index)) {
                DataType dataType = field.dataType();
                if (BooleanType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 1 != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(53).append("Fixed-length field validation error: field: ").append(field).append(", index: ").append(index).toString()));
                    }
                } else if (ByteType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 8 != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(53).append("Fixed-length field validation error: field: ").append(field).append(", index: ").append(index).toString()));
                    }
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 16 != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(53).append("Fixed-length field validation error: field: ").append(field).append(", index: ").append(index).toString()));
                    }
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 32 != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(53).append("Fixed-length field validation error: field: ").append(field).append(", index: ").append(index).toString()));
                    }
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    if (row$1.getLong(index) >> 32 != 0L) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(53).append("Fixed-length field validation error: field: ").append(field).append(", index: ").append(index).toString()));
                    }
                }
                return;
            }
        }
        if (tuple2 != null) {
            StructField field = (StructField)tuple2._1();
            int index = tuple2._2$mcI$sp();
            if (row$1.isNullAt(index)) {
                DecimalType decimalType;
                DataType dataType = field.dataType();
                if (dataType instanceof DecimalType && !UnsafeRow.isFixedLength((DataType)(decimalType = (DecimalType)dataType))) {
                    Tuple2<Object, Object> tuple23 = MODULE$.getOffsetAndSize(row$1, index);
                    if (tuple23 == null) {
                        throw new MatchError(tuple23);
                    }
                    int offset = tuple23._1$mcI$sp();
                    int size = tuple23._2$mcI$sp();
                    Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(offset, size);
                    int offset3 = sp3._1$mcI$sp();
                    int size3 = sp3._2$mcI$sp();
                    if (size3 != 0 || offset3 != 0 && (offset3 < bitSetWidthInBytes$1 + 8 * row$1.numFields() || offset3 > rowSizeInBytes$1)) {
                        throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(77).append("Variable-length decimal field special case validation error: ").append("field: ").append(field).append(", index: ").append(index).toString()));
                    }
                } else if (row$1.getLong(index) != 0L) {
                    throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new StringBuilder(62).append("Variable-length offset-size validation error: ").append("field: ").append(field).append(", index: ").append(index).toString()));
                }
                return;
            }
        }
    }

    private UnsafeRowUtils$() {
        MODULE$ = this;
    }
}

