/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.optimizer.ConstantFolding$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.SQLQueryContext;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$DefaultColumnAnalyzer$;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumnsUtils;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableCatalogCapability;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ResolveDefaultColumns$
implements QueryErrorsBase,
ResolveDefaultColumnsUtils {
    public static ResolveDefaultColumns$ MODULE$;
    private final String CURRENT_DEFAULT_COLUMN_NAME;
    private final String CURRENT_DEFAULT_COLUMN_METADATA_KEY;
    private final String EXISTS_DEFAULT_COLUMN_METADATA_KEY;

    static {
        new ResolveDefaultColumns$();
    }

    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toDSOption(String option) {
        return QueryErrorsBase.toDSOption$(this, option);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLSchema(String schema) {
        return QueryErrorsBase.toSQLSchema$(this, schema);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(SQLQueryContext sqlContext) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (SQLQueryContext)sqlContext);
    }

    public String CURRENT_DEFAULT_COLUMN_METADATA_KEY() {
        return this.CURRENT_DEFAULT_COLUMN_METADATA_KEY;
    }

    public String EXISTS_DEFAULT_COLUMN_METADATA_KEY() {
        return this.EXISTS_DEFAULT_COLUMN_METADATA_KEY;
    }

    public void org$apache$spark$sql$catalyst$util$ResolveDefaultColumnsUtils$_setter_$CURRENT_DEFAULT_COLUMN_METADATA_KEY_$eq(String x$1) {
        this.CURRENT_DEFAULT_COLUMN_METADATA_KEY = x$1;
    }

    public void org$apache$spark$sql$catalyst$util$ResolveDefaultColumnsUtils$_setter_$EXISTS_DEFAULT_COLUMN_METADATA_KEY_$eq(String x$1) {
        this.EXISTS_DEFAULT_COLUMN_METADATA_KEY = x$1;
    }

    public String CURRENT_DEFAULT_COLUMN_NAME() {
        return this.CURRENT_DEFAULT_COLUMN_NAME;
    }

    public StructType constantFoldCurrentDefaultsToExistDefaults(StructType tableSchema, String statementType) {
        if (SQLConf$.MODULE$.get().enableDefaultColumns()) {
            Seq newFields = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
                if (field.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY())) {
                    Metadata newMetadata;
                    Expression analyzed = MODULE$.analyze((StructField)field, statementType, MODULE$.analyze$default$3());
                    Metadata x$1 = newMetadata = new MetadataBuilder().withMetadata(field.metadata()).putString(MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY(), analyzed.sql()).build();
                    String x$2 = field.copy$default$1();
                    DataType x$3 = field.copy$default$2();
                    boolean x$4 = field.copy$default$3();
                    return field.copy(x$2, x$3, x$4, x$1);
                }
                return field;
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            return StructType$.MODULE$.apply(newFields);
        }
        return tableSchema;
    }

    public void validateCatalogForDefaultValue(StructType schema, TableCatalog catalog, Identifier ident) {
        if (SQLConf$.MODULE$.get().enableDefaultColumns() && schema.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$validateCatalogForDefaultValue$1(x$1))) && !catalog.capabilities().contains((Object)TableCatalogCapability.SUPPORT_COLUMN_DEFAULT_VALUE)) {
            throw QueryCompilationErrors$.MODULE$.unsupportedTableOperationError(catalog, ident, "column default value");
        }
    }

    public void validateTableProviderForDefaultValue(StructType schema, Option<String> tableProvider, String statementType, boolean addNewColumnToExistingTable) {
        if (SQLConf$.MODULE$.get().enableDefaultColumns() && schema.exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$validateTableProviderForDefaultValue$1(x$2)))) {
            String[] keywords2 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.DEFAULT_COLUMN_ALLOWED_PROVIDERS()).toLowerCase().split(","))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            String[] allowedTableProviders = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keywords2)).map((Function1 & Serializable & scala.Serializable)x$4 -> new StringOps(Predef$.MODULE$.augmentString(x$4)).stripSuffix("*"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            String[] addColumnExistingTableBannedProviders = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keywords2)).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.endsWith("*"))))).map((Function1 & Serializable & scala.Serializable)x$6 -> new StringOps(Predef$.MODULE$.augmentString(x$6)).stripSuffix("*"), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            String givenTableProvider = ((String)tableProvider.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toLowerCase();
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allowedTableProviders)).contains((Object)givenTableProvider)) {
                throw QueryCompilationErrors$.MODULE$.defaultReferencesNotAllowedInDataSource(statementType, givenTableProvider);
            }
            if (addNewColumnToExistingTable && new StringOps(Predef$.MODULE$.augmentString(givenTableProvider)).nonEmpty() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])addColumnExistingTableBannedProviders)).contains((Object)givenTableProvider)) {
                throw QueryCompilationErrors$.MODULE$.addNewDefaultColumnToExistingTableNotAllowed(statementType, givenTableProvider);
            }
            return;
        }
    }

    public boolean isExplicitDefaultColumn(UnresolvedAttribute col) {
        return col.name().equalsIgnoreCase(this.CURRENT_DEFAULT_COLUMN_NAME());
    }

    public boolean containsExplicitDefaultColumn(Expression expr) {
        return expr.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$containsExplicitDefaultColumn$1(x0$1)));
    }

    public Expression resolveColumnDefaultInAssignmentValue(Expression key, Expression value, Throwable invalidColumnDefaultException) {
        Expression expression = key;
        if (expression instanceof AttributeReference) {
            UnresolvedAttribute unresolvedAttribute;
            AttributeReference attributeReference = (AttributeReference)expression;
            Expression expression2 = value;
            if (expression2 instanceof UnresolvedAttribute && this.isExplicitDefaultColumn(unresolvedAttribute = (UnresolvedAttribute)expression2)) {
                return this.getDefaultValueExprOrNullLit(attributeReference);
            }
            if (this.containsExplicitDefaultColumn(expression2)) {
                throw invalidColumnDefaultException;
            }
            return expression2;
        }
        return value;
    }

    private Option<Expression> getDefaultValueExprOpt(StructField field) {
        if (field.metadata().contains(this.CURRENT_DEFAULT_COLUMN_METADATA_KEY())) {
            return new Some((Object)this.analyze(field, "INSERT", this.analyze$default$3()));
        }
        return None$.MODULE$;
    }

    public Expression getDefaultValueExprOrNullLit(StructField field) {
        Option<NamedExpression> defaultValue = this.getDefaultValueExprOrNullLit(field, true);
        if (defaultValue.isEmpty()) {
            throw new AnalysisException("NO_DEFAULT_COLUMN_VALUE_AVAILABLE", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"colName"), (Object)this.toSQLId((Seq<String>)((Seq)new .colon.colon((Object)field.name(), (List)Nil$.MODULE$))))})));
        }
        return (Expression)defaultValue.get();
    }

    public Expression getDefaultValueExprOrNullLit(Attribute attr) {
        StructField field = new StructField(attr.name(), attr.dataType(), attr.nullable(), attr.metadata());
        return this.getDefaultValueExprOrNullLit(field);
    }

    public Option<NamedExpression> getDefaultValueExprOrNullLit(StructField field, boolean useNullAsDefault) {
        return this.getDefaultValueExprOpt(field).orElse((Function0 & Serializable & scala.Serializable)() -> {
            if (useNullAsDefault && field.nullable()) {
                return new Some((Object)new Literal(null, field.dataType()));
            }
            return None$.MODULE$;
        }).map((Function1 & Serializable & scala.Serializable)expr -> {
            Expression x$1 = expr;
            String x$2 = field.name();
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq<String> x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            return new Alias(x$1, x$2, x$3, x$4, x$5, x$6);
        });
    }

    public Option<NamedExpression> getDefaultValueExprOrNullLit(Attribute attr, boolean useNullAsDefault) {
        StructField field = new StructField(attr.name(), attr.dataType(), attr.nullable(), attr.metadata());
        return this.getDefaultValueExprOrNullLit(field, useNullAsDefault);
    }

    public Expression analyze(StructField field, String statementType, String metadataKey) {
        return this.analyze(field.name(), field.dataType(), field.metadata().getString(metadataKey), statementType);
    }

    public Expression analyze(String colName, DataType dataType, String defaultSQL, String statementType) {
        None$ none$;
        LogicalPlan logicalPlan;
        Expression expression;
        LazyRef parser$lzy = new LazyRef();
        try {
            expression = ResolveDefaultColumns$.parser$1(parser$lzy).parseExpression(defaultSQL);
        }
        catch (ParseException ex) {
            throw QueryCompilationErrors$.MODULE$.defaultValuesUnresolvedExprError(statementType, colName, defaultSQL, ex);
        }
        Expression parsed = expression;
        if (parsed.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())) {
            throw QueryCompilationErrors$.MODULE$.defaultValuesMayNotContainSubQueryExpressions(statementType, colName, defaultSQL);
        }
        try {
            ResolveDefaultColumns$DefaultColumnAnalyzer$ analyzer = ResolveDefaultColumns$DefaultColumnAnalyzer$.MODULE$;
            Expression x$1 = parsed;
            String x$2 = colName;
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$1, x$2);
            Seq<String> x$4 = Alias$.MODULE$.apply$default$4(x$1, x$2);
            Option<Metadata> x$5 = Alias$.MODULE$.apply$default$5(x$1, x$2);
            Seq<String> x$6 = Alias$.MODULE$.apply$default$6(x$1, x$2);
            LogicalPlan analyzed = analyzer.execute(new Project((Seq<NamedExpression>)((Seq)new .colon.colon((Object)new Alias(x$1, x$2, x$3, x$4, x$5, x$6), (List)Nil$.MODULE$)), new OneRowRelation()));
            analyzer.checkAnalysis(analyzed);
            logicalPlan = ConstantFolding$.MODULE$.apply(analyzed);
        }
        catch (AnalysisException ex) {
            throw QueryCompilationErrors$.MODULE$.defaultValuesUnresolvedExprError(statementType, colName, defaultSQL, ex);
        }
        LogicalPlan plan2 = logicalPlan;
        Expression analyzed = (Expression)plan2.collectFirst(new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Project) {
                    NamedExpression a;
                    Project project = (Project)A1;
                    Seq<NamedExpression> seq = project.projectList();
                    LogicalPlan logicalPlan = project.child();
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (a = (NamedExpression)((SeqLike)some.get()).apply(0)) instanceof Alias) {
                        Alias alias = (Alias)a;
                        if (logicalPlan instanceof OneRowRelation) {
                            return (B1)alias.child();
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof Project) {
                    NamedExpression a;
                    Project project = (Project)logicalPlan;
                    Seq<NamedExpression> seq = project.projectList();
                    LogicalPlan logicalPlan2 = project.child();
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 && (a = (NamedExpression)((SeqLike)some.get()).apply(0)) instanceof Alias && logicalPlan2 instanceof OneRowRelation) {
                        return true;
                    }
                }
                return false;
            }
        }).get();
        DataType dataType2 = dataType;
        DataType dataType3 = analyzed.dataType();
        if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
            return analyzed;
        }
        if (Cast$.MODULE$.canUpCast(analyzed.dataType(), dataType)) {
            return new Cast(analyzed, dataType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
        }
        if (analyzed instanceof Literal && !((IterableLike)new .colon.colon((Object)dataType, (List)new .colon.colon((Object)analyzed.dataType(), (List)Nil$.MODULE$))).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$analyze$1(x$7)))) {
            try {
                Expression x$72 = analyzed;
                DataType x$8 = dataType;
                Enumeration.Value x$9 = EvalMode$.MODULE$.TRY();
                Option<String> x$10 = Cast$.MODULE$.apply$default$3();
                Cast qual$1 = new Cast(x$72, x$8, x$10, x$9);
                InternalRow x$11 = qual$1.eval$default$1();
                Object casted = qual$1.eval(x$11);
                if (casted != null) {
                    none$ = new Some((Object)new Literal(casted, dataType));
                }
                none$ = None$.MODULE$;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof SparkThrowable ? true : throwable2 instanceof RuntimeException) {
                    none$ = None$.MODULE$;
                }
                throw throwable;
            }
        } else {
            none$ = None$.MODULE$;
        }
        None$ result = none$;
        return (Expression)result.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.defaultValuesDataTypeError(statementType, colName, defaultSQL, dataType, analyzed.dataType());
        });
    }

    public String analyze$default$3() {
        return this.CURRENT_DEFAULT_COLUMN_METADATA_KEY();
    }

    public String normalizeFieldName(String str) {
        if (SQLConf$.MODULE$.get().caseSensitiveAnalysis()) {
            return str;
        }
        return str.toLowerCase();
    }

    public Object[] getExistenceDefaultValues(StructType schema) {
        return (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            Option defaultValue = field.getExistenceDefaultValue();
            return defaultValue.map((Function1 & Serializable & scala.Serializable)text -> {
                Expression expression;
                try {
                    Expression expr;
                    Expression expression2 = expr = MODULE$.analyze((StructField)field, "", MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY());
                    if (!(expression2 instanceof Literal ? true : expression2 instanceof Cast)) {
                        throw new MatchError((Object)expression2);
                    }
                    expression = expr;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof AnalysisException ? true : throwable2 instanceof MatchError) {
                        throw QueryCompilationErrors$.MODULE$.failedToParseExistenceDefaultAsLiteral(field.name(), (String)text);
                    }
                    throw throwable;
                }
                Expression expr = expression;
                return expr.eval(expr.eval$default$1());
            }).orNull(Predef$.MODULE$.$conforms());
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
    }

    public boolean[] getExistenceDefaultsBitmask(StructType schema) {
        return (boolean[])Array$.MODULE$.fill(Predef$.MODULE$.genericArrayOps((Object)this.existenceDefaultValues(schema)).size(), (Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true, ClassTag$.MODULE$.Boolean());
    }

    public void resetExistenceDefaultsBitmask(StructType schema, boolean[] bitmask) {
        Object[] defaultValues = this.existenceDefaultValues(schema);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.genericArrayOps((Object)defaultValues).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            bitmask$1[i] = defaultValues[i] != null;
        });
    }

    public void applyExistenceDefaultValuesToRow(StructType schema, InternalRow row, boolean[] bitmask) {
        Object[] existingValues = this.existenceDefaultValues(schema);
        if (this.hasExistenceDefaultValues(schema)) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.genericArrayOps((Object)existingValues).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                if (bitmask[i]) {
                    row.update(i, existingValues[i]);
                    return;
                }
            });
            return;
        }
    }

    public Seq<Tuple3<String, String, String>> getDescribeMetadata(StructType schema) {
        ArrayBuffer rows;
        block0: {
            rows = new ArrayBuffer();
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$getDescribeMetadata$1(x$8)))) break block0;
            rows.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"", (Object)"", (Object)"")}));
            rows.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"# Column Default Values", (Object)"", (Object)"")}));
            schema.foreach((Function1 & Serializable & scala.Serializable)column -> column.getCurrentDefaultValue().map((Function1 & Serializable & scala.Serializable)value -> {
                rows.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)column.name(), (Object)column.dataType().simpleString(), (Object)value)}));
                return BoxedUnit.UNIT;
            }));
        }
        return rows.toSeq();
    }

    public Object[] existenceDefaultValues(StructType schema) {
        return this.getExistenceDefaultValues(schema);
    }

    public boolean[] existenceDefaultsBitmask(StructType schema) {
        return this.getExistenceDefaultsBitmask(schema);
    }

    public boolean hasExistenceDefaultValues(StructType schema) {
        return Predef$.MODULE$.genericArrayOps((Object)this.existenceDefaultValues(schema)).exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$hasExistenceDefaultValues$1(x$9)));
    }

    public static final /* synthetic */ boolean $anonfun$validateCatalogForDefaultValue$1(StructField x$1) {
        return x$1.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY());
    }

    public static final /* synthetic */ boolean $anonfun$validateTableProviderForDefaultValue$1(StructField x$2) {
        return x$2.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY());
    }

    public static final /* synthetic */ boolean $anonfun$containsExplicitDefaultColumn$1(Expression x0$1) {
        Expression expression = x0$1;
        if (expression instanceof UnresolvedAttribute) {
            UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)expression;
            return MODULE$.isExplicitDefaultColumn(unresolvedAttribute);
        }
        return false;
    }

    private static final /* synthetic */ CatalystSqlParser parser$lzycompute$1(LazyRef parser$lzy$1) {
        CatalystSqlParser catalystSqlParser;
        LazyRef lazyRef = parser$lzy$1;
        synchronized (lazyRef) {
            catalystSqlParser = parser$lzy$1.initialized() ? (CatalystSqlParser)parser$lzy$1.value() : (CatalystSqlParser)parser$lzy$1.initialize((Object)new CatalystSqlParser());
        }
        return catalystSqlParser;
    }

    private static final CatalystSqlParser parser$1(LazyRef parser$lzy$1) {
        if (parser$lzy$1.initialized()) {
            return (CatalystSqlParser)parser$lzy$1.value();
        }
        return ResolveDefaultColumns$.parser$lzycompute$1(parser$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$analyze$1(DataType x$7) {
        DataType dataType = x$7;
        return dataType instanceof BooleanType ? true : (dataType instanceof ArrayType ? true : (dataType instanceof StructType ? true : dataType instanceof MapType));
    }

    public static final /* synthetic */ boolean $anonfun$getDescribeMetadata$1(StructField x$8) {
        return x$8.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY());
    }

    public static final /* synthetic */ boolean $anonfun$hasExistenceDefaultValues$1(Object x$9) {
        return x$9 != null;
    }

    private ResolveDefaultColumns$() {
        MODULE$ = this;
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
        ResolveDefaultColumnsUtils.$init$((ResolveDefaultColumnsUtils)this);
        this.CURRENT_DEFAULT_COLUMN_NAME = "DEFAULT";
    }
}

