/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HllUnion$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(first, second, allowDifferentLgConfigK) - Merges two binary representations of\n    Datasketches HllSketch objects, using a Datasketches Union object. Set\n    allowDifferentLgConfigK to true to allow unions of sketches with different\n    lgConfigK values (defaults to false). ", examples="\n    Examples:\n      > SELECT hll_sketch_estimate(_FUNC_(hll_sketch_agg(col1), hll_sketch_agg(col2))) FROM VALUES (1, 4), (1, 4), (2, 5), (2, 5), (3, 6) tab(col1, col2);\n       6\n  ", group="misc_funcs", since="3.5.0")
@ScalaSignature(bytes="\u0006\u0001\t]a\u0001\u0002\u0012$\u0001BB\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t'\u0002\u0011\t\u0012)A\u0005!\"AA\u000b\u0001BK\u0002\u0013\u0005q\n\u0003\u0005V\u0001\tE\t\u0015!\u0003Q\u0011!1\u0006A!f\u0001\n\u0003y\u0005\u0002C,\u0001\u0005#\u0005\u000b\u0011\u0002)\t\u000ba\u0003A\u0011A-\t\u000fy\u0003!\u0019!C\u0005?\"1\u0001\u000e\u0001Q\u0001\n\u0001DQ\u0001\u0017\u0001\u0005\u0002%DQ\u0001\u0017\u0001\u0005\u00021DQa\u001d\u0001\u0005RQDQa\u001f\u0001\u0005BqDq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u00022\u0001!\t%a\r\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>!I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00111\u000b\u0005\n\u00037\u0002\u0011\u0013!C\u0001\u0003;B\u0011\"a\u001d\u0001#\u0003%\t!!\u0018\t\u0013\u0005U\u0004!%A\u0005\u0002\u0005u\u0003\"CA<\u0001\u0005\u0005I\u0011IA=\u0011%\tI\tAA\u0001\n\u0003\tY\tC\u0005\u0002\u0014\u0002\t\t\u0011\"\u0001\u0002\u0016\"I\u00111\u0014\u0001\u0002\u0002\u0013\u0005\u0013Q\u0014\u0005\n\u0003W\u0003\u0011\u0011!C\u0001\u0003[C\u0011\"!-\u0001\u0003\u0003%\t%a-\b\u0013\u0005]7%!A\t\u0002\u0005eg\u0001\u0003\u0012$\u0003\u0003E\t!a7\t\racB\u0011AAu\u0011%\tY\u000fHA\u0001\n\u000b\ni\u000fC\u0005\u0002pr\t\t\u0011\"!\u0002r\"I\u0011\u0011 \u000f\u0002\u0002\u0013\u0005\u00151 \u0005\n\u0005\u001ba\u0012\u0011!C\u0005\u0005\u001f\u0011\u0001\u0002\u00137m+:LwN\u001c\u0006\u0003I\u0015\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011aeJ\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001&K\u0001\u0004gFd'B\u0001\u0016,\u0003\u0015\u0019\b/\u0019:l\u0015\taS&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002]\u0005\u0019qN]4\u0004\u0001M9\u0001!M\u001b<}\u0015[\u0005C\u0001\u001a4\u001b\u0005\u0019\u0013B\u0001\u001b$\u0005E!VM\u001d8bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003mej\u0011a\u000e\u0006\u0003q\r\nqaY8eK\u001e,g.\u0003\u0002;o\ty1i\u001c3fO\u0016tg)\u00197mE\u0006\u001c7\u000e\u0005\u00023y%\u0011Qh\t\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA C\u001d\t\u0011\u0004)\u0003\u0002BG\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!!Q\u0012\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\u000fA\u0013x\u000eZ;diB\u0011a\tT\u0005\u0003\u001b\u001e\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fQAZ5sgR,\u0012\u0001\u0015\t\u0003eEK!AU\u0012\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004gSJ\u001cH\u000fI\u0001\u0007g\u0016\u001cwN\u001c3\u0002\u000fM,7m\u001c8eA\u0005)A\u000f[5sI\u00061A\u000f[5sI\u0002\na\u0001P5oSRtD\u0003\u0002.\\9v\u0003\"A\r\u0001\t\u000b9;\u0001\u0019\u0001)\t\u000bQ;\u0001\u0019\u0001)\t\u000bY;\u0001\u0019\u0001)\u0002\u0015Q\f'oZ3u)f\u0004X-F\u0001a!\t\tg-D\u0001c\u0015\t\u0019G-A\u0002iY2T!!Z\u0016\u0002\u0019\u0011\fG/Y:lKR\u001c\u0007.Z:\n\u0005\u001d\u0014'A\u0003+hi\"cG\u000eV=qK\u0006YA/\u0019:hKR$\u0016\u0010]3!)\rQ&n\u001b\u0005\u0006\u001d*\u0001\r\u0001\u0015\u0005\u0006)*\u0001\r\u0001\u0015\u000b\u000556tw\u000eC\u0003O\u0017\u0001\u0007\u0001\u000bC\u0003U\u0017\u0001\u0007\u0001\u000bC\u0003W\u0017\u0001\u0007\u0001\u000f\u0005\u0002Gc&\u0011!o\u0012\u0002\b\u0005>|G.Z1o\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000e\u0006\u0003[k^L\b\"\u0002<\r\u0001\u0004\u0001\u0016\u0001\u00038fo\u001aK'o\u001d;\t\u000bad\u0001\u0019\u0001)\u0002\u00139,woU3d_:$\u0007\"\u0002>\r\u0001\u0004\u0001\u0016\u0001\u00038foRC\u0017N\u001d3\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001~!\rq\u00181\u0002\b\u0004\u007f\u0006\u001d\u0001cAA\u0001\u000f6\u0011\u00111\u0001\u0006\u0004\u0003\u000by\u0013A\u0002\u001fs_>$h(C\u0002\u0002\n\u001d\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0007\u0003\u001f\u0011aa\u0015;sS:<'bAA\u0005\u000f\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005U\u0001CBA\f\u0003?\t)C\u0004\u0003\u0002\u001a\u0005ua\u0002BA\u0001\u00037I\u0011\u0001S\u0005\u0003\u0003\u001eKA!!\t\u0002$\t\u00191+Z9\u000b\u0005\u0005;\u0005\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-r%A\u0003usB,7/\u0003\u0003\u00020\u0005%\"\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,WCAA\u001b!\u0011\t9#a\u000e\n\t\u0005e\u0012\u0011\u0006\u0002\t\t\u0006$\u0018\rV=qK\u0006aa.\u001e7m'\u00064W-\u0012<bYRA\u0011qHA#\u0003\u0013\ni\u0005E\u0002G\u0003\u0003J1!a\u0011H\u0005\r\te.\u001f\u0005\b\u0003\u000f\u0002\u0002\u0019AA \u0003\u00191\u0018\r\\;fc!9\u00111\n\tA\u0002\u0005}\u0012A\u0002<bYV,'\u0007C\u0004\u0002PA\u0001\r!a\u0010\u0002\rY\fG.^34\u0003\u0011\u0019w\u000e]=\u0015\u000fi\u000b)&a\u0016\u0002Z!9a*\u0005I\u0001\u0002\u0004\u0001\u0006b\u0002+\u0012!\u0003\u0005\r\u0001\u0015\u0005\b-F\u0001\n\u00111\u0001Q\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\u0018+\u0007A\u000b\tg\u000b\u0002\u0002dA!\u0011QMA8\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014!C;oG\",7m[3e\u0015\r\tigR\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA9\u0003O\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003w\u0002B!! \u0002\b6\u0011\u0011q\u0010\u0006\u0005\u0003\u0003\u000b\u0019)\u0001\u0003mC:<'BAAC\u0003\u0011Q\u0017M^1\n\t\u00055\u0011qP\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u001b\u00032ARAH\u0013\r\t\tj\u0012\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u007f\t9\nC\u0005\u0002\u001a^\t\t\u00111\u0001\u0002\u000e\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a(\u0011\r\u0005\u0005\u0016qUA \u001b\t\t\u0019KC\u0002\u0002&\u001e\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI+a)\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004a\u0006=\u0006\"CAM3\u0005\u0005\t\u0019AA \u0003\u0019)\u0017/^1mgR\u0019\u0001/!.\t\u0013\u0005e%$!AA\u0002\u0005}\u0002f\u0005\u0001\u0002:\u0006}\u0016\u0011YAc\u0003\u000f\fY-!4\u0002R\u0006M\u0007c\u0001\u001a\u0002<&\u0019\u0011QX\u0012\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u00111Y\u0001\u0003@)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015gSJ\u001cH\u000f\f\u0011tK\u000e|g\u000e\u001a\u0017!C2dwn\u001e#jM\u001a,'/\u001a8u\u0019\u001e\u001cuN\u001c4jO.K\u0003%\f\u0011NKJ<Wm\u001d\u0011uo>\u0004#-\u001b8bef\u0004#/\u001a9sKN,g\u000e^1uS>t7\u000fI8g\u0015\u0001\u0002\u0003\u0005\t#bi\u0006\u001c8.\u001a;dQ\u0016\u001c\b\u0005\u00137m'.,Go\u00195!_\nTWm\u0019;tY\u0001*8/\u001b8hA\u0005\u0004C)\u0019;bg.,Go\u00195fg\u0002*f.[8oA=\u0014'.Z2u]\u0001\u001aV\r\u001e\u0006!A\u0001\u0002\u0013\r\u001c7po\u0012KgMZ3sK:$HjZ\"p]\u001aLwm\u0013\u0011u_\u0002\"(/^3!i>\u0004\u0013\r\u001c7po\u0002*h.[8og\u0002zg\rI:lKR\u001c\u0007.Z:!o&$\b\u000e\t3jM\u001a,'/\u001a8u\u0015\u0001\u0002\u0003\u0005\t7h\u0007>tg-[4LAY\fG.^3tA!\"WMZ1vYR\u001c\b\u0005^8!M\u0006d7/Z\u0015/A\u0005AQ\r_1na2,7/\t\u0002\u0002J\u0006\tYG\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011iY2|6o[3uG\"|Vm\u001d;j[\u0006$X\rK0G+:\u001bu\f\u000b5mY~\u001b8.\u001a;dQ~\u000bwm\u001a\u0015d_2\f\u0014\u0006\f\u0011iY2|6o[3uG\"|\u0016mZ4)G>d''K\u0015*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)c1\u0002C'\u000b\u0017!QEb\u0003\u0005N\u0015-A!\u0012D\u0006I\u001b*Y\u0001B#\u0007\f\u00116S1\u0002\u0003f\r\u0017!m%\u0002C/\u00192)G>d\u0017\u0007\f\u0011d_2\u0014\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00117\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAh\u0003)i\u0017n]2`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003+\fQa\r\u00186]A\n\u0001\u0002\u00137m+:LwN\u001c\t\u0003eq\u0019B\u0001HAo\u0017BA\u0011q\\As!B\u0003&,\u0004\u0002\u0002b*\u0019\u00111]$\u0002\u000fI,h\u000e^5nK&!\u0011q]Aq\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u00033\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003w\nQ!\u00199qYf$rAWAz\u0003k\f9\u0010C\u0003O?\u0001\u0007\u0001\u000bC\u0003U?\u0001\u0007\u0001\u000bC\u0003W?\u0001\u0007\u0001+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005u(\u0011\u0002\t\u0006\r\u0006}(1A\u0005\u0004\u0005\u00039%AB(qi&|g\u000e\u0005\u0004G\u0005\u000b\u0001\u0006\u000bU\u0005\u0004\u0005\u000f9%A\u0002+va2,7\u0007\u0003\u0005\u0003\f\u0001\n\t\u00111\u0001[\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003\u0012A!\u0011Q\u0010B\n\u0013\u0011\u0011)\"a \u0003\r=\u0013'.Z2u\u0001")
public class HllUnion
extends TernaryExpression
implements CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression first;
    private final Expression second;
    private final Expression third;
    private final TgtHllType targetType;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(HllUnion hllUnion) {
        return HllUnion$.MODULE$.unapply(hllUnion);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, HllUnion> tupled() {
        return HllUnion$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, HllUnion>>> curried() {
        return HllUnion$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression first() {
        return this.first;
    }

    @Override
    public Expression second() {
        return this.second;
    }

    @Override
    public Expression third() {
        return this.third;
    }

    private TgtHllType targetType() {
        return this.targetType;
    }

    @Override
    public HllUnion withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    @Override
    public String prettyName() {
        return "hll_union";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)BinaryType$.MODULE$, (List)new .colon.colon((Object)BooleanType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object value1, Object value2, Object value3) {
        HllSketch hllSketch;
        HllSketch hllSketch2;
        try {
            hllSketch2 = HllSketch.heapify((Memory)Memory.wrap((byte[])((byte[])value1)));
        }
        catch (Error error) {
            throw QueryExecutionErrors$.MODULE$.hllInvalidInputSketchBuffer(this.prettyName());
        }
        HllSketch sketch1 = hllSketch2;
        try {
            hllSketch = HllSketch.heapify((Memory)Memory.wrap((byte[])((byte[])value2)));
        }
        catch (Error error) {
            throw QueryExecutionErrors$.MODULE$.hllInvalidInputSketchBuffer(this.prettyName());
        }
        HllSketch sketch2 = hllSketch;
        boolean allowDifferentLgConfigK = BoxesRunTime.unboxToBoolean((Object)value3);
        if (!allowDifferentLgConfigK && sketch1.getLgConfigK() != sketch2.getLgConfigK()) {
            throw QueryExecutionErrors$.MODULE$.hllUnionDifferentLgK(sketch1.getLgConfigK(), sketch2.getLgConfigK(), this.prettyName());
        }
        Union union = new Union(Math.min(sketch1.getLgConfigK(), sketch2.getLgConfigK()));
        union.update(sketch1);
        union.update(sketch2);
        return union.getResult(this.targetType()).toUpdatableByteArray();
    }

    public HllUnion copy(Expression first, Expression second, Expression third) {
        return new HllUnion(first, second, third);
    }

    public Expression copy$default$1() {
        return this.first();
    }

    public Expression copy$default$2() {
        return this.second();
    }

    public Expression copy$default$3() {
        return this.third();
    }

    @Override
    public String productPrefix() {
        return "HllUnion";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.first();
            }
            case 1: {
                return this.second();
            }
            case 2: {
                return this.third();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HllUnion;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HllUnion)) return false;
        boolean bl = true;
        if (!bl) return false;
        HllUnion hllUnion = (HllUnion)x$1;
        Expression expression = this.first();
        Expression expression2 = hllUnion.first();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.second();
        Expression expression4 = hllUnion.second();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.third();
        Expression expression6 = hllUnion.third();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!hllUnion.canEqual(this)) return false;
        return true;
    }

    public HllUnion(Expression first, Expression second, Expression third) {
        this.first = first;
        this.second = second;
        this.third = third;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.targetType = TgtHllType.HLL_8;
    }

    public HllUnion(Expression first, Expression second) {
        this(first, second, Literal$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public HllUnion(Expression first, Expression second, boolean third) {
        this(first, second, Literal$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)third)));
    }
}

