/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.spark.sql.errors.QueryExecutionErrors;
import org.apache.spark.unsafe.types.UTF8String;

public class ExpressionImplUtils {
    private static final ThreadLocal<SecureRandom> threadLocalSecureRandom = ThreadLocal.withInitial(SecureRandom::new);
    private static final int GCM_IV_LEN = 12;
    private static final int GCM_TAG_LEN = 128;
    private static final int CBC_IV_LEN = 16;

    public static boolean isLuhnNumber(UTF8String numberString) {
        String digits = numberString.toString();
        if (digits.isEmpty()) {
            return false;
        }
        int checkSum = 0;
        boolean isSecond = false;
        for (int i = digits.length() - 1; i >= 0; --i) {
            char ch = digits.charAt(i);
            if (!Character.isDigit(ch)) {
                return false;
            }
            int digit = Character.getNumericValue(ch);
            int doubled = isSecond ? digit * 2 : digit;
            checkSum += doubled % 10 + doubled / 10;
            isSecond = !isSecond;
        }
        return checkSum % 10 == 0;
    }

    public static byte[] aesEncrypt(byte[] input, byte[] key, UTF8String mode, UTF8String padding, byte[] iv, byte[] aad) {
        return ExpressionImplUtils.aesInternal(input, key, mode.toString(), padding.toString(), 1, iv, aad);
    }

    public static byte[] aesDecrypt(byte[] input, byte[] key, UTF8String mode, UTF8String padding, byte[] aad) {
        return ExpressionImplUtils.aesInternal(input, key, mode.toString(), padding.toString(), 2, null, aad);
    }

    private static SecretKeySpec getSecretKeySpec(byte[] key) {
        switch (key.length) {
            case 16: 
            case 24: 
            case 32: {
                return new SecretKeySpec(key, 0, key.length, "AES");
            }
        }
        throw QueryExecutionErrors.invalidAesKeyLengthError(key.length);
    }

    private static byte[] generateIv(CipherMode mode) {
        byte[] iv = new byte[mode.ivLength];
        threadLocalSecureRandom.get().nextBytes(iv);
        return iv;
    }

    private static AlgorithmParameterSpec getParamSpec(CipherMode mode, byte[] input) {
        switch (mode) {
            case CBC: {
                return new IvParameterSpec(input, 0, mode.ivLength);
            }
            case GCM: {
                return new GCMParameterSpec(mode.tagLength, input, 0, mode.ivLength);
            }
        }
        return null;
    }

    private static byte[] aesInternal(byte[] input, byte[] key, String mode, String padding, int opmode, byte[] iv, byte[] aad) {
        try {
            SecretKeySpec secretKey = ExpressionImplUtils.getSecretKeySpec(key);
            CipherMode cipherMode = CipherMode.fromString(mode, padding);
            Cipher cipher = Cipher.getInstance(cipherMode.transformation);
            if (opmode == 1) {
                if (iv == null || iv.length == 0) {
                    iv = ExpressionImplUtils.generateIv(cipherMode);
                } else if (!cipherMode.usesSpec) {
                    throw QueryExecutionErrors.aesUnsupportedIv(mode);
                }
                if (iv.length != cipherMode.ivLength) {
                    throw QueryExecutionErrors.invalidAesIvLengthError(mode, iv.length);
                }
                if (cipherMode.usesSpec) {
                    AlgorithmParameterSpec algSpec = ExpressionImplUtils.getParamSpec(cipherMode, iv);
                    cipher.init(opmode, (Key)secretKey, algSpec);
                } else {
                    cipher.init(opmode, secretKey);
                }
                if (aad != null && aad.length != 0) {
                    if (!cipherMode.supportsAad) {
                        throw QueryExecutionErrors.aesUnsupportedAad(mode);
                    }
                    cipher.updateAAD(aad);
                }
                byte[] encrypted = cipher.doFinal(input, 0, input.length);
                if (iv.length > 0) {
                    ByteBuffer byteBuffer = ByteBuffer.allocate(iv.length + encrypted.length);
                    byteBuffer.put(iv);
                    byteBuffer.put(encrypted);
                    return byteBuffer.array();
                }
                return encrypted;
            }
            assert (opmode == 2);
            if (cipherMode.usesSpec) {
                AlgorithmParameterSpec algSpec = ExpressionImplUtils.getParamSpec(cipherMode, input);
                cipher.init(opmode, (Key)secretKey, algSpec);
                if (aad != null && aad.length != 0) {
                    if (!cipherMode.supportsAad) {
                        throw QueryExecutionErrors.aesUnsupportedAad(mode);
                    }
                    cipher.updateAAD(aad);
                }
                return cipher.doFinal(input, cipherMode.ivLength, input.length - cipherMode.ivLength);
            }
            cipher.init(opmode, secretKey);
            return cipher.doFinal(input, 0, input.length);
        }
        catch (GeneralSecurityException e) {
            throw QueryExecutionErrors.aesCryptoError(e.getMessage());
        }
    }

    static enum CipherMode {
        ECB("ECB", 0, 0, "AES/ECB/PKCS5Padding", false, false),
        CBC("CBC", 16, 0, "AES/CBC/PKCS5Padding", true, false),
        GCM("GCM", 12, 128, "AES/GCM/NoPadding", true, true);

        private final String name;
        final int ivLength;
        final int tagLength;
        final String transformation;
        final boolean usesSpec;
        final boolean supportsAad;

        private CipherMode(String name, int ivLen, int tagLen, String transformation, boolean usesSpec, boolean supportsAad) {
            this.name = name;
            this.ivLength = ivLen;
            this.tagLength = tagLen;
            this.transformation = transformation;
            this.usesSpec = usesSpec;
            this.supportsAad = supportsAad;
        }

        static CipherMode fromString(String modeName, String padding) {
            boolean isNone = padding.equalsIgnoreCase("NONE");
            boolean isPkcs = padding.equalsIgnoreCase("PKCS");
            boolean isDefault = padding.equalsIgnoreCase("DEFAULT");
            if (modeName.equalsIgnoreCase(CipherMode.ECB.name) && (isPkcs || isDefault)) {
                return ECB;
            }
            if (modeName.equalsIgnoreCase(CipherMode.CBC.name) && (isPkcs || isDefault)) {
                return CBC;
            }
            if (modeName.equalsIgnoreCase(CipherMode.GCM.name) && (isNone || isDefault)) {
                return GCM;
            }
            throw QueryExecutionErrors.aesModeUnsupportedError(modeName, padding);
        }
    }
}

