/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import java.io.File;
import java.net.URI;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.FunctionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogTestUtils;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogSuite$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.BigInt$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000113Q!\u0001\u0002\u0002\u0002=\u0011A#\u0012=uKJt\u0017\r\\\"bi\u0006dwnZ*vSR,'BA\u0002\u0005\u0003\u001d\u0019\u0017\r^1m_\u001eT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0015!\t\t\"#D\u0001\t\u0013\t\u0019\u0002BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003+ai\u0011A\u0006\u0006\u0003/1\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005e1\"A\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]#bG\"DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002\t\u000f\u0001\u0002!\u0019!D\tC\u0005)Q\u000f^5mgV\t!\u0005\u0005\u0002\u001fG%\u0011AE\u0001\u0002\u0011\u0007\u0006$\u0018\r\\8h)\u0016\u001cH/\u0016;jYNDQA\n\u0001\u0005\u0012\u001d\n!B]3tKR\u001cF/\u0019;f)\u0005A\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#\u0001B+oSRDQa\f\u0001\u0005B\u001d\n\u0011\"\u00194uKJ,\u0015m\u00195\t\u000bE\u0002A\u0011\u0002\u001a\u0002\r\u0015D\u0018n\u001d;t)\r\u0019d\u0007\u0011\t\u0003SQJ!!\u000e\u0016\u0003\u000f\t{w\u000e\\3b]\")q\u0007\ra\u0001q\u0005\u0019QO]5\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014a\u00018fi*\tQ(\u0001\u0003kCZ\f\u0017BA ;\u0005\r)&+\u0013\u0005\u0006\u0003B\u0002\rAQ\u0001\tG\"LG\u000e\u001a:f]B\u0019\u0011fQ#\n\u0005\u0011S#A\u0003\u001fsKB,\u0017\r^3e}A\u0011a)\u0013\b\u0003S\u001dK!\u0001\u0013\u0016\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011*\u0002")
public abstract class ExternalCatalogSuite
extends SparkFunSuite
implements BeforeAndAfterEach {
    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.class.beforeEach((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.class.runTest((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public abstract CatalogTestUtils utils();

    public void resetState() {
    }

    public void afterEach() {
        try {
            this.resetState();
            return;
        }
        finally {
            BeforeAndAfterEach.class.afterEach((BeforeAndAfterEach)this);
        }
    }

    public boolean org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(URI uri, Seq<String> children2) {
        Path base = new Path(uri);
        Path finalPath = (Path)children2.foldLeft((Object)base, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Path apply(Path x0$1, String x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                if (tuple2 != null) {
                    Path parent = (Path)tuple2._1();
                    String child = (String)tuple2._2();
                    Path path = new Path(parent, child);
                    return path;
                }
                throw new MatchError((Object)tuple2);
            }
        });
        return base.getFileSystem(new Configuration()).exists(finalPath);
    }

    public ExternalCatalogSuite() {
        BeforeAndAfterEach.class.$init$((BeforeAndAfterEach)this);
        this.test("basic create and list databases", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newEmptyCatalog();
                catalog.createDatabase(this.$outer.utils().newDb("default"), true);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("default"), "catalog.databaseExists(\"default\")", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing"), "catalog.databaseExists(\"testing\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing2"), "catalog.databaseExists(\"testing2\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
                catalog.createDatabase(this.$outer.utils().newDb("testing"), false);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing"), "catalog.databaseExists(\"testing\")", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
                Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "testing"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
                catalog.createDatabase(this.$outer.utils().newDb("testing2"), false);
                Set $org_scalatest_assert_macro_left2 = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "testing", "testing2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("testing2"), "catalog.databaseExists(\"testing2\")", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(catalog.databaseExists("does_not_exist"), "catalog.databaseExists(\"does_not_exist\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("get database when a database exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                CatalogDatabase db1 = this.$outer.utils().newBasicCatalog().getDatabase("db1");
                String $org_scalatest_assert_macro_left = db1.name();
                String $org_scalatest_assert_macro_right = "db1";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
                String $org_scalatest_assert_macro_left2 = db1.description();
                String $org_scalatest_assert_macro_right2 = "db1";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("get database should throw exception when the database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final AnalysisException apply() {
                return (AnalysisException)((Object)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final CatalogDatabase apply() {
                        return this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newBasicCatalog().getDatabase("db_that_does_not_exist");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84)));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
        this.test("list databases without pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db1", "db2", "db3"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        this.test("list databases with pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listDatabases("db").toSet();
                Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
                Set $org_scalatest_assert_macro_left2 = catalog.listDatabases("db*").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db1", "db2", "db3"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
                Set $org_scalatest_assert_macro_left3 = catalog.listDatabases("*1").toSet();
                Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db1"}));
                Set set5 = $org_scalatest_assert_macro_left3;
                Set set6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
                Set $org_scalatest_assert_macro_left4 = catalog.listDatabases("db2").toSet();
                Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"db2"}));
                Set set7 = $org_scalatest_assert_macro_left4;
                Set set8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("drop database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                catalog.dropDatabase("db1", false, false);
                Set $org_scalatest_assert_macro_left = catalog.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db2", "db3"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("drop database when the database is not empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog1 = this.$outer.utils().newBasicCatalog();
                catalog1.dropTable("db2", "tbl1", false, false);
                catalog1.dropTable("db2", "tbl2", false, false);
                this.$outer.intercept((Function0)new Serializable(this, catalog1){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog1$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog1$1.dropDatabase("db2", false, false);
                    }
                    {
                        this.catalog1$1 = catalog1$1;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
                this.$outer.resetState();
                ExternalCatalog catalog2 = this.$outer.utils().newBasicCatalog();
                catalog2.dropFunction("db2", "func1");
                this.$outer.intercept((Function0)new Serializable(this, catalog2){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog2$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog2$1.dropDatabase("db2", false, false);
                    }
                    {
                        this.catalog2$1 = catalog2$1;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
                this.$outer.resetState();
                ExternalCatalog catalog3 = this.$outer.utils().newBasicCatalog();
                catalog3.dropDatabase("db2", false, true);
                Set $org_scalatest_assert_macro_left = catalog3.listDatabases().toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"default", "db1", "db3"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
        this.test("drop database when the database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$1.dropDatabase("db_that_does_not_exist", false, false);
                    }
                    {
                        this.catalog$1 = catalog$1;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
                catalog.dropDatabase("db_that_does_not_exist", true, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        this.test("alter database", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogDatabase db1 = catalog.getDatabase("db1");
                Map x$7 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"k"), (Object)"v3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"good"), (Object)"true")}));
                String x$8 = db1.copy$default$1();
                String x$9 = db1.copy$default$2();
                URI x$10 = db1.copy$default$3();
                catalog.alterDatabase(db1.copy(x$8, x$9, x$10, x$7));
                CatalogDatabase newDb1 = catalog.getDatabase("db1");
                Map $org_scalatest_assert_macro_left = db1.properties();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
                Map $org_scalatest_assert_macro_left2 = newDb1.properties();
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
                Option $org_scalatest_assert_macro_left3 = newDb1.properties().get((Object)"k");
                Some $org_scalatest_assert_macro_right2 = new Some((Object)"v3");
                Option option = $org_scalatest_assert_macro_left3;
                Some some = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
                Option $org_scalatest_assert_macro_left4 = newDb1.properties().get((Object)"good");
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"true");
                Option option2 = $org_scalatest_assert_macro_left4;
                Some some2 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("alter database should throw exception when the database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final AnalysisException apply() {
                return (AnalysisException)((Object)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newBasicCatalog().alterDatabase(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newDb("does_not_exist"));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153)));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
        this.test("the table type of an external table should be EXTERNAL_TABLE", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTable qual$1 = this.$outer.utils().newTable("external_table1", "db2");
                CatalogTableType x$11 = CatalogTableType$.MODULE$.EXTERNAL();
                TableIdentifier x$12 = qual$1.copy$default$1();
                CatalogStorageFormat x$13 = qual$1.copy$default$3();
                StructType x$14 = qual$1.copy$default$4();
                Option x$15 = qual$1.copy$default$5();
                Seq x$16 = qual$1.copy$default$6();
                Option x$17 = qual$1.copy$default$7();
                String x$18 = qual$1.copy$default$8();
                long x$19 = qual$1.copy$default$9();
                long x$20 = qual$1.copy$default$10();
                String x$21 = qual$1.copy$default$11();
                Map x$22 = qual$1.copy$default$12();
                Option x$23 = qual$1.copy$default$13();
                Option x$24 = qual$1.copy$default$14();
                Option x$25 = qual$1.copy$default$15();
                Seq x$26 = qual$1.copy$default$16();
                boolean x$27 = qual$1.copy$default$17();
                boolean x$28 = qual$1.copy$default$18();
                Map x$29 = qual$1.copy$default$19();
                CatalogTable table = qual$1.copy(x$12, x$11, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29);
                catalog.createTable(table, false);
                CatalogTable actual = catalog.getTable("db2", "external_table1");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(actual.tableType());
                CatalogTableType $org_scalatest_assert_macro_right = CatalogTableType$.MODULE$.EXTERNAL();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("create table when the table already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final TableAlreadyExistsException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
                CatalogTable table = this.$outer.utils().newTable("tbl1", "db2");
                return (TableAlreadyExistsException)this.$outer.intercept((Function0)new Serializable(this, catalog, table){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$2;
                    private final CatalogTable table$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$2.createTable(this.table$1, false);
                    }
                    {
                        this.catalog$2 = catalog$2;
                        this.table$1 = table$1;
                    }
                }, ClassTag$.MODULE$.apply(TableAlreadyExistsException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        this.test("drop table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
                catalog.dropTable("db2", "tbl1", false, false);
                Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test("drop table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$3;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$3.dropTable("unknown_db", "unknown_table", false, false);
                    }
                    {
                        this.catalog$3 = catalog$3;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$3;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$3.dropTable("unknown_db", "unknown_table", true, false);
                    }
                    {
                        this.catalog$3 = catalog$3;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$3;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$3.dropTable("db2", "unknown_table", false, false);
                    }
                    {
                        this.catalog$3 = catalog$3;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
                catalog.dropTable("db2", "unknown_table", true, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("rename table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
                catalog.renameTable("db2", "tbl1", "tblone");
                Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tblone", "tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
        this.test("rename table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final AnalysisException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$4;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$4.renameTable("unknown_db", "unknown_table", "unknown_table");
                    }
                    {
                        this.catalog$4 = catalog$4;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
                return (AnalysisException)((Object)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$4;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$4.renameTable("db2", "unknown_table", "unknown_table");
                    }
                    {
                        this.catalog$4 = catalog$4;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        this.test("rename table when destination table already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final AnalysisException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                return (AnalysisException)((Object)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$5;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$5.renameTable("db2", "tbl1", "tbl2");
                    }
                    {
                        this.catalog$5 = catalog$5;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        this.test("alter table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTable tbl1 = catalog.getTable("db2", "tbl1");
                Map x$30 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"toh"), (Object)"frem")}));
                TableIdentifier x$31 = tbl1.copy$default$1();
                CatalogTableType x$32 = tbl1.copy$default$2();
                CatalogStorageFormat x$33 = tbl1.copy$default$3();
                StructType x$34 = tbl1.copy$default$4();
                Option x$35 = tbl1.copy$default$5();
                Seq x$36 = tbl1.copy$default$6();
                Option x$37 = tbl1.copy$default$7();
                String x$38 = tbl1.copy$default$8();
                long x$39 = tbl1.copy$default$9();
                long x$40 = tbl1.copy$default$10();
                String x$41 = tbl1.copy$default$11();
                Option x$42 = tbl1.copy$default$13();
                Option x$43 = tbl1.copy$default$14();
                Option x$44 = tbl1.copy$default$15();
                Seq x$45 = tbl1.copy$default$16();
                boolean x$46 = tbl1.copy$default$17();
                boolean x$47 = tbl1.copy$default$18();
                Map x$48 = tbl1.copy$default$19();
                catalog.alterTable(tbl1.copy(x$31, x$32, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$30, x$42, x$43, x$44, x$45, x$46, x$47, x$48));
                CatalogTable newTbl1 = catalog.getTable("db2", "tbl1");
                Map $org_scalatest_assert_macro_left = tbl1.properties();
                String $org_scalatest_assert_macro_right = "toh";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
                Map $org_scalatest_assert_macro_left2 = newTbl1.properties();
                int $org_scalatest_assert_macro_right2 = tbl1.properties().size() + 1;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
                Option $org_scalatest_assert_macro_left3 = newTbl1.properties().get((Object)"toh");
                Some $org_scalatest_assert_macro_right3 = new Some((Object)"frem");
                Option option = $org_scalatest_assert_macro_left3;
                Some some = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
        this.test("alter table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final AnalysisException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$21 $outer;
                    private final ExternalCatalog catalog$6;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$6.alterTable(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newTable("tbl1", "unknown_db"));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$6 = catalog$6;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
                return (AnalysisException)((Object)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$21 $outer;
                    private final ExternalCatalog catalog$6;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$6.alterTable(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newTable("unknown_table", "db2"));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$6 = catalog$6;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241)));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 236));
        this.test("alter table schema", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                StructType newDataSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("col1", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("new_field_2", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
                catalog.alterTableDataSchema("db2", "tbl1", newDataSchema);
                CatalogTable newTbl1 = catalog.getTable("db2", "tbl1");
                StructType $org_scalatest_assert_macro_left = newTbl1.dataSchema();
                StructType $org_scalatest_assert_macro_right = newDataSchema;
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 246));
        this.test("alter table stats", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                Option oldTableStats;
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Option $org_scalatest_assert_macro_left = oldTableStats = catalog.getTable("db2", "tbl1").stats();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 259));
                CatalogStatistics newStats = new CatalogStatistics(BigInt$.MODULE$.int2bigInt(1), CatalogStatistics$.MODULE$.apply$default$2(), CatalogStatistics$.MODULE$.apply$default$3());
                catalog.alterTableStats("db2", "tbl1", (Option)new Some((Object)newStats));
                Option newTableStats = catalog.getTable("db2", "tbl1").stats();
                CatalogStatistics $org_scalatest_assert_macro_left2 = (CatalogStatistics)newTableStats.get();
                CatalogStatistics $org_scalatest_assert_macro_right = newStats;
                CatalogStatistics catalogStatistics = $org_scalatest_assert_macro_left2;
                CatalogStatistics catalogStatistics2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(catalogStatistics != null ? !catalogStatistics.equals(catalogStatistics2) : catalogStatistics2 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 263));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        this.test("get table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                String $org_scalatest_assert_macro_left = this.$outer.utils().newBasicCatalog().getTable("db2", "tbl1").identifier().table();
                String $org_scalatest_assert_macro_right = "tbl1";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 266));
        this.test("get table when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final AnalysisException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$7;

                    public final CatalogTable apply() {
                        return this.catalog$7.getTable("unknown_db", "unknown_table");
                    }
                    {
                        this.catalog$7 = catalog$7;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
                return (AnalysisException)((Object)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$7;

                    public final CatalogTable apply() {
                        return this.catalog$7.getTable("db2", "unknown_table");
                    }
                    {
                        this.catalog$7 = catalog$7;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 275)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 270));
        this.test("list tables without pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$8;

                    public final Seq<String> apply() {
                        return this.catalog$8.listTables("unknown_db");
                    }
                    {
                        this.catalog$8 = catalog$8;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
                Set $org_scalatest_assert_macro_left = catalog.listTables("db1").toSet();
                Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
                Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        this.test("list tables with pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$9;

                    public final Seq<String> apply() {
                        return this.catalog$9.listTables("unknown_db", "*");
                    }
                    {
                        this.catalog$9 = catalog$9;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
                Set $org_scalatest_assert_macro_left = catalog.listTables("db1", "*").toSet();
                Set $org_scalatest_assert_macro_right = Predef$.MODULE$.Set().empty();
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
                Set $org_scalatest_assert_macro_left2 = catalog.listTables("db2", "*").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
                Set $org_scalatest_assert_macro_left3 = catalog.listTables("db2", "tbl*").toSet();
                Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1", "tbl2"}));
                Set set5 = $org_scalatest_assert_macro_left3;
                Set set6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
                Set $org_scalatest_assert_macro_left4 = catalog.listTables("db2", "*1").toSet();
                Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tbl1"}));
                Set set7 = $org_scalatest_assert_macro_left4;
                Set set8 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 287));
        this.test("column names should be case-preserving and column nullability should be retained", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTable tbl = new CatalogTable(new TableIdentifier("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), this.$outer.utils().storageFormat(), new StructType().add("HelLo", "int", false).add("WoRLd", "int", true), (Option)new Some((Object)this.$outer.utils().defaultProvider()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WoRLd"})), (Option)new Some((Object)new BucketSpec(4, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HelLo"})), (Seq)Nil$.MODULE$)), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
                catalog.createTable(tbl, false);
                CatalogTable readBack = catalog.getTable("db1", "tbl");
                StructType $org_scalatest_assert_macro_left = readBack.schema();
                StructType $org_scalatest_assert_macro_right = tbl.schema();
                StructType structType = $org_scalatest_assert_macro_left;
                StructType structType2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
                Seq $org_scalatest_assert_macro_left2 = readBack.partitionColumnNames();
                Seq $org_scalatest_assert_macro_right2 = tbl.partitionColumnNames();
                Seq seq = $org_scalatest_assert_macro_left2;
                Seq seq2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
                Option $org_scalatest_assert_macro_left3 = readBack.bucketSpec();
                Option $org_scalatest_assert_macro_right3 = tbl.bucketSpec();
                Option option = $org_scalatest_assert_macro_left3;
                Option option2 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        this.test("basic create and list partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newEmptyCatalog();
                catalog.createDatabase(this.$outer.utils().newDb("mydb"), false);
                catalog.createTable(this.$outer.utils().newTable("tbl", "mydb"), false);
                catalog.createPartitions("mydb", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1(), this.$outer.utils().part2()})), false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.utils().catalogPartitionsEqual(catalog, "mydb", "tbl", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1(), this.$outer.utils().part2()})))), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog, \"mydb\", \"tbl\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part1, ExternalCatalogSuite.this.utils.part2))", Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
        this.test("create partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final AnalysisException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$10;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$10.createPartitions("does_not_exist", "tbl1", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false);
                    }
                    {
                        this.catalog$10 = catalog$10;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
                return (AnalysisException)((Object)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$10;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$10.createPartitions("db2", "does_not_exist", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false);
                    }
                    {
                        this.catalog$10 = catalog$10;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 328));
        this.test("create partitions that already exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;
                    private final ExternalCatalog catalog$11;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$11.createPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1()})), false);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$11 = catalog$11;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
                catalog.createPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1()})), true);
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        this.test("create partitions without location", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTable table = new CatalogTable(new TableIdentifier("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string"), (Option)new Some((Object)this.$outer.utils().defaultProvider()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1", "partCol2"})), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
                catalog.createTable(table, false);
                CatalogTablePartition partition = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"2")})), this.$outer.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                catalog.createPartitions("db1", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{partition})), false);
                URI partitionLocation = catalog.getPartition("db1", "tbl", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"2")}))).location();
                Path tableLocation = new Path(catalog.getTable("db1", "tbl").location());
                Path defaultPartitionLocation = new Path(new Path(tableLocation, "partCol1=1"), "partCol2=2");
                Path $org_scalatest_assert_macro_left = new Path(partitionLocation);
                Path $org_scalatest_assert_macro_right = defaultPartitionLocation;
                Path path = $org_scalatest_assert_macro_left;
                Path path2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(path != null ? !path.equals(path2) : path2 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
        this.test("create/drop partitions in managed tables with location", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTable table = new CatalogTable(new TableIdentifier("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string"), (Option)new Some((Object)this.$outer.utils().defaultProvider()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1", "partCol2"})), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
                catalog.createTable(table, false);
                URI newLocationPart1 = this.$outer.utils().newUriForDatabase();
                URI newLocationPart2 = this.$outer.utils().newUriForDatabase();
                CatalogTablePartition partition1 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"2")})), this.$outer.utils().storageFormat().copy((Option)new Some((Object)newLocationPart1), this.$outer.utils().storageFormat().copy$default$2(), this.$outer.utils().storageFormat().copy$default$3(), this.$outer.utils().storageFormat().copy$default$4(), this.$outer.utils().storageFormat().copy$default$5(), this.$outer.utils().storageFormat().copy$default$6()), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                CatalogTablePartition partition2 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"4")})), this.$outer.utils().storageFormat().copy((Option)new Some((Object)newLocationPart2), this.$outer.utils().storageFormat().copy$default$2(), this.$outer.utils().storageFormat().copy$default$3(), this.$outer.utils().storageFormat().copy$default$4(), this.$outer.utils().storageFormat().copy$default$5(), this.$outer.utils().storageFormat().copy$default$6()), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                catalog.createPartitions("db1", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{partition1})), false);
                catalog.createPartitions("db1", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{partition2})), false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(newLocationPart1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "ExternalCatalogSuite.this.exists(newLocationPart1)", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(newLocationPart2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "ExternalCatalogSuite.this.exists(newLocationPart2)", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
                catalog.dropPartitions("db1", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{partition1.spec()})), false, false, false);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(newLocationPart1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "ExternalCatalogSuite.this.exists(newLocationPart1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
                catalog.dropTable("db1", "tbl", false, false);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(newLocationPart2, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "ExternalCatalogSuite.this.exists(newLocationPart2)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 373));
        this.test("list partition names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                Seq partitionNames;
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTablePartition newPart = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"%=")})), this.$outer.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                catalog.createPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{newPart})), false);
                Seq $org_scalatest_assert_macro_left = partitionNames = catalog.listPartitionNames("db2", "tbl2", catalog.listPartitionNames$default$3());
                Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a=1/b=%25%3D", "a=1/b=2", "a=3/b=4"}));
                Seq seq = $org_scalatest_assert_macro_left;
                Seq seq2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
        this.test("list partition names with partial partition spec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                Seq partitionNames3;
                Seq partitionNames2;
                Seq partitionNames1;
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTablePartition newPart = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"%=")})), this.$outer.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                catalog.createPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{newPart})), false);
                Seq $org_scalatest_assert_macro_left = partitionNames1 = catalog.listPartitionNames("db2", "tbl2", (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1")}))));
                Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a=1/b=%25%3D", "a=1/b=2"}));
                Seq seq = $org_scalatest_assert_macro_left;
                Seq seq2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
                Seq $org_scalatest_assert_macro_left2 = partitionNames2 = catalog.listPartitionNames("db2", "tbl2", (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"%=")}))));
                Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a=1/b=%25%3D"}));
                Seq seq3 = $org_scalatest_assert_macro_left2;
                Seq seq4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq3 != null ? !seq3.equals(seq4) : seq4 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
                Seq $org_scalatest_assert_macro_left3 = partitionNames3 = catalog.listPartitionNames("db2", "tbl2", (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"%25%3D")}))));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 435));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
        this.test("list partitions with partial partition spec", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                Seq parts;
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Seq $org_scalatest_assert_macro_left = parts = catalog.listPartitions("db2", "tbl2", (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1")}))));
                int $org_scalatest_assert_macro_right = 1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 441));
                Map $org_scalatest_assert_macro_left2 = ((CatalogTablePartition)parts.head()).spec();
                Map $org_scalatest_assert_macro_right2 = this.$outer.utils().part1().spec();
                Map map = $org_scalatest_assert_macro_left2;
                Map map2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
                Seq $org_scalatest_assert_macro_left3 = catalog.listPartitions("db2", "tbl2", (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"unknown"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"1")}))));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
                Seq $org_scalatest_assert_macro_left4 = catalog.listPartitions("db2", "tbl2", (Option)new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"unknown")}))));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty(), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 446));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        this.test("SPARK-21457: list partitions with special chars", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Seq $org_scalatest_assert_macro_left = catalog.listPartitions("db2", "tbl1", catalog.listPartitions$default$3());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 451));
                CatalogTablePartition part1 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"i+j")})), this.$outer.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                CatalogTablePartition part2 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"i.j")})), this.$outer.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                catalog.createPartitions("db2", "tbl1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{part1, part2})), false);
                Seq $org_scalatest_assert_macro_left2 = (Seq)catalog.listPartitions("db2", "tbl1", (Option)new Some((Object)part1.spec())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, String> apply(CatalogTablePartition x$1) {
                        return x$1.spec();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq $org_scalatest_assert_macro_right = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{part1.spec()}));
                Seq seq = $org_scalatest_assert_macro_left2;
                Seq seq2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
                Seq $org_scalatest_assert_macro_left3 = (Seq)catalog.listPartitions("db2", "tbl1", (Option)new Some((Object)part2.spec())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, String> apply(CatalogTablePartition x$2) {
                        return x$2.spec();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{part2.spec()}));
                Seq seq3 = $org_scalatest_assert_macro_left3;
                Seq seq4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(seq3 != null ? !seq3.equals(seq4) : seq4 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 458));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        this.test("list partitions by filter", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;
            private static Symbol symbol$1;
            private static Symbol symbol$2;

            static {
                symbol$1 = Symbol$.MODULE$.apply("a");
                symbol$2 = Symbol$.MODULE$.apply("b");
            }

            public final AnalysisException apply() {
                String tz = TimeZone.getDefault().getID();
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTable tbl2 = catalog.getTable("db2", "tbl2");
                this.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$checkAnswer$1(tbl2, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1(), this.$outer.utils().part2()})), tz, catalog);
                this.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$checkAnswer$1(tbl2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$1).int()).$less$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1()})), tz, catalog);
                this.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$checkAnswer$1(tbl2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$1).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(2))})), Predef$.MODULE$.Set().empty(), tz, catalog);
                this.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$checkAnswer$1(tbl2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new In[]{new In(package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$1).int()).$times((Expression)package.expressions$.MODULE$.intToLiteral(10)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{package.expressions$.MODULE$.intToLiteral(30)})))})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part2()})), tz, catalog);
                this.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$checkAnswer$1(tbl2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Not[]{new Not((Expression)new In((Expression)package.expressions$.MODULE$.DslSymbol(symbol$1).int(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{package.expressions$.MODULE$.intToLiteral(4)}))))})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1(), this.$outer.utils().part2()})), tz, catalog);
                this.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$checkAnswer$1(tbl2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$1).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$2).string()).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("2"))})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1()})), tz, catalog);
                this.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$checkAnswer$1(tbl2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$1).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$2).string()).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("2")))})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1()})), tz, catalog);
                this.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$checkAnswer$1(tbl2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$1).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1)), package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$2).string()).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("x"))})), Predef$.MODULE$.Set().empty(), tz, catalog);
                this.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$checkAnswer$1(tbl2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$1).int()).$eq$eq$eq((Expression)package.expressions$.MODULE$.intToLiteral(1))).$bar$bar((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$2).string()).$eq$eq$eq((Expression)package.expressions$.MODULE$.stringToLiteral("x")))})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1()})), tz, catalog);
                return (AnalysisException)((Object)this.$outer.intercept((Function0)new Serializable(this, tz, catalog, tbl2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$39 $outer;
                    private final String tz$1;
                    private final ExternalCatalog catalog$12;
                    private final CatalogTable tbl2$1;
                    private static Symbol symbol$3;
                    private static Symbol symbol$4;

                    static {
                        symbol$3 = Symbol$.MODULE$.apply("a");
                        symbol$4 = Symbol$.MODULE$.apply("col1");
                    }

                    public final Object apply() {
                        try {
                            this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$checkAnswer$1(this.tbl2$1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$3).int()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(0))).$amp$amp((Expression)package.expressions$.MODULE$.DslExpression((Expression)package.expressions$.MODULE$.DslSymbol(symbol$4).int()).$greater((Expression)package.expressions$.MODULE$.intToLiteral(0)))})), Predef$.MODULE$.Set().empty(), this.tz$1, this.catalog$12);
                            return BoxedUnit.UNIT;
                        }
                        catch (Throwable throwable) {
                            RuntimeException runtimeException;
                            Throwable throwable2 = throwable;
                            if (throwable2 instanceof RuntimeException && (runtimeException = (RuntimeException)throwable2).getMessage().contains("MetaException")) {
                                throw new AnalysisException(runtimeException.getMessage(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                            }
                            throw throwable;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tz$1 = tz$1;
                        this.catalog$12 = catalog$12;
                        this.tbl2$1 = tbl2$1;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487)));
            }

            public final void org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$checkAnswer$1(CatalogTable table, Seq filters, Set expected, String tz$1, ExternalCatalog catalog$12) {
                this.$outer.assertResult(expected.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, String> apply(CatalogTablePartition x$3) {
                        return x$3.spec();
                    }
                }, Set$.MODULE$.canBuildFrom()), ((TraversableOnce)catalog$12.listPartitionsByFilter(table.database(), table.identifier().identifier(), filters, tz$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<String, String> apply(CatalogTablePartition x$4) {
                        return x$4.spec();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toSet(), Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
        this.test("drop partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.utils().catalogPartitionsEqual(catalog, "db2", "tbl2", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1(), this.$outer.utils().part2()})))), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog, \"db2\", \"tbl2\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part1, ExternalCatalogSuite.this.utils.part2))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 501));
                catalog.dropPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part1().spec()})), false, false, false);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.utils().catalogPartitionsEqual(catalog, "db2", "tbl2", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part2()})))), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog, \"db2\", \"tbl2\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part2))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 504));
                this.$outer.resetState();
                ExternalCatalog catalog2 = this.$outer.utils().newBasicCatalog();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.$outer.utils().catalogPartitionsEqual(catalog2, "db2", "tbl2", (Seq<CatalogTablePartition>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1(), this.$outer.utils().part2()})))), "ExternalCatalogSuite.this.utils.catalogPartitionsEqual(catalog2, \"db2\", \"tbl2\", collection.this.Seq.apply[org.apache.spark.sql.catalyst.catalog.CatalogTablePartition](ExternalCatalogSuite.this.utils.part1, ExternalCatalogSuite.this.utils.part2))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 507));
                catalog2.dropPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part1().spec(), this.$outer.utils().part2().spec()})), false, false, false);
                Seq $org_scalatest_assert_macro_left = catalog2.listPartitions("db2", "tbl2", catalog2.listPartitions$default$3());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 511));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 499));
        this.test("drop partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final AnalysisException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$13;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$13.dropPartitions("does_not_exist", "tbl1", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false, false, false);
                    }
                    {
                        this.catalog$13 = catalog$13;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
                return (AnalysisException)((Object)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$13;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$13.dropPartitions("db2", "does_not_exist", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), false, false, false);
                    }
                    {
                        this.catalog$13 = catalog$13;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 514));
        this.test("drop partitions that do not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    private final ExternalCatalog catalog$14;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$14.dropPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part3().spec()})), false, false, false);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$14 = catalog$14;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 530));
                catalog.dropPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part3().spec()})), true, false, false);
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 528));
        this.test("get partition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final AnalysisException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Map $org_scalatest_assert_macro_left = catalog.getPartition("db2", "tbl2", this.$outer.utils().part1().spec()).spec();
                Map $org_scalatest_assert_macro_right = this.$outer.utils().part1().spec();
                Map map = $org_scalatest_assert_macro_left;
                Map map2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 541));
                Map $org_scalatest_assert_macro_left2 = catalog.getPartition("db2", "tbl2", this.$outer.utils().part2().spec()).spec();
                Map $org_scalatest_assert_macro_right2 = this.$outer.utils().part2().spec();
                Map map3 = $org_scalatest_assert_macro_left2;
                Map map4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(map3 != null ? !map3.equals(map4) : map4 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
                return (AnalysisException)((Object)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$42 $outer;
                    private final ExternalCatalog catalog$15;

                    public final CatalogTablePartition apply() {
                        return this.catalog$15.getPartition("db2", "tbl1", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part3().spec());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$15 = catalog$15;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 543)));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
        this.test("get partition when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final AnalysisException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$43 $outer;
                    private final ExternalCatalog catalog$16;

                    public final CatalogTablePartition apply() {
                        return this.catalog$16.getPartition("does_not_exist", "tbl1", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1().spec());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$16 = catalog$16;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
                return (AnalysisException)((Object)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$43 $outer;
                    private final ExternalCatalog catalog$16;

                    public final CatalogTablePartition apply() {
                        return this.catalog$16.getPartition("db2", "does_not_exist", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1().spec());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$16 = catalog$16;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 553)));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 548));
        this.test("rename partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final AnalysisException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTablePartition newPart1 = this.$outer.utils().part1().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"100"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"101")})), this.$outer.utils().part1().copy$default$2(), this.$outer.utils().part1().copy$default$3(), this.$outer.utils().part1().copy$default$4(), this.$outer.utils().part1().copy$default$5(), this.$outer.utils().part1().copy$default$6());
                CatalogTablePartition newPart2 = this.$outer.utils().part2().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"200"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"201")})), this.$outer.utils().part2().copy$default$2(), this.$outer.utils().part2().copy$default$3(), this.$outer.utils().part2().copy$default$4(), this.$outer.utils().part2().copy$default$5(), this.$outer.utils().part2().copy$default$6());
                Seq newSpecs = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{newPart1.spec(), newPart2.spec()}));
                catalog.renamePartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part1().spec(), this.$outer.utils().part2().spec()})), newSpecs);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(catalog.getPartition("db2", "tbl2", newPart1.spec()).spec());
                Map $org_scalatest_assert_macro_right = newPart1.spec();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 564));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(catalog.getPartition("db2", "tbl2", newPart2.spec()).spec());
                Map $org_scalatest_assert_macro_right2 = newPart2.spec();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 565));
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$44 $outer;
                    private final ExternalCatalog catalog$17;

                    public final CatalogTablePartition apply() {
                        return this.catalog$17.getPartition("db2", "tbl2", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1().spec());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$17 = catalog$17;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 567));
                return (AnalysisException)((Object)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$44 $outer;
                    private final ExternalCatalog catalog$17;

                    public final CatalogTablePartition apply() {
                        return this.catalog$17.getPartition("db2", "tbl2", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part2().spec());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$17 = catalog$17;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 568)));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 558));
        this.test("rename partitions should update the location for managed table", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTable table = new CatalogTable(new TableIdentifier("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string"), (Option)new Some((Object)this.$outer.utils().defaultProvider()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1", "partCol2"})), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
                catalog.createTable(table, false);
                Path tableLocation = new Path(catalog.getTable("db1", "tbl").location());
                CatalogTablePartition mixedCasePart1 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"2")})), this.$outer.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                CatalogTablePartition mixedCasePart2 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"4")})), this.$outer.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                catalog.createPartitions("db1", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{mixedCasePart1})), false);
                Path $org_scalatest_assert_macro_left = new Path(catalog.getPartition("db1", "tbl", mixedCasePart1.spec()).location());
                Path $org_scalatest_assert_macro_right = new Path(new Path(tableLocation, "partCol1=1"), "partCol2=2");
                Path path = $org_scalatest_assert_macro_left;
                Path path2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(path != null ? !path.equals(path2) : path2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 594));
                catalog.renamePartitions("db1", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{mixedCasePart1.spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{mixedCasePart2.spec()})));
                Path $org_scalatest_assert_macro_left2 = new Path(catalog.getPartition("db1", "tbl", mixedCasePart2.spec()).location());
                Path $org_scalatest_assert_macro_right2 = new Path(new Path(tableLocation, "partCol1=3"), "partCol2=4");
                Path path3 = $org_scalatest_assert_macro_left2;
                Path path4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(path3 != null ? !path3.equals(path4) : path4 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 599));
                URI existingPartLoc = catalog.getPartition("db2", "tbl2", this.$outer.utils().part1().spec()).location();
                catalog.renamePartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part1().spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part3().spec()})));
                Path $org_scalatest_assert_macro_left3 = new Path(catalog.getPartition("db2", "tbl2", this.$outer.utils().part3().spec()).location());
                Path $org_scalatest_assert_macro_right3 = new Path(existingPartLoc);
                Path path5 = $org_scalatest_assert_macro_left3;
                Path path6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(path5 != null ? !path5.equals(path6) : path6 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 606));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 571));
        this.test("rename partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final AnalysisException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$46 $outer;
                    private final ExternalCatalog catalog$18;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$18.renamePartitions("does_not_exist", "tbl1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1().spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part2().spec()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$18 = catalog$18;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 613));
                return (AnalysisException)((Object)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$46 $outer;
                    private final ExternalCatalog catalog$18;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$18.renamePartitions("db2", "does_not_exist", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1().spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part2().spec()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$18 = catalog$18;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 616)));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 611));
        this.test("rename partitions when the new partition already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final AnalysisException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                return (AnalysisException)((Object)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$47 $outer;
                    private final ExternalCatalog catalog$19;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$19.renamePartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1().spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part2().spec()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$19 = catalog$19;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 623)));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 621));
        this.test("alter partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            /*
             * WARNING - void declaration
             */
            public final Object apply() {
                Object object;
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                try {
                    URI newLocation = this.$outer.utils().newUriForDatabase();
                    String newSerde = "com.sparkbricks.text.EasySerde";
                    Map newSerdeProps = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark"), (Object)"bricks"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"serialization.format"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"compressed"), (Object)"false")}));
                    CatalogTablePartition oldPart1 = catalog.getPartition("db2", "tbl2", this.$outer.utils().part1().spec());
                    CatalogTablePartition oldPart2 = catalog.getPartition("db2", "tbl2", this.$outer.utils().part2().spec());
                    CatalogTablePartition[] catalogTablePartitionArray = new CatalogTablePartition[2];
                    CatalogStorageFormat x$49 = this.$outer.utils().storageFormat().copy((Option)new Some((Object)newLocation), this.$outer.utils().storageFormat().copy$default$2(), this.$outer.utils().storageFormat().copy$default$3(), this.$outer.utils().storageFormat().copy$default$4(), this.$outer.utils().storageFormat().copy$default$5(), this.$outer.utils().storageFormat().copy$default$6());
                    Map x$50 = oldPart1.copy$default$1();
                    Map x$51 = oldPart1.copy$default$3();
                    long x$52 = oldPart1.copy$default$4();
                    long x$53 = oldPart1.copy$default$5();
                    Option x$54 = oldPart1.copy$default$6();
                    catalogTablePartitionArray[0] = oldPart1.copy(x$50, x$49, x$51, x$52, x$53, x$54);
                    CatalogStorageFormat x$55 = this.$outer.utils().storageFormat().copy((Option)new Some((Object)newLocation), this.$outer.utils().storageFormat().copy$default$2(), this.$outer.utils().storageFormat().copy$default$3(), this.$outer.utils().storageFormat().copy$default$4(), this.$outer.utils().storageFormat().copy$default$5(), this.$outer.utils().storageFormat().copy$default$6());
                    Map x$56 = oldPart2.copy$default$1();
                    Map x$57 = oldPart2.copy$default$3();
                    long x$58 = oldPart2.copy$default$4();
                    long x$59 = oldPart2.copy$default$5();
                    Option x$60 = oldPart2.copy$default$6();
                    catalogTablePartitionArray[1] = oldPart2.copy(x$56, x$55, x$57, x$58, x$59, x$60);
                    catalog.alterPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])catalogTablePartitionArray)));
                    CatalogTablePartition newPart1 = catalog.getPartition("db2", "tbl2", this.$outer.utils().part1().spec());
                    CatalogTablePartition newPart2 = catalog.getPartition("db2", "tbl2", this.$outer.utils().part2().spec());
                    Option $org_scalatest_assert_macro_left = newPart1.storage().locationUri();
                    Some $org_scalatest_assert_macro_right = new Some((Object)newLocation);
                    Option option = $org_scalatest_assert_macro_left;
                    Some some = $org_scalatest_assert_macro_right;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals(some) : some != null), Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 643));
                    Option $org_scalatest_assert_macro_left2 = newPart2.storage().locationUri();
                    Some $org_scalatest_assert_macro_right2 = new Some((Object)newLocation);
                    Option option2 = $org_scalatest_assert_macro_left2;
                    Some some2 = $org_scalatest_assert_macro_right2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(option2 != null ? !option2.equals(some2) : some2 != null), Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 644));
                    Option $org_scalatest_assert_macro_left3 = oldPart1.storage().locationUri();
                    Some $org_scalatest_assert_macro_right3 = new Some((Object)newLocation);
                    Option option3 = $org_scalatest_assert_macro_left3;
                    Some some3 = $org_scalatest_assert_macro_right3;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", (Object)$org_scalatest_assert_macro_right3, option3 != null ? !option3.equals(some3) : some3 != null, Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 645));
                    Option $org_scalatest_assert_macro_left4 = oldPart2.storage().locationUri();
                    Some $org_scalatest_assert_macro_right4 = new Some((Object)newLocation);
                    Option option4 = $org_scalatest_assert_macro_left4;
                    Some some4 = $org_scalatest_assert_macro_right4;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "!=", (Object)$org_scalatest_assert_macro_right4, option4 != null ? !option4.equals(some4) : some4 != null, Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 646));
                    CatalogTablePartition[] catalogTablePartitionArray2 = new CatalogTablePartition[2];
                    Some x$61 = new Some((Object)newSerde);
                    Option x$62 = this.$outer.utils().storageFormat().copy$default$1();
                    Option x$63 = this.$outer.utils().storageFormat().copy$default$2();
                    Option x$64 = this.$outer.utils().storageFormat().copy$default$3();
                    boolean x$65 = this.$outer.utils().storageFormat().copy$default$5();
                    Map x$66 = this.$outer.utils().storageFormat().copy$default$6();
                    CatalogStorageFormat x$67 = this.$outer.utils().storageFormat().copy(x$62, x$63, x$64, (Option)x$61, x$65, x$66);
                    Map x$68 = oldPart1.copy$default$1();
                    Map x$69 = oldPart1.copy$default$3();
                    long x$70 = oldPart1.copy$default$4();
                    long x$71 = oldPart1.copy$default$5();
                    Option x$72 = oldPart1.copy$default$6();
                    catalogTablePartitionArray2[0] = oldPart1.copy(x$68, x$67, x$69, x$70, x$71, x$72);
                    Map x$73 = newSerdeProps;
                    Option x$74 = this.$outer.utils().storageFormat().copy$default$1();
                    Option x$75 = this.$outer.utils().storageFormat().copy$default$2();
                    Option x$76 = this.$outer.utils().storageFormat().copy$default$3();
                    Option x$77 = this.$outer.utils().storageFormat().copy$default$4();
                    boolean x$78 = this.$outer.utils().storageFormat().copy$default$5();
                    CatalogStorageFormat x$79 = this.$outer.utils().storageFormat().copy(x$74, x$75, x$76, x$77, x$78, x$73);
                    Map x$80 = oldPart2.copy$default$1();
                    Map x$81 = oldPart2.copy$default$3();
                    long x$82 = oldPart2.copy$default$4();
                    long x$83 = oldPart2.copy$default$5();
                    Option x$84 = oldPart2.copy$default$6();
                    catalogTablePartitionArray2[1] = oldPart2.copy(x$80, x$79, x$81, x$82, x$83, x$84);
                    catalog.alterPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])catalogTablePartitionArray2)));
                    CatalogTablePartition newPart1b = catalog.getPartition("db2", "tbl2", this.$outer.utils().part1().spec());
                    CatalogTablePartition newPart2b = catalog.getPartition("db2", "tbl2", this.$outer.utils().part2().spec());
                    Option $org_scalatest_assert_macro_left5 = newPart1b.storage().serde();
                    Some $org_scalatest_assert_macro_right5 = new Some((Object)newSerde);
                    Option option5 = $org_scalatest_assert_macro_left5;
                    Some some5 = $org_scalatest_assert_macro_right5;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option5 != null ? !option5.equals(some5) : some5 != null), Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
                    Map $org_scalatest_assert_macro_left6 = newPart2b.storage().properties();
                    Map $org_scalatest_assert_macro_right6 = newSerdeProps;
                    Map map = $org_scalatest_assert_macro_left6;
                    Map map2 = $org_scalatest_assert_macro_right6;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(map != null ? !map.equals(map2) : map2 != null), Prettifier$.MODULE$.default());
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 654));
                    CatalogTablePartition badPart1 = this.$outer.utils().part1().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"v1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"v2")})), this.$outer.utils().part1().copy$default$2(), this.$outer.utils().part1().copy$default$3(), this.$outer.utils().part1().copy$default$4(), this.$outer.utils().part1().copy$default$5(), this.$outer.utils().part1().copy$default$6());
                    CatalogTablePartition badPart2 = this.$outer.utils().part2().copy((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"v3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"v4")})), this.$outer.utils().part2().copy$default$2(), this.$outer.utils().part2().copy$default$3(), this.$outer.utils().part2().copy$default$4(), this.$outer.utils().part2().copy$default$5(), this.$outer.utils().part2().copy$default$6());
                    object = this.$outer.intercept((Function0)new Serializable(this, catalog, badPart1, badPart2){
                        public static final long serialVersionUID = 0L;
                        private final ExternalCatalog catalog$20;
                        private final CatalogTablePartition badPart1$1;
                        private final CatalogTablePartition badPart2$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.catalog$20.alterPartitions("db2", "tbl2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.badPart1$1, this.badPart2$1})));
                        }
                        {
                            this.catalog$20 = catalog$20;
                            this.badPart1$1 = badPart1$1;
                            this.badPart2$1 = badPart2$1;
                        }
                    }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 658));
                }
                catch (Throwable throwable) {
                    void var1_1;
                    var1_1.setCurrentDatabase("default");
                    throw throwable;
                }
                catalog.setCurrentDatabase("default");
                return object;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 628));
        this.test("alter partitions when database/table does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final AnalysisException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$49 $outer;
                    private final ExternalCatalog catalog$21;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$21.alterPartitions("does_not_exist", "tbl1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$21 = catalog$21;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 669));
                return (AnalysisException)((Object)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$49 $outer;
                    private final ExternalCatalog catalog$21;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$21.alterPartitions("db2", "does_not_exist", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().part1()})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$21 = catalog$21;
                    }
                }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 672)));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
        this.test("basic create and list functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newEmptyCatalog();
                catalog.createDatabase(this.$outer.utils().newDb("mydb"), false);
                catalog.createFunction("mydb", this.$outer.utils().newFunc("myfunc", this.$outer.utils().newFunc$default$2()));
                Set $org_scalatest_assert_macro_left = catalog.listFunctions("mydb", "*").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"myfunc"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 681));
        this.test("create function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final NoSuchDatabaseException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                return (NoSuchDatabaseException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$51 $outer;
                    private final ExternalCatalog catalog$22;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$22.createFunction("does_not_exist", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newFunc());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$22 = catalog$22;
                    }
                }, ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
        this.test("create function that already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final FunctionAlreadyExistsException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                return (FunctionAlreadyExistsException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$52 $outer;
                    private final ExternalCatalog catalog$23;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$23.createFunction("db2", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newFunc("func1", this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer().utils().newFunc$default$2()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.catalog$23 = catalog$23;
                    }
                }, ClassTag$.MODULE$.apply(FunctionAlreadyExistsException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 697));
            }

            public /* synthetic */ ExternalCatalogSuite org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
        this.test("drop function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                Set $org_scalatest_assert_macro_left = catalog.listFunctions("db2", "*").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"func1"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 704));
                catalog.dropFunction("db2", "func1");
                Seq $org_scalatest_assert_macro_left2 = catalog.listFunctions("db2", "*");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 706));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 702));
        this.test("drop function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final NoSuchDatabaseException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                return (NoSuchDatabaseException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$24;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$24.dropFunction("does_not_exist", "something");
                    }
                    {
                        this.catalog$24 = catalog$24;
                    }
                }, ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 711));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
        this.test("drop function that does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final NoSuchFunctionException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                return (NoSuchFunctionException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$25;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$25.dropFunction("db2", "does_not_exist");
                    }
                    {
                        this.catalog$25 = catalog$25;
                    }
                }, ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 718));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 716));
        this.test("get function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final NoSuchFunctionException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogFunction $org_scalatest_assert_macro_left = catalog.getFunction("db2", "func1");
                CatalogFunction $org_scalatest_assert_macro_right = new CatalogFunction(new FunctionIdentifier("func1", (Option)new Some((Object)"db2")), this.$outer.utils().funcClass(), (Seq)Seq$.MODULE$.empty());
                CatalogFunction catalogFunction = $org_scalatest_assert_macro_left;
                CatalogFunction catalogFunction2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(catalogFunction != null ? !catalogFunction.equals(catalogFunction2) : catalogFunction2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 725));
                return (NoSuchFunctionException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$26;

                    public final CatalogFunction apply() {
                        return this.catalog$26.getFunction("db2", "does_not_exist");
                    }
                    {
                        this.catalog$26 = catalog$26;
                    }
                }, ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 728));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
        this.test("get function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final NoSuchDatabaseException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                return (NoSuchDatabaseException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$27;

                    public final CatalogFunction apply() {
                        return this.catalog$27.getFunction("does_not_exist", "func1");
                    }
                    {
                        this.catalog$27 = catalog$27;
                    }
                }, ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 735));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 733));
        this.test("rename function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final NoSuchFunctionException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                String newName = "funcky";
                String $org_scalatest_assert_macro_left = catalog.getFunction("db2", "func1").className();
                String $org_scalatest_assert_macro_right = this.$outer.utils().funcClass();
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
                catalog.renameFunction("db2", "func1", newName);
                this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$28;

                    public final CatalogFunction apply() {
                        return this.catalog$28.getFunction("db2", "func1");
                    }
                    {
                        this.catalog$28 = catalog$28;
                    }
                }, ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 745));
                String $org_scalatest_assert_macro_left2 = catalog.getFunction("db2", newName).identifier().funcName();
                String $org_scalatest_assert_macro_right2 = newName;
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 746));
                String $org_scalatest_assert_macro_left3 = catalog.getFunction("db2", newName).className();
                String $org_scalatest_assert_macro_right3 = this.$outer.utils().funcClass();
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 747));
                return (NoSuchFunctionException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$28;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$28.renameFunction("db2", "does_not_exist", "me");
                    }
                    {
                        this.catalog$28 = catalog$28;
                    }
                }, ClassTag$.MODULE$.apply(NoSuchFunctionException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 748));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 740));
        this.test("rename function when database does not exist", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final NoSuchDatabaseException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                return (NoSuchDatabaseException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$29;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$29.renameFunction("does_not_exist", "func1", "func5");
                    }
                    {
                        this.catalog$29 = catalog$29;
                    }
                }, ClassTag$.MODULE$.apply(NoSuchDatabaseException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 753));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 751));
        this.test("rename function when new function already exists", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final FunctionAlreadyExistsException apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                catalog.createFunction("db2", this.$outer.utils().newFunc("func2", (Option<String>)new Some((Object)"db2")));
                return (FunctionAlreadyExistsException)this.$outer.intercept((Function0)new Serializable(this, catalog){
                    public static final long serialVersionUID = 0L;
                    private final ExternalCatalog catalog$30;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.catalog$30.renameFunction("db2", "func1", "func2");
                    }
                    {
                        this.catalog$30 = catalog$30;
                    }
                }, ClassTag$.MODULE$.apply(FunctionAlreadyExistsException.class), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 761));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 758));
        this.test("alter function", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                String $org_scalatest_assert_macro_left = catalog.getFunction("db2", "func1").className();
                String $org_scalatest_assert_macro_right = this.$outer.utils().funcClass();
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 768));
                CatalogFunction qual$2 = catalog.getFunction("db2", "func1");
                String x$85 = this.$outer.utils().newFuncClass();
                FunctionIdentifier x$86 = qual$2.copy$default$1();
                Seq x$87 = qual$2.copy$default$3();
                CatalogFunction myNewFunc = qual$2.copy(x$86, x$85, x$87);
                catalog.alterFunction("db2", myNewFunc);
                String $org_scalatest_assert_macro_left2 = catalog.getFunction("db2", "func1").className();
                String $org_scalatest_assert_macro_right2 = this.$outer.utils().newFuncClass();
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 771));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 766));
        this.test("list functions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                catalog.createFunction("db2", this.$outer.utils().newFunc("func2", this.$outer.utils().newFunc$default$2()));
                catalog.createFunction("db2", this.$outer.utils().newFunc("not_me", this.$outer.utils().newFunc$default$2()));
                Set $org_scalatest_assert_macro_left = catalog.listFunctions("db2", "*").toSet();
                Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"func1", "func2", "not_me"}));
                Set set = $org_scalatest_assert_macro_left;
                Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
                Set $org_scalatest_assert_macro_left2 = catalog.listFunctions("db2", "func*").toSet();
                Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"func1", "func2"}));
                Set set3 = $org_scalatest_assert_macro_left2;
                Set set4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 774));
        this.test("create/drop database should create/delete the directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogDatabase db = this.$outer.utils().newDb("mydb");
                catalog.createDatabase(db, false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "ExternalCatalogSuite.this.exists(db.locationUri)", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 798));
                catalog.dropDatabase("mydb", false, false);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])), "ExternalCatalogSuite.this.exists(db.locationUri)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 801));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 794));
        this.test("create/drop/rename table should create/delete/rename the directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogDatabase db = catalog.getDatabase("db1");
                CatalogTable table = new CatalogTable(new TableIdentifier("my_table", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("a", "int").add("b", "string"), (Option)new Some((Object)this.$outer.utils().defaultProvider()), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
                catalog.createTable(table, false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"my_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"my_table\")", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
                catalog.renameTable("db1", "my_table", "your_table");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"my_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"my_table\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 819));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"your_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"your_table\")", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 820));
                catalog.dropTable("db1", "your_table", false, false);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"your_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"your_table\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 823));
                CatalogTable externalTable = new CatalogTable(new TableIdentifier("external_table", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.EXTERNAL(), new CatalogStorageFormat((Option)new Some((Object)Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toURI()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty()), new StructType().add("a", "int").add("b", "string"), (Option)new Some((Object)this.$outer.utils().defaultProvider()), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
                catalog.createTable(externalTable, false);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(db.locationUri(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"external_table"})), "ExternalCatalogSuite.this.exists(db.locationUri, \"external_table\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 835));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 804));
        this.test("create/drop/rename partitions should create/delete/rename the directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                CatalogTable table = new CatalogTable(new TableIdentifier("tbl", (Option)new Some((Object)"db1")), CatalogTableType$.MODULE$.MANAGED(), CatalogStorageFormat$.MODULE$.empty(), new StructType().add("col1", "int").add("col2", "string").add("partCol1", "int").add("partCol2", "string"), (Option)new Some((Object)this.$outer.utils().defaultProvider()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1", "partCol2"})), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
                catalog.createTable(table, false);
                URI tableLocation = catalog.getTable("db1", "tbl").location();
                CatalogTablePartition part1 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"2")})), this.$outer.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                CatalogTablePartition part2 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"4")})), this.$outer.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                CatalogTablePartition part3 = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"5"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"6")})), this.$outer.utils().storageFormat(), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                catalog.createPartitions("db1", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{part1, part2})), false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(tableLocation, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=1", "partCol2=2"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=1\", \"partCol2=2\")", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 860));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(tableLocation, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=3", "partCol2=4"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=3\", \"partCol2=4\")", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 861));
                catalog.renamePartitions("db1", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{part1.spec()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{part3.spec()})));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(tableLocation, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=1", "partCol2=2"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=1\", \"partCol2=2\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 864));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(tableLocation, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=5", "partCol2=6"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=5\", \"partCol2=6\")", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 865));
                catalog.dropPartitions("db1", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{part2.spec(), part3.spec()})), false, false, false);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(tableLocation, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=3", "partCol2=4"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=3\", \"partCol2=4\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 869));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$catalog$ExternalCatalogSuite$$exists(tableLocation, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partCol1=5", "partCol2=6"})), "ExternalCatalogSuite.this.exists(tableLocation, \"partCol1=5\", \"partCol2=6\")", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 870));
                File tempPath = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
                CatalogTablePartition partWithExistingDir = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"7"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"8")})), new CatalogStorageFormat((Option)new Some((Object)tempPath.toURI()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty()), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                catalog.createPartitions("db1", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{partWithExistingDir})), false);
                tempPath.delete();
                CatalogTablePartition partWithNonExistingDir = new CatalogTablePartition((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol1"), (Object)"9"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partCol2"), (Object)"10")})), new CatalogStorageFormat((Option)new Some((Object)tempPath.toURI()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false, Predef$.MODULE$.Map().empty()), CatalogTablePartition$.MODULE$.apply$default$3(), CatalogTablePartition$.MODULE$.apply$default$4(), CatalogTablePartition$.MODULE$.apply$default$5(), CatalogTablePartition$.MODULE$.apply$default$6());
                catalog.createPartitions("db1", "tbl", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{partWithNonExistingDir})), false);
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(tempPath.exists(), "tempPath.exists()", Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 889));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 838));
        this.test("drop partition from external table should not delete the directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExternalCatalogSuite $outer;

            public final Assertion apply() {
                ExternalCatalog catalog = this.$outer.utils().newBasicCatalog();
                catalog.createPartitions("db2", "tbl1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{this.$outer.utils().part1()})), false);
                Path partPath = new Path(catalog.getPartition("db2", "tbl1", this.$outer.utils().part1().spec()).location());
                FileSystem fs = partPath.getFileSystem(new Configuration());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(fs.exists(partPath), "fs.exists(partPath)", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 898));
                catalog.dropPartitions("db2", "tbl1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{this.$outer.utils().part1().spec()})), false, false, false);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(fs.exists(partPath), "fs.exists(partPath)", Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 902));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExternalCatalogSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 892));
    }
}

