/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.jetty.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.spark_project.jetty.io.AbstractByteBufferPool;
import org.spark_project.jetty.io.ByteBufferPool;
import org.spark_project.jetty.util.BufferUtil;
import org.spark_project.jetty.util.annotation.ManagedAttribute;
import org.spark_project.jetty.util.annotation.ManagedObject;
import org.spark_project.jetty.util.component.Dumpable;
import org.spark_project.jetty.util.component.DumpableCollection;
import org.spark_project.jetty.util.log.Log;
import org.spark_project.jetty.util.log.Logger;

@ManagedObject
public class ArrayByteBufferPool
extends AbstractByteBufferPool
implements Dumpable {
    private static final Logger LOG = Log.getLogger(ArrayByteBufferPool.class);
    private final int _maxCapacity;
    private final int _minCapacity;
    private final ByteBufferPool.Bucket[] _direct;
    private final ByteBufferPool.Bucket[] _indirect;
    private boolean _detailedDump = false;

    public ArrayByteBufferPool() {
        this(-1, -1, -1);
    }

    public ArrayByteBufferPool(int minCapacity, int factor, int maxCapacity) {
        this(minCapacity, factor, maxCapacity, -1, 0L, 0L);
    }

    public ArrayByteBufferPool(int minCapacity, int factor, int maxCapacity, int maxQueueLength) {
        this(minCapacity, factor, maxCapacity, maxQueueLength, 0L, 0L);
    }

    public ArrayByteBufferPool(int minCapacity, int factor, int maxCapacity, int maxQueueLength, long maxHeapMemory, long maxDirectMemory) {
        super(factor, maxQueueLength, maxHeapMemory, maxDirectMemory);
        factor = this.getCapacityFactor();
        if (minCapacity <= 0) {
            minCapacity = 0;
        }
        if (maxCapacity <= 0) {
            maxCapacity = 65536;
        }
        if (maxCapacity % factor != 0 || factor >= maxCapacity) {
            throw new IllegalArgumentException("The capacity factor must be a divisor of maxCapacity");
        }
        this._maxCapacity = maxCapacity;
        this._minCapacity = minCapacity;
        int length = this.bucketFor(maxCapacity) + 1;
        this._direct = new ByteBufferPool.Bucket[length];
        this._indirect = new ByteBufferPool.Bucket[length];
        for (int i = 0; i < length; ++i) {
            this._direct[i] = this.newBucket(i, true);
            this._indirect[i] = this.newBucket(i, false);
        }
    }

    @Override
    public ByteBuffer acquire(int size, boolean direct2) {
        int capacity = size < this._minCapacity ? size : this.capacityFor(this.bucketFor(size));
        ByteBufferPool.Bucket bucket = this.bucketFor(size, direct2);
        if (bucket == null) {
            return this.newByteBuffer(capacity, direct2);
        }
        ByteBuffer buffer = bucket.acquire();
        if (buffer == null) {
            return this.newByteBuffer(capacity, direct2);
        }
        return buffer;
    }

    @Override
    public void release(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        int capacity = buffer.capacity();
        if (capacity != this.capacityFor(this.bucketFor(capacity))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ByteBuffer {} does not belong to this pool, discarding it", BufferUtil.toDetailString(buffer));
            }
            return;
        }
        if (capacity > this._maxCapacity) {
            return;
        }
        boolean direct2 = buffer.isDirect();
        ByteBufferPool.Bucket bucket = this.bucketFor(capacity, direct2);
        if (bucket != null) {
            bucket.release(buffer);
            this.releaseExcessMemory(direct2, this::releaseMemory);
        }
    }

    private ByteBufferPool.Bucket newBucket(int key, boolean direct2) {
        return new ByteBufferPool.Bucket(this, this.capacityFor(key), this.getMaxQueueLength(), this.updateMemory(direct2));
    }

    @Override
    public void clear() {
        super.clear();
        for (int i = 0; i < this._direct.length; ++i) {
            this._direct[i].clear();
            this._indirect[i].clear();
        }
    }

    protected void releaseMemory(boolean direct2) {
        long oldest = Long.MAX_VALUE;
        int index = -1;
        ByteBufferPool.Bucket[] buckets = this.bucketsFor(direct2);
        for (int i = 0; i < buckets.length; ++i) {
            long lastUpdate;
            ByteBufferPool.Bucket bucket = buckets[i];
            if (bucket.isEmpty() || (lastUpdate = bucket.getLastUpdate()) >= oldest) continue;
            oldest = lastUpdate;
            index = i;
        }
        if (index >= 0) {
            ByteBufferPool.Bucket bucket = buckets[index];
            bucket.clear();
        }
    }

    protected int bucketFor(int capacity) {
        return (int)Math.ceil((double)capacity / (double)this.getCapacityFactor());
    }

    protected int capacityFor(int bucket) {
        return bucket * this.getCapacityFactor();
    }

    private ByteBufferPool.Bucket bucketFor(int capacity, boolean direct2) {
        if (capacity < this._minCapacity) {
            return null;
        }
        int bucket = this.bucketFor(capacity);
        if (bucket >= this._direct.length) {
            return null;
        }
        ByteBufferPool.Bucket[] buckets = this.bucketsFor(direct2);
        return buckets[bucket];
    }

    @ManagedAttribute(value="The number of pooled direct ByteBuffers")
    public long getDirectByteBufferCount() {
        return this.getByteBufferCount(true);
    }

    @ManagedAttribute(value="The number of pooled heap ByteBuffers")
    public long getHeapByteBufferCount() {
        return this.getByteBufferCount(false);
    }

    private long getByteBufferCount(boolean direct2) {
        return Arrays.stream(this.bucketsFor(direct2)).filter(Objects::nonNull).mapToLong(ByteBufferPool.Bucket::size).sum();
    }

    ByteBufferPool.Bucket[] bucketsFor(boolean direct2) {
        return direct2 ? this._direct : this._indirect;
    }

    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    public void setDetailedDump(boolean detailedDump) {
        this._detailedDump = detailedDump;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        ArrayList<Object> dump = new ArrayList<Object>();
        dump.add(String.format("HeapMemory: %d/%d", this.getHeapMemory(), this.getMaxHeapMemory()));
        dump.add(String.format("DirectMemory: %d/%d", this.getDirectMemory(), this.getMaxDirectMemory()));
        List indirect = Arrays.stream(this._indirect).filter(b -> !b.isEmpty()).collect(Collectors.toList());
        List direct2 = Arrays.stream(this._direct).filter(b -> !b.isEmpty()).collect(Collectors.toList());
        if (this.isDetailedDump()) {
            dump.add(new DumpableCollection("Indirect Buckets", indirect));
            dump.add(new DumpableCollection("Direct Buckets", direct2));
        } else {
            dump.add("Indirect Buckets size=" + indirect.size());
            dump.add("Direct Buckets size=" + direct2.size());
        }
        Dumpable.dumpObjects(out, indent, this, dump);
    }

    public String toString() {
        return String.format("%s@%x{minBufferCapacity=%s, maxBufferCapacity=%s, maxQueueLength=%s, factor=%s}", this.getClass().getSimpleName(), this.hashCode(), this._minCapacity, this._maxCapacity, this.getMaxQueueLength(), this.getCapacityFactor());
    }
}

