/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import java.io.CharArrayWriter;
import java.io.Writer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JSONOptions$;
import org.apache.spark.sql.catalyst.json.JacksonGenerator;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u000192A!\u0001\u0002\u0001\u001f\t)\"*Y2lg>tw)\u001a8fe\u0006$xN]*vSR,'BA\u0002\u0005\u0003\u0011Q7o\u001c8\u000b\u0005\u00151\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005A\u0011BA\n\t\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\")Q\u0003\u0001C\u0001-\u00051A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011A\u0001\u0005\b5\u0001\u0011\r\u0011\"\u0001\u001c\u0003\u00159W\u000e^%e+\u0005a\u0002CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\u0011a\u0017M\\4\u000b\u0003\u0005\nAA[1wC&\u00111E\b\u0002\u0007'R\u0014\u0018N\\4\t\r\u0015\u0002\u0001\u0015!\u0003\u001d\u0003\u00199W\u000e^%eA!9q\u0005\u0001b\u0001\n\u0003A\u0013AB8qi&|g.F\u0001*!\tA\"&\u0003\u0002,\u0005\tY!jU(O\u001fB$\u0018n\u001c8t\u0011\u0019i\u0003\u0001)A\u0005S\u00059q\u000e\u001d;j_:\u0004\u0003")
public class JacksonGeneratorSuite
extends SparkFunSuite {
    private final String gmtId = DateTimeUtils$.MODULE$.TimeZoneGMT().getID();
    private final JSONOptions option = new JSONOptions(Predef$.MODULE$.Map().empty(), this.gmtId(), JSONOptions$.MODULE$.$lessinit$greater$default$3());

    public String gmtId() {
        return this.gmtId;
    }

    public JSONOptions option() {
        return this.option;
    }

    public JacksonGeneratorSuite() {
        this.test("initial with StructType and write out a row", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonGeneratorSuite $outer;

            public final Assertion apply() {
                StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType dataType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
                InternalRow input = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                CharArrayWriter writer = new CharArrayWriter();
                JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.$outer.option());
                gen.write(input);
                gen.flush();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(writer.toString());
                String $org_scalatest_assert_macro_right = "{\"a\":1}";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("SPARK-29444: initial with StructType and write out an empty row with ignoreNullFields=false", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonGeneratorSuite $outer;

            public final Assertion apply() {
                StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType dataType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
                InternalRow input = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null}));
                CharArrayWriter writer = new CharArrayWriter();
                JSONOptions allowNullOption = new JSONOptions((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ignoreNullFields"), (Object)"false")})), this.$outer.gmtId(), JSONOptions$.MODULE$.$lessinit$greater$default$3());
                JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, allowNullOption);
                gen.write(input);
                gen.flush();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(writer.toString());
                String $org_scalatest_assert_macro_right = "{\"a\":null}";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("SPARK-29444: initial with StructType field and write out a row with ignoreNullFields=false and struct inner null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonGeneratorSuite $outer;

            public final Assertion apply() {
                StructField structField = new StructField("b", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType fieldType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
                StructField structField2 = new StructField("a", (DataType)fieldType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType dataType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2));
                InternalRow input = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null}))}));
                CharArrayWriter writer = new CharArrayWriter();
                JSONOptions allowNullOption = new JSONOptions((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ignoreNullFields"), (Object)"false")})), this.$outer.gmtId(), JSONOptions$.MODULE$.$lessinit$greater$default$3());
                JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, allowNullOption);
                gen.write(input);
                gen.flush();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(writer.toString());
                String $org_scalatest_assert_macro_right = "{\"a\":{\"b\":null}}";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
        this.test("initial with StructType and write out rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonGeneratorSuite $outer;

            public final Assertion apply() {
                StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType dataType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
                InternalRow internalRow = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                InternalRow internalRow2 = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2)}));
                GenericArrayData input = new GenericArrayData((Seq)Nil$.MODULE$.$colon$colon((Object)internalRow2).$colon$colon((Object)internalRow));
                CharArrayWriter writer = new CharArrayWriter();
                JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.$outer.option());
                gen.write((ArrayData)input);
                gen.flush();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(writer.toString());
                String $org_scalatest_assert_macro_right = "[{\"a\":1},{\"a\":2}]";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("initial with StructType and write out an array with single empty row", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonGeneratorSuite $outer;

            public final Assertion apply() {
                StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType dataType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
                InternalRow internalRow = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null}));
                GenericArrayData input = new GenericArrayData((Seq)Nil$.MODULE$.$colon$colon((Object)internalRow));
                CharArrayWriter writer = new CharArrayWriter();
                JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.$outer.option());
                gen.write((ArrayData)input);
                gen.flush();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(writer.toString());
                String $org_scalatest_assert_macro_right = "[{}]";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("initial with StructType and write out an empty array", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonGeneratorSuite $outer;

            public final Assertion apply() {
                StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType dataType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
                GenericArrayData input = new GenericArrayData((Seq)Nil$.MODULE$);
                CharArrayWriter writer = new CharArrayWriter();
                JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.$outer.option());
                gen.write((ArrayData)input);
                gen.flush();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(writer.toString());
                String $org_scalatest_assert_macro_right = "[]";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("initial with Map and write out a map data", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonGeneratorSuite $outer;

            public final Assertion apply() {
                MapType dataType = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$);
                ArrayBasedMapData input = ArrayBasedMapData$.MODULE$.apply((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))})), ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3());
                CharArrayWriter writer = new CharArrayWriter();
                JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.$outer.option());
                gen.write((MapData)input);
                gen.flush();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(writer.toString());
                String $org_scalatest_assert_macro_right = "{\"a\":1}";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("initial with Map and write out an array of maps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonGeneratorSuite $outer;

            public final Assertion apply() {
                MapType dataType = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$);
                ArrayBasedMapData arrayBasedMapData = ArrayBasedMapData$.MODULE$.apply((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))})), ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3());
                ArrayBasedMapData arrayBasedMapData2 = ArrayBasedMapData$.MODULE$.apply((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2))})), ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3());
                GenericArrayData input = new GenericArrayData((Seq)Nil$.MODULE$.$colon$colon((Object)arrayBasedMapData2).$colon$colon((Object)arrayBasedMapData));
                CharArrayWriter writer = new CharArrayWriter();
                JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.$outer.option());
                gen.write((ArrayData)input);
                gen.flush();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(writer.toString());
                String $org_scalatest_assert_macro_right = "[{\"a\":1},{\"b\":2}]";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
        this.test("error handling: initial with StructType but error calling write a map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonGeneratorSuite $outer;

            public final UnsupportedOperationException apply() {
                StructField structField = new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                StructType dataType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField));
                ArrayBasedMapData input = ArrayBasedMapData$.MODULE$.apply((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1))})), ArrayBasedMapData$.MODULE$.apply$default$2(), ArrayBasedMapData$.MODULE$.apply$default$3());
                CharArrayWriter writer = new CharArrayWriter();
                JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.$outer.option());
                return (UnsupportedOperationException)this.$outer.intercept((Function0)new Serializable(this, input, gen){
                    public static final long serialVersionUID = 0L;
                    private final ArrayBasedMapData input$1;
                    private final JacksonGenerator gen$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.gen$1.write((MapData)this.input$1);
                    }
                    {
                        this.input$1 = input$1;
                        this.gen$1 = gen$1;
                    }
                }, ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        this.test("error handling: initial with MapType and write out a row", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JacksonGeneratorSuite $outer;

            public final UnsupportedOperationException apply() {
                MapType dataType = MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$);
                InternalRow input = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)}));
                CharArrayWriter writer = new CharArrayWriter();
                JacksonGenerator gen = new JacksonGenerator((DataType)dataType, (Writer)writer, this.$outer.option());
                return (UnsupportedOperationException)this.$outer.intercept((Function0)new Serializable(this, input, gen){
                    public static final long serialVersionUID = 0L;
                    private final InternalRow input$2;
                    private final JacksonGenerator gen$2;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.gen$2.write(this.input$2);
                    }
                    {
                        this.input$2 = input$2;
                        this.gen$2 = gen$2;
                    }
                }, ClassTag$.MODULE$.apply(UnsupportedOperationException.class), new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("JacksonGeneratorSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
    }
}

