/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.util.Random;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.CreateArray;
import org.apache.spark.sql.catalyst.expressions.DecimalLiteral$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentileSuite$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentileSuite$$anonfun$2$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentileSuite$$anonfun$9$;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.util.SizeEstimator$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001#\tQ\u0012\t\u001d9s_bLW.\u0019;f!\u0016\u00148-\u001a8uS2,7+^5uK*\u00111\u0001B\u0001\nC\u001e<'/Z4bi\u0016T!!\u0002\u0004\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000f!\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\u000b\u000e\u0003)I!!\u0006\u0006\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t!\u0001C\u0004\u001d\u0001\t\u0007I\u0011B\u000f\u0002\rI\fg\u000eZ8n+\u0005q\u0002CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u0011)H/\u001b7\u000b\u0003\r\nAA[1wC&\u0011Q\u0005\t\u0002\u0007%\u0006tGm\\7\t\r\u001d\u0002\u0001\u0015!\u0003\u001f\u0003\u001d\u0011\u0018M\u001c3p[\u0002Bq!\u000b\u0001C\u0002\u0013%!&\u0001\u0003eCR\fW#A\u0016\u0011\u00071\u001aT'D\u0001.\u0015\tqs&A\u0005j[6,H/\u00192mK*\u0011\u0001'M\u0001\u000bG>dG.Z2uS>t'\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Qj#AC%oI\u0016DX\rZ*fcB\u0011agN\u0007\u0002c%\u0011\u0001(\r\u0002\u0004\u0013:$\bB\u0002\u001e\u0001A\u0003%1&A\u0003eCR\f\u0007\u0005C\u0003=\u0001\u0011%Q(A\u0007d_6\u0004\u0018M]3FcV\fGn\u001d\u000b\u0004}\u0005[\u0006C\u0001\u001c@\u0013\t\u0001\u0015GA\u0004C_>dW-\u00198\t\u000b\t[\u0004\u0019A\"\u0002\t1,g\r\u001e\t\u0003\tbs!!\u0012,\u000f\u0005\u0019+fBA$U\u001d\tA5K\u0004\u0002J%:\u0011!*\u0015\b\u0003\u0017Bs!\u0001T(\u000e\u00035S!A\u0014\t\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011BA\u0007\u000f\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\n\u0005]\u0013\u0011!F!qaJ|\u00070[7bi\u0016\u0004VM]2f]RLG.Z\u0005\u00033j\u0013\u0001\u0003U3sG\u0016tG/\u001b7f\t&<Wm\u001d;\u000b\u0005]\u0013\u0001\"\u0002/<\u0001\u0004\u0019\u0015!\u0002:jO\"$\b\"\u00020\u0001\t\u0013y\u0016aC1tg\u0016\u0014H/R9vC2,\"\u0001Y4\u0015\u0007\u0005$\u0007\u000f\u0005\u00027E&\u00111-\r\u0002\u0005+:LG\u000fC\u0003C;\u0002\u0007Q\r\u0005\u0002gO2\u0001A!\u00025^\u0005\u0004I'!\u0001+\u0012\u0005)l\u0007C\u0001\u001cl\u0013\ta\u0017GA\u0004O_RD\u0017N\\4\u0011\u0005Yr\u0017BA82\u0005\r\te.\u001f\u0005\u00069v\u0003\r!\u001a")
public class ApproximatePercentileSuite
extends SparkFunSuite {
    private final Random org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$random = new Random();
    private final IndexedSeq<Object> org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$data = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10000).map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;
        private final /* synthetic */ ApproximatePercentileSuite $outer;

        public final int apply(int x$1) {
            return this.apply$mcII$sp(x$1);
        }

        public int apply$mcII$sp(int x$1) {
            return this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$random().nextInt(10000);
        }
        {
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }, IndexedSeq$.MODULE$.canBuildFrom());

    public Random org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$random() {
        return this.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$random;
    }

    public IndexedSeq<Object> org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$data() {
        return this.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$data;
    }

    public boolean org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$compareEquals(ApproximatePercentile.PercentileDigest left, ApproximatePercentile.PercentileDigest right) {
        QuantileSummaries leftSummary = left.quantileSummaries();
        QuantileSummaries rightSummary = right.quantileSummaries();
        return leftSummary.compressThreshold() == rightSummary.compressThreshold() && leftSummary.relativeError() == rightSummary.relativeError() && leftSummary.count() == rightSummary.count() && Predef$.MODULE$.refArrayOps((Object[])leftSummary.sampled()).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])rightSummary.sampled()));
    }

    public <T> void org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$assertEqual(T left, T right) {
        T $org_scalatest_assert_macro_right;
        T $org_scalatest_assert_macro_left;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, BoxesRunTime.equals($org_scalatest_assert_macro_left = left, $org_scalatest_assert_macro_right = right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
    }

    public ApproximatePercentileSuite() {
        this.test("serialize and de-serialize", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ApproximatePercentileSuite $outer;

            public final Assertion apply() {
                ApproximatePercentile.PercentileDigestSerializer serializer = new ApproximatePercentile.PercentileDigestSerializer();
                ApproximatePercentile.PercentileDigest emptyBuffer = new ApproximatePercentile.PercentileDigest(0.01);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$compareEquals(emptyBuffer, serializer.deserialize(serializer.serialize(emptyBuffer))), "ApproximatePercentileSuite.this.compareEquals(emptyBuffer, serializer.deserialize(serializer.serialize(emptyBuffer)))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
                ApproximatePercentile.PercentileDigest buffer = new ApproximatePercentile.PercentileDigest(0.01);
                this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$data().foreach((Function1)new Serializable(this, buffer){
                    public static final long serialVersionUID = 0L;
                    private final ApproximatePercentile.PercentileDigest buffer$1;

                    public final void apply(int value) {
                        this.apply$mcVI$sp(value);
                    }

                    public void apply$mcVI$sp(int value) {
                        this.buffer$1.add((double)value);
                    }
                    {
                        this.buffer$1 = buffer$1;
                    }
                });
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$compareEquals(buffer, serializer.deserialize(serializer.serialize(buffer))), "ApproximatePercentileSuite.this.compareEquals(buffer, serializer.deserialize(serializer.serialize(buffer)))", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
                ApproximatePercentile agg = new ApproximatePercentile((Expression)new BoundReference(0, (DataType)DoubleType$.MODULE$, true), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$compareEquals(agg.deserialize(agg.serialize(buffer)), buffer), "ApproximatePercentileSuite.this.compareEquals(agg.deserialize(agg.serialize(buffer)), buffer)", Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("class PercentileDigest, basic operations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ApproximatePercentileSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int valueCount = 10000;
                double[] percentages = new double[]{0.25, 0.5, 0.75};
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0E-4, 0.001, 0.01, 0.1}))).foreach((Function1)new Serializable(this, valueCount, percentages){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    public final int valueCount$1;
                    private final double[] percentages$1;

                    public final void apply(double relativeError) {
                        this.apply$mcVD$sp(relativeError);
                    }

                    public void apply$mcVD$sp(double relativeError) {
                        ApproximatePercentile.PercentileDigest buffer = new ApproximatePercentile.PercentileDigest(relativeError);
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.valueCount$1).grouped(10).foreach((Function1)new Serializable(this, buffer, relativeError){
                            public static final long serialVersionUID = 0L;
                            private final ApproximatePercentile.PercentileDigest buffer$2;
                            private final double relativeError$2;

                            public final void apply(IndexedSeq<Object> group) {
                                ApproximatePercentile.PercentileDigest partialBuffer = new ApproximatePercentile.PercentileDigest(this.relativeError$2);
                                group.foreach((Function1)new Serializable(this, partialBuffer){
                                    public static final long serialVersionUID = 0L;
                                    private final ApproximatePercentile.PercentileDigest partialBuffer$1;

                                    public final void apply(int x) {
                                        this.apply$mcVI$sp(x);
                                    }

                                    public void apply$mcVI$sp(int x) {
                                        this.partialBuffer$1.add((double)x);
                                    }
                                    {
                                        this.partialBuffer$1 = partialBuffer$1;
                                    }
                                });
                                this.buffer$2.merge(partialBuffer);
                            }
                            {
                                this.buffer$2 = buffer$2;
                                this.relativeError$2 = relativeError$2;
                            }
                        });
                        double[] expectedPercentiles = (double[])Predef$.MODULE$.doubleArrayOps(this.percentages$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$1 $outer;

                            public final double apply(double x$2) {
                                return this.apply$mcDD$sp(x$2);
                            }

                            public double apply$mcDD$sp(double x$2) {
                                return x$2 * (double)this.$outer.valueCount$1;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                        double[] approxPercentiles = buffer.getPercentiles(new double[]{0.25, 0.5, 0.75});
                        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(expectedPercentiles).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(approxPercentiles), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this, relativeError){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$2$$anonfun$apply$mcV$sp$1 $outer;
                            private final double relativeError$2;

                            public final Assertion apply(Tuple2<Object, Object> pair) {
                                Tuple2<Object, Object> tuple2 = pair;
                                if (tuple2 != null) {
                                    Tuple2.mcDD.sp sp2;
                                    double expected = tuple2._1$mcD$sp();
                                    double estimate = tuple2._2$mcD$sp();
                                    Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(expected, estimate);
                                    double expected2 = sp3._1$mcD$sp();
                                    double estimate2 = sp3._2$mcD$sp();
                                    double $org_scalatest_assert_macro_left = (estimate2 - expected2) / (double)this.$outer.valueCount$1;
                                    double $org_scalatest_assert_macro_right = this.relativeError$2;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<=", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left <= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                                    return this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.relativeError$2 = relativeError$2;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$2 org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.valueCount$1 = valueCount$1;
                        this.percentages$1 = percentages$1;
                    }
                });
            }

            public /* synthetic */ ApproximatePercentileSuite org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
        this.test("class PercentileDigest, makes sure the memory foot print is bounded", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ApproximatePercentileSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double relativeError = 0.01;
                long headBufferSize = SizeEstimator$.MODULE$.estimate((Object)new double[QuantileSummaries$.MODULE$.defaultHeadSize()]);
                double bufferSize = (double)SizeEstimator$.MODULE$.estimate((Object)new QuantileSummaries.Stats(0.0, 0L, 0L)) * (1.0 / relativeError) * (double)2;
                double memoryFootPrintUpperBound = ((double)headBufferSize + bufferSize) * (double)2;
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 1000, 10000, 100000, 1000000, 10000000}))).foreach((Function1)new Serializable(this, relativeError, memoryFootPrintUpperBound){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;
                    private final double relativeError$1;
                    private final double memoryFootPrintUpperBound$1;

                    public final Assertion apply(int count) {
                        ApproximatePercentile.PercentileDigest buffer = new ApproximatePercentile.PercentileDigest(this.relativeError$1);
                        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)new Serializable(this, buffer){
                            public static final long serialVersionUID = 0L;
                            private final ApproximatePercentile.PercentileDigest buffer$3;

                            public final void apply(int x$4) {
                                this.apply$mcVI$sp(x$4);
                            }

                            public void apply$mcVI$sp(int x$4) {
                                this.buffer$3.add((double)x$4);
                            }
                            {
                                this.buffer$3 = buffer$3;
                            }
                        });
                        long $org_scalatest_assert_macro_left = SizeEstimator$.MODULE$.estimate((Object)buffer);
                        double $org_scalatest_assert_macro_right = this.memoryFootPrintUpperBound$1;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), (double)$org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.relativeError$1 = relativeError$1;
                        this.memoryFootPrintUpperBound$1 = memoryFootPrintUpperBound$1;
                    }
                });
            }

            public /* synthetic */ ApproximatePercentileSuite org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
        this.test("class ApproximatePercentile, high level interface, update, merge, eval...", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ApproximatePercentileSuite $outer;

            public final Object apply() {
                int count = 10000;
                Range data = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10000).toSeq();
                double[] percentages = new double[]{0.25, 0.5, 0.75};
                int accuracy = 10000;
                double[] expectedPercentiles = (double[])Predef$.MODULE$.doubleArrayOps(percentages).map((Function1)new Serializable(this, count){
                    public static final long serialVersionUID = 0L;
                    private final int count$1;

                    public final double apply(double x$5) {
                        return this.apply$mcDD$sp(x$5);
                    }

                    public double apply$mcDD$sp(double x$5) {
                        return (double)this.count$1 * x$5;
                    }
                    {
                        this.count$1 = count$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                Cast childExpression = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, false), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3());
                CreateArray percentageExpression = new CreateArray((Seq)Predef$.MODULE$.doubleArrayOps(percentages).toSeq().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(double x$6) {
                        return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x$6));
                    }
                }, Seq$.MODULE$.canBuildFrom()));
                Literal accuracyExpression = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10000));
                ApproximatePercentile agg = new ApproximatePercentile((Expression)childExpression, (Expression)percentageExpression, (Expression)accuracyExpression);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(agg.nullable(), "agg.nullable", Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
                Range group1 = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), data.length() / 2);
                ApproximatePercentile.PercentileDigest group1Buffer = agg.createAggregationBuffer();
                group1.foreach((Function1)new Serializable(this, data, agg, group1Buffer){
                    public static final long serialVersionUID = 0L;
                    private final Range data$1;
                    private final ApproximatePercentile agg$1;
                    private final ApproximatePercentile.PercentileDigest group1Buffer$1;

                    public final ApproximatePercentile.PercentileDigest apply(int index) {
                        InternalRow input = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.data$1.apply$mcII$sp(index))}));
                        return this.agg$1.update(this.group1Buffer$1, input);
                    }
                    {
                        this.data$1 = data$1;
                        this.agg$1 = agg$1;
                        this.group1Buffer$1 = group1Buffer$1;
                    }
                });
                Range group2 = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(data.length() / 2), data.length());
                ApproximatePercentile.PercentileDigest group2Buffer = agg.createAggregationBuffer();
                group2.foreach((Function1)new Serializable(this, data, agg, group2Buffer){
                    public static final long serialVersionUID = 0L;
                    private final Range data$1;
                    private final ApproximatePercentile agg$1;
                    private final ApproximatePercentile.PercentileDigest group2Buffer$1;

                    public final ApproximatePercentile.PercentileDigest apply(int index) {
                        InternalRow input = InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.data$1.apply$mcII$sp(index))}));
                        return this.agg$1.update(this.group2Buffer$1, input);
                    }
                    {
                        this.data$1 = data$1;
                        this.agg$1 = agg$1;
                        this.group2Buffer$1 = group2Buffer$1;
                    }
                });
                ApproximatePercentile.PercentileDigest mergeBuffer = agg.createAggregationBuffer();
                agg.merge(mergeBuffer, group1Buffer);
                agg.merge(mergeBuffer, group2Buffer);
                Object object = agg.eval(mergeBuffer);
                if (object instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)object;
                    int error = count / accuracy;
                    double[] percentiles = arrayData.toDoubleArray();
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(percentiles).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(expectedPercentiles), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).forall((Function1)new Serializable(this, error){
                        public static final long serialVersionUID = 0L;
                        private final int error$1;

                        public final boolean apply(Tuple2<Object, Object> pair) {
                            return Math.abs(pair._1$mcD$sp() - pair._2$mcD$sp()) < (double)this.error$1;
                        }
                        {
                            this.error$1 = error$1;
                        }
                    }), "scala.this.Predef.refArrayOps[(Double, Double)](scala.this.Predef.doubleArrayOps(percentiles).zip[Double, Double, Array[(Double, Double)]](scala.this.Predef.wrapDoubleArray(expectedPercentiles))(scala.this.Array.canBuildFrom[(Double, Double)]((ClassTag.apply[(Double, Double)](classOf[scala.Tuple2]): scala.reflect.ClassTag[(Double, Double)])))).forall(((pair: (Double, Double)) => java.this.lang.Math.abs(pair._1.-(pair._2)).<(error)))", Prettifier$.MODULE$.default());
                    Assertion assertion = this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
                    return assertion;
                }
                throw new MatchError(object);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
        this.test("class ApproximatePercentile, low level interface, update, merge, eval...", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ApproximatePercentileSuite $outer;

            public final Assertion apply() {
                Cast childExpression = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3());
                int inputAggregationBufferOffset = 1;
                int mutableAggregationBufferOffset = 2;
                double percentage = 0.5;
                ApproximatePercentile agg = new ApproximatePercentile((Expression)childExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)percentage))).withNewInputAggBufferOffset(inputAggregationBufferOffset).withNewMutableAggBufferOffset(mutableAggregationBufferOffset);
                GenericInternalRow mutableAggBuffer = new GenericInternalRow(new Object[mutableAggregationBufferOffset + 1]);
                agg.initialize((InternalRow)mutableAggBuffer);
                int dataCount = 10;
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), dataCount).foreach$mVc$sp((Function1)new Serializable(this, agg, mutableAggBuffer){
                    public static final long serialVersionUID = 0L;
                    private final ApproximatePercentile agg$2;
                    private final GenericInternalRow mutableAggBuffer$1;

                    public final void apply(int data) {
                        this.apply$mcVI$sp(data);
                    }

                    public void apply$mcVI$sp(int data) {
                        this.agg$2.update((InternalRow)this.mutableAggBuffer$1, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)data)})));
                    }
                    {
                        this.agg$2 = agg$2;
                        this.mutableAggBuffer$1 = mutableAggBuffer$1;
                    }
                });
                agg.serializeAggregateBufferInPlace((InternalRow)mutableAggBuffer);
                byte[] serialized = mutableAggBuffer.getBinary(mutableAggregationBufferOffset);
                GenericInternalRow inputAggBuffer = new GenericInternalRow((Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, serialized}), ClassTag$.MODULE$.Any()));
                agg.initialize((InternalRow)mutableAggBuffer);
                agg.merge((InternalRow)mutableAggBuffer, (InternalRow)inputAggBuffer);
                double expectedPercentile = (double)dataCount * percentage;
                double $org_scalatest_assert_macro_left = Math.abs(BoxesRunTime.unboxToDouble((Object)agg.eval((InternalRow)mutableAggBuffer)) - expectedPercentile);
                double $org_scalatest_assert_macro_right = 0.1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), "<", (Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left < $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        this.test("class ApproximatePercentile, sql string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ApproximatePercentileSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int defaultAccuracy = ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
                this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$assertEqual(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"percentile_approx(`a`, 0.5D, ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultAccuracy)})), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5))).sql());
                this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$assertEqual(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"percentile_approx(`a`, array(0.25D, 0.5D, 0.75D), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultAccuracy)})), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)new CreateArray((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.25, 0.5, 0.75}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(double x$7) {
                        return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x$7));
                    }
                }, Seq$.MODULE$.canBuildFrom()))).sql());
                this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$assertEqual(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"percentile_approx(`a`, 0.5D, ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultAccuracy)})), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5))).sql(false));
                this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$assertEqual(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"percentile_approx(`a`, array(0.25D, 0.5D, 0.75D), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultAccuracy)})), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)new CreateArray((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.25, 0.5, 0.75}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(double x$8) {
                        return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x$8));
                    }
                }, Seq$.MODULE$.canBuildFrom()))).sql(false));
                this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$assertEqual(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"percentile_approx(DISTINCT `a`, 0.5D, ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultAccuracy)})), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5))).sql(true));
                this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$assertEqual(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"percentile_approx(DISTINCT `a`, array(0.25D, 0.5D, 0.75D), ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)defaultAccuracy)})), new ApproximatePercentile((Expression)package.expressions$.MODULE$.DslString("a").attr(), (Expression)new CreateArray((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.25, 0.5, 0.75}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(double x$9) {
                        return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x$9));
                    }
                }, Seq$.MODULE$.canBuildFrom()))).sql(true));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
        this.test("class ApproximatePercentile, fails analysis if percentage or accuracy is not a constant", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ApproximatePercentileSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String x$12 = "a";
                DoubleType$ x$13 = DoubleType$.MODULE$;
                boolean x$14 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$15 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$16 = AttributeReference$.MODULE$.apply$default$5(x$12, (DataType)x$13, x$14, x$15);
                Seq x$17 = AttributeReference$.MODULE$.apply$default$6(x$12, (DataType)x$13, x$14, x$15);
                AttributeReference attribute = new AttributeReference(x$12, (DataType)x$13, x$14, x$15, x$16, x$17);
                String x$18 = "b";
                IntegerType$ x$19 = IntegerType$.MODULE$;
                boolean x$20 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$21 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$22 = AttributeReference$.MODULE$.apply$default$5(x$18, (DataType)x$19, x$20, x$21);
                Seq x$23 = AttributeReference$.MODULE$.apply$default$6(x$18, (DataType)x$19, x$20, x$21);
                ApproximatePercentile wrongAccuracy = new ApproximatePercentile((Expression)attribute, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), (Expression)new AttributeReference(x$18, (DataType)x$19, x$20, x$21, x$22, x$23));
                this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$assertEqual(wrongAccuracy.checkInputDataTypes(), new TypeCheckResult.TypeCheckFailure("The accuracy or percentage provided must be a constant literal"));
                ApproximatePercentile wrongPercentage = new ApproximatePercentile((Expression)attribute, (Expression)attribute, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)10000)));
                this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$assertEqual(wrongPercentage.checkInputDataTypes(), new TypeCheckResult.TypeCheckFailure("The accuracy or percentage provided must be a constant literal"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        this.test("class ApproximatePercentile, fails analysis if parameters are invalid", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ApproximatePercentileSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String x$24 = "a";
                DoubleType$ x$25 = DoubleType$.MODULE$;
                boolean x$26 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$27 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$28 = AttributeReference$.MODULE$.apply$default$5(x$24, (DataType)x$25, x$26, x$27);
                Seq x$29 = AttributeReference$.MODULE$.apply$default$6(x$24, (DataType)x$25, x$26, x$27);
                ApproximatePercentile wrongAccuracy = new ApproximatePercentile((Expression)new AttributeReference(x$24, (DataType)x$25, x$26, x$27, x$28, x$29), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)-1)));
                this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$assertEqual(wrongAccuracy.checkInputDataTypes(), new TypeCheckResult.TypeCheckFailure("The accuracy provided must be a positive integer literal (current value = -1)"));
                Seq correctPercentageExpresions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.0)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.0)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), new CreateArray((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0, 0.5}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(double x$10) {
                        return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x$10));
                    }
                }, Seq$.MODULE$.canBuildFrom()))}));
                correctPercentageExpresions.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TypeCheckResult apply(Expression percentageExpression) {
                        String x$30 = "a";
                        DoubleType$ x$31 = DoubleType$.MODULE$;
                        boolean x$32 = AttributeReference$.MODULE$.apply$default$3();
                        Metadata x$33 = AttributeReference$.MODULE$.apply$default$4();
                        ExprId x$34 = AttributeReference$.MODULE$.apply$default$5(x$30, (DataType)x$31, x$32, x$33);
                        Seq x$35 = AttributeReference$.MODULE$.apply$default$6(x$30, (DataType)x$31, x$32, x$33);
                        ApproximatePercentile correctPercentage = new ApproximatePercentile((Expression)new AttributeReference(x$30, (DataType)x$31, x$32, x$33, x$34, x$35), percentageExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)));
                        return correctPercentage.checkInputDataTypes();
                    }
                });
                Seq wrongPercentageExpressions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)1.1)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)-0.5)), new CreateArray((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.5, 1.1}))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Literal apply(double x$11) {
                        return Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)x$11));
                    }
                }, Seq$.MODULE$.canBuildFrom()))}));
                wrongPercentageExpressions.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final Assertion apply(Expression percentageExpression) {
                        TypeCheckResult.TypeCheckFailure typeCheckFailure;
                        String msg;
                        Seq x$41;
                        ExprId x$40;
                        Metadata x$39;
                        String x$36 = "a";
                        DoubleType$ x$37 = DoubleType$.MODULE$;
                        boolean x$38 = AttributeReference$.MODULE$.apply$default$3();
                        ApproximatePercentile wrongPercentage = new ApproximatePercentile((Expression)new AttributeReference(x$36, (DataType)x$37, x$38, x$39 = AttributeReference$.MODULE$.apply$default$4(), x$40 = AttributeReference$.MODULE$.apply$default$5(x$36, (DataType)x$37, x$38, x$39), x$41 = AttributeReference$.MODULE$.apply$default$6(x$36, (DataType)x$37, x$38, x$39)), percentageExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)100)));
                        TypeCheckResult typeCheckResult = wrongPercentage.checkInputDataTypes();
                        boolean bl = typeCheckResult instanceof TypeCheckResult.TypeCheckFailure && (msg = (typeCheckFailure = (TypeCheckResult.TypeCheckFailure)typeCheckResult).message()).contains("must be between 0.0 and 1.0");
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(bl, "wrongPercentage.checkInputDataTypes() match {\n  case (message: String)org.apache.spark.sql.catalyst.analysis.TypeCheckResult.TypeCheckFailure((msg @ _)) if msg.contains(\"must be between 0.0 and 1.0\") => true\n  case _ => false\n}", Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ApproximatePercentileSuite org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("class ApproximatePercentile, automatically add type casting for parameters", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ApproximatePercentileSuite $outer;
            private static Symbol symbol$1;

            static {
                symbol$1 = Symbol$.MODULE$.apply("a");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LocalRelation testRelation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol(symbol$1).int()}));
                Seq accuracyExpressions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)1000L)), DecimalLiteral$.MODULE$.apply(10000L), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)123.0))}));
                Seq percentageExpressions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.3f)), DecimalLiteral$.MODULE$.apply(0.5), new CreateArray((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)0.3f)), Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)), DecimalLiteral$.MODULE$.apply(0.7)})))}));
                accuracyExpressions.foreach((Function1)new Serializable(this, testRelation, percentageExpressions){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;
                    public final LocalRelation testRelation$1;
                    private final Seq percentageExpressions$1;

                    public final void apply(Literal accuracyExpression) {
                        this.percentageExpressions$1.foreach((Function1)new Serializable(this, accuracyExpression){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$9$$anonfun$apply$mcV$sp$8 $outer;
                            private final Literal accuracyExpression$1;

                            public final Assertion apply(Expression percentageExpression) {
                                Alias alias;
                                Expression agg;
                                ApproximatePercentile agg2 = new ApproximatePercentile((Expression)UnresolvedAttribute$.MODULE$.apply("a"), percentageExpression, (Expression)this.accuracyExpression$1);
                                Expression analyzed = (Expression)package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.$outer.testRelation$1).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{agg2}))).analyze().expressions().head();
                                Expression expression = analyzed;
                                if (expression instanceof Alias && (agg = (alias = (Alias)expression).child()) instanceof ApproximatePercentile) {
                                    Bool bool;
                                    ApproximatePercentile approximatePercentile = (ApproximatePercentile)agg;
                                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(approximatePercentile.resolved(), "agg.resolved", Prettifier$.MODULE$.default());
                                    this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 299));
                                    DataType $org_scalatest_assert_macro_left = approximatePercentile.child().dataType();
                                    IntegerType$ $org_scalatest_assert_macro_right = IntegerType$.MODULE$;
                                    DataType dataType = $org_scalatest_assert_macro_left;
                                    IntegerType$ integerType$ = $org_scalatest_assert_macro_right;
                                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(dataType != null ? !dataType.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
                                    this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
                                    DataType $org_scalatest_assert_macro_left2 = approximatePercentile.percentageExpression().dataType();
                                    DoubleType$ $org_scalatest_assert_macro_right2 = DoubleType$.MODULE$;
                                    DataType dataType2 = $org_scalatest_assert_macro_left2;
                                    DoubleType$ doubleType$ = $org_scalatest_assert_macro_right2;
                                    Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType2 != null ? !dataType2.equals(doubleType$) : doubleType$ != null), Prettifier$.MODULE$.default());
                                    if ($org_scalatest_assert_macro_left3.value()) {
                                        bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
                                    } else {
                                        DataType $org_scalatest_assert_macro_left4 = approximatePercentile.percentageExpression().dataType();
                                        ArrayType $org_scalatest_assert_macro_right3 = new ArrayType((DataType)DoubleType$.MODULE$, false);
                                        DataType dataType3 = $org_scalatest_assert_macro_left4;
                                        ArrayType arrayType = $org_scalatest_assert_macro_right3;
                                        bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType3 != null ? !dataType3.equals(arrayType) : arrayType != null), Prettifier$.MODULE$.default());
                                    }
                                    Bool $org_scalatest_assert_macro_right4 = bool;
                                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "||", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left3.$bar$bar((Function0)new Serializable(this, $org_scalatest_assert_macro_right4){
                                        public static final long serialVersionUID = 0L;
                                        private final Bool $org_scalatest_assert_macro_right$1;

                                        public final Bool apply() {
                                            return this.$org_scalatest_assert_macro_right$1;
                                        }
                                        {
                                            this.$org_scalatest_assert_macro_right$1 = $org_scalatest_assert_macro_right$1;
                                        }
                                    }), Prettifier$.MODULE$.default());
                                    this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
                                    DataType $org_scalatest_assert_macro_left5 = approximatePercentile.accuracyExpression().dataType();
                                    IntegerType$ $org_scalatest_assert_macro_right5 = IntegerType$.MODULE$;
                                    DataType dataType4 = $org_scalatest_assert_macro_left5;
                                    IntegerType$ integerType$2 = $org_scalatest_assert_macro_right5;
                                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(dataType4 != null ? !dataType4.equals(integerType$2) : integerType$2 != null), Prettifier$.MODULE$.default());
                                    Assertion assertion = this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
                                    return assertion;
                                }
                                throw this.$outer.org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$$outer().fail(new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.accuracyExpression$1 = accuracyExpression$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$9 org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.testRelation$1 = testRelation$1;
                        this.percentageExpressions$1 = percentageExpressions$1;
                    }
                });
            }

            public /* synthetic */ ApproximatePercentileSuite org$apache$spark$sql$catalyst$expressions$aggregate$ApproximatePercentileSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.test("class ApproximatePercentile, null handling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ApproximatePercentileSuite $outer;

            public final Assertion apply() {
                Cast childExpression = new Cast((Expression)new BoundReference(0, (DataType)IntegerType$.MODULE$, true), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3());
                ApproximatePercentile agg = new ApproximatePercentile((Expression)childExpression, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)0.5)));
                GenericInternalRow buffer = new GenericInternalRow(new Object[1]);
                agg.initialize((InternalRow)buffer);
                Object $org_scalatest_assert_macro_left = agg.eval((InternalRow)buffer);
                Object $org_scalatest_assert_macro_right = null;
                Object object = $org_scalatest_assert_macro_left;
                Object var7_6 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", null, !(object != null ? !object.equals(var7_6) : var7_6 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
                agg.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null})));
                Object $org_scalatest_assert_macro_left2 = agg.eval((InternalRow)buffer);
                Object $org_scalatest_assert_macro_right2 = null;
                Object object2 = $org_scalatest_assert_macro_left2;
                Object var11_10 = null;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", null, !(object2 != null ? !object2.equals(var11_10) : var11_10 != null), Prettifier$.MODULE$.default());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
                agg.update((InternalRow)buffer, InternalRow$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)0)})));
                Object $org_scalatest_assert_macro_left3 = agg.eval((InternalRow)buffer);
                Object $org_scalatest_assert_macro_right3 = null;
                Object object3 = $org_scalatest_assert_macro_left3;
                Object var15_14 = null;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left3, "!=", null, object3 != null ? !object3.equals(var15_14) : var15_14 != null, Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ApproximatePercentileSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
    }
}

