/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.util;

import java.io.File;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.SQLHelper$class;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.util.TimestampFormatterSuite$;
import org.apache.spark.sql.util.TimestampFormatterSuite$$anonfun$3$;
import org.apache.spark.sql.util.TimestampFormatterSuite$$anonfun$3$$anonfun$apply$mcV$sp$3$;
import org.apache.spark.sql.util.TimestampFormatterSuite$$anonfun$4$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}1A!\u0001\u0002\u0001\u001b\t9B+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s'VLG/\u001a\u0006\u0003\u0007\u0011\tA!\u001e;jY*\u0011QAB\u0001\u0004gFd'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\n\u0011\u0005=\u0001R\"\u0001\u0004\n\u0005E1!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005)\u0001\u000f\\1og*\u0011q\u0003B\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0011\u0004\u0006\u0002\n'Fc\u0005*\u001a7qKJDQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002")
public class TimestampFormatterSuite
extends SparkFunSuite
implements SQLHelper {
    @Override
    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f2) {
        SQLHelper$class.withSQLConf(this, pairs, f2);
    }

    @Override
    public void withTempPath(Function1<File, BoxedUnit> f2) {
        SQLHelper$class.withTempPath(this, f2);
    }

    public TimestampFormatterSuite() {
        SQLHelper$class.$init$(this);
        this.test("parsing timestamps using time zones", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimestampFormatterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String localDate = "2018-12-02T10:11:12.001234";
                Map expectedMicros = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"UTC"), (Object)BoxesRunTime.boxToLong((long)1543745472001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PST"), (Object)BoxesRunTime.boxToLong((long)1543774272001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CET"), (Object)BoxesRunTime.boxToLong((long)1543741872001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Africa/Dakar"), (Object)BoxesRunTime.boxToLong((long)1543745472001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"America/Los_Angeles"), (Object)BoxesRunTime.boxToLong((long)1543774272001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Antarctica/Vostok"), (Object)BoxesRunTime.boxToLong((long)1543723872001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Asia/Hong_Kong"), (Object)BoxesRunTime.boxToLong((long)1543716672001234L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Europe/Amsterdam"), (Object)BoxesRunTime.boxToLong((long)1543741872001234L))}));
                DateTimeTestUtils$.MODULE$.outstandingTimezonesIds().foreach((Function1)new Serializable(this, localDate, expectedMicros){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final String localDate$1;
                    private final Map expectedMicros$1;

                    public final Assertion apply(String timeZone) {
                        TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("yyyy-MM-dd'T'HH:mm:ss.SSSSSS", TimeZone.getTimeZone(timeZone));
                        long microsSinceEpoch = formatter.parse(this.localDate$1);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)microsSinceEpoch));
                        long $org_scalatest_assert_macro_right = BoxesRunTime.unboxToLong((Object)this.expectedMicros$1.apply((Object)timeZone));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.localDate$1 = localDate$1;
                        this.expectedMicros$1 = expectedMicros$1;
                    }
                });
            }

            public /* synthetic */ TimestampFormatterSuite org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("format timestamps using time zones", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimestampFormatterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                long microsSinceEpoch = 1543745472001234L;
                Map expectedTimestamp = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"UTC"), (Object)"2018-12-02T10:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PST"), (Object)"2018-12-02T02:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"CET"), (Object)"2018-12-02T11:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Africa/Dakar"), (Object)"2018-12-02T10:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"America/Los_Angeles"), (Object)"2018-12-02T02:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Antarctica/Vostok"), (Object)"2018-12-02T16:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Asia/Hong_Kong"), (Object)"2018-12-02T18:11:12.001234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Europe/Amsterdam"), (Object)"2018-12-02T11:11:12.001234")}));
                DateTimeTestUtils$.MODULE$.outstandingTimezonesIds().foreach((Function1)new Serializable(this, microsSinceEpoch, expectedTimestamp){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;
                    private final long microsSinceEpoch$1;
                    private final Map expectedTimestamp$1;

                    public final Assertion apply(String timeZone) {
                        TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("yyyy-MM-dd'T'HH:mm:ss.SSSSSS", TimeZone.getTimeZone(timeZone));
                        String timestamp = formatter.format(this.microsSinceEpoch$1);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$$outer().convertToEqualizer(timestamp);
                        String $org_scalatest_assert_macro_right = (String)this.expectedTimestamp$1.apply((Object)timeZone);
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return this.$outer.org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.microsSinceEpoch$1 = microsSinceEpoch$1;
                        this.expectedTimestamp$1 = expectedTimestamp$1;
                    }
                });
            }

            public /* synthetic */ TimestampFormatterSuite org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        this.test("roundtrip micros -> timestamp -> micros using timezones", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimestampFormatterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSSSS", "yyyy-MM-dd'T'HH:mm:ss.SSSSSSXXXXX"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(String pattern) {
                        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{-58710115316212000L, -18926315945345679L, -9463427405253013L, -244000001L, 0L, 99628200102030L, 1543749753123456L, 2177456523456789L, 11858049903010203L}))).foreach((Function1)new Serializable(this, pattern){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$3 $outer;
                            public final String pattern$1;

                            public final void apply(long micros) {
                                this.apply$mcVJ$sp(micros);
                            }

                            public void apply$mcVJ$sp(long micros) {
                                DateTimeTestUtils$.MODULE$.outstandingTimezones().foreach((Function1)new Serializable(this, micros){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$3$$anonfun$apply$1 $outer;
                                    private final long micros$1;

                                    public final Assertion apply(TimeZone timeZone) {
                                        TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply(this.$outer.pattern$1, timeZone);
                                        String timestamp = formatter.format(this.micros$1);
                                        long parsed = formatter.parse(timestamp);
                                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)this.micros$1));
                                        long $org_scalatest_assert_macro_right = parsed;
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                        return this.$outer.org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$anonfun$$anonfun$$$outer().org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.micros$1 = micros$1;
                                    }
                                });
                            }

                            public /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$3 org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.pattern$1 = pattern$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$3 org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TimestampFormatterSuite org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("roundtrip timestamp -> micros -> timestamp using timezones", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimestampFormatterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0109-07-20T18:38:03.788000", "1370-04-01T10:00:54.654321", "1670-02-11T14:09:54.746987", "1969-12-31T23:55:55.999999", "1970-01-01T00:00:00.000000", "1973-02-27T02:30:00.102030", "2018-12-02T11:22:33.123456", "2039-01-01T01:02:03.456789", "2345-10-07T22:45:03.010203"}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final void apply(String timestamp) {
                        DateTimeTestUtils$.MODULE$.outstandingTimezones().foreach((Function1)new Serializable(this, timestamp){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$4$$anonfun$apply$mcV$sp$4 $outer;
                            private final String timestamp$1;

                            public final Assertion apply(TimeZone timeZone) {
                                TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("yyyy-MM-dd'T'HH:mm:ss.SSSSSS", timeZone);
                                long micros = formatter.parse(this.timestamp$1);
                                String formatted = formatter.format(micros);
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$$outer().convertToEqualizer(this.timestamp$1);
                                String $org_scalatest_assert_macro_right = formatted;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                                return this.$outer.org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$anonfun$$$outer().org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.timestamp$1 = timestamp$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$4 org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ TimestampFormatterSuite org$apache$spark$sql$util$TimestampFormatterSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test(" case insensitive parsing of am and pm", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimestampFormatterSuite $outer;

            public final Assertion apply() {
                TimestampFormatter formatter = TimestampFormatter$.MODULE$.apply("yyyy MMM dd hh:mm:ss a", TimeZone.getTimeZone("UTC"));
                long micros = formatter.parse("2009 Mar 20 11:30:01 am");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)micros));
                long $org_scalatest_assert_macro_right = TimeUnit.SECONDS.toMicros(LocalDateTime.of(2009, 3, 20, 11, 30, 1).toEpochSecond(ZoneOffset.UTC));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("TimestampFormatterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
    }
}

