/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.analysis.ExpressionTypeCheckingSuite$;
import org.apache.spark.sql.catalyst.analysis.SimpleAnalyzer$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.dsl.package;
import org.apache.spark.sql.catalyst.expressions.Add;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.BRound;
import org.apache.spark.sql.catalyst.expressions.BitwiseAnd;
import org.apache.spark.sql.catalyst.expressions.BitwiseNot;
import org.apache.spark.sql.catalyst.expressions.BitwiseOr;
import org.apache.spark.sql.catalyst.expressions.BitwiseXor;
import org.apache.spark.sql.catalyst.expressions.CaseKeyWhen$;
import org.apache.spark.sql.catalyst.expressions.CaseWhen;
import org.apache.spark.sql.catalyst.expressions.CaseWhen$;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.CreateArray;
import org.apache.spark.sql.catalyst.expressions.CreateMap;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.Divide;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Explode;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Greatest$;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Least$;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Multiply;
import org.apache.spark.sql.catalyst.expressions.Murmur3Hash;
import org.apache.spark.sql.catalyst.expressions.PosExplode;
import org.apache.spark.sql.catalyst.expressions.Remainder;
import org.apache.spark.sql.catalyst.expressions.Round;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Symbol;
import scala.Symbol$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001\u001f\tYR\t\u001f9sKN\u001c\u0018n\u001c8UsB,7\t[3dW&twmU;ji\u0016T!a\u0001\u0003\u0002\u0011\u0005t\u0017\r\\=tSNT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0005\n\u0005MA!!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u0016\u0001\u0011\u0005a#\u0001\u0004=S:LGO\u0010\u000b\u0002/A\u0011\u0001\u0004A\u0007\u0002\u0005!9!\u0004\u0001b\u0001\n\u0003Y\u0012\u0001\u0004;fgR\u0014V\r\\1uS>tW#\u0001\u000f\u0011\u0005u\u0011S\"\u0001\u0010\u000b\u0005}\u0001\u0013a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003C\u0011\tQ\u0001\u001d7b]NL!a\t\u0010\u0003\u001b1{7-\u00197SK2\fG/[8o\u0011\u0019)\u0003\u0001)A\u00059\u0005iA/Z:u%\u0016d\u0017\r^5p]\u0002BQa\n\u0001\u0005\u0002!\n1\"Y:tKJ$XI\u001d:peR\u0019\u0011fL\u001c\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u0006a\u0019\u0002\r!M\u0001\u0005Kb\u0004(\u000f\u0005\u00023k5\t1G\u0003\u00025\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\t14G\u0001\u0006FqB\u0014Xm]:j_:DQ\u0001\u000f\u0014A\u0002e\nA\"\u001a:s_JlUm]:bO\u0016\u0004\"AO\u001f\u000f\u0005)Z\u0014B\u0001\u001f,\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qZ\u0003\"B!\u0001\t\u0003\u0011\u0015!D1tg\u0016\u0014HoU;dG\u0016\u001c8\u000f\u0006\u0002*\u0007\")\u0001\u0007\u0011a\u0001c!)Q\t\u0001C\u0001\r\u0006a\u0012m]:feR,%O]8s\r>\u0014H)\u001b4gKJLgn\u001a+za\u0016\u001cHCA\u0015H\u0011\u0015\u0001D\t1\u00012\u0001")
public class ExpressionTypeCheckingSuite
extends SparkFunSuite {
    private final LocalRelation testRelation = LocalRelation$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Attribute[]{package.expressions$.MODULE$.DslSymbol(symbol$1).int(), package.expressions$.MODULE$.DslSymbol(symbol$2).string(), package.expressions$.MODULE$.DslSymbol(symbol$3).boolean(), package.expressions$.MODULE$.DslSymbol(symbol$4).decimal(8, 0), package.expressions$.MODULE$.DslSymbol(symbol$5).array((DataType)StringType$.MODULE$), package.expressions$.MODULE$.DslSymbol(symbol$6).map((DataType)StringType$.MODULE$, (DataType)LongType$.MODULE$)}));
    private static Symbol symbol$1 = Symbol$.MODULE$.apply("intField");
    private static Symbol symbol$2 = Symbol$.MODULE$.apply("stringField");
    private static Symbol symbol$3 = Symbol$.MODULE$.apply("booleanField");
    private static Symbol symbol$4 = Symbol$.MODULE$.apply("decimalField");
    private static Symbol symbol$5 = Symbol$.MODULE$.apply("arrayField");
    private static Symbol symbol$6 = Symbol$.MODULE$.apply("mapField");

    public LocalRelation testRelation() {
        return this.testRelation;
    }

    public void assertError(Expression expr, String errorMessage) {
        AnalysisException e = (AnalysisException)this.intercept((Function0)new Serializable(this, expr){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;
            private final Expression expr$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertSuccess(this.expr$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.expr$1 = expr$1;
            }
        }, ClassTag$.MODULE$.apply(AnalysisException.class), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        String $org_scalatest_assert_macro_left = e.getMessage();
        String $org_scalatest_assert_macro_right = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cannot resolve '", "' due to data type mismatch:"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expr.sql()}));
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        String $org_scalatest_assert_macro_left2 = e.getMessage();
        String $org_scalatest_assert_macro_right2 = errorMessage;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
    }

    public void assertSuccess(Expression expr) {
        LogicalPlan analyzed = package.plans$.MODULE$.DslLogicalPlan(package.plans$.MODULE$.DslLogicalPlan((LogicalPlan)this.testRelation()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{(Expression)package.expressions$.MODULE$.DslExpression(expr).as("c")}))).analyze();
        SimpleAnalyzer$.MODULE$.checkAnalysis(analyzed);
    }

    public void assertErrorForDifferingTypes(Expression expr) {
        this.assertError(expr, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"differing types in '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expr.sql()})));
    }

    public ExpressionTypeCheckingSuite() {
        this.test("check types for unary arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;
            private static Symbol symbol$7;

            static {
                symbol$7 = Symbol$.MODULE$.apply("stringField");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertError((Expression)new BitwiseNot((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$7)), "requires integral type");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 58));
        this.test("check types for binary arithmetic", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;
            private static Symbol symbol$8;
            private static Symbol symbol$9;
            private static Symbol symbol$10;

            static {
                symbol$8 = Symbol$.MODULE$.apply("intField");
                symbol$9 = Symbol$.MODULE$.apply("stringField");
                symbol$10 = Symbol$.MODULE$.apply("booleanField");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertSuccess((Expression)new Add((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$9)));
                this.$outer.assertSuccess((Expression)new Subtract((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$9)));
                this.$outer.assertSuccess((Expression)new Multiply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$9)));
                this.$outer.assertSuccess((Expression)new Divide((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$9)));
                this.$outer.assertSuccess((Expression)new Remainder((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$9)));
                this.$outer.assertErrorForDifferingTypes((Expression)new Add((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)));
                this.$outer.assertErrorForDifferingTypes((Expression)new Subtract((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)));
                this.$outer.assertErrorForDifferingTypes((Expression)new Multiply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)));
                this.$outer.assertErrorForDifferingTypes((Expression)new Divide((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)));
                this.$outer.assertErrorForDifferingTypes((Expression)new Remainder((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)));
                this.$outer.assertErrorForDifferingTypes((Expression)new BitwiseAnd((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)));
                this.$outer.assertErrorForDifferingTypes((Expression)new BitwiseOr((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)));
                this.$outer.assertErrorForDifferingTypes((Expression)new BitwiseXor((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$8), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)));
                this.$outer.assertError((Expression)new Add((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)), "requires (numeric or calendarinterval) type");
                this.$outer.assertError((Expression)new Subtract((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)), "requires (numeric or calendarinterval) type");
                this.$outer.assertError((Expression)new Multiply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)), "requires numeric type");
                this.$outer.assertError((Expression)new Divide((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)), "requires (double or decimal) type");
                this.$outer.assertError((Expression)new Remainder((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)), "requires numeric type");
                this.$outer.assertError((Expression)new BitwiseAnd((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)), "requires integral type");
                this.$outer.assertError((Expression)new BitwiseOr((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)), "requires integral type");
                this.$outer.assertError((Expression)new BitwiseXor((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$10)), "requires integral type");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        this.test("check types for predicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;
            private static Symbol symbol$11;
            private static Symbol symbol$12;
            private static Symbol symbol$13;
            private static Symbol symbol$14;

            static {
                symbol$11 = Symbol$.MODULE$.apply("intField");
                symbol$12 = Symbol$.MODULE$.apply("stringField");
                symbol$13 = Symbol$.MODULE$.apply("booleanField");
                symbol$14 = Symbol$.MODULE$.apply("mapField");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertSuccess((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$12)));
                this.$outer.assertSuccess((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$12)));
                this.$outer.assertSuccess((Expression)new LessThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$12)));
                this.$outer.assertSuccess((Expression)new LessThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$12)));
                this.$outer.assertSuccess((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$12)));
                this.$outer.assertSuccess((Expression)new GreaterThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$12)));
                this.$outer.assertSuccess((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$13)));
                this.$outer.assertSuccess((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$13)));
                this.$outer.assertErrorForDifferingTypes((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14)));
                this.$outer.assertErrorForDifferingTypes((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14)));
                this.$outer.assertErrorForDifferingTypes((Expression)new LessThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$13)));
                this.$outer.assertErrorForDifferingTypes((Expression)new LessThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$13)));
                this.$outer.assertErrorForDifferingTypes((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$13)));
                this.$outer.assertErrorForDifferingTypes((Expression)new GreaterThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$13)));
                this.$outer.assertError((Expression)new EqualTo((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14)), "EqualTo does not support ordering on type map");
                this.$outer.assertError((Expression)new EqualNullSafe((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14)), "EqualNullSafe does not support ordering on type map");
                this.$outer.assertError((Expression)new LessThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14)), "LessThan does not support ordering on type map");
                this.$outer.assertError((Expression)new LessThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14)), "LessThanOrEqual does not support ordering on type map");
                this.$outer.assertError((Expression)new GreaterThan((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14)), "GreaterThan does not support ordering on type map");
                this.$outer.assertError((Expression)new GreaterThanOrEqual((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14)), "GreaterThanOrEqual does not support ordering on type map");
                this.$outer.assertError((Expression)new If((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$12), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$12)), "type of predicate expression in If should be boolean");
                this.$outer.assertErrorForDifferingTypes((Expression)new If((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$13), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$13)));
                this.$outer.assertError((Expression)new CaseWhen((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.expressions$.MODULE$.DslSymbol(symbol$13).attr(), (Object)package.expressions$.MODULE$.DslSymbol(symbol$11).attr()), new Tuple2((Object)package.expressions$.MODULE$.DslSymbol(symbol$13).attr(), (Object)package.expressions$.MODULE$.DslSymbol(symbol$14).attr())})), CaseWhen$.MODULE$.apply$default$2()), "THEN and ELSE expressions should all be same type or coercible to a common type");
                this.$outer.assertError((Expression)CaseKeyWhen$.MODULE$.apply((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$12), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$11), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$14)}))), "THEN and ELSE expressions should all be same type or coercible to a common type");
                this.$outer.assertError((Expression)new CaseWhen((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)package.expressions$.MODULE$.DslSymbol(symbol$13).attr(), (Object)package.expressions$.MODULE$.DslSymbol(symbol$11).attr()), new Tuple2((Object)package.expressions$.MODULE$.DslSymbol(symbol$11).attr(), (Object)package.expressions$.MODULE$.DslSymbol(symbol$11).attr())})), CaseWhen$.MODULE$.apply$default$2()), "WHEN expressions in CaseWhen should all be boolean type");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
        this.test("check types for aggregates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;
            private static Symbol symbol$15;
            private static Symbol symbol$16;
            private static Symbol symbol$17;
            private static Symbol symbol$18;

            static {
                symbol$15 = Symbol$.MODULE$.apply("stringField");
                symbol$16 = Symbol$.MODULE$.apply("arrayField");
                symbol$17 = Symbol$.MODULE$.apply("mapField");
                symbol$18 = Symbol$.MODULE$.apply("booleanField");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertSuccess((Expression)new Sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$15)));
                this.$outer.assertSuccess((Expression)new Average((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$15)));
                this.$outer.assertSuccess((Expression)new Min((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$16)));
                this.$outer.assertError((Expression)new Min((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$17)), "min does not support ordering on type");
                this.$outer.assertError((Expression)new Max((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$17)), "max does not support ordering on type");
                this.$outer.assertError((Expression)new Sum((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$18)), "function sum requires numeric type");
                this.$outer.assertError((Expression)new Average((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$18)), "function average requires numeric type");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
        this.test("check types for others", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;
            private static Symbol symbol$19;
            private static Symbol symbol$20;

            static {
                symbol$19 = Symbol$.MODULE$.apply("intField");
                symbol$20 = Symbol$.MODULE$.apply("booleanField");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertError((Expression)new CreateArray((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$19), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$20)}))), "input to function array should all be the same type");
                this.$outer.assertError((Expression)new Coalesce((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$19), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$20)}))), "input to function coalesce should all be the same type");
                this.$outer.assertError((Expression)new Coalesce((Seq)Nil$.MODULE$), "function coalesce requires at least one argument");
                this.$outer.assertError((Expression)new Murmur3Hash((Seq)Nil$.MODULE$), "function hash requires at least one argument");
                this.$outer.assertError((Expression)new Explode((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$19)), "input to function explode should be array or map type");
                this.$outer.assertError((Expression)new PosExplode((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$19)), "input to function explode should be array or map type");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
        this.test("check types for CreateNamedStruct", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;
            private static Symbol symbol$21;

            static {
                symbol$21 = Symbol$.MODULE$.apply("a");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertError((Expression)new CreateNamedStruct((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{package.expressions$.MODULE$.stringToLiteral("a"), package.expressions$.MODULE$.stringToLiteral("b"), package.expressions$.MODULE$.doubleToLiteral(2.0)}))), "even number of arguments");
                this.$outer.assertError((Expression)new CreateNamedStruct((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{package.expressions$.MODULE$.intToLiteral(1), package.expressions$.MODULE$.stringToLiteral("a"), package.expressions$.MODULE$.stringToLiteral("b"), package.expressions$.MODULE$.doubleToLiteral(2.0)}))), "Only foldable string expressions are allowed to appear at odd position");
                this.$outer.assertError((Expression)new CreateNamedStruct((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LeafExpression[]{package.expressions$.MODULE$.DslAttribute(package.expressions$.MODULE$.DslSymbol(symbol$21).string()).at(0), package.expressions$.MODULE$.stringToLiteral("a"), package.expressions$.MODULE$.stringToLiteral("b"), package.expressions$.MODULE$.doubleToLiteral(2.0)}))), "Only foldable string expressions are allowed to appear at odd position");
                this.$outer.assertError((Expression)new CreateNamedStruct((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{Literal$.MODULE$.create(null, (DataType)StringType$.MODULE$), package.expressions$.MODULE$.stringToLiteral("a")}))), "Field name should not be null");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("check types for CreateMap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;
            private static Symbol symbol$22;
            private static Symbol symbol$23;
            private static Symbol symbol$24;

            static {
                symbol$22 = Symbol$.MODULE$.apply("intField");
                symbol$23 = Symbol$.MODULE$.apply("stringField");
                symbol$24 = Symbol$.MODULE$.apply("booleanField");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertError((Expression)new CreateMap((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Literal[]{package.expressions$.MODULE$.stringToLiteral("a"), package.expressions$.MODULE$.stringToLiteral("b"), package.expressions$.MODULE$.doubleToLiteral(2.0)}))), "even number of arguments");
                this.$outer.assertError((Expression)new CreateMap((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$22), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$23), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$24), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$23)}))), "keys of function map should all be the same type");
                this.$outer.assertError((Expression)new CreateMap((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$23), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$22), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$23), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$24)}))), "values of function map should all be the same type");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        this.test("check types for ROUND/BROUND", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;
            private static Symbol symbol$25;
            private static Symbol symbol$26;
            private static Symbol symbol$27;

            static {
                symbol$25 = Symbol$.MODULE$.apply("intField");
                symbol$26 = Symbol$.MODULE$.apply("booleanField");
                symbol$27 = Symbol$.MODULE$.apply("mapField");
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertSuccess((Expression)new Round((Expression)Literal$.MODULE$.apply(null), (Expression)Literal$.MODULE$.apply(null)));
                this.$outer.assertSuccess((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$25), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))));
                this.$outer.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$25), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$25)), "Only foldable Expression is allowed");
                this.$outer.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$25), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$26)), "requires int type");
                this.$outer.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$25), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$27)), "requires int type");
                this.$outer.assertError((Expression)new Round((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$26), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$25)), "requires numeric type");
                this.$outer.assertSuccess((Expression)new BRound((Expression)Literal$.MODULE$.apply(null), (Expression)Literal$.MODULE$.apply(null)));
                this.$outer.assertSuccess((Expression)new BRound((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$25), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))));
                this.$outer.assertError((Expression)new BRound((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$25), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$25)), "Only foldable Expression is allowed");
                this.$outer.assertError((Expression)new BRound((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$25), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$26)), "requires int type");
                this.$outer.assertError((Expression)new BRound((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$25), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$27)), "requires int type");
                this.$outer.assertError((Expression)new BRound((Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$26), (Expression)package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$25)), "requires numeric type");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        this.test("check types for Greatest/Least", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpressionTypeCheckingSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{Greatest$.MODULE$, Least$.MODULE$}))).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;
                    private static Symbol symbol$28;
                    private static Symbol symbol$29;
                    private static Symbol symbol$30;
                    private static Symbol symbol$31;

                    static {
                        symbol$28 = Symbol$.MODULE$.apply("booleanField");
                        symbol$29 = Symbol$.MODULE$.apply("intField");
                        symbol$30 = Symbol$.MODULE$.apply("stringField");
                        symbol$31 = Symbol$.MODULE$.apply("mapField");
                    }

                    public final void apply(Function1<Seq<Expression>, Expression> operator) {
                        this.$outer.org$apache$spark$sql$catalyst$analysis$ExpressionTypeCheckingSuite$$anonfun$$$outer().assertError((Expression)operator.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$28)}))), "requires at least two arguments");
                        this.$outer.org$apache$spark$sql$catalyst$analysis$ExpressionTypeCheckingSuite$$anonfun$$$outer().assertError((Expression)operator.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$29), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$30)}))), "should all have the same type");
                        this.$outer.org$apache$spark$sql$catalyst$analysis$ExpressionTypeCheckingSuite$$anonfun$$$outer().assertError((Expression)operator.apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnresolvedAttribute[]{package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$31), package.expressions$.MODULE$.symbolToUnresolvedAttribute(symbol$31)}))), "does not support ordering");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ExpressionTypeCheckingSuite org$apache$spark$sql$catalyst$analysis$ExpressionTypeCheckingSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, new Position("ExpressionTypeCheckingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
    }
}

