/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.avro.AvroUtils;
import org.apache.spark.sql.avro.AvroUtils$;
import org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.spark.sql.avro.IncompatibleSchemaException$;
import org.apache.spark.sql.avro.UnsupportedAvroTypeException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u00055g!\u0002\f\u0018\u0001e\t\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u0011Y\u0002!\u0011!Q\u0001\n]B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005{!A\u0011\t\u0001B\u0001B\u0003%!\tC\u0003]\u0001\u0011\u0005Q\fC\u0003]\u0001\u0011\u0005Q\rC\u0003j\u0001\u0011\u0005!\u000eC\u0004q\u0001\t\u0007I\u0011B9\t\ra\u0004\u0001\u0015!\u0003s\u0011\u001dI\bA1A\u0005\niDaa \u0001!\u0002\u0013Y\b\"CA\u0001\u0001\t\u0007I\u0011BA\u0002\u0011!\t9\u0001\u0001Q\u0001\n\u0005\u0015QABA\u0005\u0001\u0011\tY\u0001\u0003\u0006\u0002\"\u0001A)\u0019!C\u0005\u0003GAq!a\u000e\u0001\t\u0013\tI\u0004C\u0004\u0002r\u0001!I!a\u001d\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"9\u0011q\u0016\u0001\u0005\n\u0005E\u0006bBA^\u0001\u0011%\u0011Q\u0018\u0002\u000f\u0003Z\u0014xnU3sS\u0006d\u0017N_3s\u0015\tA\u0012$\u0001\u0003bmJ|'B\u0001\u000e\u001c\u0003\r\u0019\u0018\u000f\u001c\u0006\u00039u\tQa\u001d9be.T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sON\u0019\u0001A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g!\tIC&D\u0001+\u0015\tY3$\u0001\u0005j]R,'O\\1m\u0013\ti#FA\u0004M_\u001e<\u0017N\\4\u0002!I|w\u000e^\"bi\u0006d\u0017p\u001d;UsB,7\u0001\u0001\t\u0003cQj\u0011A\r\u0006\u0003ge\tQ\u0001^=qKNL!!\u000e\u001a\u0003\u0011\u0011\u000bG/\u0019+za\u0016\fAB]8pi\u00063(o\u001c+za\u0016\u0004\"\u0001\u000f\u001e\u000e\u0003eR!\u0001G\u000f\n\u0005mJ$AB*dQ\u0016l\u0017-\u0001\u0005ok2d\u0017M\u00197f!\t\u0019c(\u0003\u0002@I\t9!i\\8mK\u0006t\u0017\u0001\u00069pg&$\u0018n\u001c8bY\u001aKW\r\u001c3NCR\u001c\u0007.\u0001\neCR,G/[7f%\u0016\u0014\u0017m]3N_\u0012,\u0007CA\"Y\u001d\t!UK\u0004\u0002F%:\u0011a)\u0015\b\u0003\u000fBs!\u0001S(\u000f\u0005%seB\u0001&N\u001b\u0005Y%B\u0001'0\u0003\u0019a$o\\8u}%\t\u0001%\u0003\u0002\u001f?%\u0011A$H\u0005\u00035mI!aK\r\n\u0005M#\u0016aB*R\u0019\u000e{gN\u001a\u0006\u0003WeI!AV,\u0002)1+w-Y2z\u0005\u0016D\u0017M^5peB{G.[2z\u0015\t\u0019F+\u0003\u0002Z5\n)a+\u00197vK&\u00111\f\n\u0002\f\u000b:,X.\u001a:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0007=\u0002\f'm\u00193\u0011\u0005}\u0003Q\"A\f\t\u000b92\u0001\u0019\u0001\u0019\t\u000bY2\u0001\u0019A\u001c\t\u000bq2\u0001\u0019A\u001f\t\u000b\u00013\u0001\u0019A\u001f\t\u000b\u00053\u0001\u0019\u0001\"\u0015\ty3w\r\u001b\u0005\u0006]\u001d\u0001\r\u0001\r\u0005\u0006m\u001d\u0001\ra\u000e\u0005\u0006y\u001d\u0001\r!P\u0001\ng\u0016\u0014\u0018.\u00197ju\u0016$\"a\u001b8\u0011\u0005\rb\u0017BA7%\u0005\r\te.\u001f\u0005\u0006_\"\u0001\ra[\u0001\rG\u0006$\u0018\r\\=ti\u0012\u000bG/Y\u0001\u000fI\u0006$XMU3cCN,g)\u001e8d+\u0005\u0011\b\u0003B\u0012tkVL!\u0001\u001e\u0013\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CA\u0012w\u0013\t9HEA\u0002J]R\fq\u0002Z1uKJ+'-Y:f\rVt7\rI\u0001\u0014i&lWm\u001d;b[B\u0014VMY1tK\u001a+hnY\u000b\u0002wB!1e\u001d?}!\t\u0019S0\u0003\u0002\u007fI\t!Aj\u001c8h\u0003Q!\u0018.\\3ti\u0006l\u0007OU3cCN,g)\u001e8dA\u0005I1m\u001c8wKJ$XM]\u000b\u0003\u0003\u000b\u0001BaI:lW\u0006Q1m\u001c8wKJ$XM\u001d\u0011\u0003\u0013\r{gN^3si\u0016\u0014\bcB\u0012\u0002\u000e\u0005EQo[\u0005\u0004\u0003\u001f!#!\u0003$v]\u000e$\u0018n\u001c83!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\t1\"\u001a=qe\u0016\u001c8/[8og*\u0019\u00111D\r\u0002\u0011\r\fG/\u00197zgRLA!a\b\u0002\u0016\t\u00112\u000b]3dS\u0006d\u0017N_3e\u000f\u0016$H/\u001a:t\u0003I!WmY5nC2\u001cuN\u001c<feNLwN\\:\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003cqA!!\u000b\u0002.9\u0019\u0001*a\u000b\n\u0005ai\u0012bAA\u0018s\u0005Y1i\u001c8wKJ\u001c\u0018n\u001c8t\u0013\u0011\t\u0019$!\u000e\u0003#\u0011+7-[7bY\u000e{gN^3sg&|gNC\u0002\u00020e\nAB\\3x\u0007>tg/\u001a:uKJ$\"\"a\u000f\u0002@\u0005\r\u0013qIA7!\r\tidD\u0007\u0002\u0001!1\u0011\u0011I\tA\u0002A\nAbY1uC2L8\u000f\u001e+za\u0016Da!!\u0012\u0012\u0001\u00049\u0014\u0001C1we>$\u0016\u0010]3\t\u000f\u0005%\u0013\u00031\u0001\u0002L\u0005a1-\u0019;bYf\u001cH\u000fU1uQB1\u0011QJA,\u0003;rA!a\u0014\u0002T9\u0019!*!\u0015\n\u0003\u0015J1!!\u0016%\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0017\u0002\\\t\u00191+Z9\u000b\u0007\u0005UC\u0005\u0005\u0003\u0002`\u0005\u001dd\u0002BA1\u0003G\u0002\"A\u0013\u0013\n\u0007\u0005\u0015D%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003S\nYG\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003K\"\u0003bBA8#\u0001\u0007\u00111J\u0001\tCZ\u0014x\u000eU1uQ\u0006\u0011b.Z<TiJ,8\r^\"p]Z,'\u000f^3s))\t)(!&\u0002 \u0006\r\u0016Q\u0015\t\u0007GM\f9(a \u0011\t\u0005e\u00141P\u0007\u0003\u00033IA!! \u0002\u001a\tY\u0011J\u001c;fe:\fGNU8x!\u0011\t\t)a$\u000f\t\u0005\r\u0015\u0011\u0012\b\u0005\u0003S\t))C\u0002\u0002\bf\nqaZ3oKJL7-\u0003\u0003\u0002\f\u00065\u0015aC$f]\u0016\u0014\u0018n\u0019#bi\u0006T1!a\":\u0013\u0011\t\t*a%\u0003\rI+7m\u001c:e\u0015\u0011\tY)!$\t\u000f\u0005]%\u00031\u0001\u0002\u001a\u0006q1-\u0019;bYf\u001cHo\u0015;sk\u000e$\bcA\u0019\u0002\u001c&\u0019\u0011Q\u0014\u001a\u0003\u0015M#(/^2u)f\u0004X\r\u0003\u0004\u0002\"J\u0001\raN\u0001\u000bCZ\u0014xn\u0015;sk\u000e$\bbBA%%\u0001\u0007\u00111\n\u0005\b\u0003_\u0012\u0002\u0019AA&\u0003M\u0011Xm]8mm\u0016tU\u000f\u001c7bE2,G+\u001f9f)\u00159\u00141VAW\u0011\u0019\t)e\u0005a\u0001o!)Ah\u0005a\u0001{\u0005y!/Z:pYZ,\u0017I\u001e:p)f\u0004X\r\u0006\u0003\u00024\u0006e\u0006#B\u0012\u00026v:\u0014bAA\\I\t1A+\u001e9mKJBa!!\u0012\u0015\u0001\u00049\u0014!G<be:tU\u000f\u001c7bE&d\u0017\u000e^=ES\u001a4WM]3oG\u0016$b!a0\u0002F\u0006%\u0007cA\u0012\u0002B&\u0019\u00111\u0019\u0013\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u000f,\u0002\u0019A\u001f\u0002\u0019\u00054(o\u001c(vY2\f'\r\\3\t\r\u0005-W\u00031\u0001>\u0003A\u0019\u0017\r^1msN$h*\u001e7mC\ndW\r")
public class AvroSerializer
implements Logging {
    private Conversions.DecimalConversion decimalConversions;
    private final DataType rootCatalystType;
    private final Schema rootAvroType;
    private final boolean positionalFieldMatch;
    private final Function1<Object, Object> dateRebaseFunc;
    private final Function1<Object, Object> timestampRebaseFunc;
    private final Function1<Object, Object> converter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Object serialize(Object catalystData) {
        return this.converter().apply(catalystData);
    }

    private Function1<Object, Object> dateRebaseFunc() {
        return this.dateRebaseFunc;
    }

    private Function1<Object, Object> timestampRebaseFunc() {
        return this.timestampRebaseFunc;
    }

    private Function1<Object, Object> converter() {
        return this.converter;
    }

    private Conversions.DecimalConversion decimalConversions$lzycompute() {
        AvroSerializer avroSerializer = this;
        synchronized (avroSerializer) {
            if (!this.bitmap$0) {
                this.decimalConversions = new Conversions.DecimalConversion();
                this.bitmap$0 = true;
            }
        }
        return this.decimalConversions;
    }

    private Conversions.DecimalConversion decimalConversions() {
        return !this.bitmap$0 ? this.decimalConversions$lzycompute() : this.decimalConversions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function2<SpecializedGetters, Object, Object> newConverter(DataType catalystType, Schema avroType, Seq<String> catalystPath, Seq<String> avroPath) {
        String errorPrefix = new StringBuilder(37).append("Cannot convert SQL ").append(AvroUtils$.MODULE$.toFieldStr(catalystPath)).append(" ").append("to Avro ").append(AvroUtils$.MODULE$.toFieldStr(avroPath)).append(" because ").toString();
        Tuple2 tuple2 = new Tuple2((Object)catalystType, (Object)avroType.getType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (NullType$.MODULE$.equals(dataType) && Schema.Type.NULL.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$1(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BooleanType$.MODULE$.equals(dataType) && Schema.Type.BOOLEAN.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToBoolean((boolean)getter.getBoolean(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ByteType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getByte(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ShortType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getShort(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (LongType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (FloatType$.MODULE$.equals(dataType) && Schema.Type.FLOAT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToFloat((float)getter.getFloat(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DoubleType$.MODULE$.equals(dataType) && Schema.Type.DOUBLE.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToDouble((double)getter.getDouble(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.FIXED.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (logicalType == null) {
                        if (decimal == null) return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$9(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    } else if (logicalType.equals(decimal)) {
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$9(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.BYTES.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (logicalType == null) {
                        if (decimal == null) return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$10(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    } else if (logicalType.equals(decimal)) {
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$10(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.ENUM.equals(type)) {
                Set enumSymbols = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getEnumSymbols()).asScala()).toSet();
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$11(enumSymbols, errorPrefix, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.STRING.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$12(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.FIXED.equals(type)) {
                int size = avroType.getFixedSize();
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$13(size, errorPrefix, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.BYTES.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$14(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DateType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)AvroSerializer.$anonfun$newConverter$15(this, getter, BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (TimestampType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                Function2 & Serializable & scala.Serializable intersect;
                LogicalType logicalType = avroType.getLogicalType();
                boolean bl = logicalType == null ? true : logicalType instanceof LogicalTypes.TimestampMillis;
                if (bl) {
                    intersect = (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.microsToMillis(this.timestampRebaseFunc().apply$mcJJ$sp(getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)))));
                    return intersect;
                } else {
                    if (!(logicalType instanceof LogicalTypes.TimestampMicros)) throw new IncompatibleSchemaException(new StringBuilder(51).append(errorPrefix).append("SQL type ").append(TimestampType$.MODULE$.sql()).append(" cannot be converted to Avro logical type ").append(logicalType).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                    intersect = (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)AvroSerializer.$anonfun$newConverter$17(this, getter, BoxesRunTime.unboxToInt((Object)ordinal)));
                }
                return intersect;
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                if (Schema.Type.ARRAY.equals(type)) {
                    Function2<SpecializedGetters, Object, Object> elementConverter = this.newConverter(et, this.resolveNullableType(avroType.getElementType(), containsNull), (Seq<String>)((Seq)catalystPath.$colon$plus((Object)"element", Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)avroPath.$colon$plus((Object)"element", Seq$.MODULE$.canBuildFrom())));
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$18(containsNull, elementConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 != null) {
            DataType st = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (st instanceof StructType) {
                StructType structType = (StructType)st;
                if (Schema.Type.RECORD.equals(type)) {
                    Function1<InternalRow, GenericData.Record> structConverter = this.newStructConverter(structType, avroType, catalystPath, avroPath);
                    int numFields = structType.length();
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$19(structConverter, numFields, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 == null) throw new IncompatibleSchemaException(new StringBuilder(48).append(errorPrefix).append("schema is incompatible (sqlType = ").append(catalystType.sql()).append(", avroType = ").append(avroType).append(")").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        DataType dataType = (DataType)tuple2._1();
        Schema.Type type = (Schema.Type)tuple2._2();
        if (!(dataType instanceof MapType)) throw new IncompatibleSchemaException(new StringBuilder(48).append(errorPrefix).append("schema is incompatible (sqlType = ").append(catalystType.sql()).append(", avroType = ").append(avroType).append(")").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        MapType mapType = (MapType)dataType;
        DataType kt = mapType.keyType();
        DataType vt = mapType.valueType();
        boolean valueContainsNull = mapType.valueContainsNull();
        if (!Schema.Type.MAP.equals(type)) throw new IncompatibleSchemaException(new StringBuilder(48).append(errorPrefix).append("schema is incompatible (sqlType = ").append(catalystType.sql()).append(", avroType = ").append(avroType).append(")").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        DataType dataType2 = kt;
        StringType$ stringType$ = StringType$.MODULE$;
        if (dataType2 == null) {
            if (stringType$ != null) {
                throw new IncompatibleSchemaException(new StringBuilder(48).append(errorPrefix).append("schema is incompatible (sqlType = ").append(catalystType.sql()).append(", avroType = ").append(avroType).append(")").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        } else if (!dataType2.equals(stringType$)) throw new IncompatibleSchemaException(new StringBuilder(48).append(errorPrefix).append("schema is incompatible (sqlType = ").append(catalystType.sql()).append(", avroType = ").append(avroType).append(")").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        Function2<SpecializedGetters, Object, Object> valueConverter = this.newConverter(vt, this.resolveNullableType(avroType.getValueType(), valueContainsNull), (Seq<String>)((Seq)catalystPath.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)avroPath.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom())));
        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$20(valueContainsNull, valueConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
    }

    private Function1<InternalRow, GenericData.Record> newStructConverter(StructType catalystStruct, Schema avroStruct, Seq<String> catalystPath, Seq<String> avroPath) {
        int[] nArray;
        Function2[] fieldConverters;
        block6: {
            Tuple2 tuple2;
            block5: {
                String avroPathStr = AvroUtils$.MODULE$.toFieldStr(avroPath);
                Schema.Type type = avroStruct.getType();
                Schema.Type type2 = Schema.Type.RECORD;
                if (type == null ? type2 != null : !type.equals(type2)) {
                    throw new IncompatibleSchemaException(new StringBuilder(17).append(avroPathStr).append(" was not a RECORD").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                }
                Buffer avroFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(avroStruct.getFields()).asScala();
                if (avroFields.size() != catalystStruct.length()) {
                    throw new IncompatibleSchemaException(new StringBuilder(58).append("Avro ").append(avroPathStr).append(" schema length (").append(avroFields.size()).append(") doesn't match ").append("SQL ").append(AvroUtils$.MODULE$.toFieldStr(catalystPath)).append(" schema length (").append(catalystStruct.length()).append(")").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                }
                AvroUtils.AvroSchemaHelper avroSchemaHelper = new AvroUtils.AvroSchemaHelper(avroStruct, avroPath, this.positionalFieldMatch);
                tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)((TraversableLike)catalystStruct.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Schema.Field field;
                    StructField catalystField;
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        Schema.Field f;
                        catalystField = (StructField)tuple2._1();
                        int catalystPos = tuple2._2$mcI$sp();
                        Option<Schema.Field> option = avroSchemaHelper.getAvroField(catalystField.name(), catalystPos);
                        if (!(option instanceof Some)) {
                            if (None$.MODULE$.equals(option)) {
                                String fieldDescription = AvroUtils$.MODULE$.toFieldDescription((Seq<String>)((Seq)catalystPath.$colon$plus((Object)catalystField.name(), Seq$.MODULE$.canBuildFrom())), catalystPos, $this.positionalFieldMatch);
                                throw new IncompatibleSchemaException(new StringBuilder(31).append("Cannot find ").append(fieldDescription).append(" in Avro schema at ").append(avroPathStr).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                            }
                            throw new MatchError(option);
                        }
                        Some some = (Some)option;
                        field = f = (Schema.Field)some.value();
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Schema.Field avroField = field;
                    Function2<SpecializedGetters, Object, Object> converter = this.newConverter(catalystField.dataType(), this.resolveNullableType(avroField.schema(), catalystField.nullable()), (Seq<String>)((Seq)catalystPath.$colon$plus((Object)catalystField.name(), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)avroPath.$colon$plus((Object)avroField.name(), Seq$.MODULE$.canBuildFrom())));
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)avroField.pos()), converter);
                    return tuple22;
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Function2.class));
                if (tuple2 == null) break block5;
                int[] avroIndices = (int[])tuple2._1();
                fieldConverters = (Function2[])tuple2._2();
                if (avroIndices == null) break block5;
                nArray = avroIndices;
                if (fieldConverters != null) break block6;
            }
            throw new MatchError((Object)tuple2);
        }
        Function2[] function2Array = fieldConverters;
        Tuple2 tuple2 = new Tuple2((Object)nArray, (Object)function2Array);
        Tuple2 tuple22 = tuple2;
        int[] avroIndices = (int[])tuple22._1();
        Function2[] fieldConverters2 = (Function2[])tuple22._2();
        int numFields = catalystStruct.length();
        return (Function1 & Serializable & scala.Serializable)row -> {
            GenericData.Record result = new GenericData.Record(avroStruct);
            for (int i = 0; i < numFields; ++i) {
                if (row.isNullAt(i)) {
                    result.put(avroIndices[i], null);
                    continue;
                }
                result.put(avroIndices[i], fieldConverters2[i].apply(row, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
            return result;
        };
    }

    private Schema resolveNullableType(Schema avroType, boolean nullable) {
        Tuple2<Object, Schema> tuple2 = this.resolveAvroType(avroType);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean avroNullable = tuple2._1$mcZ$sp();
        Schema resolvedAvroType = (Schema)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)avroNullable), (Object)resolvedAvroType);
        Tuple2 tuple23 = tuple22;
        boolean avroNullable2 = tuple23._1$mcZ$sp();
        Schema resolvedAvroType2 = (Schema)tuple23._2();
        this.warnNullabilityDifference(avroNullable2, nullable);
        return resolvedAvroType2;
    }

    private Tuple2<Object, Schema> resolveAvroType(Schema avroType) {
        Tuple2 tuple2;
        Schema.Type type = avroType.getType();
        Schema.Type type2 = Schema.Type.UNION;
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            Buffer fields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getTypes()).asScala();
            Buffer actualType = (Buffer)fields.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AvroSerializer.$anonfun$resolveAvroType$1(x$3)));
            if (fields.length() != 2 || actualType.length() != 1) {
                throw new UnsupportedAvroTypeException(new StringBuilder(88).append("Unsupported Avro UNION type ").append(avroType).append(": Only UNION of a null type and a non-null ").append("type is supported").toString());
            }
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), actualType.head());
        } else {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)avroType);
        }
        return tuple2;
    }

    private void warnNullabilityDifference(boolean avroNullable, boolean catalystNullable) {
        block1: {
            if (avroNullable && !catalystNullable) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Writing Avro files with nullable Avro schema and non-nullable catalyst schema.");
            }
            if (avroNullable || !catalystNullable) break block1;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Writing Avro files with non-nullable Avro schema and nullable catalyst schema will throw runtime exception if there is a record with null value.");
        }
    }

    private final /* synthetic */ Function1 liftedTree1$1(Schema actualAvroType$1) {
        Function1 & Serializable & scala.Serializable intersect;
        try {
            Function1 & Serializable & scala.Serializable intersect2;
            DataType dataType = this.rootCatalystType;
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                intersect2 = this.newStructConverter(structType, actualAvroType$1, (Seq<String>)Nil$.MODULE$, (Seq<String>)Nil$.MODULE$);
            } else {
                SpecificInternalRow tmpRow = new SpecificInternalRow((Seq)new .colon.colon((Object)this.rootCatalystType, (List)Nil$.MODULE$));
                Function2<SpecializedGetters, Object, Object> converter = this.newConverter(this.rootCatalystType, actualAvroType$1, (Seq<String>)Nil$.MODULE$, (Seq<String>)Nil$.MODULE$);
                intersect2 = (Function1 & Serializable & scala.Serializable)data -> {
                    tmpRow.update(0, data);
                    return converter.apply((Object)tmpRow, (Object)BoxesRunTime.boxToInteger((int)0));
                };
            }
            intersect = intersect2;
        }
        catch (IncompatibleSchemaException ise) {
            throw new IncompatibleSchemaException(new StringBuilder(39).append("Cannot convert SQL type ").append(this.rootCatalystType.sql()).append(" to Avro type ").append(this.rootAvroType).append(".").toString(), ise);
        }
        return intersect;
    }

    public static final /* synthetic */ Null$ $anonfun$newConverter$1(SpecializedGetters getter, int ordinal) {
        return null;
    }

    public static final /* synthetic */ GenericFixed $anonfun$newConverter$9(AvroSerializer $this, DecimalType x55$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x55$1.precision(), x55$1.scale());
        return $this.decimalConversions().toFixed(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x55$1.precision(), (int)x55$1.scale()));
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$10(AvroSerializer $this, DecimalType x57$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x57$1.precision(), x57$1.scale());
        return $this.decimalConversions().toBytes(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x57$1.precision(), (int)x57$1.scale()));
    }

    public static final /* synthetic */ GenericData.EnumSymbol $anonfun$newConverter$11(Set enumSymbols$1, String errorPrefix$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        String data = getter.getUTF8String(ordinal).toString();
        if (!enumSymbols$1.contains((Object)data)) {
            throw new IncompatibleSchemaException(new StringBuilder(52).append(errorPrefix$1).append("\"").append(data).append("\" cannot be written since it's not defined in enum ").append(enumSymbols$1.mkString("\"", "\", \"", "\"")).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.EnumSymbol(avroType$1, data);
    }

    public static final /* synthetic */ Utf8 $anonfun$newConverter$12(SpecializedGetters getter, int ordinal) {
        return new Utf8(getter.getUTF8String(ordinal).getBytes());
    }

    private static final String len2str$1(int len) {
        return new StringBuilder(1).append(len).append(" ").append((Object)(len > 1 ? "bytes" : "byte")).toString();
    }

    public static final /* synthetic */ GenericData.Fixed $anonfun$newConverter$13(int size$1, String errorPrefix$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        byte[] data = getter.getBinary(ordinal);
        if (data.length != size$1) {
            throw new IncompatibleSchemaException(new StringBuilder(63).append(errorPrefix$1).append(AvroSerializer.len2str$1(data.length)).append(" of binary data cannot be written into FIXED type with size of ").append(AvroSerializer.len2str$1(size$1)).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.Fixed(avroType$1, data);
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$14(SpecializedGetters getter, int ordinal) {
        return ByteBuffer.wrap(getter.getBinary(ordinal));
    }

    public static final /* synthetic */ int $anonfun$newConverter$15(AvroSerializer $this, SpecializedGetters getter, int ordinal) {
        return $this.dateRebaseFunc().apply$mcII$sp(getter.getInt(ordinal));
    }

    public static final /* synthetic */ long $anonfun$newConverter$17(AvroSerializer $this, SpecializedGetters getter, int ordinal) {
        return $this.timestampRebaseFunc().apply$mcJJ$sp(getter.getLong(ordinal));
    }

    public static final /* synthetic */ java.util.List $anonfun$newConverter$18(boolean containsNull$1, Function2 elementConverter$1, SpecializedGetters getter, int ordinal) {
        ArrayData arrayData = getter.getArray(ordinal);
        int len = arrayData.numElements();
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            result[i] = containsNull$1 && arrayData.isNullAt(i) ? null : elementConverter$1.apply((Object)arrayData, (Object)BoxesRunTime.boxToInteger((int)i));
        }
        return Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)result));
    }

    public static final /* synthetic */ GenericData.Record $anonfun$newConverter$19(Function1 structConverter$1, int numFields$1, SpecializedGetters getter, int ordinal) {
        return (GenericData.Record)structConverter$1.apply((Object)getter.getStruct(ordinal, numFields$1));
    }

    public static final /* synthetic */ HashMap $anonfun$newConverter$20(boolean valueContainsNull$1, Function2 valueConverter$1, SpecializedGetters getter, int ordinal) {
        MapData mapData = getter.getMap(ordinal);
        int len = mapData.numElements();
        HashMap<String, Object> result = new HashMap<String, Object>(len);
        ArrayData keyArray = mapData.keyArray();
        ArrayData valueArray = mapData.valueArray();
        for (int i = 0; i < len; ++i) {
            String key = keyArray.getUTF8String(i).toString();
            Object object = valueContainsNull$1 && valueArray.isNullAt(i) ? result.put(key, null) : result.put(key, valueConverter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i)));
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$resolveAvroType$1(Schema x$3) {
        Schema.Type type = x$3.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    public AvroSerializer(DataType rootCatalystType, Schema rootAvroType, boolean nullable, boolean positionalFieldMatch, Enumeration.Value datetimeRebaseMode) {
        this.rootCatalystType = rootCatalystType;
        this.rootAvroType = rootAvroType;
        this.positionalFieldMatch = positionalFieldMatch;
        Logging.$init$((Logging)this);
        this.dateRebaseFunc = DataSourceUtils$.MODULE$.creteDateRebaseFuncInWrite(datetimeRebaseMode, "Avro");
        this.timestampRebaseFunc = DataSourceUtils$.MODULE$.creteTimestampRebaseFuncInWrite(datetimeRebaseMode, "Avro");
        Schema actualAvroType = this.resolveNullableType(rootAvroType, nullable);
        Function1 & Serializable & scala.Serializable baseConverter = this.liftedTree1$1(actualAvroType);
        this.converter = nullable ? (Function1 & Serializable & scala.Serializable)data -> data == null ? null : baseConverter.apply(data) : baseConverter;
    }

    public AvroSerializer(DataType rootCatalystType, Schema rootAvroType, boolean nullable) {
        this(rootCatalystType, rootAvroType, nullable, false, SQLConf.LegacyBehaviorPolicy$.MODULE$.withName((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_WRITE())));
    }
}

