/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc;

import java.util.ServiceLoader;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.orc.DataMaskDescription;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.MaskDescriptionImpl;

public interface DataMask {
    public void maskData(ColumnVector var1, ColumnVector var2, int var3, int var4);

    public static class Factory {
        private static final ServiceLoader<Provider> LOADER = ServiceLoader.load(Provider.class);

        public static DataMask build(DataMaskDescription mask, TypeDescription schema, MaskOverrides overrides) {
            for (Provider provider : LOADER) {
                DataMask result = provider.build(mask, schema, overrides);
                if (result == null) continue;
                return result;
            }
            throw new IllegalArgumentException("Can't find data mask - " + mask);
        }
    }

    public static interface Provider {
        public DataMask build(DataMaskDescription var1, TypeDescription var2, MaskOverrides var3);
    }

    public static interface MaskOverrides {
        public DataMaskDescription hasOverride(TypeDescription var1);
    }

    public static enum Standard {
        NULLIFY("nullify"),
        REDACT("redact"),
        SHA256("sha256");

        private final String name;

        private Standard(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public DataMaskDescription getDescription(String ... params) {
            return new MaskDescriptionImpl(this.name, params);
        }
    }
}

