/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.avro.AvroFileFormat$;
import org.apache.spark.sql.avro.AvroOptions$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.ParseMode$;
import org.apache.spark.sql.internal.SQLConf$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d!\u0002\u0011\"\u0001\rZ\u0003\u0002C\u001e\u0001\u0005\u000b\u0007I\u0011A\u001f\t\u0011E\u0003!\u0011!Q\u0001\nyB\u0001B\u0016\u0001\u0003\u0006\u0004%\ta\u0016\u0005\t?\u0002\u0011\t\u0011)A\u00051\")\u0011\r\u0001C\u0001E\")\u0011\r\u0001C\u0001O\"9Q\u000e\u0001b\u0001\n\u0003q\u0007BB<\u0001A\u0003%q\u000eC\u0004y\u0001\t\u0007I\u0011A=\t\ru\u0004\u0001\u0015!\u0003{\u0011\u001dq\bA1A\u0005\u0002}Dq!!\u0001\u0001A\u0003%a\t\u0003\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0001\u0000\u0011\u001d\t)\u0001\u0001Q\u0001\n\u0019C\u0001\"a\u0002\u0001\u0005\u0004%\t!\u001f\u0005\b\u00033\u0001\u0001\u0015!\u0003{\u0011!\ti\u0002\u0001b\u0001\n\u0003y\bbBA\u0010\u0001\u0001\u0006IA\u0012\u0005\n\u0003C\u0001!\u0019!C\u0001\u0003GA\u0001\"a\u000b\u0001A\u0003%\u0011Q\u0005\u0005\t\u0003[\u0001!\u0019!C\u0001\u007f\"9\u0011q\u0006\u0001!\u0002\u00131u\u0001CA\u0019C!\u00051%a\r\u0007\u000f\u0001\n\u0003\u0012A\u0012\u00026!1\u0011\r\u0007C\u0001\u0003oAq!!\u000f\u0019\t\u0003\tY\u0004C\u0005\u0002@a\u0011\r\u0011\"\u0001\u0002B!A\u0011\u0011\u000b\r!\u0002\u0013\t\u0019\u0005C\u0005\u0002Ta\u0011\r\u0011\"\u0001\u0002B!A\u0011Q\u000b\r!\u0002\u0013\t\u0019\u0005C\u0005\u0002Xa\t\t\u0011\"\u0003\u0002Z\tY\u0011I\u001e:p\u001fB$\u0018n\u001c8t\u0015\t\u00113%\u0001\u0003bmJ|'B\u0001\u0013&\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003M\u001d\nQa\u001d9be.T!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sON!\u0001\u0001\f\u001a9!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019\te.\u001f*fMB\u00111GN\u0007\u0002i)\u0011Q'J\u0001\tS:$XM\u001d8bY&\u0011q\u0007\u000e\u0002\b\u0019><w-\u001b8h!\ti\u0013(\u0003\u0002;]\ta1+\u001a:jC2L'0\u00192mK\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0004\u0001U\ta\bE\u0002@\t\u001ak\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bA!\u001e;jY*\u00111iI\u0001\tG\u0006$\u0018\r\\=ti&\u0011Q\t\u0011\u0002\u0013\u0007\u0006\u001cX-\u00138tK:\u001c\u0018\u000e^5wK6\u000b\u0007\u000f\u0005\u0002H\u001d:\u0011\u0001\n\u0014\t\u0003\u0013:j\u0011A\u0013\u0006\u0003\u0017r\na\u0001\u0010:p_Rt\u0014BA'/\u0003\u0019\u0001&/\u001a3fM&\u0011q\n\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00055s\u0013a\u00039be\u0006lW\r^3sg\u0002B#AA*\u0011\u00055\"\u0016BA+/\u0005%!(/\u00198tS\u0016tG/\u0001\u0003d_:4W#\u0001-\u0011\u0005ekV\"\u0001.\u000b\u0005Y[&B\u0001/(\u0003\u0019A\u0017\rZ8pa&\u0011aL\u0017\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u000b\r|gN\u001a\u0011)\u0005\u0011\u0019\u0016A\u0002\u001fj]&$h\bF\u0002dK\u001a\u0004\"\u0001\u001a\u0001\u000e\u0003\u0005BQaO\u0003A\u0002yBQAV\u0003A\u0002a#2a\u00195m\u0011\u0015Yd\u00011\u0001j!\u00119%N\u0012$\n\u0005-\u0004&aA'ba\")aK\u0002a\u00011\u000611o\u00195f[\u0006,\u0012a\u001c\t\u0004[A\u0014\u0018BA9/\u0005\u0019y\u0005\u000f^5p]B\u00111/^\u0007\u0002i*\u0011!eJ\u0005\u0003mR\u0014aaU2iK6\f\u0017aB:dQ\u0016l\u0017\rI\u0001\u0018a>\u001c\u0018\u000e^5p]\u0006dg)[3mI6\u000bGo\u00195j]\u001e,\u0012A\u001f\t\u0003[mL!\u0001 \u0018\u0003\u000f\t{w\u000e\\3b]\u0006A\u0002o\\:ji&|g.\u00197GS\u0016dG-T1uG\"Lgn\u001a\u0011\u0002\u0015I,7m\u001c:e\u001d\u0006lW-F\u0001G\u0003-\u0011XmY8sI:\u000bW.\u001a\u0011\u0002\u001fI,7m\u001c:e\u001d\u0006lWm\u001d9bG\u0016\f\u0001C]3d_J$g*Y7fgB\f7-\u001a\u0011\u0002\u001f%<gn\u001c:f\u000bb$XM\\:j_:DsaDA\u0006\u0003#\t)\u0002E\u0002.\u0003\u001bI1!a\u0004/\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003'\t!*V:fAQDW\rI4f]\u0016\u0014\u0018\r\u001c\u0011eCR\f\u0007e]8ve\u000e,\u0007e\u001c9uS>t\u0007\u0005]1uQ\u001ecwN\u0019$jYR,'\u000f\t4pe\u00022\u0017\u000e\u001c;fe&tw\r\t4jY\u0016\u0004c.Y7fg\u0006\u0012\u0011qC\u0001\u0004g9\u0002\u0014\u0001E5h]>\u0014X-\u0012=uK:\u001c\u0018n\u001c8!Q\u001d\u0001\u00121BA\t\u0003+\t1bY8naJ,7o]5p]\u0006a1m\\7qe\u0016\u001c8/[8oA\u0005I\u0001/\u0019:tK6{G-Z\u000b\u0003\u0003K\u00012aPA\u0014\u0013\r\tI\u0003\u0011\u0002\n!\u0006\u00148/Z'pI\u0016\f!\u0002]1sg\u0016lu\u000eZ3!\u0003a!\u0017\r^3uS6,'+\u001a2bg\u0016lu\u000eZ3J]J+\u0017\rZ\u0001\u001aI\u0006$X\r^5nKJ+'-Y:f\u001b>$W-\u00138SK\u0006$\u0007%A\u0006BmJ|w\n\u001d;j_:\u001c\bC\u00013\u0019'\rAB\u0006\u000f\u000b\u0003\u0003g\tQ!\u00199qYf$2aYA\u001f\u0011\u0015Y$\u00041\u0001j\u0003IIwM\\8sK\u0016CH/\u001a8tS>t7*Z=\u0016\u0005\u0005\r\u0003\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\u0005Y\u0006twM\u0003\u0002\u0002N\u0005!!.\u0019<b\u0013\ry\u0015qI\u0001\u0014S\u001etwN]3FqR,gn]5p].+\u0017\u0010I\u0001\u0015\t\u0006#V\tV%N\u000b~\u0013VIQ!T\u000b~ku\nR#\u0002+\u0011\u000bE+\u0012+J\u001b\u0016{&+\u0012\"B'\u0016{Vj\u0014#FA\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\u0006\u0005\u0003\u0002F\u0005u\u0013\u0002BA0\u0003\u000f\u0012aa\u00142kK\u000e$\b")
public class AvroOptions
implements Logging,
scala.Serializable {
    private final transient CaseInsensitiveMap<String> parameters;
    private final transient Configuration conf;
    private final Option<Schema> schema;
    private final boolean positionalFieldMatching;
    private final String recordName;
    private final String recordNamespace;
    private final boolean ignoreExtension;
    private final String compression;
    private final ParseMode parseMode;
    private final String datetimeRebaseModeInRead;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String DATETIME_REBASE_MODE() {
        return AvroOptions$.MODULE$.DATETIME_REBASE_MODE();
    }

    public static String ignoreExtensionKey() {
        return AvroOptions$.MODULE$.ignoreExtensionKey();
    }

    public static AvroOptions apply(Map<String, String> map) {
        return AvroOptions$.MODULE$.apply(map);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CaseInsensitiveMap<String> parameters() {
        return this.parameters;
    }

    public Configuration conf() {
        return this.conf;
    }

    public Option<Schema> schema() {
        return this.schema;
    }

    public boolean positionalFieldMatching() {
        return this.positionalFieldMatching;
    }

    public String recordName() {
        return this.recordName;
    }

    public String recordNamespace() {
        return this.recordNamespace;
    }

    public boolean ignoreExtension() {
        return this.ignoreExtension;
    }

    public String compression() {
        return this.compression;
    }

    public ParseMode parseMode() {
        return this.parseMode;
    }

    public String datetimeRebaseModeInRead() {
        return this.datetimeRebaseModeInRead;
    }

    public static final /* synthetic */ boolean $anonfun$positionalFieldMatching$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$ignoreExtension$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
    }

    public AvroOptions(CaseInsensitiveMap<String> parameters, Configuration conf) {
        this.parameters = parameters;
        this.conf = conf;
        Logging.$init$((Logging)this);
        Schema.Parser parser = new Schema.Parser();
        this.schema = parameters.get("avroSchema").map((Function1 & Serializable & scala.Serializable)s -> parser.parse(s)).orElse((Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            Option avroUrlSchema = this.parameters().get("avroSchemaUrl").map((Function1 & Serializable & scala.Serializable)url -> {
                Schema schema;
                this.log().debug(new StringBuilder(30).append("loading avro schema from url: ").append((String)url).toString());
                FileSystem fs = FileSystem.get((URI)new URI((String)url), (Configuration)this.conf());
                try (FSDataInputStream in = fs.open(new Path(url));){
                    schema = new Schema.Parser().parse((InputStream)in);
                }
                return schema;
            });
            return var1_1;
        });
        this.positionalFieldMatching = parameters.get("positionalFieldMatching").exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AvroOptions.$anonfun$positionalFieldMatching$1(x$1)));
        this.recordName = (String)parameters.getOrElse((Object)"recordName", (Function0 & Serializable & scala.Serializable)() -> "topLevelRecord");
        this.recordNamespace = (String)parameters.getOrElse((Object)"recordNamespace", (Function0 & Serializable & scala.Serializable)() -> "");
        boolean ignoreFilesWithoutExtensionByDefault = false;
        boolean ignoreFilesWithoutExtension = conf.getBoolean(AvroFileFormat$.MODULE$.IgnoreFilesWithoutExtensionProperty(), ignoreFilesWithoutExtensionByDefault);
        this.ignoreExtension = BoxesRunTime.unboxToBoolean((Object)parameters.get(AvroOptions$.MODULE$.ignoreExtensionKey()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)AvroOptions.$anonfun$ignoreExtension$1(x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !ignoreFilesWithoutExtension));
        this.compression = (String)parameters.get("compression").getOrElse((Function0 & Serializable & scala.Serializable)() -> SQLConf$.MODULE$.get().avroCompressionCodec());
        this.parseMode = (ParseMode)parameters.get("mode").map((Function1 & Serializable & scala.Serializable)mode -> ParseMode$.MODULE$.fromString(mode)).getOrElse((Function0 & Serializable & scala.Serializable)() -> FailFastMode$.MODULE$);
        this.datetimeRebaseModeInRead = (String)parameters.get(AvroOptions$.MODULE$.DATETIME_REBASE_MODE()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_READ()));
    }

    public AvroOptions(Map<String, String> parameters, Configuration conf) {
        this((CaseInsensitiveMap<String>)CaseInsensitiveMap$.MODULE$.apply(parameters), conf);
    }
}

