/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.avro.AvroDeserializer;
import org.apache.spark.sql.avro.AvroSerdeSuite$;
import org.apache.spark.sql.avro.AvroSerdeSuite$Deserializer$;
import org.apache.spark.sql.avro.AvroSerdeSuite$MatchType$;
import org.apache.spark.sql.avro.AvroSerdeSuite$Serializer$;
import org.apache.spark.sql.avro.AvroSerializer;
import org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001\u0002\u0011\"\u00011BQ!\r\u0001\u0005\u0002IBQ!\u000e\u0001\u0005\nYB\u0011\"!.\u0001#\u0003%I!a.\t\u000f\u00055\u0007\u0001\"\u0001\u0002P\u001e)\u0011*\tE\u0001\u0015\u001a)\u0001%\tE\u0001\u0017\")\u0011G\u0002C\u0001%\"91K\u0002b\u0001\n\u0013!\u0006BB.\u0007A\u0003%QkB\u0003]\r!%QLB\u0003`\r!%\u0001\rC\u00032\u0017\u0011\u0005A-\u0002\u0003`\u0017\u0001)\u0007bB5\f\u0005\u0004%\tA\u001b\u0005\u0007W.\u0001\u000b\u0011B3\t\u000f1\\!\u0019!C\u0001U\"1Qn\u0003Q\u0001\n\u0015DQA\\\u0006\u0005\u0002=4qA\u001e\u0004\u0011\u0002G%r\u000fC\u0003z'\u0019\u0005!pB\u0004\u0002N\u0019AI!a\u0011\u0007\u000f\u0005Ub\u0001#\u0003\u00028!1\u0011G\u0006C\u0001\u0003\u0003Ba!\u001f\f\u0005B\u0005\u0015saBA(\r!%\u0011\u0011\u0006\u0004\b\u000371\u0001\u0012BA\u000f\u0011\u0019\t$\u0004\"\u0001\u0002(!1\u0011P\u0007C!\u0003WAq!!\u0015\u0007\t\u0013\t\u0019\u0006C\u0004\u0002\b\u001a!I!!#\t\u0013\u00055e!!A\u0005\n\u0005=%AD!we>\u001cVM\u001d3f'VLG/\u001a\u0006\u0003E\r\nA!\u0019<s_*\u0011A%J\u0001\u0004gFd'B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0004\u0001M\u0011\u0001!\f\t\u0003]=j\u0011!J\u0005\u0003a\u0015\u0012Qb\u00159be.4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u00014!\t!\u0004!D\u0001\"\u0003u\t7o]3si\u001a\u000b\u0017\u000e\\3e\u0007>tg/\u001a:tS>tW*Z:tC\u001e,G#C\u001c>\t\u0006\u001d\u0016QVAY!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0011)f.\u001b;\t\u000by\u0012\u0001\u0019A \u0002\u0015\u00054(o\\*dQ\u0016l\u0017\r\u0005\u0002A\u00056\t\u0011I\u0003\u0002#O%\u00111)\u0011\u0002\u0007'\u000eDW-\\1\t\u000b\u0015\u0013\u0001\u0019\u0001$\u0002\u0019M,'\u000fZ3GC\u000e$xN]=1\u0007\u001d\u000b\u0019\u000b\u0005\u0003I'\u0005\u0005fB\u0001\u001b\u0006\u00039\teO]8TKJ$WmU;ji\u0016\u0004\"\u0001\u000e\u0004\u0014\u0007\u0019au\n\u0005\u00029\u001b&\u0011a*\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005a\u0002\u0016BA):\u00051\u0019VM]5bY&T\u0018M\u00197f)\u0005Q\u0015aD\"B)\u0006c\u0015l\u0015+`'R\u0013Vk\u0011+\u0016\u0003U\u0003\"AV-\u000e\u0003]S!\u0001W\u0012\u0002\u000bQL\b/Z:\n\u0005i;&AC*ueV\u001cG\u000fV=qK\u0006\u00012)\u0011+B\u0019f\u001bFkX*U%V\u001bE\u000bI\u0001\n\u001b\u0006$8\r\u001b+za\u0016\u0004\"AX\u0006\u000e\u0003\u0019\u0011\u0011\"T1uG\"$\u0016\u0010]3\u0014\u0005-\t\u0007C\u0001\u001dc\u0013\t\u0019\u0017HA\u0006F]VlWM]1uS>tG#A/\u0011\u0005\u0019<W\"A\u0006\n\u0005!\u0014'!\u0002,bYV,\u0017a\u0002\"Z?:\u000bU*R\u000b\u0002K\u0006A!)W0O\u00036+\u0005%A\u0006C3~\u0003vjU%U\u0013>s\u0015\u0001\u0004\"Z?B{5+\u0013+J\u001f:\u0003\u0013\u0001D5t!>\u001c\u0018\u000e^5p]\u0006dGC\u00019t!\tA\u0014/\u0003\u0002ss\t9!i\\8mK\u0006t\u0007\"\u0002;\u0013\u0001\u0004)\u0018A\u00044jK2$W*\u0019;dQRK\b/\u001a\t\u0003M6\u0011AbU3sI\u00164\u0015m\u0019;pef,\"\u0001_?\u0014\u0005Ma\u0015AB2sK\u0006$X\rF\u0004|\u0003\u001b\t\t\"a\u0005\u0011\u0005qlH\u0002\u0001\u0003\u0006}N\u0011\ra \u0002\u0002)F!\u0011\u0011AA\u0004!\rA\u00141A\u0005\u0004\u0003\u000bI$a\u0002(pi\"Lgn\u001a\t\u0004q\u0005%\u0011bAA\u0006s\t\u0019\u0011I\\=\t\r\u0005=A\u00031\u0001V\u0003%\u0019\u0018\u000f\\*dQ\u0016l\u0017\rC\u0003?)\u0001\u0007q\b\u0003\u0004u)\u0001\u0007\u0011Q\u0003\t\u0004\u0003/iaB\u00010\u000bS\r\u0019\"D\u0006\u0002\r\t\u0016\u001cXM]5bY&TXM]\n\u000551\u000by\u0002\u0005\u0003_'\u0005\u0005\u0002c\u0001\u001b\u0002$%\u0019\u0011QE\u0011\u0003!\u00053(o\u001c#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014HCAA\u0015!\tq&\u0004\u0006\u0005\u0002\"\u00055\u0012qFA\u0019\u0011\u0015!C\u00041\u0001V\u0011\u0015\u0011C\u00041\u0001@\u0011\u001d\t\u0019\u0004\ba\u0001\u0003+\t\u0011\"\\1uG\"$\u0016\u0010]3\u0003\u0015M+'/[1mSj,'o\u0005\u0003\u0017\u0019\u0006e\u0002\u0003\u00020\u0014\u0003w\u00012\u0001NA\u001f\u0013\r\ty$\t\u0002\u000f\u0003Z\u0014xnU3sS\u0006d\u0017N_3s)\t\t\u0019\u0005\u0005\u0002_-QA\u00111HA$\u0003\u0013\nY\u0005C\u0003%1\u0001\u0007Q\u000bC\u0003#1\u0001\u0007q\bC\u0004\u00024a\u0001\r!!\u0006\u0002\u0015M+'/[1mSj,'/\u0001\u0007EKN,'/[1mSj,'/\u0001\u0011de\u0016\fG/\u001a(fgR,G-\u0011<s_N\u001b\u0007.Z7b/&$\bNR5fY\u0012\u001cH#B \u0002V\u0005=\u0004bBA,;\u0001\u0007\u0011\u0011L\u0001\u0016]\u0016\u001cH/\u001a3SK\u000e|'\u000f\u001a$jK2$g*Y7f!\u0011\tY&!\u001b\u000f\t\u0005u\u0013Q\r\t\u0004\u0003?JTBAA1\u0015\r\t\u0019gK\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001d\u0014(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\niG\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003OJ\u0004bBA9;\u0001\u0007\u00111O\u0001\u0002MB9\u0001(!\u001e\u0002z\u0005e\u0014bAA<s\tIa)\u001e8di&|g.\r\t\u0006\u0003w\n\ti\u0010\b\u0004\u0001\u0006u\u0014bAA@\u0003\u0006i1k\u00195f[\u0006\u0014U/\u001b7eKJLA!a!\u0002\u0006\nqa)[3mI\u0006\u001b8/Z7cY\u0016\u0014(bAA@\u0003\u0006\u00113M]3bi\u0016\feO]8TG\",W.Y,ji\"$v\u000e\u001d'fm\u0016dg)[3mIN$2aPAF\u0011\u001d\t\tH\ba\u0001\u0003g\n1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0013\t\u0005\u0003'\u000bi*\u0004\u0002\u0002\u0016*!\u0011qSAM\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0015\u0001\u00026bm\u0006LA!a(\u0002\u0016\n1qJ\u00196fGR\u00042\u0001`AR\t)\t)\u000bRA\u0001\u0002\u0003\u0015\ta \u0002\u0004?\u0012\n\u0004B\u0002;\u0003\u0001\u0004\tI\u000bE\u0002\u0002,6q!\u0001\u0013\u0006\t\u000f\u0005=&\u00011\u0001\u0002Z\u0005!R\r\u001f9fGR,GmQ1vg\u0016lUm]:bO\u0016D\u0001\"a-\u0003!\u0003\u0005\r!V\u0001\u000fG\u0006$\u0018\r\\=tiN\u001b\u0007.Z7b\u0003\u001d\n7o]3si\u001a\u000b\u0017\u000e\\3e\u0007>tg/\u001a:tS>tW*Z:tC\u001e,G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005e&fA+\u0002<.\u0012\u0011Q\u0018\t\u0005\u0003\u007f\u000bI-\u0004\u0002\u0002B*!\u00111YAc\u0003%)hn\u00195fG.,GMC\u0002\u0002Hf\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY-!1\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\nxSRDg)[3mI6\u000bGo\u00195UsB,GcA\u001c\u0002R\"9\u0011\u0011\u000f\u0003A\u0002\u0005M\u0007C\u0002\u001d\u0002v\u0005%v\u0007")
public class AvroSerdeSuite
extends SparkFunSuite {
    private void assertFailedConversionMessage(Schema avroSchema, SerdeFactory<?> serdeFactory, Enumeration.Value fieldMatchType, String expectedCauseMessage, StructType catalystSchema) {
        String string;
        IncompatibleSchemaException e = (IncompatibleSchemaException)this.intercept((Function0 & Serializable & scala.Serializable)() -> serdeFactory.create(catalystSchema, avroSchema, fieldMatchType), ClassTag$.MODULE$.apply(IncompatibleSchemaException.class), new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        SerdeFactory<?> serdeFactory2 = serdeFactory;
        if (AvroSerdeSuite$Deserializer$.MODULE$.equals(serdeFactory2)) {
            string = new StringBuilder(39).append("Cannot convert Avro type ").append(avroSchema).append(" to SQL type ").append(catalystSchema.sql()).append(".").toString();
        } else if (AvroSerdeSuite$Serializer$.MODULE$.equals(serdeFactory2)) {
            string = new StringBuilder(39).append("Cannot convert SQL type ").append(catalystSchema.sql()).append(" to Avro type ").append(avroSchema).append(".").toString();
        } else {
            throw new MatchError(serdeFactory2);
        }
        String expectMsg = string;
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(e.getMessage());
        String $org_scalatest_assert_macro_right = expectMsg;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(e.getCause().getMessage());
        String $org_scalatest_assert_macro_right2 = expectedCauseMessage;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
    }

    private StructType assertFailedConversionMessage$default$5() {
        return AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT();
    }

    public void withFieldMatchType(Function1<Enumeration.Value, BoxedUnit> f) {
        AvroSerdeSuite$MatchType$.MODULE$.values().foreach((Function1 & Serializable & scala.Serializable)fieldMatchType -> {
            this.withClue(new StringBuilder(18).append("fieldMatchType == ").append(fieldMatchType).toString(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> f.apply((Object)fieldMatchType));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$2(AvroSerdeSuite $this, Enumeration.Value fieldMatch) {
        Tuple2 tuple2;
        Enumeration.Value value = fieldMatch;
        Enumeration.Value value2 = AvroSerdeSuite$MatchType$.MODULE$.BY_NAME();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            tuple2 = new Tuple2((Object)"foo", (Object)"bar");
        } else {
            Enumeration.Value value4 = AvroSerdeSuite$MatchType$.MODULE$.BY_POSITION();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                tuple2 = new Tuple2((Object)"NOTfoo", (Object)"NOTbar");
            } else {
                throw new MatchError((Object)value);
            }
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String top = (String)tuple22._1();
        String nest = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)top, (Object)nest);
        Tuple2 tuple24 = tuple23;
        String top2 = (String)tuple24._1();
        String nest2 = (String)tuple24._2();
        Schema avro = AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createNestedAvroSchemaWithFields(top2, (Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable & scala.Serializable)x$2 -> x$2.optionalInt(nest2));
        GenericData.Record record = new GenericRecordBuilder(avro).set(top2, (Object)new GenericRecordBuilder(avro.getField(top2).schema()).set(nest2, (Object)BoxesRunTime.boxToInteger((int)42)).build()).build();
        AvroSerializer serializer = AvroSerdeSuite$Serializer$.MODULE$.create(AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT(), avro, fieldMatch);
        AvroDeserializer deserializer = AvroSerdeSuite$Deserializer$.MODULE$.create(AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT(), avro, fieldMatch);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(serializer.serialize(deserializer.deserialize((Object)record).get()));
        GenericData.Record $org_scalatest_assert_macro_right = record;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
    }

    public static final /* synthetic */ void $anonfun$new$6(AvroSerdeSuite $this, Schema avro$1, Enumeration.Value fieldMatch) {
        $this.assertFailedConversionMessage(avro$1, AvroSerdeSuite$Deserializer$.MODULE$, fieldMatch, new StringBuilder(112).append("Cannot convert Avro field 'foo' to SQL field 'foo' because schema is incompatible ").append("(avroType = \"int\", sqlType = ").append(((StructField)AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT().head()).dataType().sql()).append(")").toString(), $this.assertFailedConversionMessage$default$5());
        $this.assertFailedConversionMessage(avro$1, AvroSerdeSuite$Serializer$.MODULE$, fieldMatch, new StringBuilder(112).append("Cannot convert SQL field 'foo' to Avro field 'foo' because schema is incompatible ").append("(sqlType = ").append(((StructField)AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT().head()).dataType().sql()).append(", avroType = \"int\")").toString(), $this.assertFailedConversionMessage$default$5());
    }

    public static final /* synthetic */ void $anonfun$new$9(AvroSerdeSuite $this, Schema avro$2, Enumeration.Value fieldMatch) {
        $this.assertFailedConversionMessage(avro$2, AvroSerdeSuite$Deserializer$.MODULE$, fieldMatch, "Cannot convert Avro field 'foo.bar' to SQL field 'foo.bar' because schema is incompatible (avroType = \"float\", sqlType = INT)", $this.assertFailedConversionMessage$default$5());
        $this.assertFailedConversionMessage(avro$2, AvroSerdeSuite$Serializer$.MODULE$, fieldMatch, "Cannot convert SQL field 'foo.bar' to Avro field 'foo.bar' because schema is incompatible (sqlType = INT, avroType = \"float\")", $this.assertFailedConversionMessage$default$5());
    }

    public static final /* synthetic */ void $anonfun$new$14(AvroSerdeSuite $this, Schema avro$3, StructType catalyst$1, Enumeration.Value fieldMatch) {
        $this.assertFailedConversionMessage(avro$3, AvroSerdeSuite$Deserializer$.MODULE$, fieldMatch, "Cannot convert Avro field 'top.foo.bar' to SQL field 'top.foo.bar' because schema is incompatible (avroType = \"float\", sqlType = INT)", catalyst$1);
        $this.assertFailedConversionMessage(avro$3, AvroSerdeSuite$Serializer$.MODULE$, fieldMatch, "Cannot convert SQL field 'top.foo.bar' to Avro field 'top.foo.bar' because schema is incompatible (sqlType = INT, avroType = \"float\")", catalyst$1);
    }

    public static final /* synthetic */ void $anonfun$new$16(AvroSerdeSuite $this, Enumeration.Value fieldMatch) {
        Schema tooManyFields = AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createAvroSchemaWithTopLevelFields((Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable & scala.Serializable)x$7 -> x$7.optionalInt("foo").optionalLong("bar"));
        $this.assertFailedConversionMessage(tooManyFields, AvroSerdeSuite$Serializer$.MODULE$, fieldMatch, "Avro top-level record schema length (2) doesn't match SQL top-level record schema length (1)", $this.assertFailedConversionMessage$default$5());
        Schema tooFewFields = AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createAvroSchemaWithTopLevelFields((Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable & scala.Serializable)f -> f);
        $this.assertFailedConversionMessage(tooFewFields, AvroSerdeSuite$Serializer$.MODULE$, fieldMatch, "Avro top-level record schema length (0) doesn't match SQL top-level record schema length (1)", $this.assertFailedConversionMessage$default$5());
    }

    public AvroSerdeSuite() {
        this.test("Test basic conversion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withFieldMatchType((Function1<Enumeration.Value, BoxedUnit>)(Function1 & Serializable & scala.Serializable)fieldMatch -> {
            AvroSerdeSuite.$anonfun$new$2(this, fieldMatch);
            return BoxedUnit.UNIT;
        }), new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("Fail to convert with field type mismatch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Schema avro = AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createAvroSchemaWithTopLevelFields((Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable & scala.Serializable)x$3 -> x$3.requiredInt("foo"));
            this.withFieldMatchType((Function1<Enumeration.Value, BoxedUnit>)(Function1 & Serializable & scala.Serializable)fieldMatch -> {
                AvroSerdeSuite.$anonfun$new$6(this, avro, fieldMatch);
                return BoxedUnit.UNIT;
            });
        }, new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
        this.test("Fail to convert with nested field type mismatch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Schema avro = AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createNestedAvroSchemaWithFields("foo", (Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable & scala.Serializable)x$4 -> x$4.optionalFloat("bar"));
            this.withFieldMatchType((Function1<Enumeration.Value, BoxedUnit>)(Function1 & Serializable & scala.Serializable)fieldMatch -> {
                AvroSerdeSuite.$anonfun$new$9(this, avro, fieldMatch);
                return BoxedUnit.UNIT;
            });
        }, new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        this.test("Fail to convert with missing nested Avro fields", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Schema avro = AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createNestedAvroSchemaWithFields("foo", (Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable & scala.Serializable)x$5 -> x$5.optionalInt("NOTbar"));
            StructType nonnullCatalyst = new StructType().add("foo", (DataType)new StructType().add("bar", (DataType)IntegerType$.MODULE$, false));
            StructType extraNonnullCatalyst = new StructType().add("foo", (DataType)new StructType().add("bar", (DataType)IntegerType$.MODULE$).add("baz", (DataType)IntegerType$.MODULE$, false));
            AvroSerdeSuite$Deserializer$.MODULE$.create(AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT(), avro, AvroSerdeSuite$MatchType$.MODULE$.BY_NAME());
            this.assertFailedConversionMessage(avro, AvroSerdeSuite$Deserializer$.MODULE$, AvroSerdeSuite$MatchType$.MODULE$.BY_NAME(), "Cannot find non-nullable field 'foo.bar' (at position 0) in Avro schema.", nonnullCatalyst);
            this.assertFailedConversionMessage(avro, AvroSerdeSuite$Deserializer$.MODULE$, AvroSerdeSuite$MatchType$.MODULE$.BY_POSITION(), "Cannot find non-nullable field at position 1 (field 'foo.baz') in Avro schema.", extraNonnullCatalyst);
            String expectMsg = "Cannot find field 'foo.bar' (at position 0) in Avro schema at field 'foo'";
            this.assertFailedConversionMessage(avro, AvroSerdeSuite$Serializer$.MODULE$, AvroSerdeSuite$MatchType$.MODULE$.BY_NAME(), expectMsg, this.assertFailedConversionMessage$default$5());
            this.assertFailedConversionMessage(avro, AvroSerdeSuite$Serializer$.MODULE$, AvroSerdeSuite$MatchType$.MODULE$.BY_NAME(), expectMsg, nonnullCatalyst);
            this.assertFailedConversionMessage(avro, AvroSerdeSuite$Serializer$.MODULE$, AvroSerdeSuite$MatchType$.MODULE$.BY_POSITION(), "Avro field 'foo' schema length (1) doesn't match SQL field 'foo' schema length (2)", extraNonnullCatalyst);
        }, new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        this.test("Fail to convert with deeply nested field type mismatch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Schema avro = (Schema)SchemaBuilder.builder().record("toptest").fields().name("top").type(AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$createNestedAvroSchemaWithFields("foo", (Function1<SchemaBuilder.FieldAssembler<Schema>, SchemaBuilder.FieldAssembler<Schema>>)(Function1 & Serializable & scala.Serializable)x$6 -> x$6.optionalFloat("bar"))).noDefault().endRecord();
            StructType catalyst = new StructType().add("top", (DataType)AvroSerdeSuite$.MODULE$.org$apache$spark$sql$avro$AvroSerdeSuite$$CATALYST_STRUCT());
            this.withFieldMatchType((Function1<Enumeration.Value, BoxedUnit>)(Function1 & Serializable & scala.Serializable)fieldMatch -> {
                AvroSerdeSuite.$anonfun$new$14(this, avro, catalyst, fieldMatch);
                return BoxedUnit.UNIT;
            });
        }, new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        this.test("Fail to convert for serialization with field count mismatch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withFieldMatchType((Function1<Enumeration.Value, BoxedUnit>)(Function1 & Serializable & scala.Serializable)fieldMatch -> {
            AvroSerdeSuite.$anonfun$new$16(this, fieldMatch);
            return BoxedUnit.UNIT;
        }), new Position("AvroSerdeSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
    }

    private static interface SerdeFactory<T> {
        public T create(StructType var1, Schema var2, Enumeration.Value var3);
    }
}

